/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi;

import java.io.Serializable;
import uk.co.mmscomputing.concurrent.Semaphore;
import uk.co.mmscomputing.device.capi.CapiConstants;
import uk.co.mmscomputing.device.capi.CapiPlugin;
import uk.co.mmscomputing.device.capi.protocol.BProtocol;
import uk.co.mmscomputing.util.metadata.Metadata;

public class CapiMetadata
extends Metadata
implements CapiConstants,
Serializable {
    public CapiMetadata() {
    }

    public CapiMetadata(Class clazz) {
        super(clazz);
    }

    public void useALaw() {
        this.putInt("capi.speechcoding", 3);
    }

    public void useuLaw() {
        this.putInt("capi.speechcoding", 2);
    }

    public void use64kBit() {
        this.putInt("capi.bandwidth", 1);
    }

    public void use56kBit() {
        this.putInt("capi.bandwidth", 6);
    }

    public void useController(int n) {
        this.putInt("capi.controller.id", n);
    }

    public void setController(int n) {
        this.putInt("capi.controller.id", n);
    }

    public int getController() {
        return this.getInt("capi.controller.id");
    }

    public void useMaxLogicalConnections(int n) {
        this.putInt("capi.maxlogicalcon", n);
    }

    public void useB3DataBlocks(int n) {
        this.putInt("capi.maxb3datablocks", n);
    }

    public void useB3DataBlockSize(int n) {
        this.putInt("capi.maxb3datablocksize", n);
    }

    public void acceptAllCalls() {
        this.putInt("capi.cipmask", 536806399);
    }

    public void useLocalNo(String string) {
        this.put("capi.localno", string);
    }

    public void useFaxHeader(String string) {
        this.put("capi.faxheader", string);
    }

    public void setMaxIllegalLineCodings(int n) {
        this.putInt("capi.fax.maxIllegalLineCodings", n);
    }

    public int getMaxIllegalLineCodings() {
        return this.getInt("capi.fax.maxIllegalLineCodings", -1);
    }

    public static class Indication
    extends State {
        public String localno;
        public String remoteno;
        public String name;
        public boolean accept = false;
        private int cntl = -1;
        public int rejectFlag = 0;
        public int waitformsecs = 0;
        public Semaphore blocker = null;
        public boolean gotPickedUp = false;
        public BProtocol protocol = null;
        private CapiPlugin plugin = null;

        public Indication(int n) {
            super(n);
        }

        public String getName() {
            return "INDICATION";
        }

        public boolean isAccepted() {
            return this.accept;
        }

        public void setProtocol(BProtocol bProtocol) {
            this.protocol = bProtocol;
        }

        public BProtocol getProtocol() {
            return this.protocol;
        }

        public void setPlugin(CapiPlugin capiPlugin) {
            this.plugin = capiPlugin;
        }

        CapiPlugin getPlugin() {
            return this.plugin;
        }

        public void setController(int n) {
            this.cntl = n;
        }

        public int getController() {
            return this.cntl;
        }

        public void setAccept(int n, Semaphore semaphore) {
            this.accept = true;
            this.rejectFlag = 0;
            this.waitformsecs = n;
            this.blocker = null;
            if (n > 0) {
                this.blocker = semaphore != null ? semaphore : new Semaphore(0, true);
            }
        }

        public void setAccept(int n) {
            this.setAccept(n, null);
        }

        public void pickUp() {
            if (this.blocker != null) {
                this.gotPickedUp = true;
                this.blocker.release();
                this.blocker = null;
            }
        }

        public void setIgnore() {
            this.accept = false;
            this.rejectFlag = 1;
        }
    }

    public static abstract class State {
        final int line;

        public State(int n) {
            this.line = n;
        }

        public int getLine() {
            return this.line;
        }

        public abstract String getName();
    }
}

