/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi;

import uk.co.mmscomputing.device.capi.CapiChannel;
import uk.co.mmscomputing.device.capi.CapiController;
import uk.co.mmscomputing.device.capi.exception.CapiException;
import uk.co.mmscomputing.device.capi.jcapi;

public class CapiEnumerator {
    private static int nobc = 0;
    private static CapiController[] ctrls = new CapiController[0];

    private static void updateControllers() {
        try {
            nobc = 0;
            int n = jcapi.getNoOfControllers();
            ctrls = new CapiController[n];
            int n2 = 0;
            int n3 = 0;
            while (n2 < n) {
                ++n3;
                try {
                    CapiEnumerator.ctrls[n2] = new CapiController(n3);
                    nobc += ctrls[n2].getNoOfBChannels();
                    ++n2;
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            System.err.println(CapiEnumerator.class.getName() + "\n\t" + exception.getMessage());
        }
    }

    public static int getNoOfBChannels() {
        return nobc;
    }

    public static CapiController[] getControllers() {
        return ctrls;
    }

    public static CapiController getController(int n) throws CapiException {
        for (int i = 0; i < ctrls.length; ++i) {
            CapiController capiController = ctrls[i];
            if (capiController.getId() != n) continue;
            return capiController;
        }
        if (nobc > 0) {
            CapiController capiController = ctrls[0];
            System.err.println("CapiEnumerator.getControllerById:\n\tUse controller " + capiController.getId() + " instead of " + n);
            return capiController;
        }
        throw new CapiException("CapiEnumerator.getControllerById:\n\tCannot find any controller.");
    }

    public static CapiController getController(CapiChannel capiChannel) throws CapiException {
        return CapiEnumerator.getController(capiChannel.getCtrlId());
    }

    public String toString() {
        String string = "";
        string = string + "CapiEnumerator.getNoOfControllers() = " + ctrls.length + "\n\n\n";
        for (int i = 0; i < ctrls.length; ++i) {
            string = string + "CapiEnumerator.getController(" + ctrls[i].getId() + "):\n\n" + ctrls[i].toString() + "\n\n";
        }
        return string;
    }

    static {
        try {
            jcapi.checkInstalled();
            CapiEnumerator.updateControllers();
        }
        catch (Exception exception) {
            System.err.println(CapiEnumerator.class.getName() + "\n\t" + exception.getMessage());
        }
    }
}

