/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi;

import java.io.IOException;
import uk.co.mmscomputing.device.capi.CapiProfile;
import uk.co.mmscomputing.device.capi.exception.CapiIOException;
import uk.co.mmscomputing.device.capi.jcapi;
import uk.co.mmscomputing.device.capi.man.avm.AVMProfile;
import uk.co.mmscomputing.device.capi.man.eicon.EiconProfile;
import uk.co.mmscomputing.util.metadata.Metadata;

public class CapiController {
    private int ctrlid = -1;
    private String manufacturer = "";
    private int manuid = 0;
    private CapiProfile profile;

    CapiController(int n) throws IOException {
        this.ctrlid = n;
        this.manufacturer = jcapi.getManufacturer(this.ctrlid);
        if (this.manufacturer.toLowerCase().indexOf("avm") >= 0) {
            this.manuid = 558716481;
            this.profile = new AVMProfile(jcapi.getProfile(this.ctrlid));
        } else if (this.manufacturer.toLowerCase().indexOf("eicon") >= 0) {
            this.manuid = 0x44444944;
            this.profile = new EiconProfile(jcapi.getProfile(this.ctrlid));
        } else {
            this.profile = new CapiProfile(jcapi.getProfile(this.ctrlid));
        }
    }

    public int getNoOfBChannels() {
        return this.profile.getNoOfBChannels();
    }

    public void update(Metadata metadata) {
        metadata.putInt("capi.controller.id", this.ctrlid);
        metadata.putBoolean("capi.controller.isSupportingDTMF", this.profile.isSupportingDTMF());
        metadata.putBoolean("capi.controller.isSupportingGroup3Fax", this.profile.isSupportingGroup3Fax());
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public CapiProfile getProfile() {
        return this.profile;
    }

    public boolean isSupportingDTMF() {
        return this.profile.isSupportingDTMF();
    }

    public boolean isSupportingGroup3Fax() {
        return this.profile.isSupportingGroup3Fax();
    }

    public boolean isSupportingSupplementaryServices() {
        return this.profile.isSupportingSupplementaryServices();
    }

    public int getId() {
        return this.ctrlid;
    }

    public int getOptions() {
        return this.profile.getOptions();
    }

    public int getB1Protocols() {
        return this.profile.getB1Protocols();
    }

    public int getB2Protocols() {
        return this.profile.getB2Protocols();
    }

    public int getB3Protocols() {
        return this.profile.getB3Protocols();
    }

    public String getName() {
        String string = "" + this.ctrlid;
        try {
            int[] nArray = jcapi.getVersion(this.ctrlid);
            string = string + " " + this.manufacturer;
            try {
                string = string + " [" + jcapi.getSerialNumber(this.ctrlid) + "]";
            }
            catch (CapiIOException capiIOException) {
                System.err.println(capiIOException);
            }
            string = string + " V: " + nArray[0] + "." + nArray[1] + " - " + nArray[2] + "." + nArray[3] + "\n";
        }
        catch (CapiIOException capiIOException) {
            System.err.println(capiIOException);
        }
        return string;
    }

    public String toString() {
        String string = "Controller : " + this.ctrlid + "\n";
        try {
            int[] nArray = jcapi.getVersion(this.ctrlid);
            string = string + "Manufacturer " + this.manufacturer + " [0x" + Integer.toHexString(this.manuid) + "]\n";
            string = string + "Version " + nArray[0] + "." + nArray[1] + " - " + nArray[2] + "." + nArray[3] + "\n";
            string = string + "Serial No " + jcapi.getSerialNumber(this.ctrlid) + "\n";
        }
        catch (CapiIOException capiIOException) {
            System.err.println(capiIOException);
        }
        string = string + "\n" + this.profile.toString();
        return string;
    }
}

