/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import uk.co.mmscomputing.concurrent.Semaphore;
import uk.co.mmscomputing.concurrent.TimeUnit;
import uk.co.mmscomputing.device.capi.CapiApplication;
import uk.co.mmscomputing.device.capi.CapiConstants;
import uk.co.mmscomputing.device.capi.CapiInputStream;
import uk.co.mmscomputing.device.capi.CapiOutputStream;
import uk.co.mmscomputing.device.capi.CapiPLC;
import uk.co.mmscomputing.device.capi.CapiPlugin;
import uk.co.mmscomputing.device.capi.MsgOut;
import uk.co.mmscomputing.device.capi.exception.CapiException;
import uk.co.mmscomputing.device.capi.exception.CapiInformation;
import uk.co.mmscomputing.device.capi.facility.DTMFConf;
import uk.co.mmscomputing.device.capi.facility.DTMFInd;
import uk.co.mmscomputing.device.capi.facility.DTMFReq;
import uk.co.mmscomputing.device.capi.protocol.BProtocol;
import uk.co.mmscomputing.device.capi.sound.PCMInputStream;
import uk.co.mmscomputing.device.capi.sound.PCMOutputStream;

public abstract class CapiChannel
implements CapiConstants {
    public static final AudioFormat pcmformat = new AudioFormat(8000.0f, 16, 1, true, false);
    public static final AudioFormat alawformat = new AudioFormat(AudioFormat.Encoding.ALAW, 8000.0f, 8, 1, 1, 8000.0f, false);
    public static final AudioFormat ulawformat = new AudioFormat(AudioFormat.Encoding.ULAW, 8000.0f, 8, 1, 1, 8000.0f, false);
    protected boolean isopen = false;
    private int connectState = 0;
    protected boolean pickedUp = false;
    protected boolean changedProtocol = false;
    protected CapiApplication appl = null;
    protected int applid = -1;
    protected int lineid = -1;
    protected BProtocol protocol = null;
    protected CapiPlugin plugin = null;
    private String localno = "";
    private String remoteno = "";
    protected int speechcoding = -1;
    private Semaphore pickupBlocker = null;
    private boolean isdtmfenabled = false;
    private Semaphore blocker = null;
    private StringBuffer dtmf = null;

    public CapiChannel(CapiApplication capiApplication, int n) {
        this.appl = capiApplication;
        this.applid = capiApplication.getApplID();
        this.lineid = n;
    }

    public boolean isOpen() {
        return this.isopen;
    }

    public void close() throws IOException {
    }

    protected synchronized boolean checkIsOpen() {
        if (!this.isopen) {
            return false;
        }
        this.isopen = false;
        return true;
    }

    public boolean isConnected() {
        return this.connectState == 1;
    }

    protected synchronized boolean checkIsNotConnected() {
        if (this.connectState == 0) {
            this.connectState = 1;
            this.isopen = true;
            return true;
        }
        return false;
    }

    public boolean isDisconnected() {
        return this.connectState == 2;
    }

    protected synchronized boolean checkIsNotDisconnected() {
        if (this.connectState == 2) {
            return false;
        }
        this.connectState = 2;
        this.isopen = false;
        return true;
    }

    void setPickupBlocker(Semaphore semaphore) {
        this.pickupBlocker = semaphore;
    }

    Semaphore getPickupBlocker() {
        return this.pickupBlocker;
    }

    void releasePickupBlocker() {
        if (this.pickupBlocker != null) {
            this.pickupBlocker.release();
        }
    }

    public abstract CapiInputStream getInputStream() throws IOException;

    public abstract CapiOutputStream getOutputStream() throws IOException;

    public PCMInputStream getPCMInputStream() throws IOException {
        return new PCMInputStream(this.getInputStream(), this.isALaw());
    }

    public PCMOutputStream getPCMOutputStream() throws IOException {
        return new PCMOutputStream(this.getOutputStream(), this.isALaw());
    }

    public AudioInputStream getAudioInputStream() throws IOException {
        return new AudioInputStream(this.getPCMInputStream(), pcmformat, -1L);
    }

    public int getApplID() {
        return this.applid;
    }

    public int getLineID() {
        return this.lineid;
    }

    public void put(MsgOut msgOut) throws CapiException {
        this.appl.put(msgOut);
    }

    public int getCtrlId() {
        return this.lineid & 0x7F;
    }

    public BProtocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(BProtocol bProtocol) {
        this.protocol = bProtocol;
    }

    public CapiPlugin getPlugin() {
        return this.plugin;
    }

    public void setPlugin(CapiPlugin capiPlugin) {
        this.plugin = capiPlugin;
    }

    public String getLocalNo() {
        return this.localno;
    }

    public void setLocalNo(String string) {
        this.localno = string;
    }

    public String getRemoteNo() {
        return this.remoteno;
    }

    public void setRemoteNo(String string) {
        this.remoteno = string;
    }

    public void setSpeechCoding(int n) {
        this.speechcoding = n;
    }

    public void setALawSpeechCoding() {
        this.speechcoding = 3;
    }

    public void setuLawSpeechCoding() {
        this.speechcoding = 2;
    }

    public int getSpeechCoding() {
        return this.speechcoding;
    }

    public boolean isALaw() throws CapiException {
        switch (this.speechcoding) {
            case 3: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new CapiInformation(this.getClass().getName() + ".isALaw:\n\tThis Channel does not seem to carry sound data !");
    }

    public boolean isuLaw() throws CapiException {
        return !this.isALaw();
    }

    void setPickedUp(boolean bl) {
        this.pickedUp = bl;
    }

    public boolean getPickedUp() {
        return this.pickedUp;
    }

    void setChangedProtocol(boolean bl) {
        this.changedProtocol = bl;
    }

    public boolean getChangedProtocol() {
        return this.changedProtocol;
    }

    public void writeInputTo(OutputStream outputStream) throws IOException {
        int n;
        CapiInputStream capiInputStream = this.getInputStream();
        byte[] byArray = new byte[256];
        while (this.isOpen() && (n = capiInputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
        outputStream.flush();
    }

    public void writePCMInputTo(OutputStream outputStream) throws IOException {
        int n;
        PCMInputStream pCMInputStream = this.getPCMInputStream();
        byte[] byArray = new byte[512];
        while (this.isOpen() && (n = ((InputStream)pCMInputStream).read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
        outputStream.flush();
    }

    public void writeInputTo(SourceDataLine sourceDataLine) throws IOException {
        int n;
        PCMInputStream pCMInputStream = this.getPCMInputStream();
        byte[] byArray = new byte[512];
        sourceDataLine.start();
        ((InputStream)pCMInputStream).skip(((InputStream)pCMInputStream).available());
        while (this.isOpen() && (n = ((InputStream)pCMInputStream).read(byArray)) != -1) {
            sourceDataLine.write(byArray, 0, n);
        }
        sourceDataLine.drain();
        sourceDataLine.stop();
    }

    public void writeToOutput(InputStream inputStream) throws IOException {
        int n;
        CapiOutputStream capiOutputStream = this.getOutputStream();
        byte[] byArray = new byte[256];
        while (this.isOpen() && (n = inputStream.read(byArray)) != -1) {
            ((OutputStream)capiOutputStream).write(byArray, 0, n);
        }
        ((OutputStream)capiOutputStream).flush();
    }

    public void writeToPCMOutput(InputStream inputStream) throws IOException {
        int n;
        PCMOutputStream pCMOutputStream = this.getPCMOutputStream();
        byte[] byArray = new byte[512];
        while (this.isOpen() && (n = inputStream.read(byArray)) != -1) {
            ((OutputStream)pCMOutputStream).write(byArray, 0, n);
        }
        ((OutputStream)pCMOutputStream).flush();
    }

    public void writeToOutput(TargetDataLine targetDataLine) throws IOException {
        int n;
        PCMOutputStream pCMOutputStream = this.getPCMOutputStream();
        byte[] byArray = new byte[512];
        targetDataLine.start();
        while (this.isOpen() && (n = targetDataLine.read(byArray, 0, byArray.length)) != -1) {
            ((OutputStream)pCMOutputStream).write(byArray, 0, n);
        }
        ((OutputStream)pCMOutputStream).flush();
    }

    public void writeToOutput(AudioInputStream audioInputStream) throws IOException {
        int n;
        if (!audioInputStream.getFormat().equals(pcmformat)) {
            audioInputStream = AudioSystem.getAudioInputStream(pcmformat, audioInputStream);
        }
        PCMOutputStream pCMOutputStream = this.getPCMOutputStream();
        byte[] byArray = new byte[512];
        while (this.isOpen() && (n = audioInputStream.read(byArray)) != -1) {
            ((OutputStream)pCMOutputStream).write(byArray, 0, n);
        }
        ((OutputStream)pCMOutputStream).flush();
    }

    public boolean isDTMFEnabled() {
        return this.isdtmfenabled;
    }

    public void startDTMF() throws IOException {
        boolean bl = this.isdtmfenabled = this.isopen;
        if (this.isopen) {
            this.appl.put(DTMFReq.getStartReq(this.applid, this.lineid));
        }
    }

    public void stopDTMF() throws IOException {
        this.isdtmfenabled = false;
        if (this.isopen) {
            this.appl.put(DTMFReq.getStopReq(this.applid, this.lineid));
        }
    }

    public void sendDTMF(String string) throws IOException {
        if (this.isopen) {
            this.appl.put(DTMFReq.getSendReq(this.applid, this.lineid, string));
        }
    }

    public void receivedDTMFConf(DTMFConf dTMFConf) {
        if (dTMFConf.getInfo() != 0) {
            this.isdtmfenabled = false;
        }
    }

    public synchronized void receivedDTMFInd(DTMFInd dTMFInd) {
        String string = dTMFInd.getDigits();
        if (this.blocker != null) {
            this.dtmf.append(string);
            this.blocker.release();
        }
    }

    public String getDTMFDigits(int n, int n2) throws InterruptedException {
        this.dtmf = new StringBuffer();
        this.blocker = new Semaphore(1 - n, true);
        this.blocker.tryAcquire(n2, TimeUnit.MILLISECONDS);
        this.blocker = null;
        return this.dtmf.toString();
    }

    public void explicitCallTransferTo(CapiChannel capiChannel) throws CapiException {
        CapiPLC capiPLC = this.appl.getPLC(this.getLineID());
        CapiPLC capiPLC2 = this.appl.getPLC(capiChannel.getLineID());
        capiPLC.explicitCallTransferTo(capiPLC2);
    }
}

