/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import uk.co.mmscomputing.concurrent.Semaphore;
import uk.co.mmscomputing.device.capi.CapiChannel;
import uk.co.mmscomputing.device.capi.CapiConfMsg;
import uk.co.mmscomputing.device.capi.CapiConstants;
import uk.co.mmscomputing.device.capi.CapiController;
import uk.co.mmscomputing.device.capi.CapiEnumerator;
import uk.co.mmscomputing.device.capi.CapiIndMsg;
import uk.co.mmscomputing.device.capi.CapiNCC;
import uk.co.mmscomputing.device.capi.CapiPLC;
import uk.co.mmscomputing.device.capi.MsgIn;
import uk.co.mmscomputing.device.capi.MsgOut;
import uk.co.mmscomputing.device.capi.Rider;
import uk.co.mmscomputing.device.capi.ctrl.ConnectReq;
import uk.co.mmscomputing.device.capi.ctrl.ListenReq;
import uk.co.mmscomputing.device.capi.exception.CapiException;
import uk.co.mmscomputing.device.capi.facility.FacilityConf;
import uk.co.mmscomputing.device.capi.facility.FacilityInd;
import uk.co.mmscomputing.device.capi.facility.SupServiceConf;
import uk.co.mmscomputing.device.capi.facility.V42InfoReq;
import uk.co.mmscomputing.device.capi.jcapi;
import uk.co.mmscomputing.device.capi.ncc.ConnectB3ActiveInd;
import uk.co.mmscomputing.device.capi.ncc.ConnectB3ActiveResp;
import uk.co.mmscomputing.device.capi.ncc.ConnectB3Conf;
import uk.co.mmscomputing.device.capi.ncc.ConnectB3Ind;
import uk.co.mmscomputing.device.capi.ncc.ConnectB3Resp;
import uk.co.mmscomputing.device.capi.ncc.ConnectB3T90ActiveInd;
import uk.co.mmscomputing.device.capi.ncc.ConnectB3T90ActiveResp;
import uk.co.mmscomputing.device.capi.ncc.DataB3Conf;
import uk.co.mmscomputing.device.capi.ncc.DataB3Ind;
import uk.co.mmscomputing.device.capi.ncc.DisconnectB3Ind;
import uk.co.mmscomputing.device.capi.ncc.DisconnectB3Resp;
import uk.co.mmscomputing.device.capi.ncc.ResetB3Ind;
import uk.co.mmscomputing.device.capi.ncc.ResetB3Resp;
import uk.co.mmscomputing.device.capi.parameter.NCPI;
import uk.co.mmscomputing.device.capi.plc.ConnectActiveInd;
import uk.co.mmscomputing.device.capi.plc.ConnectActiveResp;
import uk.co.mmscomputing.device.capi.plc.ConnectConf;
import uk.co.mmscomputing.device.capi.plc.ConnectInd;
import uk.co.mmscomputing.device.capi.plc.ConnectResp;
import uk.co.mmscomputing.device.capi.plc.DisconnectInd;
import uk.co.mmscomputing.device.capi.plc.DisconnectReq;
import uk.co.mmscomputing.device.capi.plc.DisconnectResp;
import uk.co.mmscomputing.device.capi.plc.InfoResp;
import uk.co.mmscomputing.device.capi.protocol.BProtocol;
import uk.co.mmscomputing.util.metadata.Metadata;

public class CapiApplication
extends Thread
implements CapiConstants {
    protected int appid = -1;
    protected int maxLogicalCon = -1;
    protected boolean listeningToSupServices = false;
    protected Metadata md = null;
    private boolean running = true;
    private Semaphore rs = new Semaphore(0, true);
    private Vector plcs = new Vector();

    public CapiApplication(Metadata metadata) throws CapiException {
        this.md = metadata;
        metadata.getInt("capi.speechcoding", 3);
        this.maxLogicalCon = metadata.getInt("capi.maxlogicalcon", 2);
        jcapi.checkInstalled();
        this.appid = jcapi.register(this.maxLogicalCon, 7, 256);
    }

    public int getApplID() {
        return this.appid;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isListeningToSupService() {
        return this.listeningToSupServices;
    }

    protected CapiController getController() throws CapiException {
        int n = this.md.getInt("capi.controller.id", 1);
        return CapiEnumerator.getController(n);
    }

    protected int getControllerId() throws CapiException {
        return this.getController().getId();
    }

    public void put(MsgOut msgOut) throws CapiException {
        if (!this.running) {
            return;
        }
        jcapi.putMessage(this.appid, msgOut.getBytes());
    }

    public void close() {
        if (!this.running) {
            return;
        }
        try {
            int n = this.getControllerId();
            this.closePLCs();
            this.running = false;
            ListenReq listenReq = new ListenReq(this.appid, n, 0);
            jcapi.putMessage(this.appid, listenReq.getBytes());
            try {
                this.rs.acquire();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.err.println(this.getClass().getName() + ".close: RELEASED CAPI APPLICATION " + this.appid);
        }
        catch (Exception exception) {
            System.err.println(this.getClass().getName() + ".close:\n\t" + exception);
            this.md.fireListenerUpdate("9\b" + this.getClass().getName() + ".close:\n\t" + exception);
        }
    }

    public CapiPLC getPLC(int n) throws CapiException {
        if ((n &= 0xFFFF) < 256) {
            return null;
        }
        Enumeration enumeration = this.plcs.elements();
        while (enumeration.hasMoreElements()) {
            CapiPLC capiPLC = (CapiPLC)enumeration.nextElement();
            if (capiPLC.lineid != n) continue;
            return capiPLC;
        }
        throw new CapiException(this.getClass().getName() + ".getPLC(" + n + ")\n\tCannot find PLC with plci = 0x" + Integer.toHexString(n) + " !");
    }

    private CapiPLC newPLC(ConnectInd connectInd) {
        CapiPLC capiPLC = new CapiPLC(this, connectInd);
        this.plcs.add(capiPLC);
        return capiPLC;
    }

    protected CapiPLC newPLC(ConnectReq connectReq) {
        CapiPLC capiPLC = new CapiPLC(this, connectReq);
        this.plcs.add(capiPLC);
        return capiPLC;
    }

    private CapiPLC getPLC(ConnectConf connectConf) throws CapiException {
        int n = connectConf.msgno;
        Enumeration enumeration = this.plcs.elements();
        while (enumeration.hasMoreElements()) {
            CapiPLC capiPLC = (CapiPLC)enumeration.nextElement();
            if (capiPLC.getMsgno() != n) continue;
            capiPLC.setLineid(connectConf.lineid);
            return capiPLC;
        }
        throw new CapiException(this.getClass().getName() + ".getPLC(" + n + ")\n\tCannot find PLC with connect msgno = " + n + " !");
    }

    public void closePLCs() {
        CapiPLC[] capiPLCArray = this.plcs.toArray(new CapiPLC[0]);
        for (int i = 0; i < capiPLCArray.length; ++i) {
            try {
                capiPLCArray[i].close();
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    protected void received(CapiPLC capiPLC, ConnectInd connectInd) throws CapiException {
        this.put(new ConnectResp(connectInd.appid, connectInd.lineid, 1));
    }

    protected void received(CapiNCC capiNCC, ConnectB3ActiveInd connectB3ActiveInd) throws CapiException {
        BProtocol bProtocol = capiNCC.getProtocol();
        NCPI nCPI = connectB3ActiveInd.getNCPI(bProtocol);
        if (nCPI != null) {
            this.md.fireListenerUpdate(nCPI);
        }
        if (nCPI != null) {
            switch (bProtocol.B3Protocol) {
                case 4: {
                    break;
                }
                case 2: {
                    break;
                }
                case 7: {
                    this.put(new V42InfoReq(connectB3ActiveInd.appid, connectB3ActiveInd.lineid));
                }
            }
        }
    }

    protected void receivedResetB3Ind(CapiNCC capiNCC, ResetB3Ind resetB3Ind) throws CapiException {
        NCPI nCPI = resetB3Ind.getNCPI(capiNCC.getProtocol());
        if (nCPI != null) {
            this.md.fireListenerUpdate(nCPI);
        }
    }

    protected void receivedConnectB3T90ActiveInd(CapiNCC capiNCC, ConnectB3T90ActiveInd connectB3T90ActiveInd) throws CapiException {
        NCPI nCPI = connectB3T90ActiveInd.getNCPI(capiNCC.getProtocol());
        if (nCPI != null) {
            this.md.fireListenerUpdate(nCPI);
        }
    }

    private void handleIndMsg(CapiIndMsg capiIndMsg) throws CapiException {
        CapiPLC capiPLC = null;
        CapiChannel capiChannel = null;
        if ((capiIndMsg.lineid & 0xFF00) != 0) {
            capiPLC = capiIndMsg.cmd == 2 ? this.newPLC((ConnectInd)capiIndMsg) : this.getPLC(capiIndMsg.lineid);
            if ((capiIndMsg.lineid & 0xFFFF0000) != 0) {
                capiChannel = capiIndMsg.cmd == 130 ? capiPLC.addNCC((ConnectB3Ind)capiIndMsg) : capiPLC.getNCC(capiIndMsg.lineid);
            }
        }
        switch (capiIndMsg.cmd) {
            case 134: {
                ((CapiNCC)capiChannel).received((DataB3Ind)capiIndMsg);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                capiPLC.setSpeechCoding(this.md.getInt("capi.speechcoding"));
                this.received(capiPLC, (ConnectInd)capiIndMsg);
                break;
            }
            case 3: {
                this.put(new ConnectActiveResp(capiIndMsg.appid, capiIndMsg.lineid));
                capiPLC.received((ConnectActiveInd)capiIndMsg);
                break;
            }
            case 130: {
                this.put(new ConnectB3Resp(capiIndMsg.appid, capiIndMsg.lineid));
                NCPI nCPI = ((ConnectB3Ind)capiIndMsg).getNCPI(capiChannel.getProtocol());
                if (nCPI != null) {
                    this.md.fireListenerUpdate(nCPI);
                }
                if (nCPI == null) break;
                switch (capiChannel.getProtocol().B3Protocol) {
                    case 4: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 7: {
                        this.put(new V42InfoReq(capiIndMsg.appid, capiIndMsg.lineid));
                    }
                }
                break;
            }
            case 131: {
                ((CapiNCC)capiChannel).received((ConnectB3ActiveInd)capiIndMsg);
                capiChannel.setPickedUp(capiPLC.getPickedUp());
                this.received((CapiNCC)capiChannel, (ConnectB3ActiveInd)capiIndMsg);
                this.put(new ConnectB3ActiveResp(capiIndMsg.appid, capiIndMsg.lineid));
                capiChannel.releasePickupBlocker();
                break;
            }
            case 136: {
                if (capiChannel.isOpen()) break;
                this.receivedConnectB3T90ActiveInd((CapiNCC)capiChannel, (ConnectB3T90ActiveInd)capiIndMsg);
                this.put(new ConnectB3T90ActiveResp(capiIndMsg.appid, capiIndMsg.lineid));
                break;
            }
            case 132: {
                this.put(new DisconnectB3Resp(capiIndMsg.appid, capiIndMsg.lineid));
                ((CapiNCC)capiChannel).received((DisconnectB3Ind)capiIndMsg);
                capiPLC.remove((CapiNCC)capiChannel);
                break;
            }
            case 4: {
                capiPLC.received((DisconnectInd)capiIndMsg);
                this.put(new DisconnectResp(capiIndMsg.appid, capiIndMsg.lineid));
                this.plcs.remove(capiPLC);
                break;
            }
            case 128: {
                capiPLC.received((FacilityInd)capiIndMsg);
                break;
            }
            case 8: {
                this.put(new InfoResp(capiIndMsg.appid, capiIndMsg.lineid));
                break;
            }
            case 135: {
                this.receivedResetB3Ind((CapiNCC)capiChannel, (ResetB3Ind)capiIndMsg);
                this.put(new ResetB3Resp(capiIndMsg.appid, capiIndMsg.lineid));
                break;
            }
            case 255: {
                break;
            }
            default: {
                System.err.println("3\b" + this.getClass().getName() + ".handleIndMsg:\n\tUnknown indication message\n\t" + capiIndMsg);
            }
        }
    }

    private void handleConfMsg(CapiConfMsg capiConfMsg) throws IOException {
        block25: {
            CapiPLC capiPLC;
            block24: {
                int n;
                capiPLC = null;
                CapiNCC capiNCC = null;
                if ((capiConfMsg.lineid & 0xFF00) != 0) {
                    capiPLC = capiConfMsg.cmd == 2 ? this.getPLC((ConnectConf)capiConfMsg) : this.getPLC(capiConfMsg.lineid);
                    if ((capiConfMsg.lineid & 0xFFFF0000) != 0) {
                        capiNCC = capiConfMsg.cmd == 130 ? capiPLC.addNCC((ConnectB3Conf)capiConfMsg) : capiPLC.getNCC(capiConfMsg.lineid);
                    }
                }
                if (((n = capiConfMsg.getInfo()) & 0xFF00) != 0) break block24;
                switch (capiConfMsg.cmd) {
                    case 134: {
                        capiNCC.received((DataB3Conf)capiConfMsg);
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        capiPLC.setSpeechCoding(this.md.getInt("capi.speechcoding"));
                        break;
                    }
                    case 130: {
                        break;
                    }
                    case 132: {
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 128: {
                        if (capiConfMsg instanceof SupServiceConf.ListenConf) {
                            SupServiceConf.ListenConf listenConf = (SupServiceConf.ListenConf)capiConfMsg;
                            if (listenConf.getInfo() == 0) {
                                this.listeningToSupServices = true;
                            } else {
                                System.err.println("SupServiceReq.ListenReq failed\n" + capiConfMsg);
                            }
                        }
                        if (capiPLC != null) {
                            capiPLC.received((FacilityConf)capiConfMsg);
                            break;
                        }
                        break block25;
                    }
                    case 8: {
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 255: {
                        break;
                    }
                    case 135: {
                        break;
                    }
                    case 65: {
                        System.err.println(this.getClass().getName() + ": Switched Protocol: 0x" + Integer.toHexString(capiConfMsg.lineid));
                        break;
                    }
                    default: {
                        System.err.println("3\b" + this.getClass().getName() + ".handleConfMsg:\n\tUnknown confirmation message\n\t" + capiConfMsg);
                        break;
                    }
                }
                break block25;
            }
            switch (capiConfMsg.cmd) {
                case 128: {
                    capiPLC.received((FacilityConf)capiConfMsg);
                    break;
                }
                case 130: {
                    this.put(new DisconnectReq(capiConfMsg.appid, capiConfMsg.lineid));
                }
            }
        }
    }

    public void run() {
        Rider rider = new Rider();
        byte[] byArray = new byte[128];
        Thread.currentThread().setName(this.getClass().getName() + "." + this.getApplID());
        while (this.running) {
            MsgIn msgIn = null;
            try {
                jcapi.waitForMessage(this.appid);
                if (!this.running) break;
                byArray = jcapi.getMessage(this.appid, byArray);
                rider.set(byArray);
                msgIn = MsgIn.create(rider);
                if (msgIn.cmd != 134) {
                    this.md.fireListenerUpdate(msgIn);
                }
                if (msgIn.scmd == 129) {
                    this.handleConfMsg((CapiConfMsg)msgIn);
                    continue;
                }
                this.handleIndMsg((CapiIndMsg)msgIn);
            }
            catch (CapiException capiException) {
                capiException.printStackTrace();
                if (msgIn != null) {
                    System.err.println(msgIn.toString());
                }
                this.md.fireListenerUpdate(capiException);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                if (msgIn != null) {
                    System.err.println(msgIn.toString());
                }
                this.md.fireListenerUpdate("9\b" + this.getClass().getName() + ".run:\n\tFatal Error; Stopped capi application thread " + this.appid + ".\n\t" + throwable);
                break;
            }
        }
        try {
            jcapi.release(this.appid);
            this.rs.release();
            System.err.println(this.getClass().getName() + ".run: RELEASED CAPI APPLICATION " + this.appid);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

