/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.application.install;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import uk.co.mmscomputing.application.install.Engine;
import uk.co.mmscomputing.application.install.Log;
import uk.co.mmscomputing.application.install.Setup;
import uk.co.mmscomputing.application.install.Unzip;

public class MainApp
extends JApplet {
    Log log = new Log();
    Setup setup = new Setup(this.log);

    public void init() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.setup, "North");
        container.add((Component)this.log, "Center");
        JButton jButton = new JButton(this.getStartAction());
        container.add((Component)jButton, "South");
        this.log.msg("This installer will\nextract the 'uk.co.mmscomputing' packages in the installation directory,\ncompile all the '*.java' files,if provided with a valid path to a java compiler (javac),\nand start 'uk.co.mmscomputing.application.answerphone.MainApp'.\n\nA path to a java compiler might look like :\nWindows XP :     c:\\j2sdk1.4.2\\bin\\javac\nLinux :          /usr/java/j2sdk1.4.2/bin/javac\n\nPlease press the start button to continue.\n\n");
    }

    public Action getStartAction() {
        return new AbstractAction("start"){

            public void actionPerformed(ActionEvent actionEvent) {
                MainApp.this.start();
            }
        };
    }

    public void start() {
        final String string = this.setup.getJavac();
        final String string2 = this.setup.getUserdir();
        this.log.msg(string);
        new Thread(){

            public void run() {
                try {
                    if (MainApp.this.setup.getExtractIt()) {
                        new Unzip(MainApp.this.log).extract("mmsc.jar");
                    }
                    Engine engine = new Engine(MainApp.this.log);
                    if (MainApp.this.setup.getCompileIt()) {
                        engine.traverse(string2, string);
                        engine.metainf();
                    }
                    if (MainApp.this.setup.getStartImageViewer()) {
                        engine.run(string, string2, "uk.co.mmscomputing.application.imageviewer.MainApp");
                    }
                    if (MainApp.this.setup.getStartAnswerphone()) {
                        engine.run(string, string2, "uk.co.mmscomputing.application.answerphone.MainApp");
                    }
                }
                catch (Exception exception) {
                    MainApp.this.log.err(exception);
                }
            }
        }.start();
    }

    public void main(String string, String[] stringArray) {
        JFrame jFrame = new JFrame(string);
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().add(this);
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle rectangle = graphicsEnvironment.getMaximumWindowBounds();
        jFrame.setSize(rectangle.width, rectangle.height);
        this.init();
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        MainApp mainApp = new MainApp();
        mainApp.main("mmsc java package setup", stringArray);
    }
}

