/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.application.imageviewer;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Properties;
import javax.swing.JPanel;
import uk.co.mmscomputing.application.imageviewer.ImageTab;
import uk.co.mmscomputing.device.scanner.Scanner;
import uk.co.mmscomputing.device.scanner.ScannerIOMetadata;
import uk.co.mmscomputing.device.scanner.ScannerListener;
import uk.co.mmscomputing.device.twain.TwainCapability;
import uk.co.mmscomputing.device.twain.TwainConstants;
import uk.co.mmscomputing.device.twain.TwainExtImageInfo;
import uk.co.mmscomputing.device.twain.TwainIOMetadata;
import uk.co.mmscomputing.device.twain.TwainIdentity;
import uk.co.mmscomputing.device.twain.TwainImageInfo;
import uk.co.mmscomputing.device.twain.TwainImageLayout;
import uk.co.mmscomputing.device.twain.TwainScanner;
import uk.co.mmscomputing.device.twain.TwainSource;

public class ScannerTab
extends ImageTab
implements ScannerListener {
    private static int no = 1;
    private Scanner scanner;

    public ScannerTab(Properties properties) {
        super(properties);
    }

    protected void setButtonPanel(JPanel jPanel) {
        super.setButtonPanel(jPanel);
        try {
            this.scanner = Scanner.getDevice();
            if (this.scanner != null) {
                jPanel.add(this.scanner.getScanGUI());
                this.scanner.addListener(this);
                if (this.scanner instanceof TwainScanner) {
                    TwainIdentity[] twainIdentityArray = ((TwainScanner)this.scanner).getIdentities();
                    for (int i = 0; i < twainIdentityArray.length; ++i) {
                        System.out.println(twainIdentityArray[i].toString());
                    }
                }
            }
        }
        catch (Exception exception) {
            System.out.println("9\b" + this.getClass().getName() + ".setButtonPanel:\n\t" + exception);
        }
    }

    public void update(ScannerIOMetadata.Type type, ScannerIOMetadata scannerIOMetadata) {
        if (type.equals(ScannerIOMetadata.ACQUIRED)) {
            final BufferedImage bufferedImage = scannerIOMetadata.getImage();
            new Thread(){

                public void run() {
                    try {
                        ScannerTab.this.addImage("scan_" + no++, bufferedImage);
                    }
                    catch (Exception exception) {
                        System.out.println("9\b" + this.getClass().getName() + ".update:\n\t" + exception);
                        System.err.println(this.getClass().getName() + ".update:\n\t" + exception);
                        exception.printStackTrace();
                    }
                }
            }.start();
        } else if (type.equals(ScannerIOMetadata.FILE)) {
            final File file = scannerIOMetadata.getFile();
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        ScannerTab.this.open(file.getPath());
                    }
                    catch (Exception exception) {
                        System.out.println("9\b" + this.getClass().getName() + ".update:\n\t" + exception);
                        System.err.println(this.getClass().getName() + ".update:\n\t" + exception);
                        exception.printStackTrace();
                    }
                    finally {
                        if (!file.delete()) {
                            System.out.println("9\b" + this.getClass().getName() + ".update:\n\tCould not delete: " + file.getPath());
                            System.err.println(this.getClass().getName() + ".update:\n\tCould not delete: " + file.getPath());
                        }
                    }
                }
            }.start();
        } else if (type.equals(ScannerIOMetadata.NEGOTIATE)) {
            this.negotiate(scannerIOMetadata);
        } else if (type.equals(ScannerIOMetadata.STATECHANGE)) {
            System.out.println("Scanner State " + scannerIOMetadata.getStateStr());
            System.err.println("Scanner State " + scannerIOMetadata.getStateStr());
            if (scannerIOMetadata instanceof TwainIOMetadata) {
                if (scannerIOMetadata.isState(6)) {
                    TwainConstants twainConstants;
                    TwainSource twainSource = ((TwainIOMetadata)scannerIOMetadata).getSource();
                    try {
                        twainConstants = new TwainImageInfo(twainSource);
                        ((TwainImageInfo)twainConstants).get();
                        System.out.println(((TwainImageInfo)twainConstants).toString());
                    }
                    catch (Exception exception) {
                        System.out.println("3\b" + this.getClass().getName() + ".update:\n\tCannot retrieve image information.\n\t" + exception);
                    }
                    try {
                        twainConstants = new TwainImageLayout(twainSource);
                        ((TwainImageLayout)twainConstants).get();
                        System.out.println(((TwainImageLayout)twainConstants).toString());
                    }
                    catch (Exception exception) {
                        System.out.println("3\b" + this.getClass().getName() + ".update:\n\tCannot retrieve image layout.\n\t" + exception);
                    }
                } else if (scannerIOMetadata.isState(7)) {
                    TwainSource twainSource = ((TwainIOMetadata)scannerIOMetadata).getSource();
                    try {
                        int[] nArray = new int[64];
                        for (int i = 0; i < nArray.length; ++i) {
                            nArray[i] = 4608 + i;
                        }
                        TwainExtImageInfo twainExtImageInfo = new TwainExtImageInfo(twainSource, nArray);
                        twainExtImageInfo.get();
                        System.out.println(twainExtImageInfo.toString());
                    }
                    catch (Exception exception) {
                        System.out.println("3\b" + this.getClass().getName() + ".update:\n\tCannot retrieve extra image information.\n\t" + exception);
                    }
                }
            }
        } else if (type.equals(ScannerIOMetadata.INFO)) {
            System.out.println(scannerIOMetadata.getInfo());
        } else if (type.equals(ScannerIOMetadata.EXCEPTION)) {
            System.out.println("9\b" + scannerIOMetadata.getException().getMessage());
            scannerIOMetadata.getException().printStackTrace();
        }
    }

    private void negotiate(ScannerIOMetadata scannerIOMetadata) {
        if (scannerIOMetadata instanceof TwainIOMetadata) {
            TwainSource twainSource = ((TwainIOMetadata)scannerIOMetadata).getSource();
            try {
                TwainCapability[] twainCapabilityArray = twainSource.getCapabilities();
                for (int i = 0; i < twainCapabilityArray.length; ++i) {
                    System.out.println(twainCapabilityArray[i].toString());
                }
            }
            catch (Exception exception) {
                System.out.println("9\b" + exception.getMessage());
            }
        }
    }

    public void stop() {
        if (this.scanner != null) {
            this.scanner.waitToExit();
        }
    }
}

