/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.application.imageviewer;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JComponent;

public class ImagePanel
extends JComponent
implements Printable {
    protected BufferedImage image = new BufferedImage(1, 1, 1);

    public BufferedImage getImage() {
        return this.image;
    }

    public void setImage(BufferedImage bufferedImage) {
        this.image = bufferedImage;
        this.repaint();
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.drawImage((Image)this.image, 0, 0, null);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.image.getWidth(), this.image.getHeight());
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        Graphics2D graphics2D = (Graphics2D)graphics;
        double d = pageFormat.getImageableWidth() / (double)this.image.getWidth();
        double d2 = pageFormat.getImageableHeight() / (double)this.image.getHeight();
        double d3 = Math.min(d, d2);
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        graphics2D.drawImage(this.image, 0, 0, (int)((double)this.image.getWidth() * d3), (int)((double)this.image.getHeight() * d3), this);
        return 0;
    }

    public void rotate() {
        BufferedImage bufferedImage = this.image;
        try {
            int n = this.image.getWidth();
            int n2 = this.image.getHeight();
            int n3 = this.image.getType();
            this.image = ImagePanel.newImage(n, n2, n3);
            Graphics2D graphics2D = this.image.createGraphics();
            AffineTransform affineTransform = new AffineTransform(0.0, 1.0, -1.0, 0.0, (double)bufferedImage.getHeight(), 0.0);
            graphics2D.drawRenderedImage(bufferedImage, affineTransform);
            this.setSize(this.image.getWidth(), this.image.getHeight());
        }
        catch (Exception exception) {
            System.out.println("9\b" + this.getClass().getName() + "\n\t.rotate:\n\t" + exception.getMessage());
            this.image = bufferedImage;
            exception.printStackTrace();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.out.println("9\b" + this.getClass().getName() + "\n\t.rotate:\n\t" + outOfMemoryError.getMessage());
            this.image = bufferedImage;
        }
    }

    public static BufferedImage newImage(int n, int n2, int n3) throws Exception {
        try {
            return new BufferedImage(n2, n, n3);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.err.println("start gc ; free memory " + Runtime.getRuntime().freeMemory());
            Runtime.getRuntime().gc();
            System.err.println("end gc ; free memory " + Runtime.getRuntime().freeMemory());
            try {
                return new BufferedImage(n2, n, n3);
            }
            catch (OutOfMemoryError outOfMemoryError2) {
                throw new Exception("uk.co.mmscomputing.application.imageviewer.newImage:\n\t" + outOfMemoryError2.getMessage());
            }
        }
    }
}

