/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.JetFormat;
import com.healthmarketscience.jackcess.UsageMap;
import java.io.Flushable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PageChannel
implements Channel,
Flushable {
    private static final Log LOG = LogFactory.getLog(PageChannel.class);
    static final int INVALID_PAGE_NUMBER = -1;
    static final ByteOrder DEFAULT_BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private static final byte[] INVALID_PAGE_BYTE_HEADER = new byte[]{0, 0, 0, 0};
    private static final int PAGE_GLOBAL_USAGE_MAP = 1;
    private static final int ROW_GLOBAL_USAGE_MAP = 0;
    private final FileChannel _channel;
    private final JetFormat _format;
    private final boolean _autoSync;
    private final ByteBuffer _invalidPageBytes = ByteBuffer.wrap(INVALID_PAGE_BYTE_HEADER);
    private final ByteBuffer _forceBytes = ByteBuffer.allocate(1);
    private UsageMap _globalUsageMap;

    public PageChannel(FileChannel channel, JetFormat format, boolean autoSync) throws IOException {
        this._channel = channel;
        this._format = format;
        this._autoSync = autoSync;
    }

    public void initialize(Database database) throws IOException {
        this._globalUsageMap = UsageMap.read(database, 1, 0, true);
    }

    PageChannel(boolean testing) {
        if (!testing) {
            throw new IllegalArgumentException();
        }
        this._channel = null;
        this._format = JetFormat.VERSION_4;
        this._autoSync = false;
    }

    public JetFormat getFormat() {
        return this._format;
    }

    private int getNextPageNumber(long size) {
        return (int)(size / (long)this.getFormat().PAGE_SIZE);
    }

    private long getPageOffset(int pageNumber) {
        return (long)pageNumber * (long)this.getFormat().PAGE_SIZE;
    }

    private void validatePageNumber(int pageNumber) throws IOException {
        int nextPageNumber = this.getNextPageNumber(this._channel.size());
        if (pageNumber <= -1 || pageNumber >= nextPageNumber) {
            throw new IllegalStateException("invalid page number " + pageNumber);
        }
    }

    public void readPage(ByteBuffer buffer, int pageNumber) throws IOException {
        this.validatePageNumber(pageNumber);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Reading in page " + Integer.toHexString(pageNumber)));
        }
        buffer.clear();
        int bytesRead = this._channel.read(buffer, (long)pageNumber * (long)this.getFormat().PAGE_SIZE);
        buffer.flip();
        if (bytesRead != this.getFormat().PAGE_SIZE) {
            throw new IOException("Failed attempting to read " + this.getFormat().PAGE_SIZE + " bytes from page " + pageNumber + ", only read " + bytesRead);
        }
    }

    public void writePage(ByteBuffer page, int pageNumber) throws IOException {
        this.writePage(page, pageNumber, 0);
    }

    public void writePage(ByteBuffer page, int pageNumber, int pageOffset) throws IOException {
        this.validatePageNumber(pageNumber);
        page.rewind();
        if (page.remaining() - pageOffset > this.getFormat().PAGE_SIZE) {
            throw new IllegalArgumentException("Page buffer is too large, size " + (page.remaining() - pageOffset));
        }
        page.position(pageOffset);
        this._channel.write(page, this.getPageOffset(pageNumber) + (long)pageOffset);
        if (this._autoSync) {
            this.flush();
        }
    }

    public int writeNewPage(ByteBuffer page) throws IOException {
        long size = this._channel.size();
        if (size >= this.getFormat().MAX_DATABASE_SIZE) {
            throw new IOException("Database is at maximum size " + this.getFormat().MAX_DATABASE_SIZE);
        }
        if (size % (long)this.getFormat().PAGE_SIZE != 0L) {
            throw new IOException("Database corrupted, file size " + size + " is not multiple of page size " + this.getFormat().PAGE_SIZE);
        }
        page.rewind();
        if (page.remaining() > this.getFormat().PAGE_SIZE) {
            throw new IllegalArgumentException("Page buffer is too large, size " + page.remaining());
        }
        long offset = size + (long)(this.getFormat().PAGE_SIZE - page.remaining());
        this._channel.write(page, offset);
        int pageNumber = this.getNextPageNumber(size);
        this._globalUsageMap.removePageNumber(pageNumber);
        return pageNumber;
    }

    public int allocateNewPage() throws IOException {
        return this.writeNewPage(this._forceBytes);
    }

    public void deallocatePage(int pageNumber) throws IOException {
        this.validatePageNumber(pageNumber);
        this._invalidPageBytes.rewind();
        this._channel.write(this._invalidPageBytes, this.getPageOffset(pageNumber));
        this._globalUsageMap.addPageNumber(pageNumber);
    }

    public ByteBuffer createPageBuffer() {
        return this.createBuffer(this.getFormat().PAGE_SIZE);
    }

    public ByteBuffer createBuffer(int size) {
        return this.createBuffer(size, ByteOrder.LITTLE_ENDIAN);
    }

    public ByteBuffer createBuffer(int size, ByteOrder order) {
        ByteBuffer rtn = ByteBuffer.allocate(size);
        rtn.order(order);
        return rtn;
    }

    public void flush() throws IOException {
        this._channel.force(true);
    }

    public void close() throws IOException {
        this.flush();
        this._channel.close();
    }

    public boolean isOpen() {
        return this._channel.isOpen();
    }

    public static ByteBuffer narrowBuffer(ByteBuffer buffer, int position, int limit) {
        return (ByteBuffer)buffer.duplicate().order(buffer.order()).clear().limit(limit).position(position).mark();
    }
}

