/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.crypto.Cipher;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Null;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.cms.Time;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSSignedHelper;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.CounterSignatureDigestCalculator;
import org.bouncycastle.cms.DigestCalculator;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformationStore;

public class SignerInformation {
    private SignerId sid;
    private SignerInfo info;
    private AlgorithmIdentifier digestAlgorithm;
    private AlgorithmIdentifier encryptionAlgorithm;
    private ASN1Set signedAttributes;
    private ASN1Set unsignedAttributes;
    private CMSProcessable content;
    private byte[] signature;
    private DERObjectIdentifier contentType;
    private DigestCalculator digestCalculator;
    private byte[] resultDigest;

    SignerInformation(SignerInfo info, DERObjectIdentifier contentType, CMSProcessable content, DigestCalculator digestCalculator) {
        this.info = info;
        this.sid = new SignerId();
        this.contentType = contentType;
        try {
            SignerIdentifier s = info.getSID();
            if (s.isTagged()) {
                ASN1OctetString octs = ASN1OctetString.getInstance(s.getId());
                this.sid.setSubjectKeyIdentifier(octs.getEncoded());
            } else {
                IssuerAndSerialNumber iAnds = IssuerAndSerialNumber.getInstance(s.getId());
                this.sid.setIssuer(iAnds.getName().getEncoded());
                this.sid.setSerialNumber(iAnds.getSerialNumber().getValue());
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("invalid sid in SignerInfo");
        }
        this.digestAlgorithm = info.getDigestAlgorithm();
        this.signedAttributes = info.getAuthenticatedAttributes();
        this.unsignedAttributes = info.getUnauthenticatedAttributes();
        this.encryptionAlgorithm = info.getDigestEncryptionAlgorithm();
        this.signature = info.getEncryptedDigest().getOctets();
        this.content = content;
        this.digestCalculator = digestCalculator;
    }

    private byte[] encodeObj(DEREncodable obj) throws IOException {
        if (obj != null) {
            return obj.getDERObject().getEncoded();
        }
        return null;
    }

    public SignerId getSID() {
        return this.sid;
    }

    public int getVersion() {
        return this.info.getVersion().getValue().intValue();
    }

    public String getDigestAlgOID() {
        return this.digestAlgorithm.getObjectId().getId();
    }

    public byte[] getDigestAlgParams() {
        try {
            return this.encodeObj(this.digestAlgorithm.getParameters());
        }
        catch (Exception e) {
            throw new RuntimeException("exception getting digest parameters " + e);
        }
    }

    public byte[] getContentDigest() {
        if (this.resultDigest == null) {
            throw new IllegalStateException("method can only be called after verify.");
        }
        return (byte[])this.resultDigest.clone();
    }

    public String getEncryptionAlgOID() {
        return this.encryptionAlgorithm.getObjectId().getId();
    }

    public byte[] getEncryptionAlgParams() {
        try {
            return this.encodeObj(this.encryptionAlgorithm.getParameters());
        }
        catch (Exception e) {
            throw new RuntimeException("exception getting encryption parameters " + e);
        }
    }

    public AttributeTable getSignedAttributes() {
        if (this.signedAttributes == null) {
            return null;
        }
        return new AttributeTable(this.signedAttributes);
    }

    public AttributeTable getUnsignedAttributes() {
        if (this.unsignedAttributes == null) {
            return null;
        }
        return new AttributeTable(this.unsignedAttributes);
    }

    public byte[] getSignature() {
        return (byte[])this.signature.clone();
    }

    public SignerInformationStore getCounterSignatures() {
        AttributeTable unsignedAttributeTable = this.getUnsignedAttributes();
        if (unsignedAttributeTable == null) {
            return new SignerInformationStore(new ArrayList(0));
        }
        ArrayList<SignerInformation> counterSignatures = new ArrayList<SignerInformation>();
        ASN1EncodableVector allCSAttrs = unsignedAttributeTable.getAll(CMSAttributes.counterSignature);
        int i = 0;
        while (i < allCSAttrs.size()) {
            Attribute counterSignatureAttribute = (Attribute)allCSAttrs.get(i);
            ASN1Set values = counterSignatureAttribute.getAttrValues();
            values.size();
            Enumeration en = values.getObjects();
            while (en.hasMoreElements()) {
                SignerInfo si = SignerInfo.getInstance(en.nextElement());
                String digestName = CMSSignedHelper.INSTANCE.getDigestAlgName(si.getDigestAlgorithm().getObjectId().getId());
                counterSignatures.add(new SignerInformation(si, CMSAttributes.counterSignature, null, new CounterSignatureDigestCalculator(digestName, null, this.getSignature())));
            }
            ++i;
        }
        return new SignerInformationStore(counterSignatures);
    }

    public byte[] getEncodedSignedAttributes() throws IOException {
        if (this.signedAttributes != null) {
            return this.signedAttributes.getEncoded("DER");
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doVerify(PublicKey key, AttributeTable signedAttrTable, Provider sigProvider) throws CMSException, NoSuchAlgorithmException {
        String digestName = CMSSignedHelper.INSTANCE.getDigestAlgName(this.getDigestAlgOID());
        String signatureName = String.valueOf(digestName) + "with" + CMSSignedHelper.INSTANCE.getEncryptionAlgName(this.getEncryptionAlgOID());
        Signature sig = CMSSignedHelper.INSTANCE.getSignatureInstance(signatureName, sigProvider);
        MessageDigest digest = CMSSignedHelper.INSTANCE.getDigestInstance(digestName, sigProvider);
        try {
            DERObjectIdentifier typeOID;
            byte[] hash;
            sig.initVerify(key);
            if (this.signedAttributes == null) {
                if (this.content != null) {
                    this.content.write(new CMSSignedDataGenerator.SigOutputStream(sig));
                    this.content.write(new CMSSignedDataGenerator.DigOutputStream(digest));
                    this.resultDigest = digest.digest();
                    return sig.verify(this.getSignature());
                }
                this.resultDigest = this.digestCalculator.getDigest();
                return this.verifyDigest(this.resultDigest, key, this.getSignature(), sigProvider);
            }
            if (this.content != null) {
                this.content.write(new CMSSignedDataGenerator.DigOutputStream(digest));
                hash = digest.digest();
            } else {
                hash = this.digestCalculator != null ? this.digestCalculator.getDigest() : (byte[])null;
            }
            this.resultDigest = hash;
            Attribute dig = signedAttrTable.get(CMSAttributes.messageDigest);
            Attribute type = signedAttrTable.get(CMSAttributes.contentType);
            if (dig == null) {
                throw new SignatureException("no hash for content found in signed attributes");
            }
            if (type == null && !this.contentType.equals(CMSAttributes.counterSignature)) {
                throw new SignatureException("no content type id found in signed attributes");
            }
            DERObject hashObj = dig.getAttrValues().getObjectAt(0).getDERObject();
            if (hashObj instanceof ASN1OctetString) {
                byte[] signedHash = ((ASN1OctetString)hashObj).getOctets();
                if (!MessageDigest.isEqual(hash, signedHash)) {
                    throw new SignatureException("content hash found in signed attributes different");
                }
            } else if (hashObj instanceof DERNull && hash != null) {
                throw new SignatureException("NULL hash found in signed attributes when one expected");
            }
            if (type != null && !(typeOID = (DERObjectIdentifier)type.getAttrValues().getObjectAt(0)).equals(this.contentType)) {
                throw new SignatureException("contentType in signed attributes different");
            }
            sig.update(this.getEncodedSignedAttributes());
            return sig.verify(this.getSignature());
        }
        catch (InvalidKeyException e) {
            throw new CMSException("key not appropriate to signature in message.", e);
        }
        catch (IOException e) {
            throw new CMSException("can't process mime object to create signature.", e);
        }
        catch (SignatureException e) {
            throw new CMSException("invalid signature format in message: " + e.getMessage(), e);
        }
    }

    private boolean isNull(DEREncodable o) {
        return o instanceof ASN1Null || o == null;
    }

    private DigestInfo derDecode(byte[] encoding) throws IOException, CMSException {
        if (encoding[0] != 48) {
            throw new IOException("not a digest info object");
        }
        ASN1InputStream aIn = new ASN1InputStream(encoding);
        DigestInfo digInfo = new DigestInfo((ASN1Sequence)aIn.readObject());
        if (digInfo.getEncoded().length != encoding.length) {
            throw new CMSException("malformed RSA signature");
        }
        return digInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean verifyDigest(byte[] digest, PublicKey key, byte[] signature, Provider sigProvider) throws NoSuchAlgorithmException, CMSException {
        String algorithm = CMSSignedHelper.INSTANCE.getEncryptionAlgName(this.getEncryptionAlgOID());
        try {
            if (algorithm.equals("RSA")) {
                Cipher c = sigProvider != null ? Cipher.getInstance("RSA/ECB/PKCS1Padding", sigProvider) : Cipher.getInstance("RSA/ECB/PKCS1Padding");
                c.init(2, key);
                DigestInfo digInfo = this.derDecode(c.doFinal(signature));
                if (!digInfo.getAlgorithmId().getObjectId().equals(this.digestAlgorithm.getObjectId())) {
                    return false;
                }
                if (!this.isNull(digInfo.getAlgorithmId().getParameters())) {
                    return false;
                }
                byte[] sigHash = digInfo.getDigest();
                return MessageDigest.isEqual(digest, sigHash);
            }
            if (!algorithm.equals("DSA")) {
                throw new CMSException("algorithm: " + algorithm + " not supported in base signatures.");
            }
            Signature sig = sigProvider != null ? Signature.getInstance("NONEwithDSA", sigProvider) : Signature.getInstance("NONEwithDSA");
            sig.initVerify(key);
            sig.update(digest);
            return sig.verify(signature);
        }
        catch (GeneralSecurityException e) {
            throw new CMSException("Exception processing signature: " + e, e);
        }
        catch (IOException e) {
            throw new CMSException("Exception decoding signature: " + e, e);
        }
    }

    public boolean verify(PublicKey key, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.doVerify(key, this.getSignedAttributes(), CMSUtils.getProvider(sigProvider));
    }

    public boolean verify(PublicKey key, Provider sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.doVerify(key, this.getSignedAttributes(), sigProvider);
    }

    public boolean verify(X509Certificate cert, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, CertificateExpiredException, CertificateNotYetValidException, CMSException {
        return this.verify(cert, CMSUtils.getProvider(sigProvider));
    }

    public boolean verify(X509Certificate cert, Provider sigProvider) throws NoSuchAlgorithmException, CertificateExpiredException, CertificateNotYetValidException, CMSException {
        AttributeTable attr = this.getSignedAttributes();
        if (attr != null) {
            ASN1EncodableVector v = attr.getAll(CMSAttributes.signingTime);
            switch (v.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    Attribute t = (Attribute)v.get(0);
                    ASN1Set attrValues = t.getAttrValues();
                    if (attrValues.size() != 1) {
                        throw new CMSException("A signing-time attribute MUST have a single attribute value");
                    }
                    Time time = Time.getInstance(attrValues.getObjectAt(0).getDERObject());
                    cert.checkValidity(time.getDate());
                    break;
                }
                default: {
                    throw new CMSException("The SignedAttributes in a signerInfo MUST NOT include multiple instances of the signing-time attribute");
                }
            }
        }
        return this.doVerify(cert.getPublicKey(), attr, sigProvider);
    }

    public SignerInfo toSignerInfo() {
        return this.info;
    }

    public static SignerInformation replaceUnsignedAttributes(SignerInformation signerInformation, AttributeTable unsignedAttributes) {
        SignerInfo sInfo = signerInformation.info;
        DERSet unsignedAttr = null;
        if (unsignedAttributes != null) {
            unsignedAttr = new DERSet(unsignedAttributes.toASN1EncodableVector());
        }
        return new SignerInformation(new SignerInfo(sInfo.getSID(), sInfo.getDigestAlgorithm(), sInfo.getAuthenticatedAttributes(), sInfo.getDigestEncryptionAlgorithm(), sInfo.getEncryptedDigest(), unsignedAttr), signerInformation.contentType, signerInformation.content, null);
    }

    public static SignerInformation addCounterSigners(SignerInformation signerInformation, SignerInformationStore counterSigners) {
        SignerInfo sInfo = signerInformation.info;
        AttributeTable unsignedAttr = signerInformation.getUnsignedAttributes();
        ASN1EncodableVector v = unsignedAttr != null ? unsignedAttr.toASN1EncodableVector() : new ASN1EncodableVector();
        ASN1EncodableVector sigs = new ASN1EncodableVector();
        Iterator it = counterSigners.getSigners().iterator();
        while (it.hasNext()) {
            sigs.add(((SignerInformation)it.next()).toSignerInfo());
        }
        v.add(new Attribute(CMSAttributes.counterSignature, new DERSet(sigs)));
        return new SignerInformation(new SignerInfo(sInfo.getSID(), sInfo.getDigestAlgorithm(), sInfo.getAuthenticatedAttributes(), sInfo.getDigestEncryptionAlgorithm(), sInfo.getEncryptedDigest(), new DERSet(v)), signerInformation.contentType, signerInformation.content, null);
    }
}

