/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.Attribute;

public class AttributeTable {
    private Hashtable attributes = new Hashtable();

    public AttributeTable(Hashtable attrs) {
        this.attributes = this.copyTable(attrs);
    }

    public AttributeTable(DEREncodableVector v) {
        int i = 0;
        while (i != v.size()) {
            Attribute a = Attribute.getInstance(v.get(i));
            this.addAttribute(a.getAttrType(), a);
            ++i;
        }
    }

    public AttributeTable(ASN1Set s) {
        int i = 0;
        while (i != s.size()) {
            Attribute a = Attribute.getInstance(s.getObjectAt(i));
            this.addAttribute(a.getAttrType(), a);
            ++i;
        }
    }

    private void addAttribute(DERObjectIdentifier oid, Attribute a) {
        Object value = this.attributes.get(oid);
        if (value == null) {
            this.attributes.put(oid, a);
        } else {
            Vector<Object> v;
            if (value instanceof Attribute) {
                v = new Vector<Object>();
                v.addElement(value);
                v.addElement(a);
            } else {
                v = (Vector<Object>)value;
                v.addElement(a);
            }
            this.attributes.put(oid, v);
        }
    }

    public Attribute get(DERObjectIdentifier oid) {
        Object value = this.attributes.get(oid);
        if (value instanceof Vector) {
            return (Attribute)((Vector)value).elementAt(0);
        }
        return (Attribute)value;
    }

    public ASN1EncodableVector getAll(DERObjectIdentifier oid) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        Object value = this.attributes.get(oid);
        if (value instanceof Vector) {
            Enumeration e = ((Vector)value).elements();
            while (e.hasMoreElements()) {
                v.add((Attribute)e.nextElement());
            }
        } else if (value != null) {
            v.add((Attribute)value);
        }
        return v;
    }

    public Hashtable toHashtable() {
        return this.copyTable(this.attributes);
    }

    public ASN1EncodableVector toASN1EncodableVector() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        Enumeration e = this.attributes.elements();
        while (e.hasMoreElements()) {
            Object value = e.nextElement();
            if (value instanceof Vector) {
                Enumeration en = ((Vector)value).elements();
                while (en.hasMoreElements()) {
                    v.add(Attribute.getInstance(en.nextElement()));
                }
                continue;
            }
            v.add(Attribute.getInstance(value));
        }
        return v;
    }

    private Hashtable copyTable(Hashtable in) {
        Hashtable out = new Hashtable();
        Enumeration e = in.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            out.put(key, in.get(key));
        }
        return out;
    }
}

