/*
 * Decompiled with CFR 0.152.
 */
package lu.luxtrust.pkix.pkcs.p7;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lu.luxtrust.pkix.pkcs.p7.AbstractAny;
import lu.luxtrust.pkix.pkcs.p7.DER;
import lu.luxtrust.pkix.pkcs.p7.TypeMismatchException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Sequence
extends AbstractAny
implements Serializable {
    private final DER der;

    private static final List<DER> listOf(DER ... ders) {
        if (ders == null) {
            return Collections.emptyList();
        }
        ArrayList<DER> seq = new ArrayList<DER>(ders.length);
        DER[] dERArray = ders;
        int n = ders.length;
        int n2 = 0;
        while (n2 < n) {
            DER der = dERArray[n2];
            if (der == null) {
                throw new NullPointerException("A sequence component must not be null.");
            }
            seq.add(der);
            ++n2;
        }
        return seq;
    }

    public Sequence(List<? extends DER> list) {
        this.der = new DER(list != null ? list : new ArrayList(0));
    }

    public Sequence(DER ... ders) {
        this.der = new DER(Sequence.listOf(ders));
    }

    private Sequence(DER der, boolean internal) {
        this.der = der;
    }

    public final DER get(int i) {
        return (DER)((List)((Object)this.der.getContent())).get(i);
    }

    public final int size() {
        return ((List)((Object)this.der.getContent())).size();
    }

    @Override
    public final DER asDER() {
        return this.der;
    }

    public static final Sequence cast(DER der, int minimum, int maximum) {
        if (der != null && der.getType() == -16) {
            List seq = (List)((Object)der.getContent());
            if (minimum <= seq.size() && (maximum < 0 || maximum >= seq.size())) {
                return new Sequence(der, true);
            }
            throw new TypeMismatchException("The " + der + " der is not a Sequence of size " + (maximum != minimum ? "[" + minimum + ".." + (maximum < 0 ? "any" : Integer.toString(maximum)) + "]" : Integer.toString(maximum)) + ".");
        }
        throw new TypeMismatchException("The " + der + " der is not a Sequence.");
    }
}

