/*
 * Decompiled with CFR 0.152.
 */
package lu.luxtrust.pkix.pkcs.p7;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import lu.luxtrust.pkix.pkcs.p7.AbstractAny;
import lu.luxtrust.pkix.pkcs.p7.Any;
import lu.luxtrust.pkix.pkcs.p7.AttributeTypeAndValue;
import lu.luxtrust.pkix.pkcs.p7.DER;
import lu.luxtrust.pkix.pkcs.p7.TypeMismatchException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RelativeDistinguishedName
extends AbstractAny
implements Serializable {
    public static final Any.Factory<RelativeDistinguishedName> FACTORY = new Any.Factory<RelativeDistinguishedName>(){

        @Override
        public RelativeDistinguishedName cast(DER der) {
            return RelativeDistinguishedName.cast(der);
        }
    };
    public static final DER CN = RelativeDistinguishedName.ofType(new int[]{2, 5, 4, 3});
    public static final DER SURNAME = RelativeDistinguishedName.ofType(new int[]{2, 5, 4, 4});
    public static final DER SERIALNUMBER = RelativeDistinguishedName.ofType(new int[]{2, 5, 4, 5});
    public static final DER C = RelativeDistinguishedName.ofType(new int[]{2, 5, 4, 6});
    public static final DER L = RelativeDistinguishedName.ofType(new int[]{2, 5, 4, 7});
    public static final DER S = RelativeDistinguishedName.ofType(new int[]{2, 5, 4, 8});
    public static final DER O = RelativeDistinguishedName.ofType(new int[]{2, 5, 4, 10});
    public static final DER OU = RelativeDistinguishedName.ofType(new int[]{2, 5, 4, 11});
    public static final DER T = RelativeDistinguishedName.ofType(new int[]{2, 5, 4, 12});
    public static final DER GIVENNAME = RelativeDistinguishedName.ofType(new int[]{2, 5, 4, 42});
    public static final DER INITIALS = RelativeDistinguishedName.ofType(new int[]{2, 5, 4, 43});
    public static final DER GENERATION = RelativeDistinguishedName.ofType(new int[]{2, 5, 4, 44});
    public static final DER DNQUALIFIER = RelativeDistinguishedName.ofType(new int[]{2, 5, 4, 46});
    private static final Map<DER, String> oidNameMap = new HashMap<DER, String>();
    private final DER type;
    private final DER value;
    private DER set;

    static {
        oidNameMap.put(CN, "CN");
        oidNameMap.put(SURNAME, "SURNAME");
        oidNameMap.put(SERIALNUMBER, "SERIALNUMBER");
        oidNameMap.put(C, "C");
        oidNameMap.put(L, "L");
        oidNameMap.put(S, "S");
        oidNameMap.put(O, "O");
        oidNameMap.put(OU, "OU");
        oidNameMap.put(T, "T");
        oidNameMap.put(GIVENNAME, "GIVENNAME");
        oidNameMap.put(INITIALS, "INITIALS");
        oidNameMap.put(GENERATION, "GENERATION");
        oidNameMap.put(DNQUALIFIER, "DNQUALIFIER");
    }

    private static DER ofValue(String value) {
        return new DER(-19, value);
    }

    private static final DER singletonOf(AttributeTypeAndValue component) {
        TreeSet<DER> singleton = new TreeSet<DER>();
        singleton.add(component.asDER());
        return new DER(singleton);
    }

    private static final AttributeTypeAndValue getContent(SortedSet<DER> set) {
        return AttributeTypeAndValue.cast(set.first());
    }

    private static final DER ofType(int[] type) {
        return new DER(type);
    }

    public RelativeDistinguishedName(DER type, DER value) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (type.getType() != -6) {
            throw new IllegalArgumentException("type");
        }
        this.type = type;
        this.value = value;
    }

    public RelativeDistinguishedName(int[] type, DER value) {
        this(new DER(type), value);
    }

    public RelativeDistinguishedName(DER type, String value) {
        this(type, RelativeDistinguishedName.ofValue(value));
    }

    private DER createDER() {
        return RelativeDistinguishedName.singletonOf(new AttributeTypeAndValue(this.type, this.value));
    }

    @Override
    public DER asDER() {
        if (this.set == null) {
            this.set = this.createDER();
        }
        return this.set;
    }

    public DER getType() {
        return this.type;
    }

    public DER getValue() {
        return this.value;
    }

    public String toString() {
        StringBuffer buffy = new StringBuffer();
        buffy.append(oidNameMap.get(this.getType()));
        buffy.append('=');
        buffy.append((String)((Object)this.getValue().getContent()));
        return buffy.toString();
    }

    public static final RelativeDistinguishedName cast(DER der) {
        SortedSet set;
        if (der != null && der.getType() == -17 && (set = (SortedSet)((Object)der.getContent())).size() == 1) {
            AttributeTypeAndValue component = RelativeDistinguishedName.getContent(set);
            RelativeDistinguishedName r = new RelativeDistinguishedName(component.getType(), component.getValue());
            r.set = der;
            return r;
        }
        throw new TypeMismatchException("The " + der + " der is not a supported RelativeDistinguishedName.");
    }
}

