/*
 * Decompiled with CFR 0.152.
 */
package lu.luxtrust.pkix.pkcs.p7;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import lu.luxtrust.pkix.pkcs.p7.AbstractAny;
import lu.luxtrust.pkix.pkcs.p7.Any;
import lu.luxtrust.pkix.pkcs.p7.DER;
import lu.luxtrust.pkix.pkcs.p7.DERUtil;
import lu.luxtrust.pkix.pkcs.p7.DistinguishedName;
import lu.luxtrust.pkix.pkcs.p7.Sequence;

class IssuerAndSerialNumber
extends AbstractAny
implements Serializable {
    public static final Any.Factory<IssuerAndSerialNumber> FACTORY = new Any.Factory<IssuerAndSerialNumber>(){

        @Override
        public IssuerAndSerialNumber cast(DER der) {
            return IssuerAndSerialNumber.cast(der);
        }
    };
    private final DistinguishedName issuer;
    private final BigInteger serial;
    private DER der;

    public IssuerAndSerialNumber(DistinguishedName issuer, BigInteger serialNumber) {
        if (issuer == null) {
            throw new NullPointerException();
        }
        if (serialNumber == null) {
            throw new NullPointerException();
        }
        this.issuer = issuer;
        this.serial = serialNumber;
    }

    private DER createDER() {
        ArrayList<DER> list = new ArrayList<DER>();
        list.add(this.issuer.asDER());
        list.add(new DER(this.serial));
        return new DER(list);
    }

    public DistinguishedName getIssuer() {
        return this.issuer;
    }

    public BigInteger getSerialNumber() {
        return this.serial;
    }

    public DER asDER() {
        if (this.der == null) {
            this.der = this.createDER();
        }
        return this.der;
    }

    public static IssuerAndSerialNumber cast(DER der) {
        Sequence seq = Sequence.cast(der, 2, 2);
        DistinguishedName issuer = DistinguishedName.cast(seq.get(0));
        DER serial = seq.get(1);
        DERUtil.checkType(serial, -2);
        IssuerAndSerialNumber i = new IssuerAndSerialNumber(issuer, (BigInteger)serial.getContent());
        i.der = der;
        return i;
    }
}

