/*
 * Decompiled with CFR 0.152.
 */
package lu.luxtrust.pkix.pkcs.p7;

import java.io.IOException;
import java.io.Serializable;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;
import lu.luxtrust.pkix.pkcs.p7.AbstractAny;
import lu.luxtrust.pkix.pkcs.p7.Any;
import lu.luxtrust.pkix.pkcs.p7.DER;
import lu.luxtrust.pkix.pkcs.p7.DERException;
import lu.luxtrust.pkix.pkcs.p7.DERUtil;
import lu.luxtrust.pkix.pkcs.p7.Sequence;
import lu.luxtrust.pkix.pkcs.p7.TypeMismatchException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Extension
extends AbstractAny
implements Serializable {
    public static final Any.Factory<Extension> FACTORY = new Any.Factory<Extension>(){

        @Override
        public Extension cast(DER der) {
            return Extension.cast(der);
        }
    };
    private final DER id;
    private final boolean critical;
    private final DER value;
    private Sequence sequence;

    private static final DER oid(int[] oid) {
        return new DER(oid);
    }

    private static final DER wrap(DER der) throws DERException {
        if (der != null) {
            try {
                return new DER(der);
            }
            catch (IOException ex) {
                throw new DERException("Problem when encoding the " + der + " extension.", ex);
            }
        }
        return null;
    }

    private static final DER unwrap(DER der) throws IOException {
        if (der.getType() != -4) {
            throw new TypeMismatchException("DER " + der + " is not an octet string");
        }
        byte[] content = (byte[])der.getContent();
        return DER.decode(content);
    }

    private static final <T> List<T> nonNull(List<T> list) {
        if (list == null || list.isEmpty()) {
            throw new NullPointerException("The argument list must not be null or empty.");
        }
        return list;
    }

    public Extension(DER extnID, boolean critical, DER extnValue) {
        if (extnID == null) {
            throw new NullPointerException("extnID");
        }
        if (extnValue == null) {
            throw new NullPointerException("extnValue");
        }
        if (extnID.getType() != -6) {
            throw new IllegalArgumentException("extnID must be an object identifier");
        }
        this.id = extnID;
        this.critical = critical;
        this.value = extnValue;
    }

    private Extension(DER extnID, boolean critical, DER extnValue, boolean internal) throws DERException {
        if (extnID == null) {
            throw new NullPointerException("extnID");
        }
        if (extnValue == null) {
            throw new NullPointerException("extnValue");
        }
        if (extnID.getType() != -6) {
            throw new IllegalArgumentException("extnID must be an object identifier");
        }
        this.id = extnID;
        this.critical = critical;
        try {
            this.value = Extension.unwrap(extnValue);
        }
        catch (DERException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Extension(DER extnID, DER extnValue) {
        this(extnID, false, extnValue);
    }

    public DER getextnID() {
        return this.id;
    }

    public boolean isCritical() {
        return this.critical;
    }

    public DER getextnValue() {
        return this.value;
    }

    @Override
    public final DER asDER() {
        if (this.sequence == null) {
            try {
                this.sequence = this.critical ? new Sequence(this.id, new DER(this.critical), Extension.wrap(this.value)) : new Sequence(this.id, Extension.wrap(this.value));
            }
            catch (DERException ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.sequence.asDER();
    }

    public static final Extension cast(DER der) {
        Sequence seq = Sequence.cast(der, 2, 3);
        if (seq != null && seq.get(0).getType() == -6 && (seq.size() > 2 ? seq.get(1).getType() == -1 && seq.get(2).getType() == -4 : seq.get(1).getType() == -4)) {
            Extension ext;
            try {
                ext = new Extension(seq.get(0), seq.size() > 2 ? (Boolean)seq.get(1).getContent() : Boolean.FALSE, seq.get(seq.size() - 1), true);
            }
            catch (DERException e) {
                throw new TypeMismatchException("DER " + der + " is not a n Extension.");
            }
            ext.sequence = seq;
            return ext;
        }
        throw new TypeMismatchException("The " + der + " der is not an Extension.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ExtendedKeyUsage
    extends Extension {
        public static final DER anyExtendedKeyUsage;
        public static final DER serverAuth;
        public static final DER clientAuth;
        public static final DER codeSigning;
        public static final DER emailProtection;
        public static final DER timeStamping;
        public static final DER OCSPSigning;
        public static final DER nsServerGatedCryptography;
        public static final DER msServerGatedCryptography;
        private final List<? extends DER> keyUsages;
        public static final DER OID;

        static {
            int[] nArray = new int[5];
            nArray[0] = 2;
            nArray[1] = 5;
            nArray[2] = 29;
            nArray[3] = 37;
            anyExtendedKeyUsage = Extension.oid(nArray);
            serverAuth = Extension.oid(new int[]{1, 3, 6, 1, 5, 5, 7, 3, 1});
            clientAuth = Extension.oid(new int[]{1, 3, 6, 1, 5, 5, 7, 3, 2});
            codeSigning = Extension.oid(new int[]{1, 3, 6, 1, 5, 5, 7, 3, 3});
            emailProtection = Extension.oid(new int[]{1, 3, 6, 1, 5, 5, 7, 3, 4});
            timeStamping = Extension.oid(new int[]{1, 3, 6, 1, 5, 5, 7, 3, 8});
            OCSPSigning = Extension.oid(new int[]{1, 3, 6, 1, 5, 5, 7, 3, 9});
            nsServerGatedCryptography = Extension.oid(new int[]{2, 16, 840, 1, 113730, 4, 1});
            msServerGatedCryptography = Extension.oid(new int[]{1, 3, 6, 1, 4, 1, 311, 10, 3, 3});
            OID = Extension.oid(new int[]{2, 5, 29, 37});
        }

        public ExtendedKeyUsage(List<? extends DER> keyPurposeId) {
            super(OID, new Sequence(keyPurposeId).asDER());
            this.keyUsages = keyPurposeId;
        }

        public ExtendedKeyUsage(List<? extends DER> keyPurposeId, boolean critical) {
            super(OID, critical, new Sequence(keyPurposeId).asDER());
            this.keyUsages = keyPurposeId;
        }

        public boolean hasKeyUsage(DER oid) {
            return this.keyUsages.contains(oid);
        }

        public List<? extends DER> getKeyUsages() {
            return this.keyUsages;
        }

        public String toOIDString() {
            return ExtendedKeyUsage.toOIDString((int[])this.getextnValue().getContent());
        }

        public static final String OIDStringFromDER(DER oid) throws TypeMismatchException {
            if (oid.getType() != -6) {
                throw new TypeMismatchException("DER " + oid + " is not an object identifier.");
            }
            return ExtendedKeyUsage.toOIDString((int[])oid.getContent());
        }

        private static final String toOIDString(int[] oid) {
            StringBuffer buffy = new StringBuffer();
            if (oid == null) {
                return null;
            }
            int i = 0;
            while (i < oid.length - 1) {
                buffy.append(oid[i]);
                buffy.append('.');
                ++i;
            }
            buffy.append(oid[oid.length - 1]);
            return buffy.toString();
        }

        public static final ExtendedKeyUsage fromExtension(DER der) throws TypeMismatchException {
            Extension extension = ExtendedKeyUsage.cast(der);
            if (!OID.equals(extension.getextnID())) {
                throw new TypeMismatchException("Extension is not a ExtendedKeyUsage.");
            }
            DER derVal = extension.getextnValue();
            Sequence seq = Sequence.cast(derVal, 0, -1);
            LinkedList<DER> extKeyUsages = new LinkedList<DER>();
            int i = 0;
            while (i < seq.size()) {
                DER cur = seq.get(0);
                DERUtil.checkType(cur, -6);
                extKeyUsages.add(cur);
                ++i;
            }
            return new ExtendedKeyUsage(extKeyUsages);
        }
    }

    public static final class KeyUsage
    extends Extension {
        public static final int digitalSignature = 0;
        public static final int nonRepudiation = 1;
        public static final int keyEncipherment = 2;
        public static final int dataEncipherment = 3;
        public static final int keyAgreement = 4;
        public static final int keyCertSign = 5;
        public static final int cRLSign = 6;
        public static final int encipherOnly = 7;
        public static final int decipherOnly = 8;
        public static final DER OID = Extension.access$0(new int[]{2, 5, 29, 15});

        public KeyUsage(BitSet usage) {
            super(OID, true, new DER(usage));
        }

        public final boolean[] toKeyUsage() {
            BitSet usage = (BitSet)this.getextnValue().getContent();
            boolean[] flag = new boolean[usage.length()];
            int i = usage.nextSetBit(0);
            while (i >= 0) {
                flag[i] = true;
                i = usage.nextSetBit(i + 1);
            }
            return flag;
        }

        public static final KeyUsage fromKeyUsage(boolean[] usage) {
            int length;
            int n = length = usage != null ? usage.length : 0;
            if (length > 9) {
                throw new IllegalArgumentException("There are only 9 well-known usage flags instead of " + length + ".");
            }
            BitSet set = new BitSet(length);
            int i = 0;
            while (i < length) {
                if (usage[i]) {
                    set.set(i);
                }
                ++i;
            }
            return new KeyUsage(set);
        }

        public static final KeyUsage fromExtension(DER der) throws TypeMismatchException {
            Extension extension = KeyUsage.cast(der);
            if (!OID.equals(extension.getextnID())) {
                throw new TypeMismatchException("Extension is not a KeyUsage.");
            }
            DER derVal = extension.getextnValue();
            DERUtil.checkType(derVal, -3);
            return new KeyUsage((BitSet)derVal.getContent());
        }
    }
}

