/*
 * Decompiled with CFR 0.152.
 */
package lu.luxtrust.pkix.pkcs.p7;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import lu.luxtrust.pkix.pkcs.p7.AlgorithmIdentifier;
import lu.luxtrust.pkix.pkcs.p7.Any;
import lu.luxtrust.pkix.pkcs.p7.AnySet;
import lu.luxtrust.pkix.pkcs.p7.Certificate;
import lu.luxtrust.pkix.pkcs.p7.CertificateChoice;
import lu.luxtrust.pkix.pkcs.p7.ContentInfo;
import lu.luxtrust.pkix.pkcs.p7.DER;
import lu.luxtrust.pkix.pkcs.p7.HashAlgorithm;
import lu.luxtrust.pkix.pkcs.p7.IssuerAndSerialNumber;
import lu.luxtrust.pkix.pkcs.p7.SignedData;
import lu.luxtrust.pkix.pkcs.p7.SignerInfo;

public final class Envelope {
    private static final X509Certificate[] EMPTY_CERTIFICATES = new X509Certificate[0];
    private byte[] signature;
    private final byte[] encapsulatedContent;
    private final X509Certificate signerCertificate;
    private final X509Certificate[] certificates;
    private final HashAlgorithm hashAlgorithm;

    public Envelope(byte[] signature, HashAlgorithm hashAlgorithm, X509Certificate signerCertificate, X509Certificate[] certificates, byte[] encapsulatedContent) {
        if (signature == null) {
            throw new NullPointerException("signature");
        }
        if (hashAlgorithm == null) {
            throw new NullPointerException("hashAlgorithm");
        }
        if (signerCertificate == null) {
            throw new NullPointerException("signerCertificate");
        }
        this.encapsulatedContent = encapsulatedContent != null ? (byte[])encapsulatedContent.clone() : null;
        this.signature = (byte[])signature.clone();
        this.certificates = certificates != null ? (X509Certificate[])certificates.clone() : null;
        this.signerCertificate = signerCertificate;
        this.hashAlgorithm = hashAlgorithm;
    }

    public byte[] getSignature() {
        return (byte[])this.signature.clone();
    }

    public X509Certificate getSignerCertificate() {
        return this.signerCertificate;
    }

    public java.security.cert.Certificate[] getCertificates() {
        return this.certificates != null ? (X509Certificate[])this.certificates.clone() : EMPTY_CERTIFICATES;
    }

    public HashAlgorithm getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public byte[] getEncapsulatedContent() {
        return this.encapsulatedContent != null ? (byte[])this.encapsulatedContent.clone() : null;
    }

    public byte[] toPkcs7() {
        try {
            return Envelope.buildSignedData(this.signature, this.hashAlgorithm, AlgorithmIdentifier.RSA, this.signerCertificate, this.certificates, this.encapsulatedContent).asDER().encode();
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    private static ContentInfo.Signed buildSignedData(byte[] signature, HashAlgorithm hashAlgorithm, AlgorithmIdentifier signatureAlgorithm, X509Certificate signerCertificate, X509Certificate[] certificates, byte[] encapsulatedContent) throws NoSuchAlgorithmException {
        AnySet.Builder<CertificateChoice> certSetBuilder;
        Certificate derCert = Certificate.fromX509Certificate(signerCertificate);
        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(derCert.getTBSCertificate().getIssuer(), derCert.getTBSCertificate().getSerialNumber());
        AlgorithmIdentifier digestAlgorithm = hashAlgorithm.toAlgorithmIdentifier();
        if (digestAlgorithm == null) {
            throw new NoSuchAlgorithmException("No OID available for digest algorithm " + (Object)((Object)hashAlgorithm));
        }
        SignerInfo signerInfo = new SignerInfo(issuerAndSerialNumber, null, digestAlgorithm, null, signatureAlgorithm, new DER(signature), null);
        ContentInfo.Encapsulated encapsulated = new ContentInfo.Encapsulated(ContentInfo.OID_DATA, encapsulatedContent);
        if (certificates != null && certificates.length > 0) {
            certSetBuilder = new AnySet.Builder<CertificateChoice>();
            X509Certificate[] x509CertificateArray = certificates;
            int n = certificates.length;
            int n2 = 0;
            while (n2 < n) {
                X509Certificate certificate = x509CertificateArray[n2];
                certSetBuilder.add(new CertificateChoice(Certificate.fromX509Certificate(certificate)));
                ++n2;
            }
        } else {
            certSetBuilder = null;
        }
        SignedData signedData = new SignedData(new AnySet((Any[])new AlgorithmIdentifier[]{digestAlgorithm}), encapsulated, certSetBuilder != null ? certSetBuilder.build() : null, null, new AnySet((Any[])new SignerInfo[]{signerInfo}));
        return new ContentInfo.Signed(signedData);
    }
}

