/*
 * Decompiled with CFR 0.152.
 */
package lu.luxtrust.pkix.pkcs.p7;

import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import lu.luxtrust.pkix.pkcs.p7.Any;
import lu.luxtrust.pkix.pkcs.p7.AnySequence;
import lu.luxtrust.pkix.pkcs.p7.AnySet;
import lu.luxtrust.pkix.pkcs.p7.DER;
import lu.luxtrust.pkix.pkcs.p7.DERException;
import lu.luxtrust.pkix.pkcs.p7.TypeMismatchException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class DERUtil {
    DERUtil() {
    }

    public static void checkType(DER der, int ... types) throws TypeMismatchException {
        if (der == null) {
            throw new NullPointerException();
        }
        if (types == null) {
            throw new NullPointerException();
        }
        int[] nArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            int type = nArray[n2];
            if (der.getType() == type) {
                return;
            }
            ++n2;
        }
        throw new TypeMismatchException("DER " + der + " should have type " + Arrays.toString(types) + ", but has " + der.getType());
    }

    public static DER unpackExplicit(DER der) throws TypeMismatchException {
        if (der.getType() < 0) {
            throw new TypeMismatchException("DER " + der + " is not tagged");
        }
        return (DER)((Collection)((Object)der.getContent())).iterator().next();
    }

    public static DER unpackImplicit(int type, DER der) throws TypeMismatchException {
        if (der.getType() < 0) {
            throw new TypeMismatchException("DER " + der + " is not tagged");
        }
        try {
            return new DER(type, der);
        }
        catch (DERException e) {
            throw new TypeMismatchException("DER " + der + " is not of expected type " + type);
        }
    }

    public static int hashCode(Any any) {
        return any.asDER().hashCode();
    }

    public static boolean equals(Any any, Object obj) {
        if (obj == any) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Any)) {
            return false;
        }
        return ((Any)obj).asDER().equals(any.asDER());
    }

    public static <T extends Any> void dump(PrintStream ps, T any, Class<? extends T> cl) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        DERUtil.dump("", ps, any, cl);
    }

    private static <T extends Any> void dump(String indent, PrintStream ps, T any, Class<? extends T> cl) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method[] getters;
        DERUtil.checkInterfaceType(cl);
        Method[] methodArray = getters = DERUtil.getGetters(cl);
        int n = getters.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractCollection seq;
            Class<Any> actAnyClass;
            Type actType;
            Type genRetType;
            Method getter = methodArray[n2];
            Class<?> retType = getter.getReturnType();
            Object value = getter.invoke(any, null);
            ps.print(indent);
            ps.print(getter.getName());
            ps.print(" = ");
            if (value == null) {
                ps.println("null");
            } else if (retType == DER.class) {
                ((DER)value).printTo(ps);
            } else if (AnySequence.class.isAssignableFrom(retType)) {
                Class actClass;
                ParameterizedType par;
                boolean done = false;
                genRetType = getter.getGenericReturnType();
                if (genRetType instanceof ParameterizedType && (actType = (par = (ParameterizedType)genRetType).getActualTypeArguments()[0]) instanceof Class && Any.class.isAssignableFrom(actClass = (Class)actType)) {
                    actAnyClass = actClass.asSubclass(Any.class);
                    seq = (AnySequence)value;
                    ps.println("SEQ {");
                    int i = 0;
                    while (i < ((AnySequence)seq).size()) {
                        Object sval = ((AnySequence)seq).get(i);
                        DERUtil.dump(String.valueOf(indent) + "  ", ps, actAnyClass.cast(sval), actAnyClass);
                        ps.print(",");
                        ++i;
                    }
                    ps.println(String.valueOf(indent) + "}");
                    done = true;
                }
                if (!done) {
                    ps.print(retType.getName());
                    ps.print(": ");
                    ps.println(value.toString());
                }
            } else if (AnySet.class.isAssignableFrom(retType)) {
                Class actClass;
                ParameterizedType par;
                boolean done = false;
                genRetType = getter.getGenericReturnType();
                if (genRetType instanceof ParameterizedType && (actType = (par = (ParameterizedType)genRetType).getActualTypeArguments()[0]) instanceof Class && Any.class.isAssignableFrom(actClass = (Class)actType)) {
                    actAnyClass = actClass.asSubclass(Any.class);
                    seq = (AnySet)value;
                    ps.println("SET {");
                    for (Any sval : seq) {
                        DERUtil.dump(String.valueOf(indent) + "  ", ps, actAnyClass.cast(sval), actAnyClass);
                        ps.print(String.valueOf(indent) + ",");
                    }
                    ps.println("}");
                    done = true;
                }
                if (!done) {
                    ps.print(retType.getName());
                    ps.print(": ");
                    ps.println(DERUtil.toString(value));
                }
            } else if (Any.class.isAssignableFrom(retType)) {
                Class<Any> anyRetType = retType.asSubclass(Any.class);
                if (DERUtil.isIterable(retType)) {
                    ps.print(anyRetType.getName());
                    ps.print(": ");
                    ps.println("{");
                    DERUtil.dump(String.valueOf(indent) + "  ", ps, anyRetType.cast(value), anyRetType);
                    Method itMethod = DERUtil.getIterationMethod(retType);
                    int size = DERUtil.getSize(retType, value);
                    Class<? extends Any> itType = DERUtil.getIterationType(retType);
                    int i = 0;
                    while (i < size) {
                        ps.print(String.valueOf(indent) + "  ");
                        ps.print(i);
                        ps.println(": {");
                        Any it = DERUtil.getFromIterable(itMethod, value, i);
                        DERUtil.dump(String.valueOf(indent) + "    ", ps, itType.cast(it), itType);
                        ps.print(indent);
                        ps.println("  }");
                        ++i;
                    }
                    ps.println(String.valueOf(indent) + "}");
                } else {
                    ps.print(anyRetType.getName());
                    ps.print(": ");
                    ps.println("{");
                    DERUtil.dump(String.valueOf(indent) + "  ", ps, anyRetType.cast(value), anyRetType);
                    ps.println(String.valueOf(indent) + "}");
                }
            } else {
                ps.print(retType.getName());
                ps.print(": ");
                ps.println(DERUtil.toString(value));
            }
            ++n2;
        }
    }

    private static String toString(Object value) {
        if (value instanceof byte[]) {
            return Arrays.toString((byte[])value);
        }
        if (value instanceof int[]) {
            return Arrays.toString((int[])value);
        }
        return value.toString();
    }

    private static Any getFromIterable(Method itMethod, Object value, int i) {
        try {
            return (Any)itMethod.invoke(value, i);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static Class<? extends Any> getIterationType(Class<?> retType) {
        try {
            Method m = retType.getMethod("get", Integer.TYPE);
            return m.getReturnType().asSubclass(Any.class);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static int getSize(Class<?> retType, Object value) {
        try {
            Method m = retType.getMethod("size", null);
            return (Integer)m.invoke(value, null);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static Method getIterationMethod(Class<?> retType) {
        try {
            return retType.getMethod("get", Integer.TYPE);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isIterable(Class<?> retType) {
        block4: {
            Method m = retType.getMethod("get", Integer.TYPE);
            if (Any.class.isAssignableFrom(m.getReturnType())) break block4;
            return false;
        }
        try {
            Method m2 = retType.getMethod("size", null);
            return Integer.TYPE.isAssignableFrom(m2.getReturnType());
        }
        catch (SecurityException e) {
            return false;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private static void checkInterfaceType(Class<?> cl) {
        if (!cl.isInterface()) {
            throw new RuntimeException("Class " + cl.getName() + " is not an interface");
        }
    }

    private static Method[] getGetters(Class<?> cl) {
        Method[] methods;
        ArrayList<Method> getters = new ArrayList<Method>();
        Method[] methodArray = methods = cl.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (!(method.getParameterTypes() != null && method.getParameterTypes().length != 0 || method.getReturnType() == Void.TYPE || "asDER".equals(method.getName()) || method.getName().startsWith("to"))) {
                getters.add(method);
            }
            ++n2;
        }
        return getters.toArray(new Method[0]);
    }
}

