/*
 * Decompiled with CFR 0.152.
 */
package lu.luxtrust.pkix.pkcs.p7;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import lu.luxtrust.pkix.pkcs.p7.AbstractAny;
import lu.luxtrust.pkix.pkcs.p7.Any;
import lu.luxtrust.pkix.pkcs.p7.DER;
import lu.luxtrust.pkix.pkcs.p7.DERException;
import lu.luxtrust.pkix.pkcs.p7.DERUtil;
import lu.luxtrust.pkix.pkcs.p7.Sequence;
import lu.luxtrust.pkix.pkcs.p7.SignedData;
import lu.luxtrust.pkix.pkcs.p7.TypeMismatchException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
interface ContentInfo<T>
extends Any {
    public static final DER OID_DATA = new DER(new int[]{1, 2, 840, 113549, 1, 7, 1});
    public static final Any.Factory<ContentInfo<SignedData>> SIGNED_DATA_FACTORY = new Any.Factory<ContentInfo<SignedData>>(){

        @Override
        public ContentInfo<SignedData> cast(DER der) {
            return Signed.cast(der);
        }
    };
    public static final Any.Factory<ContentInfo<byte[]>> ENCAPSULATED_FACTORY = new Any.Factory<ContentInfo<byte[]>>(){

        @Override
        public ContentInfo<byte[]> cast(DER der) {
            return Encapsulated.cast(der);
        }
    };

    public DER getContentType();

    public T getContent();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Encapsulated
    extends AbstractAny
    implements ContentInfo<byte[]>,
    Serializable {
        private final DER type;
        private final DER content;
        private DER der;

        public Encapsulated(DER type, byte[] content) {
            if (type == null) {
                throw new NullPointerException();
            }
            DERUtil.checkType(type, -6);
            this.type = type;
            this.content = content != null ? new DER(content) : null;
        }

        public Encapsulated(DER type, DER content) {
            if (type == null) {
                throw new NullPointerException();
            }
            DERUtil.checkType(type, -6);
            this.type = type;
            try {
                this.content = content != null ? new DER(content) : null;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private Encapsulated(DER type, DER octetStringContent, boolean internal) {
            this.type = type;
            this.content = octetStringContent;
        }

        public Encapsulated(int[] type, byte[] content) {
            this(new DER(type), content);
        }

        public Encapsulated(int[] type, DER content) {
            this(new DER(type), content);
        }

        private DER createDER() {
            ArrayList<DER> list = new ArrayList<DER>();
            list.add(this.type);
            if (this.content != null) {
                try {
                    list.add(new DER(0, this.content));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return new DER(list);
        }

        @Override
        public byte[] getContent() {
            if (this.content.getType() == -5) {
                return null;
            }
            return (byte[])this.content.getContent();
        }

        @Override
        public DER getContentType() {
            return this.type;
        }

        @Override
        public DER asDER() {
            if (this.der == null) {
                this.der = this.createDER();
            }
            return this.der;
        }

        public static ContentInfo<byte[]> cast(DER der) {
            DER content;
            Sequence seq = Sequence.cast(der, 1, 2);
            DER type = seq.get(0);
            DERUtil.checkType(type, -6);
            DER dER = content = seq.size() > 1 ? seq.get(1) : new DER();
            if (content != null && content.getType() != -5) {
                DERUtil.checkType(content, 0);
                content = DERUtil.unpackExplicit(content);
                if (content.getType() != -5) {
                    DERUtil.checkType(content, -4);
                }
            }
            Encapsulated e = new Encapsulated(type, content, true);
            e.der = der;
            return e;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Signed
    extends AbstractAny
    implements ContentInfo<SignedData>,
    Serializable {
        private final DER type;
        private final SignedData data;
        private DER der;

        public Signed(SignedData content) {
            if (content == null) {
                throw new NullPointerException();
            }
            this.type = SignedData.OID_SIGNED_DATA;
            this.data = content;
        }

        private DER createDER() throws DERException {
            ArrayList<DER> list = new ArrayList<DER>();
            list.add(SignedData.OID_SIGNED_DATA);
            list.add(new DER(0, this.data.asDER()));
            return new DER(list);
        }

        @Override
        public SignedData getContent() {
            return this.data;
        }

        @Override
        public DER getContentType() {
            return this.type;
        }

        @Override
        public DER asDER() {
            if (this.der == null) {
                try {
                    this.der = this.createDER();
                }
                catch (DERException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.der;
        }

        public static ContentInfo<SignedData> cast(DER der) {
            Sequence seq = Sequence.cast(der, 2, 2);
            DER type = seq.get(0);
            DERUtil.checkType(type, -6);
            if (!type.equals(SignedData.OID_SIGNED_DATA)) {
                throw new TypeMismatchException("DER " + der + " is no SignedContentInfo");
            }
            DER content = seq.get(1);
            DERUtil.checkType(content, 0);
            content = DERUtil.unpackExplicit(content);
            SignedData data = SignedData.cast(content);
            Signed s = new Signed(data);
            s.der = der;
            return s;
        }
    }
}

