/*
 * Decompiled with CFR 0.152.
 */
package lu.luxtrust.pkix.pkcs.p7;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.math.BigInteger;
import lu.luxtrust.pkix.pkcs.p7.BERException;

final class BER {
    public static final int CLASS_UNIVERSAL = 0;
    public static final int CLASS_APPLICATION = 1;
    public static final int CLASS_CONTEXT = 2;
    public static final int CLASS_PRIVATE = 3;
    private static final int MAXBUFFER = 2048;
    private static final byte SHORTTAG = 31;
    private static final byte SHORTLENGTH = 127;
    private static final BigInteger _MAXBUFFER = BigInteger.valueOf(2048L);
    private static final BigInteger _SHORTTAG = BigInteger.valueOf(31L);
    private static final BigInteger _SHORTLENGTH = BigInteger.valueOf(127L);
    private static final BigInteger _LONGLENGTH = BigInteger.valueOf(-1L);
    private final int type;
    private final boolean constructed;
    private final BigInteger tag;
    private final BigInteger length;
    private final CheckedStream content;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BER(InputStream encoded) throws IOException {
        int m = encoded.read();
        if (m < 0) throw new BERException("No identifier octet available.");
        byte id = (byte)m;
        this.type = id >> 6 & 3;
        this.constructed = (id & 0x20) != 0;
        int n = id & 0x1F;
        if (n >= 31) {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            int i = encoded.read();
            boolean undone = true;
            while (undone && i >= 0) {
                byte b = (byte)i;
                buffer.write((byte)(b & 0x7F));
                if ((b & 0x80) != 0) {
                    i = encoded.read();
                    continue;
                }
                undone = false;
            }
            if (undone) {
                throw new BERException("Premature end of tag number octets detected.");
            }
            byte[] tag = buffer.toByteArray();
            if (tag[0] == 0) throw new BERException("Leading zero tag number octet detected.");
            int s = 0;
            int q = 0;
            int p = tag.length - 1;
            while (p > 0) {
                int r = p - 1;
                byte x = tag[r];
                if ((s = (s + 1) % 8) > 0) {
                    int n2 = p + q;
                    tag[n2] = (byte)(tag[n2] | (byte)(x << 8 - s & 0xFF));
                } else {
                    ++q;
                }
                tag[r + q] = (byte)(x >> s);
                --p;
            }
            int u = 0;
            while (u < q) {
                tag[u] = 0;
                ++u;
            }
            this.tag = new BigInteger(1, tag);
        } else {
            this.tag = BigInteger.valueOf(n);
        }
        int j = encoded.read();
        if (j < 0) throw new BERException("Premature end of length octets detected.");
        byte b = (byte)j;
        if ((b & 0x80) != 0) {
            int count = b & 0x7F;
            if (count == 127) throw new BERException("Leading all one length octet detected.");
            if (count > 0) {
                byte[] length = new byte[count];
                int p = 0;
                while (p < count) {
                    int k = encoded.read(length, p, count - p);
                    if (k < 1) {
                        throw new BERException("Premature end of length octets detected after " + p + " of " + count + " octets read.");
                    }
                    p += k;
                }
                BigInteger size = new BigInteger(1, length);
                this.content = new DefiniteStream(encoded, size);
                this.length = size;
                return;
            } else {
                this.content = new InDefiniteStream(encoded);
                this.length = _LONGLENGTH;
            }
            return;
        } else {
            BigInteger size = BigInteger.valueOf(b);
            this.content = new DefiniteStream(encoded, size);
            this.length = size;
        }
    }

    private BER(int type, boolean constructed, BigInteger tag, BigInteger length, InputStream content) throws BERException {
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.type = type;
                break;
            }
            default: {
                throw new BERException("Invalid " + type + " class id supplied for BER construction.");
            }
        }
        if (tag == null || tag.signum() < 0) {
            throw new BERException("Invalid negative " + tag + " tag number supplied for BER construction.");
        }
        if (length == null) {
            throw new BERException("No content length supplied for BER construction.");
        }
        if (content == null) {
            throw new BERException("No content supplied for BER construction.");
        }
        this.tag = tag;
        this.constructed = constructed;
        this.content = length.signum() < 0 ? new InDefiniteStream(new SequenceInputStream(content, new ByteArrayInputStream(new byte[2]))) : new DefiniteStream(content, length);
        this.length = length;
    }

    private BER(int type, boolean constructed, BigInteger tag, int length, InputStream content) throws BERException {
        this(type, constructed, tag, BigInteger.valueOf(length), content);
    }

    public BER(int type, boolean constructed, BigInteger tag, byte[] content) throws BERException {
        this(type, constructed, tag, content != null ? content.length : 0, (InputStream)new ByteArrayInputStream(content != null ? content : new byte[]{}));
    }

    public BER(int type, boolean constructed, int tag, byte[] content) throws BERException {
        this(type, constructed, BigInteger.valueOf(tag), content);
    }

    public BER(int type, boolean constructed, BigInteger tag, InputStream content) throws BERException {
        this(type, constructed, tag, _LONGLENGTH, content);
    }

    public BER(int type, boolean constructed, int tag, InputStream content) throws BERException {
        this(type, constructed, BigInteger.valueOf(tag), content);
    }

    public final int getType() {
        return this.type;
    }

    public final boolean isConstructed() {
        return this.constructed;
    }

    public final BigInteger getTag() {
        return this.tag;
    }

    public final BigInteger getLength() {
        return this.length;
    }

    public final InputStream getContent() {
        return this.content;
    }

    public static final BER decode(InputStream encoded) throws IOException {
        if (encoded == null) {
            throw new NullPointerException("No input stream supplied for decoding BER.");
        }
        return new BER(encoded);
    }

    public static final BER decode(byte[] encoded) throws IOException {
        if (encoded == null) {
            throw new NullPointerException("No input data supplied for decoding BER.");
        }
        return new BER(new ByteArrayInputStream(encoded));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void encode(OutputStream encoded) throws IOException {
        boolean definite;
        int k;
        if (encoded == null) throw new NullPointerException("No output stream supplied.");
        int id = this.type << 6 | (this.constructed ? 32 : 0);
        if (this.tag.compareTo(_SHORTTAG) >= 0) {
            encoded.write((byte)(id | 0x1F));
            int size = (this.tag.bitLength() + 6) / 7;
            byte[] num = new byte[size];
            k = 0;
            int i = size - 1;
            while (i >= 0) {
                int j = 0;
                while (j < 7) {
                    if (this.tag.testBit(k++)) {
                        int n = i;
                        num[n] = (byte)(num[n] | (byte)(1 << j));
                    }
                    ++j;
                }
                --i;
            }
            i = 0;
            while (i < num.length - 1) {
                encoded.write((byte)(num[i] | 0x80));
                ++i;
            }
            encoded.write((byte)(num[num.length - 1] & 0x7F));
        } else {
            encoded.write((byte)(id | this.tag.intValue()));
        }
        boolean bl = definite = this.length.signum() >= 0;
        if (definite) {
            if (this.length.compareTo(_SHORTLENGTH) > 0) {
                byte[] len = this.length.toByteArray();
                int start = 0;
                while (start < len.length && len[start] == 0) {
                    ++start;
                }
                int count = len.length - start;
                if (count > 127) throw new BERException("Invalid " + this.length + " length supplied for BER encoding.");
                encoded.write((byte)(count | 0x80));
                int i = start;
                while (i < len.length) {
                    encoded.write(len[i]);
                    ++i;
                }
            } else {
                encoded.write((byte)(this.length.intValue() & 0x7F));
            }
        } else {
            encoded.write(-128);
        }
        byte[] buffer = new byte[definite ? (this.length.compareTo(_MAXBUFFER) > 0 ? 2048 : this.length.intValue()) : 2048];
        k = this.content.read(buffer);
        while (k > 0) {
            encoded.write(buffer, 0, k);
            k = this.content.read(buffer);
        }
    }

    public byte[] encode() throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        this.encode(buffer);
        return buffer.toByteArray();
    }

    private static abstract class CheckedStream
    extends FilterInputStream {
        private boolean unchecked = true;

        public CheckedStream(InputStream input) {
            super(input);
        }

        protected abstract void check() throws IOException;

        public void mark(int readlimit) {
            throw new UnsupportedOperationException("Marking is not supported by this stream.");
        }

        public void reset() throws IOException {
            throw new UnsupportedOperationException("Resetting is not supported by this stream.");
        }

        public long skip(long n) throws IOException {
            throw new UnsupportedOperationException("Skipping is not supported by this stream.");
        }

        public int read() throws IOException {
            int result = super.read();
            if (result < 0 && this.unchecked) {
                this.unchecked = false;
                this.check();
            }
            return result;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int result = super.read(b, off, len);
            if (result < Math.min(len, 1) && this.unchecked) {
                this.unchecked = false;
                this.check();
            }
            return result;
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }
    }

    private static class DefiniteStream
    extends CheckedStream {
        private BigInteger count;

        public DefiniteStream(InputStream input, BigInteger limit) {
            super(input);
            this.count = limit;
        }

        protected final void check() throws IOException {
            if (this.count.signum() > 0) {
                throw new BERException("Premature end of stream detected although " + this.count + " characters should be available.");
            }
        }

        private final void check(BigInteger n) throws BERException {
            this.count = this.count.subtract(n);
            if (this.count.signum() < 0) {
                throw new BERException("More characters read than those that should be available.");
            }
        }

        public int read() throws IOException {
            int result = super.read();
            if (result >= 0) {
                this.check(BigInteger.ONE);
            }
            return result;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int result = super.read(b, off, len);
            if (result > 0) {
                this.check(BigInteger.valueOf(result));
            }
            return result;
        }
    }

    private static class InDefiniteStream
    extends CheckedStream {
        private byte[] eoc = new byte[2];

        public InDefiniteStream(InputStream input) {
            super(input);
            this.eoc[0] = -1;
            this.eoc[1] = -1;
        }

        protected final void check() throws IOException {
            if (this.eoc[0] != 0 || this.eoc[1] != 0) {
                throw new BERException("End of content octets missing.");
            }
        }

        public int read() throws IOException {
            int result = super.read();
            if (result >= 0) {
                this.eoc[0] = this.eoc[1];
                this.eoc[1] = (byte)result;
            }
            return result;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int result = super.read(b, off, len);
            if (result > 0) {
                int last = off + result - 1;
                this.eoc[0] = result > 1 ? b[last - 1] : this.eoc[1];
                this.eoc[1] = b[last];
            }
            return result;
        }
    }
}

