/*
 * Decompiled with CFR 0.152.
 */
package lu.luxtrust.pkix.pkcs.p7;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import lu.luxtrust.pkix.pkcs.p7.Any;
import lu.luxtrust.pkix.pkcs.p7.AnyCollection;
import lu.luxtrust.pkix.pkcs.p7.DER;
import lu.luxtrust.pkix.pkcs.p7.DERUtil;
import lu.luxtrust.pkix.pkcs.p7.TypeMismatchException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AnySet<T extends Any>
extends AbstractCollection<T>
implements AnyCollection<T>,
Serializable {
    private static final Comparator<Any> ANY_COMPARATOR = new Comparator<Any>(){

        @Override
        public int compare(Any o1, Any o2) {
            return o1.asDER().compareTo(o2.asDER());
        }
    };
    private final DER der;
    private final List<T> list;

    public AnySet(T ... members) {
        this((Collection<T>)(members != null ? Arrays.asList(members) : null));
    }

    public AnySet(Collection<? extends T> members) {
        if (members == null) {
            members = Collections.emptyList();
        }
        TreeSet<DER> derset = new TreeSet<DER>();
        if (members != null) {
            for (Any m : members) {
                derset.add(m.asDER());
            }
        }
        ArrayList list = new ArrayList(members.size());
        list.addAll(members);
        Collections.sort(list, ANY_COMPARATOR);
        this.list = Collections.unmodifiableList(list);
        this.der = new DER(derset);
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    public final int size() {
        return this.list.size();
    }

    @Override
    public final DER asDER() {
        return this.der;
    }

    @Override
    public boolean equals(Object obj) {
        return DERUtil.equals(this, obj);
    }

    @Override
    public int hashCode() {
        return DERUtil.hashCode(this);
    }

    public static final <T extends Any> AnySet<T> cast(DER der, Any.Factory<? extends T> factory, int minSize, int maxSize) {
        DERUtil.checkType(der, -17);
        SortedSet set = (SortedSet)((Object)der.getContent());
        if (set.size() < minSize || maxSize >= 0 && set.size() > maxSize) {
            throw new TypeMismatchException("The DER " + der + " is not a Set.");
        }
        ArrayList<T> list = new ArrayList<T>(set.size());
        int i = 0;
        for (DER d : set) {
            try {
                list.add(factory.cast(d));
            }
            catch (TypeMismatchException ex) {
                TypeMismatchException sub = new TypeMismatchException("The component " + i + " of an set is not of the appropriate type.");
                sub.initCause(ex);
                throw sub;
            }
            ++i;
        }
        return new AnySet(list);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Builder<T extends Any>
    implements Serializable {
        private final Set<T> set;

        public Builder() {
            this.set = new HashSet<T>();
        }

        public Builder(Builder<? extends T> builder) {
            this.set = new HashSet<T>((Collection)builder.set);
        }

        public Builder<T> add(T obj) {
            this.set.add(obj);
            return this;
        }

        public int size() {
            return this.set.size();
        }

        public AnySet<T> build() {
            return new AnySet<T>(this.set);
        }
    }
}

