/*
 * Decompiled with CFR 0.152.
 */
package lu.luxtrust.pkix.pkcs.p7;

import java.io.Serializable;
import lu.luxtrust.pkix.pkcs.p7.AbstractAny;
import lu.luxtrust.pkix.pkcs.p7.Any;
import lu.luxtrust.pkix.pkcs.p7.DER;
import lu.luxtrust.pkix.pkcs.p7.Sequence;
import lu.luxtrust.pkix.pkcs.p7.TypeMismatchException;

class AlgorithmIdentifier
extends AbstractAny
implements Serializable {
    public static final Any.Factory<AlgorithmIdentifier> FACTORY = new Any.Factory<AlgorithmIdentifier>(){

        @Override
        public AlgorithmIdentifier cast(DER der) {
            return AlgorithmIdentifier.cast(der);
        }
    };
    public static final AlgorithmIdentifier AES_256_CBC = AlgorithmIdentifier.of(new int[]{2, 16, 840, 1, 101, 3, 4, 1, 42});
    public static final AlgorithmIdentifier RSA = AlgorithmIdentifier.of(new int[]{1, 2, 840, 113549, 1, 1, 1});
    public static final AlgorithmIdentifier MD5withRSA = AlgorithmIdentifier.of(new int[]{1, 2, 840, 113549, 1, 1, 4});
    public static final AlgorithmIdentifier SHA1withRSA = AlgorithmIdentifier.of(new int[]{1, 2, 840, 113549, 1, 1, 5});
    public static final AlgorithmIdentifier SHA256withRSA = AlgorithmIdentifier.of(new int[]{1, 2, 840, 113549, 1, 1, 11});
    public static final AlgorithmIdentifier SHA384withRSA = AlgorithmIdentifier.of(new int[]{1, 2, 840, 113549, 1, 1, 12});
    public static final AlgorithmIdentifier SHA512withRSA = AlgorithmIdentifier.of(new int[]{1, 2, 840, 113549, 1, 1, 13});
    public static final AlgorithmIdentifier DSA = AlgorithmIdentifier.of(new int[]{1, 2, 840, 10040, 4, 1});
    public static final AlgorithmIdentifier SHA1withDSA = AlgorithmIdentifier.of(new int[]{1, 2, 840, 10040, 4, 3});
    public static final AlgorithmIdentifier MD5 = AlgorithmIdentifier.of(new int[]{1, 2, 840, 113549, 2, 5});
    public static final AlgorithmIdentifier SHA1 = AlgorithmIdentifier.of(new int[]{1, 3, 14, 3, 2, 26});
    public static final AlgorithmIdentifier SHA256 = AlgorithmIdentifier.of(new int[]{2, 16, 840, 1, 101, 3, 4, 2, 1});
    public static final AlgorithmIdentifier SHA384 = AlgorithmIdentifier.of(new int[]{2, 16, 840, 1, 101, 3, 4, 2, 2});
    public static final AlgorithmIdentifier SHA512 = AlgorithmIdentifier.of(new int[]{2, 16, 840, 1, 101, 3, 4, 2, 3});
    public static final AlgorithmIdentifier HMAC_SHA1 = AlgorithmIdentifier.of(new int[]{1, 2, 840, 113549, 2, 7});
    public static final AlgorithmIdentifier HMAC_SHA256 = AlgorithmIdentifier.of(new int[]{1, 2, 840, 113549, 2, 9});
    public static final AlgorithmIdentifier HMAC_SHA384 = AlgorithmIdentifier.of(new int[]{1, 2, 840, 113549, 2, 10});
    public static final AlgorithmIdentifier HMAC_SHA512 = AlgorithmIdentifier.of(new int[]{1, 2, 840, 113549, 2, 11});
    private final DER algorithm;
    private final DER parameters;
    private Sequence sequence;

    public AlgorithmIdentifier(DER algorithm, DER parameters) {
        if (algorithm == null) {
            throw new NullPointerException();
        }
        if (algorithm.getType() != -6) {
            throw new IllegalArgumentException("algorithm");
        }
        this.algorithm = algorithm;
        this.parameters = parameters;
    }

    public AlgorithmIdentifier(DER algorithm) {
        this(algorithm, new DER());
    }

    public AlgorithmIdentifier(int[] algorithm, DER parameters) {
        this(new DER(algorithm), parameters);
    }

    public AlgorithmIdentifier(int[] algorithm) {
        this(algorithm, new DER());
    }

    public final DER asDER() {
        if (this.sequence == null) {
            this.sequence = this.parameters != null ? new Sequence(this.algorithm, this.parameters) : new Sequence(this.algorithm);
        }
        return this.sequence.asDER();
    }

    private static final AlgorithmIdentifier of(int[] algorithm) {
        return new AlgorithmIdentifier(algorithm);
    }

    public DER getAlgorithm() {
        return this.algorithm;
    }

    public DER getParameters() {
        return this.parameters;
    }

    public static final AlgorithmIdentifier cast(DER der) {
        Sequence seq = Sequence.cast(der, 1, 2);
        if (seq != null && seq.get(0).getType() == -6) {
            AlgorithmIdentifier a = new AlgorithmIdentifier(seq.get(0), seq.size() > 1 ? seq.get(1) : null);
            a.sequence = seq;
            return a;
        }
        throw new TypeMismatchException("The " + der + " der is not an AlgorithmIdentifier.");
    }
}

