/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.net;

import org.dcm4che2.net.pdu.ExtendedNegotiation;

public class TransferCapability {
    public static final String SCU = "SCU";
    public static final String SCP = "SCP";
    private static byte[] NO_EXT_INFO = new byte[0];
    protected String commonName;
    protected String sopClass;
    protected boolean scp;
    protected String[] transferSyntax = new String[0];
    protected byte[] extInfo = new byte[0];

    public TransferCapability() {
    }

    public TransferCapability(String sopClass, String[] transferSyntax, String role) {
        this.setSopClass(sopClass);
        this.setTransferSyntax(transferSyntax);
        this.setRole(role);
    }

    public String getCommonName() {
        return this.commonName;
    }

    public void setCommonName(String commonName) {
        this.commonName = commonName;
    }

    public String getRole() {
        return this.scp ? SCP : SCU;
    }

    public void setRole(String role) {
        if (role == null) {
            throw new NullPointerException("Role");
        }
        if (role.equals(SCP)) {
            this.scp = true;
        } else if (role.equals(SCU)) {
            this.scp = false;
        } else {
            throw new IllegalArgumentException("Role:" + role);
        }
    }

    public boolean isSCP() {
        return this.scp;
    }

    public boolean isSCU() {
        return !this.scp;
    }

    public String getSopClass() {
        return this.sopClass;
    }

    public void setSopClass(String sopClass) {
        if (sopClass == null) {
            throw new NullPointerException("sopClass");
        }
        this.sopClass = sopClass;
    }

    public String[] getTransferSyntax() {
        return (String[])this.transferSyntax.clone();
    }

    public void setTransferSyntax(String[] transferSyntax) {
        if (transferSyntax.length == 0) {
            throw new IllegalArgumentException("transferSyntax.length = 0");
        }
        for (int i = 0; i < transferSyntax.length; ++i) {
            if (transferSyntax[i] != null) continue;
            throw new NullPointerException("transferSyntax[" + i + "]");
        }
        this.transferSyntax = (String[])transferSyntax.clone();
    }

    public byte[] getExtInfo() {
        return (byte[])this.extInfo.clone();
    }

    public void setExtInfo(byte[] info) {
        this.extInfo = info != null ? (byte[])info.clone() : NO_EXT_INFO;
    }

    public boolean getExtInfoBoolean(int field) {
        return this.extInfo != null && this.extInfo.length > field && this.extInfo[field] != 0;
    }

    public int getExtInfoInt(int field) {
        return this.extInfo != null && this.extInfo.length > field ? this.extInfo[field] & 0xFF : 0;
    }

    public void setExtInfoBoolean(int field, boolean b) {
        this.setExtInfoInt(field, b ? 1 : 0);
    }

    public void setExtInfoInt(int field, int value) {
        this.extInfo[field] = (byte)value;
    }

    protected ExtendedNegotiation negotiate(ExtendedNegotiation offered) {
        if (offered == null || this.extInfo == null) {
            return null;
        }
        byte[] info = offered.getInformation();
        for (int i = 0; i < info.length; ++i) {
            int n = i;
            info[n] = (byte)(info[n] & this.getExtInfoInt(i));
        }
        return new ExtendedNegotiation(this.sopClass, info);
    }
}

