/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.dcm4che2.net.Association;
import org.dcm4che2.net.Device;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkConnection {
    static Logger log = LoggerFactory.getLogger(NetworkConnection.class);
    public static final int DEFAULT = 0;
    public static final int ONLY_ACTIVE = -1;
    private static final String[] TLS_NULL = new String[]{"SSL_RSA_WITH_NULL_SHA"};
    private static final String[] TLS_3DES_EDE_CBC = new String[]{"SSL_RSA_WITH_3DES_EDE_CBC_SHA"};
    private static final String[] TLS_AES_128_CBC = new String[]{"TLS_RSA_WITH_AES_128_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA"};
    private static String[] TLS_WO_SSLv2 = new String[]{"TLSv1", "SSLv3"};
    private static String[] TLS_AND_SSLv2 = new String[]{"TLSv1", "SSLv3", "SSLv2Hello"};
    private String commonName;
    private String hostname;
    private int port = -1;
    private String[] tlsCipherSuite = new String[0];
    private Boolean installed;
    private int backlog = 50;
    private int connectTimeout = 5000;
    private int requestTimeout = 5000;
    private int acceptTimeout = 5000;
    private int releaseTimeout = 5000;
    private int socketCloseDelay = 50;
    private int sendBufferSize = 0;
    private int receiveBufferSize = 0;
    private boolean tcpNoDelay = true;
    private boolean tlsNeedClientAuth = true;
    private String[] tlsProtocol = TLS_AND_SSLv2;
    private Device device;
    protected ServerSocket server;
    private List<String> excludeConnectionsFrom;
    private int maxScpAssociations = 50;
    private AtomicInteger associationCount = new AtomicInteger();
    private InetAddress addr;

    private InetAddress addr() throws UnknownHostException {
        if (this.addr == null && this.hostname != null) {
            this.addr = InetAddress.getByName(this.hostname);
        }
        return this.addr;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("NetworkConnection[");
        sb.append(this.hostname).append(':').append(this.port);
        if (this.tlsCipherSuite.length != 0) {
            sb.append(", TLS").append(Arrays.asList(this.tlsCipherSuite));
        }
        if (this.installed != null) {
            sb.append(", installed=").append(this.installed);
        }
        if (this.commonName != null) {
            sb.append(", cn=").append(this.commonName);
        }
        sb.append(']');
        return sb.toString();
    }

    public Device getDevice() {
        return this.device;
    }

    void setDevice(Device device) {
        this.device = device;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        if (hostname == null || !hostname.equals(this.hostname)) {
            this.addr = null;
        }
        this.hostname = hostname;
    }

    public String getCommonName() {
        return this.commonName;
    }

    public void setCommonName(String name) {
        this.commonName = name;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        if (port < -1 || port > 65535) {
            throw new IllegalArgumentException("port out of range:" + port);
        }
        this.port = port;
    }

    public String[] getTlsCipherSuite() {
        return (String[])this.tlsCipherSuite.clone();
    }

    public void setTlsCipherSuite(String[] tlsCipherSuite) {
        NetworkConnection.checkNotNull("tlsCipherSuite", tlsCipherSuite);
        this.tlsCipherSuite = (String[])tlsCipherSuite.clone();
    }

    private static void checkNotNull(String name, Object[] a) {
        if (a == null) {
            throw new NullPointerException(name);
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != null) continue;
            throw new NullPointerException(name + '[' + i + ']');
        }
    }

    public void setTlsWithoutEncyrption() {
        this.tlsCipherSuite = TLS_NULL;
    }

    public void setTls3DES_EDE_CBC() {
        this.tlsCipherSuite = TLS_3DES_EDE_CBC;
    }

    public void setTlsAES_128_CBC() {
        this.tlsCipherSuite = TLS_AES_128_CBC;
    }

    public boolean isInstalled() {
        return this.installed != null ? this.installed : this.device == null || this.device.isInstalled();
    }

    public void setInstalled(boolean installed) {
        this.installed = installed;
    }

    public boolean isListening() {
        return this.port != -1;
    }

    public boolean isTLS() {
        return this.tlsCipherSuite.length > 0;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        if (backlog < 1) {
            throw new IllegalArgumentException("backlog: " + backlog);
        }
        this.backlog = backlog;
    }

    public int getAcceptTimeout() {
        return this.acceptTimeout;
    }

    public void setAcceptTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout: " + timeout);
        }
        this.acceptTimeout = timeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout: " + timeout);
        }
        this.connectTimeout = timeout;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout: " + timeout);
        }
        this.requestTimeout = timeout;
    }

    public int getReleaseTimeout() {
        return this.releaseTimeout;
    }

    public void setReleaseTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout: " + timeout);
        }
        this.releaseTimeout = timeout;
    }

    public int getSocketCloseDelay() {
        return this.socketCloseDelay;
    }

    public void setSocketCloseDelay(int delay) {
        if (delay < 0) {
            throw new IllegalArgumentException("delay: " + delay);
        }
        this.socketCloseDelay = delay;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size: " + size);
        }
        this.receiveBufferSize = size;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size: " + size);
        }
        this.sendBufferSize = size;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public boolean isTlsNeedClientAuth() {
        return this.tlsNeedClientAuth;
    }

    public void setTlsNeedClientAuth(boolean tlsNeedClientAuth) {
        this.tlsNeedClientAuth = tlsNeedClientAuth;
    }

    public String[] getTlsProtocol() {
        return (String[])this.tlsProtocol.clone();
    }

    public void setTlsProtocol(String[] tlsProtocol) {
        this.tlsProtocol = (String[])tlsProtocol.clone();
    }

    public void enableSSLv2Hello() {
        this.tlsProtocol = TLS_AND_SSLv2;
    }

    public void disableSSLv2Hello() {
        this.tlsProtocol = TLS_WO_SSLv2;
    }

    private InetSocketAddress getEndPoint() throws UnknownHostException {
        return new InetSocketAddress(this.addr(), this.port);
    }

    private InetSocketAddress getBindPoint() throws UnknownHostException {
        return new InetSocketAddress(NetworkConnection.maskLoopBackAddress(this.addr()), 0);
    }

    private static InetAddress maskLoopBackAddress(InetAddress addr) {
        return addr != null && addr.isLoopbackAddress() ? null : addr;
    }

    public ServerSocket getServer() {
        return this.server;
    }

    public Socket connect(NetworkConnection peerConfig) throws IOException {
        if (this.device == null) {
            throw new IllegalStateException("Device not initalized");
        }
        if (!peerConfig.isListening()) {
            throw new IllegalArgumentException("Only initiates associations - " + peerConfig);
        }
        Socket s = this.isTLS() ? this.createTLSSocket() : new Socket();
        InetSocketAddress bindPoint = this.getBindPoint();
        InetSocketAddress endpoint = peerConfig.getEndPoint();
        log.debug("Initiate connection from {} to {}", (Object)bindPoint, (Object)endpoint);
        s.bind(bindPoint);
        this.setSocketOptions(s);
        s.connect(endpoint, this.connectTimeout);
        return s;
    }

    protected void setSocketOptions(Socket s) throws SocketException {
        int size = s.getReceiveBufferSize();
        if (this.receiveBufferSize == 0) {
            this.receiveBufferSize = size;
        } else if (this.receiveBufferSize != size) {
            s.setReceiveBufferSize(this.receiveBufferSize);
            this.receiveBufferSize = s.getReceiveBufferSize();
        }
        size = s.getSendBufferSize();
        if (this.sendBufferSize == 0) {
            this.sendBufferSize = size;
        } else if (this.sendBufferSize != size) {
            s.setSendBufferSize(this.sendBufferSize);
            this.sendBufferSize = s.getSendBufferSize();
        }
        if (s.getTcpNoDelay() != this.tcpNoDelay) {
            s.setTcpNoDelay(this.tcpNoDelay);
        }
    }

    public synchronized void bind(final Executor executor) throws IOException {
        if (this.device == null) {
            throw new IllegalStateException("Device not initalized");
        }
        if (!this.isListening()) {
            throw new IllegalStateException("Only initiates associations - " + this);
        }
        if (this.server != null) {
            throw new IllegalStateException("Already listening - " + this.server);
        }
        this.server = this.isTLS() ? this.createTLSServerSocket() : new ServerSocket();
        this.server.bind(this.getEndPoint(), this.backlog);
        executor.execute(new Runnable(){

            public void run() {
                SocketAddress sockAddr = NetworkConnection.this.server.getLocalSocketAddress();
                log.info("Start listening on {}", (Object)sockAddr);
                try {
                    while (true) {
                        log.debug("Wait for connection on {}", (Object)sockAddr);
                        Socket s = NetworkConnection.this.server.accept();
                        NetworkConnection.this.setSocketOptions(s);
                        if (!NetworkConnection.this.checkConnection(s)) continue;
                        Association a = Association.accept(s, NetworkConnection.this);
                        executor.execute(a);
                    }
                }
                catch (Throwable throwable) {
                    log.info("Stop listening on {}", (Object)sockAddr);
                    return;
                }
            }
        });
    }

    protected boolean checkConnection(Socket s) {
        if (this.excludeConnectionsFrom == null || this.excludeConnectionsFrom.size() == 0) {
            return true;
        }
        for (String ip : this.excludeConnectionsFrom) {
            if (!s.getInetAddress().getHostAddress().equals(ip)) continue;
            log.debug("Rejecting connection from {}", (Object)ip);
            try {
                s.close();
            }
            catch (IOException e) {
                log.debug("Caught IOException closing socket from {}", (Object)ip);
            }
            return false;
        }
        return true;
    }

    protected void incListenerConnectionCount() {
        this.associationCount.incrementAndGet();
    }

    protected void decListenerConnectionCount() {
        int current;
        while ((current = this.associationCount.get()) > 0 && !this.associationCount.compareAndSet(current, current - 1)) {
        }
    }

    public boolean checkConnectionCountWithinLimit() {
        return this.associationCount.intValue() <= this.maxScpAssociations;
    }

    public synchronized void unbind() {
        if (this.server == null) {
            return;
        }
        try {
            this.server.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.associationCount.set(0);
        this.server = null;
    }

    protected Socket createTLSSocket() throws IOException {
        SSLContext sslContext = this.device.getSSLContext();
        if (sslContext == null) {
            throw new IllegalStateException("TLS Context not initialized!");
        }
        SSLSocketFactory sf = sslContext.getSocketFactory();
        SSLSocket s = (SSLSocket)sf.createSocket();
        s.setEnabledProtocols(this.tlsProtocol);
        s.setEnabledCipherSuites(this.tlsCipherSuite);
        return s;
    }

    protected ServerSocket createTLSServerSocket() throws IOException {
        SSLContext sslContext = this.device.getSSLContext();
        if (sslContext == null) {
            throw new IllegalStateException("TLS Context not initialized!");
        }
        SSLServerSocketFactory ssf = sslContext.getServerSocketFactory();
        SSLServerSocket ss = (SSLServerSocket)ssf.createServerSocket();
        ss.setEnabledProtocols(this.tlsProtocol);
        ss.setEnabledCipherSuites(this.tlsCipherSuite);
        ss.setNeedClientAuth(this.tlsNeedClientAuth);
        return ss;
    }

    public List<String> getExcludeConnectionsFrom() {
        return this.excludeConnectionsFrom;
    }

    public void setExcludeConnectionsFrom(List<String> excludeConnectionsFrom) {
        this.excludeConnectionsFrom = excludeConnectionsFrom;
    }

    public int getMaxScpAssociations() {
        return this.maxScpAssociations;
    }

    public void setMaxScpAssociations(int maxListenerAssociations) {
        this.maxScpAssociations = maxListenerAssociations;
    }
}

