/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.net;

import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.net.Association;
import org.dcm4che2.net.AssociationAcceptEvent;
import org.dcm4che2.net.AssociationCloseEvent;
import org.dcm4che2.net.AssociationListener;
import org.dcm4che2.net.ConfigurationException;
import org.dcm4che2.net.Device;
import org.dcm4che2.net.DicomServiceRegistry;
import org.dcm4che2.net.NetworkConnection;
import org.dcm4che2.net.PDVInputStream;
import org.dcm4che2.net.TransferCapability;
import org.dcm4che2.net.UserIdentity;
import org.dcm4che2.net.pdu.AAssociateAC;
import org.dcm4che2.net.pdu.AAssociateRJ;
import org.dcm4che2.net.pdu.AAssociateRQ;
import org.dcm4che2.net.pdu.ExtendedNegotiation;
import org.dcm4che2.net.pdu.PresentationContext;
import org.dcm4che2.net.pdu.RoleSelection;
import org.dcm4che2.net.service.DicomService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkApplicationEntity {
    private static Logger log = LoggerFactory.getLogger(NetworkApplicationEntity.class);
    private boolean associationAcceptor;
    private boolean associationInitiator;
    private String aeTitle;
    private String description;
    private Object[] vendorData = new Object[0];
    private String[] applicationCluster = new String[0];
    private String[] preferredCallingAETitle = new String[0];
    private String[] preferredCalledAETitle = new String[0];
    private String[] supportedCharacterSet = new String[0];
    private Boolean installed;
    private int maxOpsInvoked;
    private int maxOpsPerformed;
    private int maxPDULengthReceive = 16384;
    private int maxPDULengthSend = 16384;
    private boolean packPDV;
    private int dimseRspTimeout = 10000;
    private int retrieveRspTimeout = 600000;
    private int idleTimeout = 60000;
    private List<String> reuseAssocationToAETitle = Collections.emptyList();
    private List<String> reuseAssocationFromAETitle = Collections.emptyList();
    private NetworkConnection[] networkConnection = new NetworkConnection[0];
    private TransferCapability[] transferCapability = new TransferCapability[0];
    private boolean offerDefaultTSInSeparatePC;
    private UserIdentity userIdentity;
    private Device device;
    private AssociationListener[] als = new AssociationListener[0];
    private final DicomServiceRegistry serviceRegistry = new DicomServiceRegistry();
    private final List<Association> pool = new ArrayList<Association>();
    private AtomicInteger messageID = new AtomicInteger();

    public Device getDevice() {
        return this.device;
    }

    void setDevice(Device device) {
        this.device = device;
    }

    public String getAETitle() {
        return this.aeTitle;
    }

    public void setAETitle(String aetitle) {
        this.aeTitle = aetitle;
    }

    public String[] getApplicationCluster() {
        return this.applicationCluster;
    }

    public void setApplicationCluster(String[] cluster) {
        this.applicationCluster = cluster;
    }

    public boolean isAssociationAcceptor() {
        return this.associationAcceptor;
    }

    public void setAssociationAcceptor(boolean acceptor) {
        this.associationAcceptor = acceptor;
    }

    public boolean isAssociationInitiator() {
        return this.associationInitiator;
    }

    public void setAssociationInitiator(boolean initiator) {
        this.associationInitiator = initiator;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isInstalled() {
        return this.installed != null ? this.installed : this.device == null || this.device.isInstalled();
    }

    public void setInstalled(boolean installed) {
        this.installed = installed;
    }

    public NetworkConnection[] getNetworkConnection() {
        return this.networkConnection;
    }

    public void setNetworkConnection(NetworkConnection nc) {
        this.setNetworkConnection(new NetworkConnection[]{nc});
    }

    public void setNetworkConnection(NetworkConnection[] nc) {
        this.networkConnection = nc;
    }

    public String[] getPreferredCalledAETitle() {
        return this.preferredCalledAETitle;
    }

    public boolean hasPreferredCalledAETitle() {
        return this.preferredCalledAETitle != null && this.preferredCalledAETitle.length > 0;
    }

    public boolean isPreferredCalledAETitle(String aet) {
        return NetworkApplicationEntity.contains(this.preferredCalledAETitle, aet);
    }

    private static boolean contains(String[] a, String s) {
        for (int i = 0; i < a.length; ++i) {
            if (!s.equals(a[i])) continue;
            return true;
        }
        return false;
    }

    public void setPreferredCalledAETitle(String[] aets) {
        this.preferredCalledAETitle = aets;
    }

    public String[] getPreferredCallingAETitle() {
        return this.preferredCallingAETitle;
    }

    public boolean hasPreferredCallingAETitle() {
        return this.preferredCallingAETitle != null && this.preferredCallingAETitle.length > 0;
    }

    public boolean isPreferredCallingAETitle(String aet) {
        return NetworkApplicationEntity.contains(this.preferredCallingAETitle, aet);
    }

    public void setPreferredCallingAETitle(String[] aets) {
        this.preferredCallingAETitle = aets;
    }

    public String[] getSupportedCharacterSet() {
        return this.supportedCharacterSet;
    }

    public void setSupportedCharacterSet(String[] characterSets) {
        this.supportedCharacterSet = characterSets;
    }

    public TransferCapability[] getTransferCapability() {
        return this.transferCapability;
    }

    public void setTransferCapability(TransferCapability[] transferCapability) {
        this.transferCapability = transferCapability;
    }

    public boolean isOfferDefaultTransferSyntaxInSeparatePresentationContext() {
        return this.offerDefaultTSInSeparatePC;
    }

    public void setOfferDefaultTransferSyntaxInSeparatePresentationContext(boolean offerDefaultTSInSeparatePC) {
        this.offerDefaultTSInSeparatePC = offerDefaultTSInSeparatePC;
    }

    public Object[] getVendorData() {
        return this.vendorData;
    }

    public void setVendorData(Object[] vendorData) {
        this.vendorData = vendorData;
    }

    public int getMaxOpsInvoked() {
        return this.maxOpsInvoked;
    }

    public void setMaxOpsInvoked(int maxOpsInvoked) {
        this.maxOpsInvoked = maxOpsInvoked;
    }

    public int getMaxOpsPerformed() {
        return this.maxOpsPerformed;
    }

    public void setMaxOpsPerformed(int maxOpsPerformed) {
        this.maxOpsPerformed = maxOpsPerformed;
    }

    public boolean isAsyncOps() {
        return this.maxOpsInvoked != 1 || this.maxOpsPerformed != 1;
    }

    public int getMaxPDULengthReceive() {
        return this.maxPDULengthReceive;
    }

    public void setMaxPDULengthReceive(int maxPDULengthReceive) {
        this.maxPDULengthReceive = maxPDULengthReceive;
    }

    public int getMaxPDULengthSend() {
        return this.maxPDULengthSend;
    }

    public void setMaxPDULengthSend(int maxPDULengthSend) {
        this.maxPDULengthSend = maxPDULengthSend;
    }

    public boolean isPackPDV() {
        return this.packPDV;
    }

    public void setPackPDV(boolean packPDV) {
        this.packPDV = packPDV;
    }

    public int getDimseRspTimeout() {
        return this.dimseRspTimeout;
    }

    public void setDimseRspTimeout(int dimseRspTimeout) {
        this.dimseRspTimeout = dimseRspTimeout;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    @Deprecated
    public int getMoveRspTimeout() {
        return this.retrieveRspTimeout;
    }

    @Deprecated
    public void setMoveRspTimeout(int moveRspTimeout) {
        this.retrieveRspTimeout = moveRspTimeout;
    }

    public int getRetrieveRspTimeout() {
        return this.retrieveRspTimeout;
    }

    public void setRetrieveRspTimeout(int retrieveRspTimeout) {
        this.retrieveRspTimeout = retrieveRspTimeout;
    }

    public String[] getReuseAssocationFromAETitle() {
        return this.reuseAssocationFromAETitle.toArray(new String[this.reuseAssocationFromAETitle.size()]);
    }

    public void setReuseAssocationFromAETitle(String[] reuseAssocationFromAETitle) {
        this.reuseAssocationFromAETitle = Arrays.asList(reuseAssocationFromAETitle);
    }

    public String[] getReuseAssocationToAETitle() {
        return this.reuseAssocationToAETitle.toArray(new String[this.reuseAssocationToAETitle.size()]);
    }

    public void setReuseAssocationToAETitle(String[] reuseAssocationToAETitle) {
        this.reuseAssocationToAETitle = Arrays.asList(reuseAssocationToAETitle);
    }

    public UserIdentity getUserIdentity() {
        return this.userIdentity;
    }

    public void setUserIdentity(UserIdentity userIdentity) {
        this.userIdentity = userIdentity;
    }

    public Association connect(NetworkApplicationEntity remoteAE, Executor executor) throws ConfigurationException, IOException, InterruptedException {
        return this.connect(this.userIdentity, remoteAE, executor, false);
    }

    public Association connect(UserIdentity userIdentity, NetworkApplicationEntity remoteAE, Executor executor) throws ConfigurationException, IOException, InterruptedException {
        return this.connect(userIdentity, remoteAE, executor, false);
    }

    public Association connect(NetworkApplicationEntity remoteAE, Executor executor, boolean forceNew) throws ConfigurationException, IOException, InterruptedException {
        return this.connect(this.userIdentity, remoteAE, executor, forceNew);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Association connect(UserIdentity userIdentity, NetworkApplicationEntity remoteAE, Executor executor, boolean forceNew) throws ConfigurationException, IOException, InterruptedException {
        String remoteAET = remoteAE.getAETitle();
        if (!(forceNew || this.pool.isEmpty() || this.reuseAssocationToAETitle.isEmpty() && this.reuseAssocationFromAETitle.isEmpty())) {
            List<Association> list = this.pool;
            synchronized (list) {
                for (Association as : this.pool) {
                    if (!remoteAET.equals(as.getRemoteAET()) || userIdentity != as.getUserIdentity() || !as.isReadyForDataTransfer() || !as.isAvailableOps() || !(as.isRequestor() ? this.reuseAssocationToAETitle : this.reuseAssocationFromAETitle).contains(remoteAET)) continue;
                    return as;
                }
            }
        }
        NetworkConnection[] remoteConns = remoteAE.getNetworkConnection();
        for (int i = 0; i < this.networkConnection.length; ++i) {
            NetworkConnection c = this.networkConnection[i];
            if (!this.networkConnection[i].isInstalled()) continue;
            for (int j = 0; j < remoteConns.length; ++j) {
                NetworkConnection nc = remoteConns[j];
                if (!nc.isInstalled() || !nc.isListening() || c.isTLS() != nc.isTLS()) continue;
                AAssociateRQ rq = this.makeAAssociateRQ(userIdentity, remoteAE);
                Socket s = c.connect(nc);
                Association a = Association.request(s, c, this, userIdentity);
                executor.execute(a);
                a.negotiate(rq);
                this.addToPool(a);
                this.associationAccepted(a);
                return a;
            }
        }
        throw new ConfigurationException("No compatible Network Connection between local AE " + this.aeTitle + " and remote AE " + remoteAET);
    }

    protected AAssociateRQ makeAAssociateRQ(UserIdentity userIdentity, NetworkApplicationEntity remoteAE) {
        AAssociateRQ aarq = new AAssociateRQ();
        aarq.setCallingAET(this.aeTitle);
        aarq.setCalledAET(remoteAE.getAETitle());
        aarq.setMaxPDULength(this.maxPDULengthReceive);
        aarq.setMaxOpsInvoked(this.minZeroAsMax(this.maxOpsInvoked, remoteAE.maxOpsPerformed));
        aarq.setMaxOpsPerformed(this.minZeroAsMax(this.maxOpsPerformed, remoteAE.maxOpsInvoked));
        LinkedHashMap<String, Collection<String>> cuid2ts = new LinkedHashMap<String, Collection<String>>();
        HashSet<String> scu = new HashSet<String>();
        HashSet<String> scp = new HashSet<String>();
        this.evaluateTC(aarq, cuid2ts, scu, scp, remoteAE.getTransferCapability());
        if (cuid2ts.isEmpty()) {
            log.info("No common Transfer Capability between local AE " + this.getAETitle() + " and remote AE " + remoteAE.getAETitle());
            PresentationContext pctx = new PresentationContext();
            pctx.setPCID(aarq.nextPCID());
            pctx.setAbstractSyntax("1.2.840.10008.1.1");
            pctx.addTransferSyntax("1.2.840.10008.1.2");
            aarq.addPresentationContext(pctx);
            return aarq;
        }
        this.initPCs(aarq, cuid2ts);
        if (!cuid2ts.isEmpty()) {
            log.info("Maximum number (128) of offered Presentation Context reached -  cannot offer all Transfer Capabilities in A-ASSOCIATE-RQ");
        }
        for (String cuid : scp) {
            aarq.addRoleSelection(new RoleSelection(cuid, scu.contains(cuid), true));
        }
        if (userIdentity != null) {
            aarq.setUserIdentity(userIdentity.getUserIdentityRQ());
        }
        return aarq;
    }

    private void evaluateTC(AAssociateRQ aarq, Map<String, Collection<String>> cuid2ts, Collection<String> scu, Collection<String> scp, TransferCapability[] remoteTCs) {
        for (int i = 0; i < this.transferCapability.length; ++i) {
            Collection<String> ts;
            TransferCapability tc = this.transferCapability[i];
            String cuid = tc.getSopClass();
            LinkedHashSet<String> ts1 = new LinkedHashSet<String>(Arrays.asList(tc.getTransferSyntax()));
            if (remoteTCs.length != 0) {
                TransferCapability remoteTC = this.findTC(remoteTCs, cuid, tc.isSCU());
                if (remoteTC == null) continue;
                ts1.retainAll(Arrays.asList(remoteTC.getTransferSyntax()));
                if (ts1.isEmpty()) continue;
            }
            if ((ts = cuid2ts.get(cuid)) == null) {
                cuid2ts.put(cuid, ts1);
            } else {
                ts.addAll(ts1);
            }
            (tc.isSCP() ? scp : scu).add(cuid);
            byte[] extInfo = tc.getExtInfo();
            if (extInfo.length == 0) continue;
            ExtendedNegotiation extneg = new ExtendedNegotiation(cuid, extInfo);
            aarq.addExtendedNegotiation(extneg);
        }
    }

    private void initPCs(AAssociateRQ aarq, Map<String, Collection<String>> cuid2ts) {
        String[] tsdefs = new String[]{"1.2.840.10008.1.2", "1.2.840.10008.1.2.4.50", "1.2.840.10008.1.2.4.51", "1.2.840.10008.1.2.4.70", "1.2.840.10008.1.2.4.80"};
        while (!cuid2ts.isEmpty() && aarq.getNumberOfPresentationContexts() < 128) {
            Iterator<Map.Entry<String, Collection<String>>> iter = cuid2ts.entrySet().iterator();
            while (iter.hasNext() && aarq.getNumberOfPresentationContexts() < 128) {
                Map.Entry<String, Collection<String>> e = iter.next();
                String cuid = e.getKey();
                Collection<String> ts = e.getValue();
                PresentationContext pctx = new PresentationContext();
                pctx.setPCID(aarq.nextPCID());
                pctx.setAbstractSyntax(cuid);
                pctx.addTransferSyntax(this.selectTS(ts, tsdefs));
                aarq.addPresentationContext(pctx);
                if (!ts.isEmpty()) continue;
                iter.remove();
            }
        }
    }

    private String selectTS(Collection<String> ts, String[] tsdefs) {
        for (String tsdef : tsdefs) {
            if (!ts.remove(tsdef)) continue;
            return tsdef;
        }
        Iterator<String> tsiter = ts.iterator();
        String uid = tsiter.next();
        tsiter.remove();
        return uid;
    }

    private TransferCapability findTC(TransferCapability[] tcs, String cuid, boolean scp) {
        for (int i = 0; i < tcs.length; ++i) {
            TransferCapability tc = tcs[i];
            if (tc.isSCP() != scp || !tc.getSopClass().equals(cuid)) continue;
            return tc;
        }
        return null;
    }

    public void register(DicomService service) {
        this.serviceRegistry.register(service);
    }

    public void unregister(DicomService service) {
        this.serviceRegistry.unregister(service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToPool(Association a) {
        List<Association> list = this.pool;
        synchronized (list) {
            this.pool.add(a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFromPool(Association a) {
        List<Association> list = this.pool;
        synchronized (list) {
            this.pool.remove(a);
        }
    }

    void perform(Association as, int pcid, DicomObject cmd, PDVInputStream dataStream, String tsuid) throws IOException {
        this.serviceRegistry.process(as, pcid, cmd, dataStream, tsuid);
    }

    AAssociateAC negotiate(Association a, AAssociateRQ rq) throws AAssociateRJ {
        if (!this.isAssociationAcceptor()) {
            throw new AAssociateRJ(1, 1, 1);
        }
        String[] calling = this.getPreferredCallingAETitle();
        if (calling.length != 0 && Arrays.asList(calling).indexOf(rq.getCallingAET()) == -1) {
            throw new AAssociateRJ(1, 1, 3);
        }
        if (!this.isInstalled()) {
            throw new AAssociateRJ(2, 1, 1);
        }
        AAssociateAC ac = new AAssociateAC();
        ac.setCalledAET(rq.getCalledAET());
        ac.setCallingAET(rq.getCallingAET());
        ac.setMaxPDULength(this.maxPDULengthReceive);
        ac.setMaxOpsInvoked(this.minZeroAsMax(rq.getMaxOpsInvoked(), this.maxOpsPerformed));
        ac.setMaxOpsPerformed(this.minZeroAsMax(rq.getMaxOpsPerformed(), this.maxOpsInvoked));
        Collection<PresentationContext> pcs = rq.getPresentationContexts();
        for (PresentationContext rqpc : pcs) {
            PresentationContext acpc = this.negPresCtx(rq, ac, rqpc);
            ac.addPresentationContext(acpc);
        }
        return ac;
    }

    private PresentationContext negPresCtx(AAssociateRQ rq, AAssociateAC ac, PresentationContext rqpc) {
        String asuid = rqpc.getAbstractSyntax();
        RoleSelection rqrs = rq.getRoleSelectionFor(asuid);
        TransferCapability tcscp = this.findTC(this.transferCapability, asuid, true);
        TransferCapability tcscu = this.findTC(this.transferCapability, asuid, false);
        RoleSelection acrs = ac.getRoleSelectionFor(asuid);
        if (rqrs != null && acrs == null) {
            boolean scp = rqrs.isSCP() && tcscu != null;
            boolean scu = rqrs.isSCU() && tcscp != null;
            acrs = new RoleSelection(asuid, scu, scp);
            ac.addRoleSelection(acrs);
        }
        TransferCapability tc = rqrs == null || acrs.isSCU() ? tcscp : tcscu;
        PresentationContext acpc = new PresentationContext();
        acpc.setPCID(rqpc.getPCID());
        if (tc != null) {
            Set<String> rqts = rqpc.getTransferSyntaxes();
            String[] acts = tc.getTransferSyntax();
            for (int i = 0; i < acts.length; ++i) {
                ExtendedNegotiation extNeg;
                if (!rqts.contains(acts[i])) continue;
                acpc.addTransferSyntax(acts[i]);
                if (ac.getExtendedNegotiationFor(asuid) == null && (extNeg = tc.negotiate(rq.getExtendedNegotiationFor(asuid))) != null) {
                    ac.addExtendedNegotiation(extNeg);
                }
                return acpc;
            }
            acpc.setResult(4);
        } else {
            acpc.setResult(3);
        }
        acpc.addTransferSyntax(rqpc.getTransferSyntax());
        return acpc;
    }

    private int minZeroAsMax(int i1, int i2) {
        return i1 == 0 ? i2 : (i2 == 0 ? i1 : Math.min(i1, i2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAssociationListener(AssociationListener l) {
        if (l == null) {
            throw new NullPointerException();
        }
        AssociationListener[] associationListenerArray = this.als;
        synchronized (this.als) {
            AssociationListener[] tmp = new AssociationListener[this.als.length + 1];
            System.arraycopy(this.als, 0, tmp, 0, this.als.length);
            tmp[this.als.length] = l;
            this.als = tmp;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAssociationListener(AssociationListener l) {
        if (l == null) {
            throw new NullPointerException();
        }
        AssociationListener[] associationListenerArray = this.als;
        synchronized (this.als) {
            for (int i = 0; i < this.als.length; ++i) {
                if (!this.als[i].equals(l)) continue;
                AssociationListener[] tmp = new AssociationListener[this.als.length - 1];
                System.arraycopy(this.als, 0, tmp, 0, i);
                System.arraycopy(this.als, i + 1, tmp, i, tmp.length - i);
                this.als = tmp;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void associationAccepted(Association a) {
        AssociationListener[] associationListenerArray = this.als;
        synchronized (this.als) {
            for (AssociationListener l : this.als) {
                l.associationAccepted(new AssociationAcceptEvent(this, a));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void associationClosed(Association a) {
        AssociationListener[] associationListenerArray = this.als;
        synchronized (this.als) {
            for (AssociationListener l : this.als) {
                l.associationClosed(new AssociationCloseEvent(this, a));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    int nextMessageID() {
        return this.messageID.incrementAndGet() & 0xFFFF;
    }
}

