/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.net;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.concurrent.Executor;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.dcm4che2.net.AssociationReaper;
import org.dcm4che2.net.NetworkApplicationEntity;
import org.dcm4che2.net.NetworkConnection;

public class Device {
    private String deviceName = "";
    private String description;
    private String manufacturer;
    private String manufacturerModelName;
    private String stationName;
    private String deviceSerialNumber;
    private String issuerOfPATIENT_ID;
    private String[] softwareVersion = new String[0];
    private String[] primaryDeviceType = new String[0];
    private String[] institutionName = new String[0];
    private String[] institutionAddress = new String[0];
    private String[] institutionalDepartmentName = new String[0];
    private X509Certificate[] authorizedNodeCertificate = new X509Certificate[0];
    private X509Certificate[] thisNodeCertificate = new X509Certificate[0];
    private Object[] relatedDeviceConfiguration = new Object[0];
    private Object[] vendorDeviceData = new Object[0];
    private int associationReaperPeriod = 10000;
    private boolean installed = true;
    private NetworkConnection[] networkConnection = new NetworkConnection[0];
    private NetworkApplicationEntity[] networkAE = new NetworkApplicationEntity[0];
    private SSLContext sslContext;
    private AssociationReaper reaper;

    public Device() {
    }

    public Device(String deviceName) {
        this.deviceName = deviceName;
    }

    final synchronized AssociationReaper getAssociationReaper() {
        if (this.reaper == null) {
            this.reaper = new AssociationReaper(this.getAssociationReaperPeriod());
        }
        return this.reaper;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    public String getManufacturerModelName() {
        return this.manufacturerModelName;
    }

    public void setManufacturerModelName(String manufacturerModelName) {
        this.manufacturerModelName = manufacturerModelName;
    }

    public String[] getSoftwareVersion() {
        return this.softwareVersion;
    }

    public void setSoftwareVersion(String[] softwareVersion) {
        this.softwareVersion = softwareVersion;
    }

    public String getStationName() {
        return this.stationName;
    }

    public void setStationName(String stationName) {
        this.stationName = stationName;
    }

    public String getDeviceSerialNumber() {
        return this.deviceSerialNumber;
    }

    public void setDeviceSerialNumber(String deviceSerialNumber) {
        this.deviceSerialNumber = deviceSerialNumber;
    }

    public String[] getPrimaryDeviceType() {
        return this.primaryDeviceType;
    }

    public void setPrimaryDeviceType(String[] primaryDeviceType) {
        this.primaryDeviceType = primaryDeviceType;
    }

    public String[] getInstitutionName() {
        return this.institutionName;
    }

    public void setInstitutionName(String[] name) {
        this.institutionName = name;
    }

    public String[] getInstitutionAddress() {
        return this.institutionAddress;
    }

    public void setInstitutionAddress(String[] addr) {
        this.institutionAddress = addr;
    }

    public String[] getInstitutionalDepartmentName() {
        return this.institutionalDepartmentName;
    }

    public void setInstitutionalDepartmentName(String[] name) {
        this.institutionalDepartmentName = name;
    }

    public String getIssuerOfPATIENT_ID() {
        return this.issuerOfPATIENT_ID;
    }

    public void setIssuerOfPATIENT_ID(String issuerOfPATIENT_ID) {
        this.issuerOfPATIENT_ID = issuerOfPATIENT_ID;
    }

    public Object[] getRelatedDeviceConfiguration() {
        return this.relatedDeviceConfiguration;
    }

    public void setRelatedDeviceConfiguration(Object[] relatedDevice) {
        this.relatedDeviceConfiguration = relatedDevice;
    }

    public X509Certificate[] getAuthorizedNodeCertificate() {
        return this.authorizedNodeCertificate;
    }

    public void setAuthorizedNodeCertificate(X509Certificate[] certs) {
        this.authorizedNodeCertificate = certs;
    }

    public X509Certificate[] getThisNodeCertificate() {
        return this.thisNodeCertificate;
    }

    public void setThisNodeCertificate(X509Certificate[] certs) {
        this.thisNodeCertificate = certs;
    }

    public Object[] getVendorDeviceData() {
        return this.vendorDeviceData;
    }

    public void setVendorDeviceData(Object[] vendorDeviceData) {
        this.vendorDeviceData = vendorDeviceData;
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public void setInstalled(boolean installed) {
        this.installed = installed;
    }

    public NetworkApplicationEntity[] getNetworkApplicationEntity() {
        return this.networkAE;
    }

    public void setNetworkApplicationEntity(NetworkApplicationEntity networkAE) {
        this.setNetworkApplicationEntity(new NetworkApplicationEntity[]{networkAE});
    }

    public void setNetworkApplicationEntity(NetworkApplicationEntity[] networkAE) {
        for (int i = 0; i < networkAE.length; ++i) {
            networkAE[i].setDevice(this);
        }
        this.networkAE = networkAE;
    }

    public NetworkConnection[] getNetworkConnection() {
        return this.networkConnection;
    }

    public void setNetworkConnection(NetworkConnection networkConnection) {
        this.setNetworkConnection(new NetworkConnection[]{networkConnection});
    }

    public void setNetworkConnection(NetworkConnection[] networkConnection) {
        for (int i = 0; i < networkConnection.length; ++i) {
            networkConnection[i].setDevice(this);
        }
        this.networkConnection = networkConnection;
    }

    public int getAssociationReaperPeriod() {
        return this.associationReaperPeriod;
    }

    public void setAssociationReaperPeriod(int associationReaperPeriod) {
        this.associationReaperPeriod = associationReaperPeriod;
    }

    public void setSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public void initTLS(KeyStore key, char[] password) throws GeneralSecurityException {
        KeyStore trust = KeyStore.getInstance(KeyStore.getDefaultType());
        this.addCertificate(trust, this.getThisNodeCertificate());
        this.addCertificate(trust, this.getAuthorizedNodeCertificate());
        this.initTLS(key, password, trust);
    }

    private void addCertificate(KeyStore trust, X509Certificate[] certs) throws KeyStoreException {
        if (certs != null) {
            for (int i = 0; i < certs.length; ++i) {
                trust.setCertificateEntry(certs[i].getSubjectDN().getName(), certs[i]);
            }
        }
    }

    public void initTLS(KeyStore key, char[] password, KeyStore trust) throws GeneralSecurityException {
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(key, password);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(trust);
        if (this.sslContext == null) {
            this.sslContext = SSLContext.getInstance("TLS");
        }
        this.sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), new SecureRandom());
    }

    public void startListening(Executor executor) throws IOException {
        for (int i = 0; i < this.networkConnection.length; ++i) {
            NetworkConnection c = this.networkConnection[i];
            if (!c.isInstalled() || !c.isListening()) continue;
            c.bind(executor);
        }
    }

    public void stopListening() {
        for (int i = 0; i < this.networkConnection.length; ++i) {
            NetworkConnection c = this.networkConnection[i];
            c.unbind();
        }
    }

    public NetworkApplicationEntity getNetworkApplicationEntity(String aet) {
        for (int i = 0; i < this.networkAE.length; ++i) {
            NetworkApplicationEntity ae = this.networkAE[i];
            String aeti = ae.getAETitle();
            if (aeti != null && !aeti.equals(aet)) continue;
            return ae;
        }
        return null;
    }
}

