/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.widgets.gui;

import java.awt.Color;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;

public class ButtonFactory {
    public static JButton createEffectButton(Icon icon) {
        return ButtonFactory.createEffectButton(null, icon);
    }

    public static JButton createEffectButton(String title, Icon icon) {
        final JButton b = new JButton(icon);
        if (title != null) {
            b.setText(title);
            b.setToolTipText(title);
        }
        b.setMargin(new Insets(0, 0, 0, 0));
        b.setFocusable(false);
        b.setContentAreaFilled(false);
        b.setBorderPainted(false);
        b.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                b.setBorderPainted(true);
                b.setContentAreaFilled(true);
            }

            public void mouseExited(MouseEvent e) {
                b.setBorderPainted(false);
                b.setContentAreaFilled(false);
            }
        });
        return b;
    }

    public static JButton createEffectButton(String title, Icon icon, final Color color) {
        final JButton b = new JButton(icon);
        if (title != null) {
            b.setText(title);
            b.setToolTipText(title);
        }
        b.setMargin(new Insets(0, 0, 0, 0));
        b.setFocusable(false);
        b.setContentAreaFilled(false);
        b.setBorderPainted(false);
        b.addMouseListener(new MouseAdapter(){
            private Object uiProperty;
            private static final String GRADIENT = "Button.gradient";

            public void mouseEntered(MouseEvent e) {
                this.uiProperty = UIManager.get(GRADIENT);
                ArrayList<Serializable> bUI = new ArrayList<Serializable>();
                bUI.add(Double.valueOf(0.3));
                bUI.add(Double.valueOf(0.0));
                bUI.add(new ColorUIResource(color.brighter()));
                bUI.add(new ColorUIResource(255, 255, 255));
                bUI.add(new ColorUIResource(color));
                UIManager.put(GRADIENT, bUI);
                b.setBorderPainted(true);
                b.setContentAreaFilled(true);
            }

            public void mouseExited(MouseEvent e) {
                UIManager.put(GRADIENT, this.uiProperty);
                b.setBorderPainted(false);
                b.setContentAreaFilled(false);
            }
        });
        return b;
    }

    public static JButton createNarrowButton() {
        JButton b = new JButton();
        b.setMargin(new Insets(0, 0, 0, 0));
        return b;
    }

    public static JButton createNarrowButton(Icon icon) {
        JButton b = new JButton(icon);
        b.setMargin(new Insets(0, 0, 0, 0));
        return b;
    }

    public static JButton createNarrowButton(String title) {
        JButton b = new JButton(title);
        b.setMargin(new Insets(0, 0, 0, 0));
        b.setToolTipText(title);
        return b;
    }

    public static JButton create2LineButton(String title, Icon icon) {
        JButton b = new JButton(title, icon);
        b.setToolTipText(title);
        b.setVerticalTextPosition(3);
        b.setHorizontalTextPosition(0);
        return b;
    }

    public static JButton create2LineEffectButton(String title, Icon icon) {
        JButton b = ButtonFactory.createEffectButton(title, icon);
        b.setToolTipText(title);
        b.setVerticalTextPosition(3);
        b.setHorizontalTextPosition(0);
        return b;
    }

    public static JButton create2LineEffectButton(String title, Icon icon, Color color) {
        JButton b = ButtonFactory.createEffectButton(title, icon);
        b.setToolTipText(title);
        b.setVerticalTextPosition(3);
        b.setHorizontalTextPosition(0);
        return b;
    }
}

