/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.widgets;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.text.MaskFormatter;

public class UCMCodeField
extends JFormattedTextField
implements ActionListener {
    private Color m_Foreground;
    private static final String c_ZeroCheckSum = new String("00");

    public UCMCodeField() {
        this.setFormatter(this.createFormatter("######-##"));
        this.addActionListener(this);
        this.m_Foreground = this.getForeground();
    }

    protected MaskFormatter createFormatter(String p_Format) {
        MaskFormatter l_Formatter = null;
        try {
            l_Formatter = new MaskFormatter(p_Format);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return l_Formatter;
    }

    protected String buildChecksum(String p_UCMCode) {
        int l_UCMCode;
        try {
            l_UCMCode = Integer.parseInt(p_UCMCode);
        }
        catch (NumberFormatException p_Exception) {
            l_UCMCode = 0;
        }
        int l_Modulo = l_UCMCode % 97;
        String l_Checksum = l_Modulo < 10 ? new String("0") : new String("");
        l_Checksum = l_Checksum + l_Modulo;
        return l_Checksum;
    }

    public void processKeyEvent(KeyEvent p_Event) {
        char l_Character = p_Event.getKeyChar();
        if (l_Character != '\n') {
            this.setForeground(this.m_Foreground);
        }
        if (l_Character == '-') {
            String l_UCMCode = this.getText().substring(0, 6);
            l_UCMCode = l_UCMCode + l_Character + this.buildChecksum(l_UCMCode);
            this.setText(l_UCMCode);
        } else {
            super.processKeyEvent(p_Event);
        }
    }

    public void actionPerformed(ActionEvent p_Event) {
        String l_UCMCode = this.getText();
        int l_Length = l_UCMCode.length();
        if (l_Length == 9) {
            String l_CodeRoot = l_UCMCode.substring(0, 6);
            String l_CodeChecksum = l_UCMCode.substring(7, 9);
            String l_RealChecksum = this.buildChecksum(l_CodeRoot);
            if (l_CodeChecksum.equals(c_ZeroCheckSum)) {
                this.setForeground(this.m_Foreground);
                l_UCMCode = l_CodeRoot + '-' + l_RealChecksum;
                this.setText(l_UCMCode);
            } else if (!l_CodeChecksum.equals(l_RealChecksum)) {
                this.setForeground(Color.RED);
            }
        } else {
            this.setForeground(this.m_Foreground);
            String l_CodeRoot = l_UCMCode.substring(0, 6);
            String l_RealChecksum = this.buildChecksum(l_CodeRoot);
            l_UCMCode = l_CodeRoot + '-' + l_RealChecksum;
            this.setText(l_UCMCode);
        }
    }
}

