/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.widgets;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import lu.tudor.santec.i18n.Translatrix;
import lu.tudor.santec.widgets.Icons;

public abstract class SANTECApplication
extends JFrame {
    private static final long serialVersionUID = 2146929442141914402L;
    private static JFrame m_App = null;
    private static Logger m_Logger = null;
    public JTabbedPane m_ModuleTabbedPane = new JTabbedPane();
    protected JMenuBar m_MenuBar = new JMenuBar();
    protected JToolBar m_ToolBar = new JToolBar();
    private JLabel m_StatusBar = new JLabel("Framework ready.");
    protected JButton cutButton;
    protected JButton copyButton;
    protected JButton pasteButton;

    public SANTECApplication(String title, String packageName) {
        super(title);
        this.init(packageName);
    }

    public void pasteAction() {
        Component c = this.getFocusOwner();
        if (c instanceof JTextComponent) {
            ((JTextComponent)c).paste();
        }
    }

    public void copyAction() {
        Component c = this.getFocusOwner();
        if (c instanceof JTextComponent) {
            ((JTextComponent)c).copy();
        }
    }

    public void cutAction() {
        m_Logger.log(Level.INFO, "Begin...");
        Component c = this.getFocusOwner();
        if (c instanceof JTextComponent) {
            ((JTextComponent)c).cut();
        }
        m_Logger.log(Level.INFO, "End...");
    }

    public void checkForUpdate() {
    }

    public void updateAction() {
    }

    public static JFrame getFramework() {
        return m_App;
    }

    public String getSoftwareVersion() {
        FileInputStream l_PrefFileInStream = null;
        Properties l_LocalVersionInfo = new Properties();
        try {
            m_Logger.log(Level.INFO, "Loading local versionInfo File");
            l_PrefFileInStream = new FileInputStream("config/VersionInfo.prf");
            l_LocalVersionInfo.load(l_PrefFileInStream);
        }
        catch (FileNotFoundException f) {
            m_Logger.log(Level.WARNING, "Couldn't find the local VersionInfo.prf file");
        }
        catch (IOException io) {
            m_Logger.log(Level.WARNING, "Couldn't open the local VersionInfo.prf file");
        }
        return l_LocalVersionInfo.getProperty("ActualVersion");
    }

    protected void setStatusMessage(String p_Message) {
        m_Logger.log(Level.INFO, "Begin...");
        this.m_StatusBar.setText(p_Message);
        m_Logger.log(Level.INFO, "End...");
    }

    protected void init() {
        this.installActionListener();
        this.createMenuStructure();
        this.setJMenuBar(this.m_MenuBar);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.m_ToolBar, "North");
        this.getContentPane().add((Component)this.m_StatusBar, "South");
    }

    private void init(String packageName) {
        m_App = this;
        m_Logger = Logger.getLogger(packageName);
        m_Logger.log(Level.INFO, "System Logger was set up successfully: " + packageName);
        Translatrix.loadSupportedLocales((String)(packageName + ".resources.supportedLocales"));
        Translatrix.addBundle((String)"lu.tudor.santec.widgets.resources.WidgetResources");
        Translatrix.addBundle((String)"lu.tudor.santec.settings.resources.WidgetResources");
        Translatrix.addBundle((String)(packageName + ".resources.WidgetResources"));
        this.init();
    }

    private void firstRun() {
        File f = new File("config/firstrun.txt");
        System.out.println("updating nowwwww");
    }

    public abstract void aboutAction();

    public void welcomeAction() {
    }

    public void settingsAction() {
    }

    protected void createMenu(String pName) {
        m_Logger.log(Level.FINE, "Begin...");
        JMenu lMenu = new JMenu(pName, true);
        this.m_MenuBar.add(lMenu);
        m_Logger.log(Level.FINE, "End...");
    }

    protected JMenuItem createMenuItem(String pMenu, String pName, String pIconPath, int pMnemonic, KeyStroke pShortcut, final String pAction) {
        m_Logger.log(Level.FINE, "Begin...");
        JMenuItem lMenuItem = null;
        lMenuItem = pIconPath == null ? new JMenuItem(pName) : new JMenuItem(pName, Icons.getIcon(pIconPath, 16));
        lMenuItem.setMnemonic(pMnemonic);
        ActionListener lMenuAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Class<?> c = ((SANTECApplication)m_App).getClass();
                    Method todoAction = c.getMethod(pAction, null);
                    todoAction.invoke((Object)((SANTECApplication)m_App), (Object[])null);
                }
                catch (IllegalAccessException ia) {
                    ia.printStackTrace();
                }
                catch (NoSuchMethodException nsm) {
                    nsm.printStackTrace();
                }
                catch (Exception eg) {
                    eg.printStackTrace();
                }
            }
        };
        lMenuItem.addActionListener(lMenuAction);
        lMenuItem.setAccelerator(pShortcut);
        for (int i = 0; i < this.getJMenuBar().getMenuCount(); ++i) {
            if (!this.getJMenuBar().getMenu(i).getText().equals(pMenu)) continue;
            this.getJMenuBar().getMenu(i).add(lMenuItem);
        }
        m_Logger.log(Level.FINE, "End...");
        return lMenuItem;
    }

    public void createMenuSeperator(String pMenu) {
        for (int i = 0; i < this.getJMenuBar().getMenuCount(); ++i) {
            if (!this.getJMenuBar().getMenu(i).getText().equals(pMenu)) continue;
            this.getJMenuBar().getMenu(i).add(new JSeparator());
        }
    }

    protected void createToolBarSeperator() {
        this.m_ToolBar.addSeparator();
    }

    protected JButton createToolBarButton(String pIconPath, String pToolTip, String pAction) {
        return this.createToolBarButton(pIconPath, pToolTip, pAction, null, null);
    }

    protected JButton createToolBarButton(String pIconPath, String pToolTip, final String pAction, final Class[] pClassParameters, final Object[] pParameters) {
        JButton lToolbarButton = new JButton(Icons.getIcon(pIconPath, 32));
        lToolbarButton.setToolTipText(pToolTip);
        ActionListener lToolbarAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Class<?> c = ((SANTECApplication)m_App).getClass();
                    Method todoAction = c.getMethod(pAction, pClassParameters);
                    todoAction.invoke((Object)((SANTECApplication)m_App), pParameters);
                }
                catch (IllegalAccessException ia) {
                    ia.printStackTrace();
                }
                catch (NoSuchMethodException nsm) {
                    nsm.printStackTrace();
                }
                catch (Exception eg) {
                    eg.printStackTrace();
                }
            }
        };
        lToolbarButton.addActionListener(lToolbarAction);
        this.m_ToolBar.add(lToolbarButton);
        return lToolbarButton;
    }

    protected JButton createToolBarButton(JButton lToolbarButton, final String pAction) {
        ActionListener lToolbarAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Class<?> c = ((SANTECApplication)m_App).getClass();
                    Method todoAction = c.getMethod(pAction, null);
                    todoAction.invoke((Object)((SANTECApplication)m_App), (Object[])null);
                }
                catch (IllegalAccessException ia) {
                    ia.printStackTrace();
                }
                catch (NoSuchMethodException nsm) {
                    nsm.printStackTrace();
                }
                catch (Exception eg) {
                    eg.printStackTrace();
                }
            }
        };
        lToolbarButton.addActionListener(lToolbarAction);
        this.m_ToolBar.add(lToolbarButton);
        return lToolbarButton;
    }

    protected abstract void createMenuStructure();

    public void helpAction() {
    }

    protected void checkRestart() {
    }

    public abstract void exitAction();

    private void installActionListener() {
        this.setDefaultCloseOperation(0);
        WindowListener closeWindowAction = new WindowListener(){

            public void windowClosing(WindowEvent e) {
                SANTECApplication.this.exitAction();
            }

            public void windowClosed(WindowEvent e) {
            }

            public void windowOpened(WindowEvent e) {
            }

            public void windowIconified(WindowEvent e) {
            }

            public void windowDeiconified(WindowEvent e) {
            }

            public void windowActivated(WindowEvent e) {
            }

            public void windowDeactivated(WindowEvent e) {
            }
        };
        this.addWindowListener(closeWindowAction);
    }

    public static void log(Level info, String string) {
        SANTECApplication cfr_ignored_0 = (SANTECApplication)m_App;
        SANTECApplication.getLogger().log(info, string);
    }

    public static Logger getLogger() {
        return m_Logger;
    }
}

