/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.widgets;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import lu.tudor.santec.i18n.Translatrix;

public class ProgressDialog
extends JDialog
implements ActionListener {
    private Timer m_MonitoringIntervall;
    private JProgressBar m_ProgressBar;
    private ActionListener m_ActionListener;
    private JButton m_Abort;
    private JLabel m_Task = new JLabel();
    private boolean m_IsMonitoring;
    private boolean m_Aborted;

    public ProgressDialog(JFrame p_Parent, String p_Title, String p_Message, int p_MinValue, int p_MaxValue) {
        super(p_Parent, p_Title, false);
        Font l_TaskFont = this.m_Task.getFont();
        this.m_Task.setFont(l_TaskFont.deriveFont((float)((double)l_TaskFont.getSize() * 0.75)));
        this.m_ProgressBar = new JProgressBar(p_MinValue, p_MaxValue);
        this.m_Abort = new JButton(Translatrix.getTranslationString((String)"AbortOption"));
        this.m_Abort.addActionListener(this);
        Object[] l_Content = new Object[]{p_Message, this.m_Task, this.m_ProgressBar};
        Object[] l_Options = new Object[]{this.m_Abort};
        JOptionPane l_OptionPane = new JOptionPane(l_Content, -1, 0, null, l_Options, l_Options[0]);
        this.setContentPane(l_OptionPane);
    }

    public void addActionListener(ActionListener p_ActionListener) {
        this.m_ActionListener = p_ActionListener;
    }

    public void startMonitoring() {
        this.m_ProgressBar.setValue(this.m_ProgressBar.getMinimum());
        this.m_ProgressBar.setIndeterminate(true);
        this.m_ProgressBar.setStringPainted(true);
        this.m_ProgressBar.setString("");
        this.m_MonitoringIntervall = new Timer(1000, this.m_ActionListener);
        this.m_MonitoringIntervall.start();
        this.m_IsMonitoring = true;
        this.m_Aborted = false;
    }

    public void setProgress(int p_Progress) {
        if (p_Progress >= this.m_ProgressBar.getMinimum() && p_Progress <= this.m_ProgressBar.getMaximum()) {
            if (this.m_ProgressBar.isIndeterminate()) {
                this.m_ProgressBar.setIndeterminate(false);
                this.m_ProgressBar.setString(null);
            }
            this.m_ProgressBar.setValue(p_Progress);
        }
    }

    public void setTask(String p_TaskDescription) {
        this.m_Task.setText(p_TaskDescription);
    }

    public void setVisible(boolean p_Visibility) {
        if (p_Visibility) {
            Dimension l_ScreenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension l_DialogSize = this.getSize();
            this.setLocation((l_ScreenSize.width - l_DialogSize.width) / 2, (l_ScreenSize.height - l_DialogSize.height) / 2);
        }
        super.setVisible(p_Visibility);
    }

    public void stopMonitoring() {
        this.m_ProgressBar.setValue(this.m_ProgressBar.getMinimum());
        this.m_MonitoringIntervall.stop();
        this.m_IsMonitoring = false;
    }

    public boolean getAborted() {
        return this.m_Aborted;
    }

    public void actionPerformed(ActionEvent p_ActionEvent) {
        if (p_ActionEvent.getSource() == this.m_Abort) {
            this.m_Aborted = true;
            this.setVisible(false);
        }
    }
}

