/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.widgets;

import java.net.URL;
import java.util.logging.Logger;
import javax.swing.ImageIcon;

public class IconFactory {
    private static final int LARGEPIX = 90;
    private static final int MEDIPIX = 24;
    private static final int SMALLPIX = 18;
    private static final int MINIPIX = 16;
    public static final String CLEAR_LTR = "edit-clear-ltr.png";
    private static Logger logger = Logger.getLogger("lu.tudor.santec.widget");

    public ImageIcon getIconResource(String iconName) {
        String iconPath = "resources/icons/" + iconName;
        URL location = this.getClass().getResource(iconPath);
        if (location != null) {
            return new ImageIcon(location);
        }
        return new ImageIcon(iconPath);
    }

    public static ImageIcon getIcon(String iconName) {
        String iconPath = "resources/icons/" + iconName;
        URL location = IconFactory.class.getResource(iconPath);
        ImageIcon icon = location != null ? new ImageIcon(location) : new ImageIcon(iconPath);
        if (icon.getIconHeight() <= 0) {
            logger.warning("Couldn't find Icon: " + iconPath);
        }
        return icon;
    }

    public static ImageIcon getMiniIcon(String iconName) {
        return IconFactory.getScaledIcon(iconName, 16);
    }

    public static ImageIcon getSmallIcon(String iconName) {
        return IconFactory.getScaledIcon(iconName, 18);
    }

    public static ImageIcon getMediumIcon(String iconName) {
        return IconFactory.getScaledIcon(iconName, 24);
    }

    public static ImageIcon getBigIcon(String iconName) {
        return IconFactory.getScaledIcon(iconName, 90);
    }

    private static ImageIcon getScaledIcon(String iconName, int size) {
        return new ImageIcon(IconFactory.getIcon(iconName).getImage().getScaledInstance(size, size, 4));
    }
}

