/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.widgets;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import lu.tudor.santec.i18n.Relocalizable;
import lu.tudor.santec.i18n.Translatrix;

public class FileSelectorPanel
extends JPanel
implements ActionListener,
Relocalizable {
    private Component m_Owner;
    private GridBagLayout m_Layout;
    private GridBagConstraints m_Constraints;
    private JLabel m_FileNameLabel;
    private JTextField m_FileName;
    private String m_FilePath;
    private JButton m_BrowseButton;
    private int m_Mode;
    private File m_ChosenFile;
    private FileFilter m_FileFilter;
    private static File m_LastDirectory;
    public static final String c_FileSelectionChanged = "FileSelectionChanged";
    public static final int c_ForLoading = 1;
    public static final int c_ForSaving = 2;
    public static final int c_ChooseFolder = 3;

    public FileSelectorPanel(Component p_Owner, String p_FileNameLabel, int p_Mode) {
        this.m_Owner = p_Owner;
        this.m_Layout = new GridBagLayout();
        this.m_Constraints = new GridBagConstraints();
        this.setLayout(this.m_Layout);
        this.buildConstraint(this.m_Constraints, 0, 0, 1, 1, 100, 25, 10, 5);
        this.m_Constraints.fill = 0;
        this.m_Constraints.anchor = 16;
        this.m_FileNameLabel = new JLabel(p_FileNameLabel);
        this.m_Layout.setConstraints(this.m_FileNameLabel, this.m_Constraints);
        this.add(this.m_FileNameLabel);
        this.buildConstraint(this.m_Constraints, 0, 1, 1, 1, 75, 75, 10, 5);
        this.m_Constraints.fill = 2;
        this.m_Constraints.anchor = 18;
        this.m_FileName = new JTextField("", 32);
        this.m_FileName.setBackground(Color.white);
        this.m_FileName.addActionListener(this);
        this.m_Layout.setConstraints(this.m_FileName, this.m_Constraints);
        this.add(this.m_FileName);
        this.buildConstraint(this.m_Constraints, 1, 1, 1, 1, 25, 75, 10, 5);
        this.m_Constraints.fill = 0;
        this.m_Constraints.anchor = 18;
        this.m_BrowseButton = new JButton(Translatrix.getTranslationString((String)"BrowseButton"));
        this.m_BrowseButton.addActionListener(this);
        this.m_Layout.setConstraints(this.m_BrowseButton, this.m_Constraints);
        this.add(this.m_BrowseButton);
        switch (p_Mode) {
            case 1: 
            case 2: 
            case 3: {
                this.m_Mode = p_Mode;
                break;
            }
            default: {
                this.m_Mode = 1;
            }
        }
        this.m_FilePath = new String();
        this.m_ChosenFile = null;
        if (!(m_LastDirectory instanceof File)) {
            try {
                m_LastDirectory = new File(System.getProperty("user.dir"));
            }
            catch (SecurityException l_Exception) {
                m_LastDirectory = new File("", "");
            }
        }
    }

    public static void localizeFileSelector() {
        UIManager.put("FileChooser.lookInLabelText", Translatrix.getTranslationString((String)"FileSelector:LookIn"));
        UIManager.put("FileChooser.saveInLabelText", Translatrix.getTranslationString((String)"FileSelector:SaveIn"));
        UIManager.put("FileChooser.fileNameLabelText", Translatrix.getTranslationString((String)"FileSelector:FileName"));
        UIManager.put("FileChooser.filesOfTypeLabelText", Translatrix.getTranslationString((String)"FileSelector:FilesOfType"));
        UIManager.put("FileChooser.fileNameHeaderText", Translatrix.getTranslationString((String)"FileSelector:FileNameHeader"));
        UIManager.put("FileChooser.fileSizeHeaderText", Translatrix.getTranslationString((String)"FileSelector:FileSizeHeader"));
        UIManager.put("FileChooser.fileTypeHeaderText", Translatrix.getTranslationString((String)"FileSelector:FileTypeHeader"));
        UIManager.put("FileChooser.fileDateHeaderText", Translatrix.getTranslationString((String)"FileSelector:FileDateHeader"));
        UIManager.put("FileChooser.fileAttrHeaderText", Translatrix.getTranslationString((String)"FileSelector:FileAttributesHeader"));
        UIManager.put("FileChooser.saveButtonText", Translatrix.getTranslationString((String)"FileSelector:SaveButton"));
        UIManager.put("FileChooser.openButtonText", Translatrix.getTranslationString((String)"FileSelector:OpenButton"));
        UIManager.put("FileChooser.directoryOpenButtonText", Translatrix.getTranslationString((String)"FileSelector:OpenFolderButton"));
        UIManager.put("FileChooser.cancelButtonText", Translatrix.getTranslationString((String)"FileSelector:CancelButton"));
        UIManager.put("FileChooser.updateButtonText", Translatrix.getTranslationString((String)"FileSelector:UpdateButton"));
        UIManager.put("FileChooser.helpButtonText", Translatrix.getTranslationString((String)"FileSelector:HelpButton"));
        UIManager.put("FileChooser.upFolderToolTipText", Translatrix.getTranslationString((String)"FileSelector:UpFolderTip"));
        UIManager.put("FileChooser.homeFolderToolTipText", Translatrix.getTranslationString((String)"FileSelector:HomeFolderTip"));
        UIManager.put("FileChooser.newFolderToolTipText", Translatrix.getTranslationString((String)"FileSelector:NewFolderTip"));
        UIManager.put("FileChooser.listViewButtonToolTipText", Translatrix.getTranslationString((String)"FileSelector:ListViewTip"));
        UIManager.put("FileChooser.detailsViewButtonToolTipText", Translatrix.getTranslationString((String)"FileSelector:DetailViewTip"));
        UIManager.put("FileChooser.saveButtonToolTipText", Translatrix.getTranslationString((String)"FileSelector:SaveButtonTip"));
        UIManager.put("FileChooser.openButtonToolTipText", Translatrix.getTranslationString((String)"FileSelector:OpenButtonTip"));
        UIManager.put("FileChooser.cancelButtonToolTipText", Translatrix.getTranslationString((String)"FileSelector:CancelButtonTip"));
        UIManager.put("FileChooser.updateButtonToolTipText", Translatrix.getTranslationString((String)"FileSelector:UpdateButtonTip"));
        UIManager.put("FileChooser.helpButtonToolTipText", Translatrix.getTranslationString((String)"FileSelector:HelpButtonTip"));
    }

    public void setFileFilter(FileFilter p_FileFilter) {
        this.m_FileFilter = p_FileFilter;
    }

    public void setFileNameLabel(String p_FileNameLabel) {
        if (p_FileNameLabel != null && this.m_FileNameLabel != null) {
            this.m_FileNameLabel.setText(p_FileNameLabel);
        }
    }

    public void actionPerformed(ActionEvent p_Event) {
        JButton l_PressedButton;
        String l_ButtonLabel;
        if (p_Event.getSource() instanceof JButton && (l_ButtonLabel = (l_PressedButton = (JButton)p_Event.getSource()).getText()) == Translatrix.getTranslationString((String)"BrowseButton")) {
            int l_Choice;
            JFileChooser l_FileSelector = new JFileChooser();
            l_FileSelector.setLocale(Translatrix.getLocale());
            if (this.m_FileFilter != null) {
                l_FileSelector.setFileFilter(this.m_FileFilter);
            }
            if (this.m_ChosenFile instanceof File) {
                l_FileSelector.setCurrentDirectory(this.m_ChosenFile);
            } else if (m_LastDirectory instanceof File) {
                l_FileSelector.setCurrentDirectory(m_LastDirectory);
            }
            switch (this.m_Mode) {
                case 1: {
                    l_FileSelector.setDialogTitle(Translatrix.getTranslationString((String)"LoadFileTitle"));
                    l_Choice = l_FileSelector.showOpenDialog(this.m_Owner);
                    break;
                }
                case 2: {
                    l_FileSelector.setDialogTitle(Translatrix.getTranslationString((String)"SaveFileTitle"));
                    l_Choice = l_FileSelector.showSaveDialog(this.m_Owner);
                    break;
                }
                case 3: {
                    l_FileSelector.setDialogTitle(Translatrix.getTranslationString((String)"ChooseFolderTitle"));
                    l_FileSelector.setFileSelectionMode(1);
                    l_Choice = l_FileSelector.showDialog(this.m_Owner, Translatrix.getTranslationString((String)"ChooseButton"));
                    break;
                }
                default: {
                    l_FileSelector.setDialogTitle(Translatrix.getTranslationString((String)"LoadFileTitle"));
                    l_Choice = l_FileSelector.showOpenDialog(this.m_Owner);
                }
            }
            if (l_Choice == 0) {
                File l_OldFile = this.m_ChosenFile;
                this.m_ChosenFile = l_FileSelector.getSelectedFile();
                this.m_FilePath = this.m_ChosenFile.getParent();
                this.m_FileName.setText(this.m_ChosenFile.getName());
                this.firePropertyChange(c_FileSelectionChanged, l_OldFile, this.m_ChosenFile);
                m_LastDirectory = this.m_ChosenFile;
            }
        }
        if (p_Event.getSource() instanceof JTextField) {
            File l_OldFile = this.m_ChosenFile;
            this.m_ChosenFile = this.m_FileName.getText().length() > 0 ? new File(this.m_FilePath, this.m_FileName.getText()) : null;
            this.firePropertyChange(c_FileSelectionChanged, l_OldFile, this.m_ChosenFile);
        }
    }

    public void buildConstraint(GridBagConstraints p_Constraints, int p_GridX, int p_GridY, int p_GridWidth, int p_GridHeight, int p_WeightX, int p_WeightY, int p_MarginX, int p_MarginY) {
        p_Constraints.gridx = p_GridX;
        p_Constraints.gridy = p_GridY;
        p_Constraints.gridwidth = p_GridWidth;
        p_Constraints.gridheight = p_GridHeight;
        p_Constraints.weightx = p_WeightX;
        p_Constraints.weighty = p_WeightY;
        p_Constraints.insets = new Insets(p_MarginY, p_MarginX, p_MarginY, p_MarginX);
    }

    public void setEnabled(boolean p_EnableIt) {
        super.setEnabled(p_EnableIt);
        this.m_FileName.setEnabled(p_EnableIt);
        this.m_BrowseButton.setEnabled(p_EnableIt);
    }

    public File getChosenFile() {
        return this.m_ChosenFile;
    }

    public void forgetFile() {
        this.m_ChosenFile = null;
        this.m_FilePath = "";
        this.m_FileName.setText("");
    }

    public void setFile(File p_File) {
        if (p_File instanceof File) {
            this.m_ChosenFile = p_File;
            this.m_FilePath = this.m_ChosenFile.getParent();
            this.m_FileName.setText(this.m_ChosenFile.getName());
        } else {
            this.m_ChosenFile = null;
            this.m_FilePath = "";
            this.m_FileName.setText("");
        }
    }

    public String getFilePath() {
        return this.m_FilePath + "/" + this.m_FileName.getText();
    }

    public void relocalize() {
        if (this.m_BrowseButton != null) {
            this.m_BrowseButton.setText(Translatrix.getTranslationString((String)"BrowseButton"));
        }
        FileSelectorPanel.localizeFileSelector();
    }
}

