/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import org.jboss.logging.Logger;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.tm.JBossXATerminator;
import org.jboss.tm.TransactionImpl;
import org.jboss.tm.TransactionManagerServiceMBean;
import org.jboss.tm.TxManager;
import org.jboss.tm.XAExceptionFormatter;
import org.jboss.tm.XidFactoryMBean;
import org.jboss.tm.integrity.TransactionIntegrityFactory;

public class TransactionManagerService
extends ServiceMBeanSupport
implements TransactionManagerServiceMBean,
ObjectFactory {
    public static String JNDI_NAME = "java:/TransactionManager";
    public static String JNDI_IMPORTER = "java:/TransactionPropagationContextImporter";
    public static String JNDI_EXPORTER = "java:/TransactionPropagationContextExporter";
    private boolean globalIdsEnabled = false;
    private boolean interruptThreads = false;
    private int timeout = 300;
    private ObjectName xidFactory;
    private TransactionIntegrityFactory integrityFactory;
    private final Map xaExceptionFormatters = new HashMap();
    static TxManager tm;
    static /* synthetic */ Class class$javax$transaction$xa$XAException;

    protected void startService() throws Exception {
        XidFactoryMBean xidFactoryObj;
        TransactionImpl.xidFactory = xidFactoryObj = (XidFactoryMBean)this.getServer().getAttribute(this.xidFactory, "Instance");
        TransactionImpl.txManagerService = this;
        tm = TxManager.getInstance();
        tm.setDefaultTransactionTimeout(this.timeout);
        tm.setGlobalIdsEnabled(this.globalIdsEnabled);
        tm.setInterruptThreads(this.interruptThreads);
        if (this.integrityFactory != null) {
            tm.setTransactionIntegrity(this.integrityFactory.createTransactionIntegrity());
        } else {
            tm.setTransactionIntegrity(null);
        }
        this.bindRef(JNDI_NAME, "org.jboss.tm.TxManager");
        this.bindRef(JNDI_IMPORTER, "org.jboss.tm.TransactionPropagationContextImporter");
        this.bindRef(JNDI_EXPORTER, "org.jboss.tm.TransactionPropagationContextFactory");
    }

    protected void stopService() {
        try {
            InitialContext ctx = new InitialContext();
            ctx.unbind(JNDI_NAME);
            ctx.unbind(JNDI_IMPORTER);
            ctx.unbind(JNDI_EXPORTER);
        }
        catch (Exception e) {
            this.log.error("Failed to clear JNDI bindings", e);
        }
    }

    public boolean getGlobalIdsEnabled() {
        return this.globalIdsEnabled;
    }

    public void setGlobalIdsEnabled(boolean newValue) {
        this.globalIdsEnabled = newValue;
        if (tm != null) {
            tm.setGlobalIdsEnabled(newValue);
        }
    }

    public boolean isInterruptThreads() {
        return this.interruptThreads;
    }

    public void setInterruptThreads(boolean interruptThreads) {
        this.interruptThreads = interruptThreads;
        if (tm != null) {
            tm.setInterruptThreads(interruptThreads);
        }
    }

    public int getTransactionTimeout() {
        if (tm != null) {
            this.timeout = tm.getDefaultTransactionTimeout();
        }
        return this.timeout;
    }

    public void setTransactionTimeout(int timeout) {
        this.timeout = timeout;
        if (tm != null) {
            tm.setDefaultTransactionTimeout(timeout);
        }
    }

    public void setTransactionIntegrityFactory(TransactionIntegrityFactory factory) {
        this.integrityFactory = factory;
        if (tm != null) {
            if (factory != null) {
                tm.setTransactionIntegrity(factory.createTransactionIntegrity());
            } else {
                tm.setTransactionIntegrity(null);
            }
        }
    }

    public ObjectName getXidFactory() {
        return this.xidFactory;
    }

    public void setXidFactory(ObjectName xidFactory) {
        this.xidFactory = xidFactory;
    }

    public TransactionManager getTransactionManager() {
        return tm;
    }

    public JBossXATerminator getXATerminator() {
        return tm;
    }

    public long getTransactionCount() {
        return tm.getTransactionCount();
    }

    public long getCommitCount() {
        return tm.getCommitCount();
    }

    public long getRollbackCount() {
        return tm.getRollbackCount();
    }

    public void registerXAExceptionFormatter(Class clazz, XAExceptionFormatter formatter) {
        this.xaExceptionFormatters.put(clazz, formatter);
    }

    public void unregisterXAExceptionFormatter(Class clazz) {
        this.xaExceptionFormatters.remove(clazz);
    }

    void formatXAException(XAException xae, Logger log) {
        for (Class<?> clazz = xae.getClass(); clazz != (class$javax$transaction$xa$XAException == null ? TransactionManagerService.class$("javax.transaction.xa.XAException") : class$javax$transaction$xa$XAException); clazz = clazz.getSuperclass()) {
            XAExceptionFormatter formatter = (XAExceptionFormatter)this.xaExceptionFormatters.get(clazz);
            if (formatter == null) continue;
            formatter.formatXAException(xae, log);
            return;
        }
    }

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        return tm;
    }

    private void bindRef(String jndiName, String className) throws Exception {
        Reference ref = new Reference(className, this.getClass().getName(), null);
        new InitialContext().bind(jndiName, (Object)ref);
    }
}

