/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.transaction.Transaction;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.InvocationKey;
import org.jboss.invocation.InvocationType;
import org.jboss.invocation.JBossLazyUnmarshallingException;
import org.jboss.invocation.MarshalledValue;
import org.jboss.remoting.serialization.IMarshalledValue;
import org.jboss.remoting.serialization.SerializationStreamFactory;

public class MarshalledInvocation
extends Invocation
implements Externalizable {
    static final long serialVersionUID = -718723094688127810L;
    static boolean useFullHashMode;
    static Map hashMap;
    protected Object tpc;
    protected transient Map methodMap;
    protected transient long methodHash = 0L;
    protected transient Object marshalledArgs = null;

    public long getMethodHash() {
        return this.methodHash;
    }

    public void setMethodHash(long methodHash) {
        this.methodHash = methodHash;
    }

    public static boolean getUseFullHashMode() {
        return useFullHashMode;
    }

    public static void setUseFullHashMode(boolean flag) {
        useFullHashMode = flag;
    }

    public static Map getInterfaceHashes(Class intf) {
        Method[] methods = null;
        if (System.getSecurityManager() != null) {
            DeclaredMethodsAction action = new DeclaredMethodsAction(intf);
            methods = (Method[])AccessController.doPrivileged(action);
        } else {
            methods = intf.getDeclaredMethods();
        }
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            Class<?>[] parameterTypes = method.getParameterTypes();
            String methodDesc = method.getName() + "(";
            for (int j = 0; j < parameterTypes.length; ++j) {
                methodDesc = methodDesc + MarshalledInvocation.getTypeString(parameterTypes[j]);
            }
            methodDesc = methodDesc + ")" + MarshalledInvocation.getTypeString(method.getReturnType());
            try {
                long hash = 0L;
                ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream(512);
                MessageDigest messagedigest = MessageDigest.getInstance("SHA");
                DataOutputStream dataoutputstream = new DataOutputStream(new DigestOutputStream(bytearrayoutputstream, messagedigest));
                dataoutputstream.writeUTF(methodDesc);
                dataoutputstream.flush();
                byte[] abyte0 = messagedigest.digest();
                for (int j = 0; j < Math.min(8, abyte0.length); ++j) {
                    hash += (long)(abyte0[j] & 0xFF) << j * 8;
                }
                map.put(method.toString(), new Long(hash));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    public static Map getFullInterfaceHashes(Class intf) {
        Method[] methods = null;
        if (System.getSecurityManager() != null) {
            DeclaredMethodsAction action = new DeclaredMethodsAction(intf);
            methods = (Method[])AccessController.doPrivileged(action);
        } else {
            methods = intf.getDeclaredMethods();
        }
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            String methodDesc = method.toString();
            try {
                long hash = 0L;
                ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream(512);
                MessageDigest messagedigest = MessageDigest.getInstance("SHA");
                DataOutputStream dataoutputstream = new DataOutputStream(new DigestOutputStream(bytearrayoutputstream, messagedigest));
                dataoutputstream.writeUTF(methodDesc);
                dataoutputstream.flush();
                byte[] abyte0 = messagedigest.digest();
                for (int j = 0; j < Math.min(8, abyte0.length); ++j) {
                    hash += (long)(abyte0[j] & 0xFF) << j * 8;
                }
                map.put(method.toString(), new Long(hash));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    public static Map methodToHashesMap(Class c) {
        Method[] methods = null;
        if (System.getSecurityManager() != null) {
            DeclaredMethodsAction action = new DeclaredMethodsAction(c);
            methods = (Method[])AccessController.doPrivileged(action);
        } else {
            methods = c.getDeclaredMethods();
        }
        HashMap<Long, Method> map = new HashMap<Long, Method>();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            String methodDesc = method.toString();
            try {
                long hash = 0L;
                ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream(512);
                MessageDigest messagedigest = MessageDigest.getInstance("SHA");
                DataOutputStream dataoutputstream = new DataOutputStream(new DigestOutputStream(bytearrayoutputstream, messagedigest));
                dataoutputstream.writeUTF(methodDesc);
                dataoutputstream.flush();
                byte[] abyte0 = messagedigest.digest();
                for (int j = 0; j < Math.min(8, abyte0.length); ++j) {
                    hash += (long)(abyte0[j] & 0xFF) << j * 8;
                }
                map.put(new Long(hash), method);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    static String getTypeString(Class cl) {
        if (cl == Byte.TYPE) {
            return "B";
        }
        if (cl == Character.TYPE) {
            return "C";
        }
        if (cl == Double.TYPE) {
            return "D";
        }
        if (cl == Float.TYPE) {
            return "F";
        }
        if (cl == Integer.TYPE) {
            return "I";
        }
        if (cl == Long.TYPE) {
            return "J";
        }
        if (cl == Short.TYPE) {
            return "S";
        }
        if (cl == Boolean.TYPE) {
            return "Z";
        }
        if (cl == Void.TYPE) {
            return "V";
        }
        if (cl.isArray()) {
            return "[" + MarshalledInvocation.getTypeString(cl.getComponentType());
        }
        return "L" + cl.getName().replace('.', '/') + ";";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long calculateHash(Method method) {
        Map methodHashes = (Map)hashMap.get(method.getDeclaringClass());
        if (methodHashes == null) {
            methodHashes = useFullHashMode ? MarshalledInvocation.getFullInterfaceHashes(method.getDeclaringClass()) : MarshalledInvocation.getInterfaceHashes(method.getDeclaringClass());
            Map map = hashMap;
            synchronized (map) {
                hashMap.put(method.getDeclaringClass(), methodHashes);
            }
        }
        Long hash = (Long)methodHashes.get(method.toString());
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeHashes(Class declaringClass) {
        Map map = hashMap;
        synchronized (map) {
            hashMap.remove(declaringClass);
        }
    }

    public MarshalledInvocation() {
    }

    public MarshalledInvocation(Invocation invocation) {
        this.payload = invocation.payload;
        this.as_is_payload = invocation.as_is_payload;
        this.method = invocation.getMethod();
        this.objectName = invocation.getObjectName();
        this.args = invocation.getArguments();
        this.invocationType = invocation.getType();
        this.transient_payload = invocation.transient_payload;
        this.invocationContext = invocation.invocationContext;
    }

    public MarshalledInvocation(Object id, Method m, Object[] args, Transaction tx, Principal identity, Object credential) {
        super(id, m, args, tx, identity, credential);
    }

    public Method getMethod() {
        if (this.method != null) {
            return this.method;
        }
        this.method = (Method)this.methodMap.get(new Long(this.methodHash));
        if (this.method == null) {
            throw new IllegalStateException("Failed to find method for hash:" + this.methodHash + " available=" + this.methodMap);
        }
        return this.method;
    }

    public void setMethodMap(Map methods) {
        this.methodMap = methods;
    }

    public void setTransactionPropagationContext(Object tpc) {
        this.tpc = tpc;
    }

    public Object getTransactionPropagationContext() {
        return this.tpc;
    }

    public Object getValue(Object key) {
        Object value = super.getValue(key);
        if (value instanceof IMarshalledValue) {
            try {
                IMarshalledValue mv = (IMarshalledValue)value;
                value = mv.get();
            }
            catch (Exception e) {
                JBossLazyUnmarshallingException ise = new JBossLazyUnmarshallingException("getValue failed");
                ise.initCause(e);
                throw ise;
            }
        }
        return value;
    }

    public Object getPayloadValue(Object key) {
        Object value = this.getPayload().get(key);
        if (value instanceof MarshalledValue) {
            try {
                MarshalledValue mv = (MarshalledValue)value;
                value = mv.get();
            }
            catch (Exception e) {
                JBossLazyUnmarshallingException ise = new JBossLazyUnmarshallingException("getPayloadValue failed");
                ise.initCause(e);
                throw ise;
            }
        }
        if (value instanceof IMarshalledValue) {
            try {
                IMarshalledValue mv = (IMarshalledValue)value;
                value = mv.get();
            }
            catch (Exception e) {
                JBossLazyUnmarshallingException ise = new JBossLazyUnmarshallingException("getPayloadValue failed");
                ise.initCause(e);
                throw ise;
            }
        }
        return value;
    }

    public Object[] getArguments() {
        if (this.args == null) {
            if (this.marshalledArgs instanceof MarshalledValue) {
                try {
                    this.args = (Object[])((MarshalledValue)this.marshalledArgs).get();
                }
                catch (Exception e) {
                    JBossLazyUnmarshallingException ise = new JBossLazyUnmarshallingException("getArguments failed");
                    ise.initCause(e);
                    throw ise;
                }
            }
            if (this.marshalledArgs instanceof IMarshalledValue) {
                try {
                    this.args = (Object[])((IMarshalledValue)this.marshalledArgs).get();
                }
                catch (Exception e) {
                    JBossLazyUnmarshallingException ise = new JBossLazyUnmarshallingException("getArguments failed");
                    ise.initCause(e);
                    throw ise;
                }
            }
        }
        return this.args;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        Object currentKey;
        Iterator keys;
        this.getAsIsPayload().put(InvocationKey.TYPE, this.invocationType);
        out.writeObject(this.tpc);
        long methodHash = this.methodHash;
        if (methodHash == 0L) {
            methodHash = MarshalledInvocation.calculateHash(this.method);
        }
        out.writeLong(methodHash);
        out.writeObject(this.objectName);
        String serializationType = null;
        if (this.invocationContext != null) {
            serializationType = (String)this.invocationContext.getValue("SERIALIZATION_TYPE");
        }
        if (this.args == null && this.marshalledArgs != null) {
            out.writeObject(this.marshalledArgs);
        } else {
            out.writeObject(this.createMarshalledValue(serializationType, this.args));
        }
        if (this.payload == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.payload.size());
            keys = this.payload.keySet().iterator();
            while (keys.hasNext()) {
                currentKey = keys.next();
                out.writeObject(currentKey);
                Object value = this.payload.get(currentKey);
                if (!(value instanceof MarshalledValue)) {
                    value = this.createMarshalledValue(serializationType, value);
                }
                out.writeObject(value);
            }
        }
        if (this.as_is_payload == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.as_is_payload.size());
            keys = this.as_is_payload.keySet().iterator();
            while (keys.hasNext()) {
                currentKey = keys.next();
                out.writeObject(currentKey);
                out.writeObject(this.as_is_payload.get(currentKey));
            }
        }
    }

    private Object createMarshalledValue(String serializationType, Object valueToBeMarshalled) throws IOException {
        if (serializationType != null) {
            return SerializationStreamFactory.getManagerInstance((String)serializationType).createdMarshalledValue(valueToBeMarshalled);
        }
        return new MarshalledValue(valueToBeMarshalled);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int as_is_payloadSize;
        this.tpc = in.readObject();
        this.methodHash = in.readLong();
        this.objectName = in.readObject();
        this.marshalledArgs = in.readObject();
        int payloadSize = in.readInt();
        if (payloadSize > 0) {
            this.payload = new HashMap();
            for (int i = 0; i < payloadSize; ++i) {
                Object key = in.readObject();
                Object value = in.readObject();
                this.payload.put(key, value);
            }
        }
        if ((as_is_payloadSize = in.readInt()) > 0) {
            this.as_is_payload = new HashMap();
            for (int i = 0; i < as_is_payloadSize; ++i) {
                Object key = in.readObject();
                Object value = in.readObject();
                this.as_is_payload.put(key, value);
            }
        }
        this.invocationType = (InvocationType)this.getAsIsValue(InvocationKey.TYPE);
    }

    public void setMarshalledArguments(IMarshalledValue marshalledValue) {
        this.marshalledArgs = marshalledValue;
    }

    static {
        try {
            Class.forName("org.jboss.invocation.unified.interfaces.JavaSerializationManager");
        }
        catch (Exception exception) {
            // empty catch block
        }
        useFullHashMode = true;
        hashMap = new WeakHashMap();
    }

    private static class DeclaredMethodsAction
    implements PrivilegedAction {
        Class c;

        DeclaredMethodsAction(Class c) {
            this.c = c;
        }

        public Object run() {
            Method[] methods = this.c.getDeclaredMethods();
            this.c = null;
            return methods;
        }
    }
}

