/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class InvocationStatistics {
    private Map methodStats;
    public long concurrentCalls = 0L;
    public long maxConcurrentCalls = 0L;
    public long lastResetTime = System.currentTimeMillis();

    public InvocationStatistics() {
        this.methodStats = new ConcurrentReaderHashMap();
    }

    public void updateStats(Method m, long elapsed) {
        TimeStatistic stat = (TimeStatistic)this.methodStats.get(m);
        if (stat == null) {
            stat = new TimeStatistic();
            this.methodStats.put(m, stat);
        }
        ++stat.count;
        stat.totalTime += elapsed;
        if (stat.minTime > elapsed) {
            stat.minTime = elapsed;
        }
        if (stat.maxTime < elapsed) {
            stat.maxTime = elapsed;
        }
    }

    public synchronized void callIn() {
        ++this.concurrentCalls;
        if (this.concurrentCalls > this.maxConcurrentCalls) {
            this.maxConcurrentCalls = this.concurrentCalls;
        }
    }

    public synchronized void callOut() {
        --this.concurrentCalls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetStats() {
        Map map = this.methodStats;
        synchronized (map) {
            Iterator iter = this.methodStats.values().iterator();
            while (iter.hasNext()) {
                TimeStatistic stat = (TimeStatistic)iter.next();
                stat.reset();
            }
        }
        this.maxConcurrentCalls = 0L;
        this.lastResetTime = System.currentTimeMillis();
    }

    public Map getStats() {
        return this.methodStats;
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer("<InvocationStatistics concurrentCalls='");
        tmp.append(this.concurrentCalls);
        tmp.append("' >\n");
        HashMap copy = new HashMap(this.methodStats);
        Iterator iter = copy.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            TimeStatistic stat = (TimeStatistic)entry.getValue();
            if (stat == null) continue;
            tmp.append("<method name='");
            tmp.append(entry.getKey());
            tmp.append("' count='");
            tmp.append(stat.count);
            tmp.append("' minTime='");
            tmp.append(stat.minTime);
            tmp.append("' maxTime='");
            tmp.append(stat.maxTime);
            tmp.append("' totalTime='");
            tmp.append(stat.totalTime);
            tmp.append("' />\n");
        }
        tmp.append("</InvocationStatistics>");
        return tmp.toString();
    }

    public class TimeStatistic {
        public volatile long count;
        public volatile long minTime = Long.MAX_VALUE;
        public volatile long maxTime;
        public volatile long totalTime;

        public void reset() {
            this.count = 0L;
            this.minTime = Long.MAX_VALUE;
            this.maxTime = 0L;
            this.totalTime = 0L;
        }
    }
}

