/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.iiop.rmi;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.rmi.AccessException;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.util.Arrays;
import java.util.Iterator;
import javax.transaction.InvalidTransactionException;
import javax.transaction.TransactionRequiredException;
import javax.transaction.TransactionRolledbackException;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSACTION_REQUIRED;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.portable.IDLEntity;

public class RmiIdlUtil {
    static /* synthetic */ Class class$java$rmi$RemoteException;
    static /* synthetic */ Class class$java$lang$String;

    public static boolean hasLegalRMIIIOPArguments(Method method) {
        Class<?>[] params = method.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            if (RmiIdlUtil.isRMIIIOPType(params[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean hasLegalRMIIIOPReturnType(Method method) {
        return RmiIdlUtil.isRMIIIOPType(method.getReturnType());
    }

    public static boolean hasLegalRMIIIOPExceptionTypes(Method method) {
        Iterator<Class<?>> it = Arrays.asList(method.getExceptionTypes()).iterator();
        while (it.hasNext()) {
            Class<?> exception = it.next();
            if (RmiIdlUtil.isRMIIDLExceptionType(exception)) continue;
            return false;
        }
        return true;
    }

    public static boolean throwsRemoteException(Method method) {
        Class<?>[] exception = method.getExceptionTypes();
        for (int i = 0; i < exception.length; ++i) {
            if (!exception[i].isAssignableFrom(class$java$rmi$RemoteException == null ? RmiIdlUtil.class$("java.rmi.RemoteException") : class$java$rmi$RemoteException)) continue;
            return true;
        }
        return false;
    }

    public static boolean isStatic(Member member) {
        return Modifier.isStatic(member.getModifiers());
    }

    public static boolean isStatic(Class c) {
        return Modifier.isStatic(c.getModifiers());
    }

    public static boolean isFinal(Member member) {
        return Modifier.isFinal(member.getModifiers());
    }

    public static boolean isFinal(Class c) {
        return Modifier.isFinal(c.getModifiers());
    }

    public static boolean isPublic(Member member) {
        return Modifier.isPublic(member.getModifiers());
    }

    public static boolean isPublic(Class c) {
        return Modifier.isPublic(c.getModifiers());
    }

    public static boolean isAllFieldsPublic(Class c) {
        try {
            Field[] list = c.getFields();
            for (int i = 0; i < list.length; ++i) {
                if (Modifier.isPublic(list[i].getModifiers())) continue;
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isAbstract(Class c) {
        return Modifier.isAbstract(c.getModifiers());
    }

    public static boolean isRMIIIOPType(Class type) {
        if (type.isPrimitive()) {
            return true;
        }
        if (type.isArray()) {
            return RmiIdlUtil.isRMIIIOPType(type.getComponentType());
        }
        if (Object.class.isAssignableFrom(type)) {
            return true;
        }
        if (IDLEntity.class.isAssignableFrom(type)) {
            return true;
        }
        if (RmiIdlUtil.isRMIIDLRemoteInterface(type)) {
            return true;
        }
        if (RmiIdlUtil.isRMIIDLExceptionType(type)) {
            return true;
        }
        return RmiIdlUtil.isRMIIDLValueType(type);
    }

    public static boolean isRMIIDLRemoteInterface(Class type) {
        if (!Remote.class.isAssignableFrom(type)) {
            return false;
        }
        Iterator<Method> methodIterator = Arrays.asList(type.getMethods()).iterator();
        while (methodIterator.hasNext()) {
            Method m = methodIterator.next();
            if (!RmiIdlUtil.throwsRemoteException(m)) {
                return false;
            }
            Iterator<Class<?>> it = Arrays.asList(m.getExceptionTypes()).iterator();
            while (it.hasNext()) {
                Class<?> exception = it.next();
                if (RmiIdlUtil.isRMIIDLExceptionType(exception)) continue;
                return false;
            }
        }
        Iterator<Field> fieldIterator = Arrays.asList(type.getFields()).iterator();
        while (fieldIterator.hasNext()) {
            Field f = fieldIterator.next();
            if (f.getType().isPrimitive() || f.getType().equals(class$java$lang$String == null ? RmiIdlUtil.class$("java.lang.String") : class$java$lang$String)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAbstractInterface(Class type) {
        if (!type.isInterface()) {
            return false;
        }
        if (Object.class.isAssignableFrom(type)) {
            return false;
        }
        if (Remote.class.isAssignableFrom(type)) {
            return false;
        }
        Iterator<Method> methodIterator = Arrays.asList(type.getMethods()).iterator();
        while (methodIterator.hasNext()) {
            Method m = methodIterator.next();
            if (RmiIdlUtil.throwsRemoteException(m)) continue;
            return false;
        }
        return true;
    }

    public static boolean isRMIIDLExceptionType(Class type) {
        if (!Throwable.class.isAssignableFrom(type)) {
            return false;
        }
        if (Error.class.isAssignableFrom(type)) {
            return false;
        }
        if (RuntimeException.class.isAssignableFrom(type)) {
            return false;
        }
        return RmiIdlUtil.isRMIIDLValueType(type);
    }

    public static boolean isRMIIDLValueType(Class type) {
        if (Remote.class.isAssignableFrom(type)) {
            return false;
        }
        if (Object.class.isAssignableFrom(type)) {
            return false;
        }
        return type.getDeclaringClass() == null || !RmiIdlUtil.isStatic(type) || RmiIdlUtil.isRMIIDLValueType(type.getDeclaringClass());
    }

    public static boolean isAbstractValueType(Class type) {
        if (!type.isInterface()) {
            return false;
        }
        if (Object.class.isAssignableFrom(type)) {
            return false;
        }
        boolean cannotBeRemote = false;
        boolean cannotBeAbstractInterface = false;
        if (Remote.class.isAssignableFrom(type)) {
            cannotBeAbstractInterface = true;
        } else {
            cannotBeRemote = true;
        }
        Iterator<Method> methodIterator = Arrays.asList(type.getMethods()).iterator();
        block0: while (methodIterator.hasNext()) {
            Method m = methodIterator.next();
            if (!RmiIdlUtil.throwsRemoteException(m)) {
                cannotBeAbstractInterface = true;
                cannotBeRemote = true;
                break;
            }
            Iterator<Class<?>> it = Arrays.asList(m.getExceptionTypes()).iterator();
            while (it.hasNext()) {
                Class<?> exception = it.next();
                if (RmiIdlUtil.isRMIIDLExceptionType(exception)) continue;
                cannotBeRemote = true;
                continue block0;
            }
        }
        if (!cannotBeRemote) {
            Iterator<Field> fieldIterator = Arrays.asList(type.getFields()).iterator();
            while (fieldIterator.hasNext()) {
                Field f = fieldIterator.next();
                if (f.getType().isPrimitive() || f.getType().equals(class$java$lang$String == null ? RmiIdlUtil.class$("java.lang.String") : class$java$lang$String)) continue;
                cannotBeRemote = true;
                break;
            }
        }
        return cannotBeRemote && cannotBeAbstractInterface;
    }

    public static void rethrowIfCorbaSystemException(Exception e) {
        if (e instanceof MarshalException) {
            throw new MARSHAL(e.toString());
        }
        if (e instanceof NoSuchObjectException) {
            throw new OBJECT_NOT_EXIST(e.toString());
        }
        if (e instanceof AccessException) {
            throw new NO_PERMISSION(e.toString());
        }
        if (e instanceof TransactionRequiredException) {
            throw new TRANSACTION_REQUIRED(e.toString());
        }
        if (e instanceof TransactionRolledbackException) {
            throw new TRANSACTION_ROLLEDBACK(e.toString());
        }
        if (e instanceof InvalidTransactionException) {
            throw new INVALID_TRANSACTION(e.toString());
        }
        if (e instanceof SystemException) {
            throw (SystemException)e;
        }
    }
}

