/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.settings;

import java.beans.XMLDecoder;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SettingReader {
    private LinkedHashMap m_Settings = new LinkedHashMap();
    protected static Logger m_Logger = Logger.getLogger(SettingReader.class.getName());

    public void loadSettings(File f) throws IOException {
        this.loadSettings(new FileInputStream(f));
    }

    public void loadSettings(InputStream p_SettingsStream) throws IOException {
        try {
            String line;
            InputStreamReader reader = new InputStreamReader(p_SettingsStream, "UTF-8");
            BufferedReader br = new BufferedReader(reader);
            StringBuilder lines = new StringBuilder();
            while ((line = br.readLine()) != null) {
                lines.append(line).append('\n');
            }
            XMLDecoder l_Decoder = new XMLDecoder(new ByteArrayInputStream(lines.toString().getBytes()));
            try {
                try {
                    LinkedHashMap loadedSettings = (LinkedHashMap)l_Decoder.readObject();
                    for (String pluginName : loadedSettings.keySet()) {
                        this.m_Settings.put(pluginName, loadedSettings.get(pluginName));
                    }
                }
                catch (Exception e) {
                    m_Logger.log(Level.WARNING, "Reading of Settings failed, Settings File not Compatible", e);
                    l_Decoder.close();
                }
            }
            finally {
                l_Decoder.close();
            }
        }
        finally {
            p_SettingsStream.close();
        }
    }

    public Object getValue(String p_PluginName, String p_Key) {
        Object l_Value = null;
        l_Value = ((Hashtable)this.m_Settings.get(p_PluginName)).get(p_Key);
        return l_Value;
    }

    public Collection getLoadedPluginNames() {
        return this.m_Settings.keySet();
    }

    public Collection getKeysForPlugin(String p_PluginName) {
        return ((Hashtable)this.m_Settings.get(p_PluginName)).keySet();
    }

    public static void main(String[] args) {
        SettingReader sr = new SettingReader();
        try {
            sr.loadSettings(new File("settings.xml"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

