/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.settings;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.SocketHandler;
import java.util.logging.XMLFormatter;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import lu.tudor.santec.i18n.Translatrix;
import lu.tudor.santec.settings.SettingEvent;
import lu.tudor.santec.settings.SettingListener;
import lu.tudor.santec.settings.SettingsPlugin;

public class LoggingPlugin
extends SettingsPlugin
implements SettingListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private JCheckBox fileEnabled;
    private JCheckBox fileAppend;
    private JCheckBox consoleEnabled;
    private JCheckBox socketEnabled;
    private JCheckBox showConsoleWindow;
    private JSpinner fileNumber;
    private JSpinner fileSize;
    private JTextField fileName;
    private JTextField socketHost;
    private JSpinner socketPort;
    private JButton chooseFile;
    private JComboBox logLevel;
    private JComboBox fileType;
    private JComboBox socketType;
    private JLabel fileNameLabel;
    private JLabel logLevelLabel;
    private JLabel fileTypeLabel;
    private JLabel fileSizeLabel;
    private JLabel fileNumberLabel;
    private JLabel socketHostLabel;
    private JLabel socketTypeLabel;
    private JLabel socketPortLabel;
    private JFileChooser fileChooser;
    private JPanel filePanel;
    private JPanel consolePanel;
    private JPanel socketPanel;
    private JPanel generalPanel;
    private JPanel windowPanel;
    public static final String NAME = "logging";
    private static Level[] LOGLEVELS = new Level[]{Level.ALL, Level.FINEST, Level.FINER, Level.FINE, Level.CONFIG, Level.INFO, Level.WARNING, Level.SEVERE};
    private static Logger logger = Logger.getLogger("lu.tudor.santec.settings.LoggingPlugin");
    private Console console;
    private Logger generalLogger = Logger.getLogger("");

    public LoggingPlugin() {
        super(NAME);
        this.setIcon(LoggingPlugin.getIconResource("icn_logging"));
        this.setStationaryValues();
        this.buildPanel();
        this.relocalize();
    }

    public LoggingPlugin(String p_Name) {
        super(p_Name);
        this.setIcon(LoggingPlugin.getIconResource("icn_logging"));
        this.setStationaryValues();
        this.buildPanel();
        this.relocalize();
    }

    private void buildPanel() {
        this.initComponents();
        CellConstraints cc = new CellConstraints();
        this.generalPanel = this.createSubPanel(Translatrix.getTranslationString((String)"logging.GeneralSettings"));
        FormLayout generalLayout = new FormLayout("40dlu, 2dlu, 40dlu, 2dlu, 40dlu, 2dlu, 40dlu, 2dlu, pref:grow", "2dlu, pref, 2dlu");
        this.generalPanel.setLayout((LayoutManager)generalLayout);
        this.generalPanel.add((Component)this.logLevelLabel, cc.xy(1, 2));
        this.generalPanel.add((Component)this.logLevel, cc.xyw(3, 2, 3));
        this.addSubPanel(this.generalPanel);
        this.consolePanel = this.createSubPanel(Translatrix.getTranslationString((String)"logging.LogToConsole"));
        FormLayout consoleLayout = new FormLayout("40dlu, 2dlu, 40dlu, 2dlu, 40dlu, 2dlu, 25dlu, 2dlu, pref:grow", "pref, 2dlu");
        this.consolePanel.setLayout((LayoutManager)consoleLayout);
        this.consolePanel.add((Component)this.consoleEnabled, cc.xyw(1, 1, 3));
        this.addSubPanel(this.consolePanel);
        this.windowPanel = this.createSubPanel(Translatrix.getTranslationString((String)"logging.LogToWindow"));
        FormLayout windowLayout = new FormLayout("40dlu, 2dlu, 40dlu, 2dlu, 40dlu, 2dlu, 25dlu, 2dlu, pref:grow", "pref, 2dlu");
        this.windowPanel.setLayout((LayoutManager)windowLayout);
        this.windowPanel.add((Component)this.showConsoleWindow, cc.xyw(1, 1, 5));
        this.addSubPanel(this.windowPanel);
        this.filePanel = this.createSubPanel(Translatrix.getTranslationString((String)"logging.LogToFile"));
        FormLayout fileLayout = new FormLayout("40dlu, 2dlu, 40dlu, 2dlu, 40dlu, 2dlu, 25dlu, 2dlu, pref:grow", "pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu");
        this.filePanel.setLayout((LayoutManager)fileLayout);
        JPanel fileChooserPanel = new JPanel(new BorderLayout());
        fileChooserPanel.add((Component)this.fileName, "Center");
        fileChooserPanel.add((Component)this.chooseFile, "East");
        this.filePanel.add((Component)this.fileEnabled, cc.xyw(1, 1, 3));
        this.filePanel.add((Component)this.fileNameLabel, cc.xy(1, 3));
        this.filePanel.add((Component)fileChooserPanel, cc.xyw(3, 3, 7));
        this.filePanel.add((Component)this.fileTypeLabel, cc.xy(1, 5));
        this.filePanel.add((Component)this.fileType, cc.xyw(3, 5, 3));
        this.filePanel.add((Component)this.fileAppend, cc.xyw(6, 5, 4));
        this.filePanel.add((Component)this.fileNumberLabel, cc.xy(1, 7));
        this.filePanel.add((Component)this.fileNumber, cc.xy(3, 7));
        this.filePanel.add((Component)this.fileSizeLabel, cc.xy(5, 7));
        this.filePanel.add((Component)this.fileSize, cc.xy(7, 7));
        this.addSubPanel(this.filePanel);
        this.socketPanel = this.createSubPanel(Translatrix.getTranslationString((String)"logging.LogToLoggingHost"));
        FormLayout socketLayout = new FormLayout("40dlu, 2dlu, 40dlu, 2dlu, 40dlu, 2dlu, 25dlu, 2dlu, pref:grow", "pref, 2dlu, pref, 2dlu,pref, 2dlu");
        this.socketPanel.setLayout((LayoutManager)socketLayout);
        this.socketPanel.add((Component)this.socketEnabled, cc.xyw(1, 1, 3));
        this.socketPanel.add((Component)this.socketHostLabel, cc.xy(1, 3));
        this.socketPanel.add((Component)this.socketHost, cc.xyw(3, 3, 3));
        this.socketPanel.add((Component)this.socketPortLabel, cc.xy(7, 3));
        this.socketPanel.add((Component)this.socketPort, cc.xy(9, 3));
        this.socketPanel.add((Component)this.socketTypeLabel, cc.xy(1, 5));
        this.socketPanel.add((Component)this.socketType, cc.xyw(3, 5, 3));
        this.addSubPanel(this.socketPanel);
    }

    private void initComponents() {
        this.logLevelLabel = new JLabel();
        this.logLevel = new JComboBox<Level>(LOGLEVELS);
        this.consoleEnabled = new JCheckBox();
        this.showConsoleWindow = new JCheckBox();
        this.showConsoleWindow.addActionListener(this);
        this.fileEnabled = new JCheckBox();
        this.chooseFile = new JButton(new AbstractAction("..."){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                LoggingPlugin.this.fileChooser = new JFileChooser();
                LoggingPlugin.this.fileChooser.showOpenDialog(LoggingPlugin.this.getParent());
                if (LoggingPlugin.this.fileChooser.getSelectedFile() != null) {
                    LoggingPlugin.this.fileName.setText(LoggingPlugin.this.fileChooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
        this.fileNameLabel = new JLabel();
        this.fileName = new JTextField();
        this.fileTypeLabel = new JLabel();
        Formatter[] formatters = new Formatter[]{new SimpleFormatter(), new XMLFormatter()};
        this.fileType = new JComboBox<Formatter>(formatters);
        this.fileType.setRenderer(new FormatterComboBoxRenderer());
        this.fileAppend = new JCheckBox();
        this.fileNumberLabel = new JLabel();
        this.fileNumber = new JSpinner(new SpinnerNumberModel(1, 1, 20, 1));
        this.fileSizeLabel = new JLabel();
        this.fileSize = new JSpinner(new SpinnerNumberModel(1, 1, 20, 1));
        this.socketEnabled = new JCheckBox();
        this.socketTypeLabel = new JLabel();
        this.socketType = new JComboBox<Formatter>(formatters);
        this.socketType.setRenderer(new FormatterComboBoxRenderer());
        this.socketHostLabel = new JLabel();
        this.socketHost = new JTextField();
        this.socketPortLabel = new JLabel();
        this.socketPort = new JSpinner(new SpinnerNumberModel(5104, 1024, 65535, 1));
    }

    public void setStationaryValues() {
        this.setStationary("LogLevel", new Integer(6));
        this.setStationary("ConsoleEnabled", new Boolean(true));
        this.setStationary("FileEnabled", new Boolean(false));
        this.setStationary("FileName", "");
        this.setStationary("FileType", new Integer(0));
        this.setStationary("FileNumber", new Integer(1));
        this.setStationary("FileSize", new Integer(1));
        this.setStationary("FileAppend", new Boolean(false));
        this.setStationary("SocketEnabled", new Boolean(false));
        this.setStationary("SocketType", new Integer(0));
        this.setStationary("SocketHost", "localhost");
        this.setStationary("SocketPort", new Integer(1234));
    }

    public void revertToDefaults() {
        this.logLevel.setSelectedIndex((Integer)this.getDefault("LogLevel"));
        this.consoleEnabled.setSelected((Boolean)this.getDefault("ConsoleEnabled"));
        this.fileEnabled.setSelected((Boolean)this.getDefault("FileEnabled"));
        this.fileName.setText((String)this.getDefault("FileName"));
        this.fileType.setSelectedIndex((Integer)this.getDefault("FileType"));
        this.fileNumber.setValue(this.getDefault("FileNumber"));
        this.fileSize.setValue(this.getDefault("FileSize"));
        this.fileAppend.setSelected((Boolean)this.getDefault("FileAppend"));
        this.socketEnabled.setSelected((Boolean)this.getDefault("SocketEnabled"));
        this.socketType.setSelectedIndex((Integer)this.getDefault("SocketType"));
        this.socketHost.setText((String)this.getDefault("SocketHost"));
        this.socketPort.setValue((Integer)this.getDefault("SocketPort"));
        this.reflectSettings();
        super.revertToDefaults();
    }

    public void updateSettings() {
        this.setValue("LogLevel", new Integer(this.logLevel.getSelectedIndex()));
        this.setValue("ConsoleEnabled", new Boolean(this.consoleEnabled.isSelected()));
        this.setValue("FileEnabled", new Boolean(this.fileEnabled.isSelected()));
        this.setValue("FileName", new String(this.fileName.getText()));
        this.setValue("FileType", new Integer(this.fileType.getSelectedIndex()));
        this.setValue("FileNumber", (Integer)this.fileNumber.getValue());
        this.setValue("FileSize", (Integer)this.fileSize.getValue());
        this.setValue("FileAppend", new Boolean(this.fileAppend.isSelected()));
        this.setValue("SocketEnabled", new Boolean(this.socketEnabled.isSelected()));
        this.setValue("SocketType", new Integer(this.socketType.getSelectedIndex()));
        this.setValue("SocketHost", new String(this.socketHost.getText()));
        this.setValue("SocketPort", (Integer)this.socketPort.getValue());
        super.updateSettings();
    }

    public void reflectSettings() {
        super.reflectSettings();
        try {
            this.logLevel.setSelectedIndex((Integer)this.getValue("LogLevel"));
            this.consoleEnabled.setSelected((Boolean)this.getValue("ConsoleEnabled"));
            this.fileEnabled.setSelected((Boolean)this.getValue("FileEnabled"));
            this.fileName.setText((String)this.getValue("FileName"));
            this.fileType.setSelectedIndex((Integer)this.getValue("FileType"));
            this.fileNumber.setValue(this.getValue("FileNumber"));
            this.fileSize.setValue(this.getValue("FileSize"));
            this.fileAppend.setSelected((Boolean)this.getValue("FileAppend"));
            this.socketEnabled.setSelected((Boolean)this.getValue("SocketEnabled"));
            this.socketType.setSelectedIndex((Integer)this.getValue("SocketType"));
            this.socketHost.setText((String)this.getValue("SocketHost"));
            this.socketPort.setValue((Integer)this.getValue("SocketPort"));
            this.updateLoggers();
        }
        catch (Exception e) {
            System.err.println("Could not load settings");
            e.printStackTrace();
        }
    }

    public void updateLoggers() {
        Handler[] handlers = this.generalLogger.getHandlers();
        int i = 0;
        while (i < handlers.length) {
            this.generalLogger.removeHandler(handlers[i]);
            ++i;
        }
        this.generalLogger.setLevel((Level)this.logLevel.getSelectedItem());
        logger.info("LogLevel set to: " + this.logLevel.getSelectedItem());
        try {
            if (this.consoleEnabled.isSelected()) {
                ConsoleHandler ch = new ConsoleHandler();
                this.generalLogger.addHandler(ch);
                logger.info("Added logging to console");
            }
        }
        catch (Exception e) {
            System.err.println("Could not create console logger: " + e.getLocalizedMessage());
            logger.warning("Could not create console logger: " + e.getLocalizedMessage());
        }
        try {
            if (this.fileEnabled.isSelected()) {
                FileHandler fh = new FileHandler(this.fileName.getText(), (Integer)this.fileSize.getValue() * 1024 * 1024, (int)((Integer)this.fileNumber.getValue()), this.fileAppend.isSelected());
                fh.setFormatter((Formatter)this.fileType.getSelectedItem());
                this.generalLogger.addHandler(fh);
                logger.info("Added logging to file: " + this.fileName.getText());
            }
        }
        catch (Exception e) {
            System.err.println("Could not create file logger: " + e.getLocalizedMessage());
            logger.warning("Could not create file logger: " + e.getLocalizedMessage());
        }
        try {
            if (this.socketEnabled.isSelected()) {
                SocketHandler sh = new SocketHandler(this.socketHost.getText(), (Integer)this.socketPort.getValue());
                this.generalLogger.addHandler(sh);
                sh.setFormatter((Formatter)this.fileType.getSelectedItem());
                logger.info("Added logging to socket: " + this.socketHost.getText() + ":" + this.socketPort.getValue());
            }
        }
        catch (Exception e) {
            System.err.println("Could not create socket logger: " + e.getLocalizedMessage());
            logger.warning("Could not create socket logger: " + e.getLocalizedMessage());
        }
    }

    public void relocalize() {
        this.setLabel(Translatrix.getTranslationString((String)"logging.Logging"));
        this.setSubPanelTitle(this.generalPanel, Translatrix.getTranslationString((String)"logging.GeneralSettings"));
        this.logLevelLabel.setText(Translatrix.getTranslationString((String)"logging.LogLevel"));
        this.consoleEnabled.setText(Translatrix.getTranslationString((String)"logging.Enable"));
        this.setSubPanelTitle(this.consolePanel, Translatrix.getTranslationString((String)"logging.LogToConsole"));
        this.consoleEnabled.setText(Translatrix.getTranslationString((String)"logging.Enable"));
        this.setSubPanelTitle(this.windowPanel, Translatrix.getTranslationString((String)"logging.LogToWindow"));
        this.showConsoleWindow.setText(Translatrix.getTranslationString((String)"logging.Enable"));
        this.setSubPanelTitle(this.filePanel, Translatrix.getTranslationString((String)"logging.LogToFile"));
        this.fileEnabled.setText(Translatrix.getTranslationString((String)"logging.Enable"));
        this.fileNameLabel.setText(Translatrix.getTranslationString((String)"logging.LogFile"));
        this.fileTypeLabel.setText(Translatrix.getTranslationString((String)"logging.Type"));
        this.fileAppend.setText(Translatrix.getTranslationString((String)"logging.Append"));
        this.fileNumberLabel.setText(Translatrix.getTranslationString((String)"logging.FileNr"));
        this.fileSizeLabel.setText(Translatrix.getTranslationString((String)"logging.FileSize"));
        this.setSubPanelTitle(this.socketPanel, Translatrix.getTranslationString((String)"logging.LogToLoggingHost"));
        this.socketEnabled.setText(Translatrix.getTranslationString((String)"logging.Enable"));
        this.socketTypeLabel.setText(Translatrix.getTranslationString((String)"logging.Type"));
        this.socketHostLabel.setText(Translatrix.getTranslationString((String)"logging.Host"));
        this.socketPortLabel.setText(Translatrix.getTranslationString((String)"logging.Port"));
    }

    public void settingChanged(SettingEvent p_Event) {
        if (p_Event.getPluginName().equals(this.getName())) {
            this.updateLoggers();
        }
    }

    public void pluginAdded() {
        this.m_Owner.addSettingListener(this);
    }

    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource().equals(this.showConsoleWindow)) {
            if (this.showConsoleWindow.isSelected()) {
                try {
                    this.console = new Console();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else if (this.console != null) {
                this.console.stop();
            }
        }
    }

    public class Console
    extends JFrame {
        private static final long serialVersionUID = 1L;
        PipedInputStream piOut;
        PipedInputStream piErr;
        PipedOutputStream poOut;
        PipedOutputStream poErr;
        JTextArea textArea;
        PrintStream oldOut;
        PrintStream oldErr;
        private ConsoleHandler console2window;

        public Console() throws IOException {
            super("Logging Window");
            this.textArea = new JTextArea();
            this.setIconImage(LoggingPlugin.getIconResource("icn_logging").getImage());
            this.oldOut = System.out;
            this.oldErr = System.err;
            this.piOut = new PipedInputStream();
            this.poOut = new PipedOutputStream(this.piOut);
            System.setOut(new PrintStream(this.poOut, true));
            this.piErr = new PipedInputStream();
            this.poErr = new PipedOutputStream(this.piErr);
            System.setErr(new PrintStream(this.poErr, true));
            this.console2window = new ConsoleHandler();
            LoggingPlugin.this.generalLogger.addHandler(this.console2window);
            this.textArea.setEditable(false);
            this.textArea.setRows(20);
            this.textArea.setColumns(50);
            this.getContentPane().add((Component)new JScrollPane(this.textArea), "Center");
            this.pack();
            this.setVisible(true);
            new ReaderThread(this.piOut).start();
            new ReaderThread(this.piErr).start();
            System.out.println("Testing System.out");
            System.err.println("Testing System.err");
            logger.warning("Testing logging to Logwindow");
        }

        public void stop() {
            System.setOut(this.oldOut);
            System.setErr(this.oldErr);
            Logger.getLogger("").removeHandler(this.console2window);
            this.dispose();
        }

        class ReaderThread
        extends Thread {
            PipedInputStream pi;

            ReaderThread(PipedInputStream pi) {
                this.pi = pi;
            }

            public void run() {
                final byte[] buf = new byte[1024];
                try {
                    int len;
                    while ((len = this.pi.read(buf)) != -1) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                ((ReaderThread)ReaderThread.this).Console.this.textArea.append(new String(buf, 0, len));
                                ((ReaderThread)ReaderThread.this).Console.this.textArea.setCaretPosition(((ReaderThread)ReaderThread.this).Console.this.textArea.getDocument().getLength());
                                int idealSize = 1000;
                                int maxExcess = 500;
                                int excess = ((ReaderThread)ReaderThread.this).Console.this.textArea.getDocument().getLength() - idealSize;
                                if (excess >= maxExcess) {
                                    ((ReaderThread)ReaderThread.this).Console.this.textArea.replaceRange("", 0, excess);
                                }
                            }
                        });
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public class FormatterComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;

        public FormatterComboBoxRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            try {
                this.setText(" " + value.getClass().getName().substring(value.getClass().getName().lastIndexOf(".") + 1));
            }
            catch (Exception e) {
                this.setText("");
            }
            return this;
        }
    }
}

