/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.data;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.dcm4che2.data.DateRange;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.DicomObjectToStringParam;
import org.dcm4che2.data.SpecificCharacterSet;
import org.dcm4che2.data.VR;

public class DicomObjects {
    private DicomObjects() {
    }

    public static DicomObject unmodifiableDicomObject(DicomObject dcmobj) {
        return dcmobj instanceof UnmodifiableDicomObject ? dcmobj : new UnmodifiableDicomObject(dcmobj);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UnmodifiabledIterator
    implements Iterator<DicomElement> {
        private final Iterator<DicomElement> itr;

        public UnmodifiabledIterator(Iterator<DicomElement> itr) {
            if (itr == null) {
                throw new NullPointerException();
            }
            this.itr = itr;
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        @Override
        public DicomElement next() {
            return new UnmodifiableDicomElement(this.itr.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class UnmodifiableDicomElement
    implements DicomElement {
        private static final long serialVersionUID = -5205393560442114448L;
        private final DicomElement e;

        public UnmodifiableDicomElement(DicomElement e) {
            if (e == null) {
                throw new NullPointerException();
            }
            this.e = e;
        }

        public DicomObject addDicomObject(DicomObject item) {
            throw new UnsupportedOperationException();
        }

        public DicomObject addDicomObject(int index, DicomObject item) {
            throw new UnsupportedOperationException();
        }

        public byte[] addFragment(byte[] b) {
            throw new UnsupportedOperationException();
        }

        public byte[] addFragment(int index, byte[] b) {
            throw new UnsupportedOperationException();
        }

        public boolean bigEndian() {
            return this.e.bigEndian();
        }

        public DicomElement bigEndian(boolean bigEndian) {
            if (this.e.bigEndian() == bigEndian || this.e.isEmpty()) {
                return this;
            }
            throw new UnsupportedOperationException();
        }

        public int countItems() {
            return this.e.countItems();
        }

        public DicomElement filterItems(DicomObject filter) {
            DicomElement filteredItems = this.e.filterItems(filter);
            return filteredItems != this ? new UnmodifiableDicomElement(filteredItems) : this;
        }

        public byte[] getBytes() {
            return this.e.getBytes();
        }

        public Date getDate(boolean cache) {
            return this.e.getDate(cache);
        }

        public DateRange getDateRange(boolean cache) {
            return this.e.getDateRange(cache);
        }

        public Date[] getDates(boolean cache) {
            return this.e.getDates(cache);
        }

        public DicomObject getDicomObject() {
            DicomObject item = this.e.getDicomObject();
            return item != null ? new UnmodifiableDicomObject(item) : null;
        }

        public DicomObject getDicomObject(int index) {
            return new UnmodifiableDicomObject(this.e.getDicomObject(index));
        }

        public double getDouble(boolean cache) {
            return this.e.getDouble(cache);
        }

        public double[] getDoubles(boolean cache) {
            return this.e.getDoubles(cache);
        }

        public float getFloat(boolean cache) {
            return this.e.getFloat(cache);
        }

        public float[] getFloats(boolean cache) {
            return this.e.getFloats(cache);
        }

        public byte[] getFragment(int index) {
            return this.e.getFragment(index);
        }

        public int getInt(boolean cache) {
            return this.e.getInt(cache);
        }

        public int[] getInts(boolean cache) {
            return this.e.getInts(cache);
        }

        public Pattern getPattern(SpecificCharacterSet cs, boolean ignoreCase, boolean cache) {
            return this.e.getPattern(cs, ignoreCase, cache);
        }

        public short[] getShorts(boolean cache) {
            return this.e.getShorts(cache);
        }

        public String getString(SpecificCharacterSet cs, boolean cache) {
            return this.e.getString(cs, cache);
        }

        public String[] getStrings(SpecificCharacterSet cs, boolean cache) {
            return this.e.getStrings(cs, cache);
        }

        public boolean hasDicomObjects() {
            return this.e.hasDicomObjects();
        }

        public boolean hasFragments() {
            return this.e.hasFragments();
        }

        public boolean hasItems() {
            return this.e.hasItems();
        }

        public boolean isEmpty() {
            return this.e.isEmpty();
        }

        public int length() {
            return this.e.length();
        }

        public boolean removeDicomObject(DicomObject item) {
            throw new UnsupportedOperationException();
        }

        public DicomObject removeDicomObject(int index) {
            throw new UnsupportedOperationException();
        }

        public boolean removeFragment(byte[] b) {
            throw new UnsupportedOperationException();
        }

        public byte[] removeFragment(int index) {
            throw new UnsupportedOperationException();
        }

        public DicomObject setDicomObject(int index, DicomObject item) {
            throw new UnsupportedOperationException();
        }

        public byte[] setFragment(int index, byte[] b) {
            throw new UnsupportedOperationException();
        }

        public DicomElement share() {
            return this.e.share();
        }

        public int tag() {
            return this.e.tag();
        }

        public StringBuffer toStringBuffer(StringBuffer sb, int maxValLen) {
            return this.e.toStringBuffer(sb, maxValLen);
        }

        public int vm(SpecificCharacterSet cs) {
            return this.e.vm(cs);
        }

        public VR vr() {
            return this.e.vr();
        }

        public String getValueAsString(SpecificCharacterSet cs, int truncate) {
            return this.e.getValueAsString(cs, truncate);
        }
    }

    static class UnmodifiableVisitor
    implements DicomObject.Visitor {
        private final DicomObject.Visitor visitor;

        public UnmodifiableVisitor(DicomObject.Visitor visitor) {
            if (visitor == null) {
                throw new NullPointerException();
            }
            this.visitor = visitor;
        }

        public boolean visit(DicomElement e) {
            return this.visitor.visit(new UnmodifiableDicomElement(e));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UnmodifiableDicomObject
    implements DicomObject {
        private static final long serialVersionUID = 4384087053472506817L;
        private final DicomObject dcmobj;

        public UnmodifiableDicomObject(DicomObject dcmobj) {
            if (dcmobj == null) {
                throw new NullPointerException();
            }
            this.dcmobj = dcmobj;
        }

        public String toString() {
            return this.dcmobj.toString();
        }

        public int hashCode() {
            return this.dcmobj.hashCode();
        }

        public boolean equals(Object other) {
            return this.dcmobj.equals(other);
        }

        @Override
        public boolean accept(DicomObject.Visitor visitor) {
            return this.dcmobj.accept(new UnmodifiableVisitor(visitor));
        }

        @Override
        public void add(DicomElement attr) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean bigEndian() {
            return this.dcmobj.bigEndian();
        }

        @Override
        public void bigEndian(boolean bigEndian) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean cacheGet() {
            return this.dcmobj.cacheGet();
        }

        @Override
        public void cacheGet(boolean cacheGet) {
            this.dcmobj.cacheGet(cacheGet);
        }

        @Override
        public boolean cachePut() {
            return this.dcmobj.cachePut();
        }

        @Override
        public void cachePut(boolean cachePut) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public DicomObject command() {
            return new UnmodifiableDicomObject(this.dcmobj.command());
        }

        @Override
        public Iterator<DicomElement> commandIterator() {
            return new UnmodifiabledIterator(this.dcmobj.commandIterator());
        }

        @Override
        public boolean contains(int tag) {
            return this.dcmobj.contains(tag);
        }

        @Override
        public boolean containsAll(DicomObject keys) {
            return this.dcmobj.containsAll(keys);
        }

        @Override
        public boolean containsValue(int tag) {
            return this.dcmobj.containsValue(tag);
        }

        @Override
        public void copyTo(DicomObject destination) {
            this.dcmobj.copyTo(destination);
        }

        @Override
        public void copyTo(DicomObject destination, boolean resolveDestinationPrivateTags) {
            this.dcmobj.copyTo(destination, resolveDestinationPrivateTags);
        }

        @Override
        public DicomObject dataset() {
            return new UnmodifiableDicomObject(this.dcmobj.dataset());
        }

        @Override
        public Iterator<DicomElement> datasetIterator() {
            return new UnmodifiabledIterator(this.dcmobj.datasetIterator());
        }

        @Override
        public DicomObject exclude(int[] tags) {
            return new UnmodifiableDicomObject(this.dcmobj.exclude(tags));
        }

        @Override
        public DicomObject excludePrivate() {
            return new UnmodifiableDicomObject(this.dcmobj.excludePrivate());
        }

        @Override
        public DicomObject fileMetaInfo() {
            return new UnmodifiableDicomObject(this.dcmobj.fileMetaInfo());
        }

        @Override
        public Iterator<DicomElement> fileMetaInfoIterator() {
            return new UnmodifiabledIterator(this.dcmobj.fileMetaInfoIterator());
        }

        @Override
        public DicomElement get(int tag) {
            DicomElement e = this.dcmobj.get(tag);
            return e != null ? new UnmodifiableDicomElement(e) : null;
        }

        @Override
        public DicomElement get(int tag, VR vr) {
            DicomElement e = this.dcmobj.get(tag, vr);
            return e != null ? new UnmodifiableDicomElement(e) : null;
        }

        @Override
        public DicomElement get(int[] tagPath) {
            DicomElement e = this.dcmobj.get(tagPath);
            return e != null ? new UnmodifiableDicomElement(e) : null;
        }

        @Override
        public DicomElement get(int[] tagPath, VR vr) {
            DicomElement e = this.dcmobj.get(tagPath, vr);
            return e != null ? new UnmodifiableDicomElement(e) : null;
        }

        @Override
        public byte[] getBytes(int tag, boolean bigEndian) {
            return this.dcmobj.getBytes(tag, bigEndian);
        }

        @Override
        public byte[] getBytes(int tag) {
            return this.dcmobj.getBytes(tag);
        }

        @Override
        public byte[] getBytes(int[] tagPath, boolean bigEndian) {
            return this.dcmobj.getBytes(tagPath, bigEndian);
        }

        @Override
        public byte[] getBytes(int[] tagPath) {
            return this.dcmobj.getBytes(tagPath);
        }

        @Override
        public Date getDate(int tag, Date defVal) {
            return this.dcmobj.getDate(tag, defVal);
        }

        @Override
        public Date getDate(int tag, VR vr, Date defVal) {
            return this.dcmobj.getDate(tag, vr, defVal);
        }

        @Override
        public Date getDate(int daTag, int tmTag, Date defVal) {
            return this.dcmobj.getDate(daTag, tmTag, defVal);
        }

        @Override
        public Date getDate(int daTag, int tmTag) {
            return this.dcmobj.getDate(daTag, tmTag);
        }

        @Override
        public Date getDate(int tag) {
            return this.dcmobj.getDate(tag);
        }

        @Override
        public Date getDate(int tag, VR vr) {
            return this.dcmobj.getDate(tag, vr);
        }

        @Override
        public Date getDate(int[] tagPath, Date defVal) {
            return this.dcmobj.getDate(tagPath, defVal);
        }

        @Override
        public Date getDate(int[] tagPath, VR vr, Date defVal) {
            return this.dcmobj.getDate(tagPath, vr, defVal);
        }

        @Override
        public Date getDate(int[] itemPath, int daTag, int tmTag, Date defVal) {
            return this.dcmobj.getDate(itemPath, daTag, tmTag, defVal);
        }

        @Override
        public Date getDate(int[] itemPath, int daTag, int tmTag) {
            return this.dcmobj.getDate(itemPath, daTag, tmTag);
        }

        @Override
        public Date getDate(int[] tagPath) {
            return this.dcmobj.getDate(tagPath);
        }

        @Override
        public Date getDate(int[] tagPath, VR vr) {
            return this.dcmobj.getDate(tagPath, vr);
        }

        @Override
        public DateRange getDateRange(int tag, DateRange defVal) {
            return this.dcmobj.getDateRange(tag, defVal);
        }

        @Override
        public DateRange getDateRange(int tag, VR vr, DateRange defVal) {
            return this.dcmobj.getDateRange(tag, vr, defVal);
        }

        @Override
        public DateRange getDateRange(int daTag, int tmTag, DateRange defVal) {
            return this.dcmobj.getDateRange(daTag, tmTag, defVal);
        }

        @Override
        public DateRange getDateRange(int daTag, int tmTag) {
            return this.dcmobj.getDateRange(daTag, tmTag);
        }

        @Override
        public DateRange getDateRange(int tag) {
            return this.dcmobj.getDateRange(tag);
        }

        @Override
        public DateRange getDateRange(int tag, VR vr) {
            return this.dcmobj.getDateRange(tag, vr);
        }

        @Override
        public DateRange getDateRange(int[] tagPath, DateRange defVal) {
            return this.dcmobj.getDateRange(tagPath, defVal);
        }

        @Override
        public DateRange getDateRange(int[] tagPath, VR vr, DateRange defVal) {
            return this.dcmobj.getDateRange(tagPath, vr, defVal);
        }

        @Override
        public DateRange getDateRange(int[] itemPath, int daTag, int tmTag, DateRange defVal) {
            return this.dcmobj.getDateRange(itemPath, daTag, tmTag, defVal);
        }

        @Override
        public DateRange getDateRange(int[] itemPath, int daTag, int tmTag) {
            return this.dcmobj.getDateRange(itemPath, daTag, tmTag);
        }

        @Override
        public DateRange getDateRange(int[] tagPath) {
            return this.dcmobj.getDateRange(tagPath);
        }

        @Override
        public DateRange getDateRange(int[] tagPath, VR vr) {
            return this.dcmobj.getDateRange(tagPath, vr);
        }

        @Override
        public Date[] getDates(int tag, Date[] defVal) {
            return this.dcmobj.getDates(tag, defVal);
        }

        @Override
        public Date[] getDates(int tag, VR vr, Date[] defVal) {
            return this.dcmobj.getDates(tag, vr, defVal);
        }

        @Override
        public Date[] getDates(int daTag, int tmTag, Date[] defVal) {
            return this.dcmobj.getDates(daTag, tmTag, defVal);
        }

        @Override
        public Date[] getDates(int daTag, int tmTag) {
            return this.dcmobj.getDates(daTag, tmTag);
        }

        @Override
        public Date[] getDates(int tag) {
            return this.dcmobj.getDates(tag);
        }

        @Override
        public Date[] getDates(int tag, VR vr) {
            return this.dcmobj.getDates(tag, vr);
        }

        @Override
        public Date[] getDates(int[] tagPath, Date[] defVal) {
            return this.dcmobj.getDates(tagPath, defVal);
        }

        @Override
        public Date[] getDates(int[] tagPath, VR vr, Date[] defVal) {
            return this.dcmobj.getDates(tagPath, vr, defVal);
        }

        @Override
        public Date[] getDates(int[] itemPath, int daTag, int tmTag, Date[] defVal) {
            return this.dcmobj.getDates(itemPath, daTag, tmTag, defVal);
        }

        @Override
        public Date[] getDates(int[] itemPath, int daTag, int tmTag) {
            return this.dcmobj.getDates(itemPath, daTag, tmTag);
        }

        @Override
        public Date[] getDates(int[] tagPath) {
            return this.dcmobj.getDates(tagPath);
        }

        @Override
        public Date[] getDates(int[] tagPath, VR vr) {
            return this.dcmobj.getDates(tagPath, vr);
        }

        @Override
        public double getDouble(int tag, double defVal) {
            return this.dcmobj.getDouble(tag, defVal);
        }

        @Override
        public double getDouble(int tag, VR vr, double defVal) {
            return this.dcmobj.getDouble(tag, vr, defVal);
        }

        @Override
        public double getDouble(int tag) {
            return this.dcmobj.getDouble(tag);
        }

        @Override
        public double getDouble(int tag, VR vr) {
            return this.dcmobj.getDouble(tag, vr);
        }

        @Override
        public double getDouble(int[] tagPath, double defVal) {
            return this.dcmobj.getDouble(tagPath, defVal);
        }

        @Override
        public double getDouble(int[] tagPath, VR vr, double defVal) {
            return this.dcmobj.getDouble(tagPath, vr, defVal);
        }

        @Override
        public double getDouble(int[] tagPath) {
            return this.dcmobj.getDouble(tagPath);
        }

        @Override
        public double getDouble(int[] tagPath, VR vr) {
            return this.dcmobj.getDouble(tagPath, vr);
        }

        @Override
        public double[] getDoubles(int tag, double[] defVal) {
            return this.dcmobj.getDoubles(tag, defVal);
        }

        @Override
        public double[] getDoubles(int tag, VR vr, double[] defVal) {
            return this.dcmobj.getDoubles(tag, vr, defVal);
        }

        @Override
        public double[] getDoubles(int tag) {
            return this.dcmobj.getDoubles(tag);
        }

        @Override
        public double[] getDoubles(int tag, VR vr) {
            return this.dcmobj.getDoubles(tag, vr);
        }

        @Override
        public double[] getDoubles(int[] tagPath, double[] defVal) {
            return this.dcmobj.getDoubles(tagPath, defVal);
        }

        @Override
        public double[] getDoubles(int[] tagPath, VR vr, double[] defVal) {
            return this.dcmobj.getDoubles(tagPath, vr, defVal);
        }

        @Override
        public double[] getDoubles(int[] tagPath) {
            return this.dcmobj.getDoubles(tagPath);
        }

        @Override
        public double[] getDoubles(int[] tagPath, VR vr) {
            return this.dcmobj.getDoubles(tagPath, vr);
        }

        @Override
        public float getFloat(int tag, float defVal) {
            return this.dcmobj.getFloat(tag, defVal);
        }

        @Override
        public float getFloat(int tag, VR vr, float defVal) {
            return this.dcmobj.getFloat(tag, vr, defVal);
        }

        @Override
        public float getFloat(int tag) {
            return this.dcmobj.getFloat(tag);
        }

        @Override
        public float getFloat(int tag, VR vr) {
            return this.dcmobj.getFloat(tag, vr);
        }

        @Override
        public float getFloat(int[] tagPath, float defVal) {
            return this.dcmobj.getFloat(tagPath, defVal);
        }

        @Override
        public float getFloat(int[] tagPath, VR vr, float defVal) {
            return this.dcmobj.getFloat(tagPath, vr, defVal);
        }

        @Override
        public float getFloat(int[] tagPath) {
            return this.dcmobj.getFloat(tagPath);
        }

        @Override
        public float getFloat(int[] tagPath, VR vr) {
            return this.dcmobj.getFloat(tagPath, vr);
        }

        @Override
        public float[] getFloats(int tag, float[] defVal) {
            return this.dcmobj.getFloats(tag, defVal);
        }

        @Override
        public float[] getFloats(int tag, VR vr, float[] defVal) {
            return this.dcmobj.getFloats(tag, vr, defVal);
        }

        @Override
        public float[] getFloats(int tag) {
            return this.dcmobj.getFloats(tag);
        }

        @Override
        public float[] getFloats(int tag, VR vr) {
            return this.dcmobj.getFloats(tag, vr);
        }

        @Override
        public float[] getFloats(int[] tagPath, float[] defVal) {
            return this.dcmobj.getFloats(tagPath, defVal);
        }

        @Override
        public float[] getFloats(int[] tagPath, VR vr, float[] defVal) {
            return this.dcmobj.getFloats(tagPath, vr, defVal);
        }

        @Override
        public float[] getFloats(int[] tagPath) {
            return this.dcmobj.getFloats(tagPath);
        }

        @Override
        public float[] getFloats(int[] tagPath, VR vr) {
            return this.dcmobj.getFloats(tagPath, vr);
        }

        @Override
        public int getInt(int tag, int defVal) {
            return this.dcmobj.getInt(tag, defVal);
        }

        @Override
        public int getInt(int tag, VR vr, int defVal) {
            return this.dcmobj.getInt(tag, vr, defVal);
        }

        @Override
        public int getInt(int tag) {
            return this.dcmobj.getInt(tag);
        }

        @Override
        public int getInt(int tag, VR vr) {
            return this.dcmobj.getInt(tag, vr);
        }

        @Override
        public int getInt(int[] tagPath, int defVal) {
            return this.dcmobj.getInt(tagPath, defVal);
        }

        @Override
        public int getInt(int[] tagPath, VR vr, int defVal) {
            return this.dcmobj.getInt(tagPath, vr, defVal);
        }

        @Override
        public int getInt(int[] tagPath) {
            return this.dcmobj.getInt(tagPath);
        }

        @Override
        public int getInt(int[] tagPath, VR vr) {
            return this.dcmobj.getInt(tagPath, vr);
        }

        @Override
        public int[] getInts(int tag, int[] defVal) {
            return this.dcmobj.getInts(tag, defVal);
        }

        @Override
        public int[] getInts(int tag, VR vr, int[] defVal) {
            return this.dcmobj.getInts(tag, vr, defVal);
        }

        @Override
        public int[] getInts(int tag) {
            return this.dcmobj.getInts(tag);
        }

        @Override
        public int[] getInts(int tag, VR vr) {
            return this.dcmobj.getInts(tag, vr);
        }

        @Override
        public int[] getInts(int[] tagPath, int[] defVal) {
            return this.dcmobj.getInts(tagPath, defVal);
        }

        @Override
        public int[] getInts(int[] tagPath, VR vr, int[] defVal) {
            return this.dcmobj.getInts(tagPath, vr, defVal);
        }

        @Override
        public int[] getInts(int[] tagPath) {
            return this.dcmobj.getInts(tagPath);
        }

        @Override
        public int[] getInts(int[] tagPath, VR vr) {
            return this.dcmobj.getInts(tagPath, vr);
        }

        @Override
        public long getItemOffset() {
            return this.dcmobj.getItemOffset();
        }

        @Override
        public int getItemPosition() {
            return this.dcmobj.getItemPosition();
        }

        @Override
        public DicomObject getNestedDicomObject(int tag) {
            DicomObject item = this.dcmobj.getNestedDicomObject(tag);
            return item != null ? new UnmodifiableDicomObject(item) : null;
        }

        @Override
        public DicomObject getNestedDicomObject(int[] itemPath) {
            DicomObject item = this.dcmobj.getNestedDicomObject(itemPath);
            return item != null ? new UnmodifiableDicomObject(item) : null;
        }

        @Override
        public DicomObject getParent() {
            DicomObject parent = this.dcmobj.getParent();
            return parent != null ? new UnmodifiableDicomObject(parent) : null;
        }

        @Override
        public String getPrivateCreator(int tag) {
            return this.dcmobj.getPrivateCreator(tag);
        }

        @Override
        public DicomObject getRoot() {
            return this.dcmobj.isRoot() ? this : new UnmodifiableDicomObject(this.dcmobj.getRoot());
        }

        @Override
        public short[] getShorts(int tag, short[] defVal) {
            return this.dcmobj.getShorts(tag, defVal);
        }

        @Override
        public short[] getShorts(int tag, VR vr, short[] defVal) {
            return this.dcmobj.getShorts(tag, vr, defVal);
        }

        @Override
        public short[] getShorts(int tag) {
            return this.dcmobj.getShorts(tag);
        }

        @Override
        public short[] getShorts(int tag, VR vr) {
            return this.dcmobj.getShorts(tag, vr);
        }

        @Override
        public short[] getShorts(int[] tagPath, short[] defVal) {
            return this.dcmobj.getShorts(tagPath, defVal);
        }

        @Override
        public short[] getShorts(int[] tagPath, VR vr, short[] defVal) {
            return this.dcmobj.getShorts(tagPath, vr, defVal);
        }

        @Override
        public short[] getShorts(int[] tagPath) {
            return this.dcmobj.getShorts(tagPath);
        }

        @Override
        public short[] getShorts(int[] tagPath, VR vr) {
            return this.dcmobj.getShorts(tagPath, vr);
        }

        @Override
        public SpecificCharacterSet getSpecificCharacterSet() {
            return this.dcmobj.getSpecificCharacterSet();
        }

        @Override
        public String getString(int tag, String defVal) {
            return this.dcmobj.getString(tag, defVal);
        }

        @Override
        public String getString(int tag, VR vr, String defVal) {
            return this.dcmobj.getString(tag, vr, defVal);
        }

        @Override
        public String getString(int tag) {
            return this.dcmobj.getString(tag);
        }

        @Override
        public String getString(int tag, VR vr) {
            return this.dcmobj.getString(tag, vr);
        }

        @Override
        public String getString(int[] tagPath, String defVal) {
            return this.dcmobj.getString(tagPath, defVal);
        }

        @Override
        public String getString(int[] tagPath, VR vr, String defVal) {
            return this.dcmobj.getString(tagPath, vr, defVal);
        }

        @Override
        public String getString(int[] tagPath) {
            return this.dcmobj.getString(tagPath);
        }

        @Override
        public String getString(int[] tagPath, VR vr) {
            return this.dcmobj.getString(tagPath, vr);
        }

        @Override
        public String[] getStrings(int tag, String[] defVal) {
            return this.dcmobj.getStrings(tag, defVal);
        }

        @Override
        public String[] getStrings(int tag, VR vr, String[] defVal) {
            return this.dcmobj.getStrings(tag, vr, defVal);
        }

        @Override
        public String[] getStrings(int tag) {
            return this.dcmobj.getStrings(tag);
        }

        @Override
        public String[] getStrings(int tag, VR vr) {
            return this.dcmobj.getStrings(tag, vr);
        }

        @Override
        public String[] getStrings(int[] tagPath, String[] defVal) {
            return this.dcmobj.getStrings(tagPath, defVal);
        }

        @Override
        public String[] getStrings(int[] tagPath, VR vr, String[] defVal) {
            return this.dcmobj.getStrings(tagPath, vr, defVal);
        }

        @Override
        public String[] getStrings(int[] tagPath) {
            return this.dcmobj.getStrings(tagPath);
        }

        @Override
        public String[] getStrings(int[] tagPath, VR vr) {
            return this.dcmobj.getStrings(tagPath, vr);
        }

        @Override
        public void initFileMetaInformation(String cuid, String iuid, String tsuid) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void initFileMetaInformation(String tsuid) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            return this.dcmobj.isEmpty();
        }

        @Override
        public boolean isRoot() {
            return this.dcmobj.isRoot();
        }

        @Override
        public Iterator<DicomElement> iterator() {
            return new UnmodifiabledIterator(this.dcmobj.iterator());
        }

        @Override
        public Iterator<DicomElement> iterator(int fromTag, int toTag) {
            return new UnmodifiabledIterator(this.dcmobj.iterator(fromTag, toTag));
        }

        @Override
        public boolean matches(DicomObject keys, boolean ignoreCaseOfPN) {
            return this.dcmobj.matches(keys, ignoreCaseOfPN);
        }

        @Override
        public String nameOf(int tag) {
            return this.dcmobj.nameOf(tag);
        }

        @Override
        public DicomElement putBytes(int tag, VR vr, byte[] val, boolean bigEndian) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DicomElement putBytes(int tag, VR vr, byte[] val) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DicomElement putBytes(int[] tagPath, VR vr, byte[] val, boolean bigEndian) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DicomElement putBytes(int[] tagPath, VR vr, byte[] val) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DicomElement putDate(int tag, VR vr, Date val) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DicomElement putDate(int[] tagPath, VR vr, Date val) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DicomElement putDateRange(int tag, VR vr, DateRange val) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DicomElement putDateRange(int[] tagPath, VR vr, DateRange val) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DicomElement putDates(int tag, VR vr, Date[] val) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DicomElement putDates(int[] tagPath, VR vr, Date[] val) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DicomElement putDouble(int tag, VR vr, double val) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DicomElement putDouble(int[] tagPath, VR vr, double val) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DicomElement putDoubles(int tag, VR vr, double[] val) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DicomElement putDoubles(int[] tagPath, VR vr, double[] val) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DicomElement putFloat(int tag, VR vr, float val) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DicomElement putFloat(int[] tagPath, VR vr, float val) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DicomElement putFloats(int tag, VR vr, float[] val) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DicomElement putFloats(int[] tagPath, VR vr, float[] val) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DicomElement putFragments(int tag, VR vr, boolean bigEndian, int capacity) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DicomElement putFragments(int tag, VR vr, boolean bigEndian) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DicomElement putFragments(int[] tagPath, VR vr, boolean bigEndian, int capacity) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DicomElement putFragments(int[] tagPath, VR vr, boolean bigEndian) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DicomElement putInt(int tag, VR vr, int val) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DicomElement putInt(int[] tagPath, VR vr, int val) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DicomElement putInts(int tag, VR vr, int[] val) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DicomElement putInts(int[] tagPath, VR vr, int[] val) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DicomElement putNestedDicomObject(int tag, DicomObject item) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DicomElement putNestedDicomObject(int[] tagPath, DicomObject item) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DicomElement putNull(int tag, VR vr) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DicomElement putNull(int[] tagPath, VR vr) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DicomElement putSequence(int tag, int capacity) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DicomElement putSequence(int tag) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DicomElement putSequence(int[] tagPath, int capacity) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DicomElement putSequence(int[] tagPath) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DicomElement putShorts(int tag, VR vr, short[] val) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DicomElement putShorts(int[] tagPath, VR vr, short[] val) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DicomElement putString(int tag, VR vr, String val) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DicomElement putString(int[] tagPath, VR vr, String val) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DicomElement putStrings(int tag, VR vr, String[] val) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DicomElement putStrings(int[] tagPath, VR vr, String[] val) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DicomElement remove(int tag) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DicomElement remove(int[] tagPath) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int resolveTag(int tag, String privateCreator, boolean reserve) {
            if (reserve) {
                throw new UnsupportedOperationException();
            }
            return this.dcmobj.resolveTag(tag, privateCreator, reserve);
        }

        @Override
        public int resolveTag(int tag, String privateCreator) {
            return this.dcmobj.resolveTag(tag, privateCreator);
        }

        @Override
        public void serializeElements(ObjectOutputStream oos) throws IOException {
            this.dcmobj.serializeElements(oos);
        }

        @Override
        public void setItemOffset(long offset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setItemPosition(int pos) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setParent(DicomObject parent) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void shareElements() {
            this.dcmobj.shareElements();
        }

        @Override
        public int size() {
            return this.dcmobj.size();
        }

        @Override
        public DicomObject subSet(DicomObject filter) {
            return new UnmodifiableDicomObject(this.dcmobj.subSet(filter));
        }

        @Override
        public DicomObject subSet(int fromTag, int toTag) {
            return new UnmodifiableDicomObject(this.dcmobj.subSet(fromTag, toTag));
        }

        @Override
        public DicomObject subSet(int[] tags) {
            return new UnmodifiableDicomObject(this.dcmobj.subSet(tags));
        }

        @Override
        public int toStringBuffer(StringBuffer sb, DicomObjectToStringParam param) {
            return this.dcmobj.toStringBuffer(sb, param);
        }

        @Override
        public int vm(int tag) {
            return this.dcmobj.vm(tag);
        }

        @Override
        public VR vrOf(int tag) {
            return this.dcmobj.vrOf(tag);
        }
    }
}

