/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.sender;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.log4j.Logger;
import org.dcm4che.util.DcmURL;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.UIDDictionary;
import org.dcm4che2.data.VR;
import org.dcm4che2.io.DicomInputHandler;
import org.dcm4che2.io.DicomInputStream;
import org.dcm4che2.io.DicomOutputStream;
import org.dcm4che2.io.StopTagInputHandler;
import org.dcm4che2.io.TranscoderInputHandler;
import org.dcm4che2.net.Association;
import org.dcm4che2.net.ConfigurationException;
import org.dcm4che2.net.Device;
import org.dcm4che2.net.DimseRSP;
import org.dcm4che2.net.DimseRSPHandler;
import org.dcm4che2.net.NetworkApplicationEntity;
import org.dcm4che2.net.NetworkConnection;
import org.dcm4che2.net.NewThreadExecutor;
import org.dcm4che2.net.NoPresentationContextException;
import org.dcm4che2.net.PDVOutputStream;
import org.dcm4che2.net.TransferCapability;
import org.dcm4che2.net.UserIdentity;
import org.dcm4che2.net.service.DicomService;
import org.dcm4che2.net.service.StorageCommitmentService;
import org.dcm4che2.util.CloseUtils;
import org.dcm4che2.util.StringUtils;
import org.dcm4che2.util.UIDUtils;

public class DicomSender
extends StorageCommitmentService {
    private static Logger logger = Logger.getLogger((String)DicomSender.class.getName());
    private static final int PEEK_LEN = 1024;
    private static char[] SECRET = new char[]{'s', 'e', 'c', 'r', 'e', 't'};
    private static final String[] ONLY_IVLE_TS = new String[]{"1.2.840.10008.1.2"};
    private static final String[] IVLE_TS = new String[]{"1.2.840.10008.1.2", "1.2.840.10008.1.2.1", "1.2.840.10008.1.2.2"};
    private static final String[] EVLE_TS = new String[]{"1.2.840.10008.1.2.1", "1.2.840.10008.1.2", "1.2.840.10008.1.2.2"};
    private static final String[] EVBE_TS = new String[]{"1.2.840.10008.1.2.2", "1.2.840.10008.1.2.1", "1.2.840.10008.1.2"};
    private static final int STG_CMT_ACTION_TYPE = 1;
    private static final String DCM4CHEE_URI_REFERENCED_TS_UID = "1.2.40.0.13.1.1.2.4.94";
    private Executor executor = new NewThreadExecutor("DCMSND");
    private NetworkApplicationEntity remoteAE = new NetworkApplicationEntity();
    private NetworkConnection remoteConn = new NetworkConnection();
    private Device device = new Device("DCMSND");
    private NetworkApplicationEntity ae = new NetworkApplicationEntity();
    private NetworkConnection conn = new NetworkConnection();
    private Map<String, Set<String>> as2ts = new HashMap<String, Set<String>>();
    private ArrayList<FileInfo> files = new ArrayList();
    private Association assoc;
    private int priority = 0;
    private int transcoderBufferSize = 1024;
    private int filesSent = 0;
    private long totalSize = 0L;
    private boolean fileref = false;
    private boolean stgcmt = false;
    private long shutdownDelay = 1000L;
    private String keyStoreURL = "resource:tls/test_sys_1.p12";
    private char[] keyStorePassword = SECRET;
    private char[] keyPassword;
    private String trustStoreURL = "resource:tls/mesa_certs.jks";
    private char[] trustStorePassword = SECRET;
    private DcmURL url;
    private String error = "";

    public final void setLocalHost(String hostname) {
        this.conn.setHostname(hostname);
    }

    public final void setLocalPort(int port) {
        this.conn.setPort(port);
    }

    public final void setRemoteHost(String hostname) {
        this.remoteConn.setHostname(hostname);
    }

    public final void setRemotePort(int port) {
        this.remoteConn.setPort(port);
    }

    public final void setTlsWithoutEncyrption() {
        this.conn.setTlsWithoutEncyrption();
        this.remoteConn.setTlsWithoutEncyrption();
    }

    public final void setTls3DES_EDE_CBC() {
        this.conn.setTls3DES_EDE_CBC();
        this.remoteConn.setTls3DES_EDE_CBC();
    }

    public final void setTlsAES_128_CBC() {
        this.conn.setTlsAES_128_CBC();
        this.remoteConn.setTlsAES_128_CBC();
    }

    public final void disableSSLv2Hello() {
        this.conn.disableSSLv2Hello();
    }

    public final void setTlsNeedClientAuth(boolean needClientAuth) {
        this.conn.setTlsNeedClientAuth(needClientAuth);
    }

    public final void setKeyStoreURL(String url) {
        this.keyStoreURL = url;
    }

    public final void setKeyStorePassword(String pw) {
        this.keyStorePassword = pw.toCharArray();
    }

    public final void setKeyPassword(String pw) {
        this.keyPassword = pw.toCharArray();
    }

    public final void setTrustStorePassword(String pw) {
        this.trustStorePassword = pw.toCharArray();
    }

    public final void setTrustStoreURL(String url) {
        this.trustStoreURL = url;
    }

    public final void setCalledAET(String called) {
        this.remoteAE.setAETitle(called);
    }

    public final void setCalling(String calling) {
        if (calling == null) {
            calling = "";
        }
        this.ae.setAETitle(calling);
    }

    public final void setUserIdentity(UserIdentity userIdentity) {
        this.ae.setUserIdentity(userIdentity);
    }

    public final void setOfferDefaultTransferSyntaxInSeparatePresentationContext(boolean enable) {
        this.ae.setOfferDefaultTransferSyntaxInSeparatePresentationContext(enable);
    }

    public final void setSendFileRef(boolean fileref) {
        this.fileref = fileref;
    }

    public final void setStorageCommitment(boolean stgcmt) {
        this.stgcmt = stgcmt;
    }

    public final boolean isStorageCommitment() {
        return this.stgcmt;
    }

    public final void setShutdownDelay(int shutdownDelay) {
        this.shutdownDelay = shutdownDelay;
    }

    public final void setConnectTimeout(int connectTimeout) {
        this.conn.setConnectTimeout(connectTimeout);
    }

    public final void setMaxPDULengthReceive(int maxPDULength) {
        this.ae.setMaxPDULengthReceive(maxPDULength);
    }

    public final void setMaxOpsInvoked(int maxOpsInvoked) {
        this.ae.setMaxOpsInvoked(maxOpsInvoked);
    }

    public final void setPackPDV(boolean packPDV) {
        this.ae.setPackPDV(packPDV);
    }

    public final void setAssociationReaperPeriod(int period) {
        this.device.setAssociationReaperPeriod(period);
    }

    public final void setDimseRspTimeout(int timeout) {
        this.ae.setDimseRspTimeout(timeout);
    }

    public final void setPriority(int priority) {
        this.priority = priority;
    }

    public final void setTcpNoDelay(boolean tcpNoDelay) {
        this.conn.setTcpNoDelay(tcpNoDelay);
    }

    public final void setAcceptTimeout(int timeout) {
        this.conn.setAcceptTimeout(timeout);
    }

    public final void setReleaseTimeout(int timeout) {
        this.conn.setReleaseTimeout(timeout);
    }

    public final void setSocketCloseDelay(int timeout) {
        this.conn.setSocketCloseDelay(timeout);
    }

    public final void setMaxPDULengthSend(int maxPDULength) {
        this.ae.setMaxPDULengthSend(maxPDULength);
    }

    public final void setReceiveBufferSize(int bufferSize) {
        this.conn.setReceiveBufferSize(bufferSize);
    }

    public final void setSendBufferSize(int bufferSize) {
        this.conn.setSendBufferSize(bufferSize);
    }

    public final void setTranscoderBufferSize(int transcoderBufferSize) {
        this.transcoderBufferSize = transcoderBufferSize;
    }

    public final int getNumberOfFilesToSend() {
        return this.files.size();
    }

    public final int getNumberOfFilesSent() {
        return this.filesSent;
    }

    public final long getTotalSizeSent() {
        return this.totalSize;
    }

    public void addFile(File f) {
        if (f.isDirectory()) {
            File[] fs = f.listFiles();
            int i = 0;
            while (i < fs.length) {
                this.addFile(fs[i]);
                ++i;
            }
            return;
        }
        FileInfo info = new FileInfo(f);
        BasicDicomObject dcmObj = new BasicDicomObject();
        DicomInputStream in = null;
        try {
            try {
                in = new DicomInputStream(f);
                in.setHandler((DicomInputHandler)new StopTagInputHandler(524320));
                in.readDicomObject((DicomObject)dcmObj, 1024);
                info.tsuid = in.getTransferSyntax().uid();
                info.fmiEndPos = in.getEndOfFileMetaInfoPosition();
            }
            catch (Throwable e) {
                e.printStackTrace();
                System.err.println("WARNING: Failed to parse " + f + " - skipped.");
                System.out.print('F');
                CloseUtils.safeClose((Closeable)in);
                return;
            }
        }
        catch (Throwable throwable) {
            CloseUtils.safeClose(in);
            throw throwable;
        }
        CloseUtils.safeClose((Closeable)in);
        info.cuid = dcmObj.getString(524310);
        if (info.cuid == null) {
            System.err.println("WARNING: Missing SOP Class UID in " + f + " - skipped.");
            System.out.print('F');
            return;
        }
        info.iuid = dcmObj.getString(524312);
        if (info.iuid == null) {
            System.err.println("WARNING: Missing SOP Instance UID in " + f + " - skipped.");
            System.out.print('F');
            return;
        }
        this.addTransferCapability(info.cuid, info.tsuid);
        this.files.add(info);
        System.out.print('.');
    }

    private void addTransferCapability(String cuid, String tsuid) {
        Set<String> ts = this.as2ts.get(cuid);
        if (this.fileref) {
            if (ts == null) {
                this.as2ts.put(cuid, Collections.singleton(DCM4CHEE_URI_REFERENCED_TS_UID));
            }
        } else {
            if (ts == null) {
                ts = new HashSet<String>();
                ts.add("1.2.840.10008.1.2");
                this.as2ts.put(cuid, ts);
            }
            ts.add(tsuid);
        }
    }

    private void configureTransferCapability() {
        int off = this.stgcmt ? 1 : 0;
        TransferCapability[] tc = new TransferCapability[off + this.as2ts.size()];
        if (this.stgcmt) {
            tc[0] = new TransferCapability("1.2.840.10008.1.20.1", ONLY_IVLE_TS, "SCU");
        }
        Iterator<Map.Entry<String, Set<String>>> iter = this.as2ts.entrySet().iterator();
        int i = off;
        while (i < tc.length) {
            Map.Entry<String, Set<String>> e = iter.next();
            String cuid = e.getKey();
            Set<String> ts = e.getValue();
            tc[i] = new TransferCapability(cuid, ts.toArray(new String[ts.size()]), "SCU");
            ++i;
        }
        this.ae.setTransferCapability(tc);
    }

    public void start() throws IOException {
        if (this.conn.isListening()) {
            this.conn.bind(this.executor);
            System.out.println("Start Server listening on port " + this.conn.getPort());
        }
    }

    public void stop() {
        if (this.conn.isListening()) {
            try {
                Thread.sleep(this.shutdownDelay);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.conn.unbind();
        }
    }

    public void open() throws IOException, ConfigurationException, InterruptedException {
        this.assoc = this.ae.connect(this.remoteAE, this.executor);
    }

    public void send() throws Exception {
        this.error = "";
        int i = 0;
        int n = this.files.size();
        while (i < n) {
            FileInfo info = this.files.get(i);
            TransferCapability tc = this.assoc.getTransferCapabilityAsSCU(info.cuid);
            if (tc == null) {
                throw new Exception("SOP Class UID: \"" + UIDDictionary.getDictionary().prompt(info.cuid) + "\" is not supported by " + this.remoteAE.getAETitle());
            }
            String tsuid = this.selectTransferSyntax(tc.getTransferSyntax(), this.fileref ? DCM4CHEE_URI_REFERENCED_TS_UID : info.tsuid);
            if (tsuid == null) {
                throw new Exception("SOP Class UID: \"" + UIDDictionary.getDictionary().prompt(info.cuid) + "\" with TransferSyntax UID: \"" + UIDDictionary.getDictionary().prompt(this.fileref ? DCM4CHEE_URI_REFERENCED_TS_UID : info.tsuid) + "\" is not supported by " + this.remoteAE.getAETitle());
            }
            try {
                DimseRSPHandler rspHandler = new DimseRSPHandler(){

                    public void onDimseRSP(Association as, DicomObject cmd, DicomObject data) {
                        DicomSender.this.onDimseRSP(cmd);
                    }
                };
                this.assoc.cstore(info.cuid, info.iuid, this.priority, (org.dcm4che2.net.DataWriter)new DataWriter(info), tsuid, rspHandler);
            }
            catch (NoPresentationContextException e) {
                throw new Exception("WARNING: " + e.getMessage() + " - cannot send " + info.f);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new Exception("ERROR: Failed to send - " + info.f + ": " + e.getMessage());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++i;
        }
        try {
            this.assoc.waitForDimseRSP();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public boolean commit() {
        int status;
        DicomObject cmd;
        block7: {
            BasicDicomObject actionInfo = new BasicDicomObject();
            actionInfo.putString(528789, VR.UI, UIDUtils.createUID());
            DicomElement refSOPSq = actionInfo.putSequence(528793);
            int i = 0;
            int n = this.files.size();
            while (i < n) {
                FileInfo info = this.files.get(i);
                if (info.transferred) {
                    BasicDicomObject refSOP = new BasicDicomObject();
                    refSOP.putString(528720, VR.UI, info.cuid);
                    refSOP.putString(528725, VR.UI, info.iuid);
                    refSOPSq.addDicomObject((DicomObject)refSOP);
                }
                ++i;
            }
            DimseRSP rsp = this.assoc.naction("1.2.840.10008.1.20.1", "1.2.840.10008.1.20.1.1", 1, (DicomObject)actionInfo, "1.2.840.10008.1.2");
            rsp.next();
            cmd = rsp.getCommand();
            status = cmd.getInt(2304);
            if (status != 0) break block7;
            return true;
        }
        try {
            System.err.println("WARNING: Storage Commitment request failed with status: " + StringUtils.shortToHex((int)status) + "H");
            System.err.println(cmd.toString());
        }
        catch (NoPresentationContextException e) {
            System.err.println("WARNING: " + e.getMessage() + " - cannot request Storage Commitment");
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("ERROR: Failed to send Storage Commitment request: " + e.getMessage());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return false;
    }

    private String selectTransferSyntax(String[] available, String tsuid) {
        if (tsuid.equals("1.2.840.10008.1.2")) {
            return this.selectTransferSyntax(available, IVLE_TS);
        }
        if (tsuid.equals("1.2.840.10008.1.2.1")) {
            return this.selectTransferSyntax(available, EVLE_TS);
        }
        if (tsuid.equals("1.2.840.10008.1.2.2")) {
            return this.selectTransferSyntax(available, EVBE_TS);
        }
        int j = 0;
        while (j < available.length) {
            if (available[j].equals(tsuid)) {
                return tsuid;
            }
            ++j;
        }
        return null;
    }

    private String selectTransferSyntax(String[] available, String[] tsuids) {
        int i = 0;
        while (i < tsuids.length) {
            int j = 0;
            while (j < available.length) {
                if (available[j].equals(tsuids[i])) {
                    return available[j];
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public void close() {
        try {
            this.assoc.release(false);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void promptErrRSP(String prefix, int status, FileInfo info, DicomObject cmd) {
        System.err.println(String.valueOf(prefix) + StringUtils.shortToHex((int)status) + "H for " + info.f + ", cuid=" + info.cuid + ", tsuid=" + info.tsuid);
        System.err.println(cmd.toString());
        this.error = String.valueOf(this.error) + prefix + " " + cmd.toString() + "\n";
    }

    private void onDimseRSP(DicomObject cmd) {
        int status = cmd.getInt(2304);
        int msgId = cmd.getInt(288);
        FileInfo info = null;
        try {
            info = this.files.get(msgId - 1);
        }
        catch (Exception e) {
            info = this.files.get(0);
        }
        switch (status) {
            case 0: {
                info.transferred = true;
                this.totalSize += info.length;
                ++this.filesSent;
                System.out.print('.');
                logger.info((Object)("DICOM-SENT for file " + (info != null ? info.f : "") + " SUCCESSFUL"));
                break;
            }
            case 45056: 
            case 45062: 
            case 45063: {
                info.transferred = true;
                this.totalSize += info.length;
                ++this.filesSent;
                this.promptErrRSP("WARNING: Received RSP with Status ", status, info, cmd);
                System.out.print('W');
                break;
            }
            default: {
                this.promptErrRSP("ERROR: Received RSP with Status ", status, info, cmd);
                System.out.print('F');
            }
        }
    }

    protected synchronized void onNEventReportRSP(Association as, int pcid, DicomObject rq, DicomObject info, DicomObject rsp) {
        ((Object)((Object)this)).notifyAll();
    }

    public void initTLS() throws GeneralSecurityException, IOException {
        KeyStore keyStore = DicomSender.loadKeyStore(this.keyStoreURL, this.keyStorePassword);
        KeyStore trustStore = DicomSender.loadKeyStore(this.trustStoreURL, this.trustStorePassword);
        this.device.initTLS(keyStore, this.keyPassword != null ? this.keyPassword : this.keyStorePassword, trustStore);
    }

    private static KeyStore loadKeyStore(String url, char[] password) throws GeneralSecurityException, IOException {
        KeyStore key = KeyStore.getInstance(DicomSender.toKeyStoreType(url));
        InputStream in = DicomSender.openFileOrURL(url);
        try {
            key.load(in, password);
        }
        finally {
            in.close();
        }
        return key;
    }

    private static InputStream openFileOrURL(String url) throws IOException {
        if (url.startsWith("resource:")) {
            return DicomSender.class.getClassLoader().getResourceAsStream(url.substring(9));
        }
        try {
            return new URL(url).openStream();
        }
        catch (MalformedURLException e) {
            return new FileInputStream(url);
        }
    }

    private static String toKeyStoreType(String fname) {
        return fname.endsWith(".p12") || fname.endsWith(".P12") ? "PKCS12" : "JKS";
    }

    public DicomSender(DcmURL url) {
        this.url = url;
        this.remoteAE.setInstalled(true);
        this.remoteAE.setAssociationAcceptor(true);
        this.remoteAE.setNetworkConnection(new NetworkConnection[]{this.remoteConn});
        this.device.setNetworkApplicationEntity(this.ae);
        this.device.setNetworkConnection(this.conn);
        this.ae.setNetworkConnection(this.conn);
        this.ae.setAssociationInitiator(true);
        this.ae.setAssociationAcceptor(true);
        this.ae.register((DicomService)this);
        this.ae.setAETitle("DCMSND");
        this.setCalling(url.getCallingAET());
        this.setCalledAET(url.getCalledAET());
        this.setRemoteHost(url.getHost());
        this.setRemotePort(url.getPort());
    }

    public boolean send(File file) throws Exception {
        this.addFile(file);
        this.configureTransferCapability();
        this.start();
        this.open();
        int filesToSend = this.getNumberOfFilesToSend();
        this.send();
        int filesSend = this.getNumberOfFilesSent();
        this.close();
        this.stop();
        if (filesToSend != filesSend) {
            logger.warn((Object)("FAILED to send file " + file.getAbsolutePath() + " to " + this.url.toString()));
            this.files.clear();
            this.filesSent = 0;
            return false;
        }
        logger.info((Object)("SENDING of file " + file.getAbsolutePath() + " to " + this.url.toString() + " done"));
        this.files.clear();
        this.filesSent = 0;
        return true;
    }

    public String getUrl() {
        return this.url.toString();
    }

    public String getError() {
        return this.error;
    }

    public static void main(String[] args) {
        try {
            DicomSender dSender;
            DcmURL url = new DcmURL("dicom://OSIRIX:test@10.14.1.8:5104");
            if (args.length == 1) {
                try {
                    url = new DcmURL(args[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if ((dSender = new DicomSender(url)).send(new File("/home/hermenj/im1"))) {
                System.out.println("sending successfull");
            } else {
                System.out.println("sending failed");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class DataWriter
    implements org.dcm4che2.net.DataWriter {
        private FileInfo info;

        public DataWriter(FileInfo info) {
            this.info = info;
        }

        public void writeTo(PDVOutputStream out, String tsuid) throws IOException {
            if (tsuid.equals(this.info.tsuid)) {
                FileInputStream fis = new FileInputStream(this.info.f);
                try {
                    long skip = this.info.fmiEndPos;
                    while (skip > 0L) {
                        skip -= fis.skip(skip);
                    }
                    out.copyFrom((InputStream)fis);
                }
                finally {
                    fis.close();
                }
            }
            if (tsuid.equals(DicomSender.DCM4CHEE_URI_REFERENCED_TS_UID)) {
                DicomObject attrs;
                DicomInputStream dis = new DicomInputStream(this.info.f);
                try {
                    dis.setHandler((DicomInputHandler)new StopTagInputHandler(2145386512));
                    attrs = dis.readDicomObject();
                }
                finally {
                    dis.close();
                }
                DicomOutputStream dos = new DicomOutputStream((OutputStream)out);
                attrs.putString(4251664, VR.UT, this.info.f.toURI().toString());
                dos.writeDataset(attrs, tsuid);
            } else {
                DicomInputStream dis = new DicomInputStream(this.info.f);
                try {
                    DicomOutputStream dos = new DicomOutputStream((OutputStream)out);
                    dos.setTransferSyntax(tsuid);
                    TranscoderInputHandler h = new TranscoderInputHandler(dos, DicomSender.this.transcoderBufferSize);
                    dis.setHandler((DicomInputHandler)h);
                    dis.readDicomObject();
                }
                finally {
                    dis.close();
                }
            }
        }
    }

    private static final class FileInfo {
        File f;
        String cuid;
        String iuid;
        String tsuid;
        long fmiEndPos;
        long length;
        boolean transferred;

        public FileInfo(File f) {
            this.f = f;
            this.length = f.length();
        }
    }
}

