/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.receiver;

import java.io.File;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import lu.tudor.santec.dicom.gui.header.DicomHeader;
import lu.tudor.santec.dicom.receiver.DICOMListener;
import lu.tudor.santec.dicom.receiver.DicomEvent;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class DicomRXListener
implements DICOMListener {
    private static Logger logger = Logger.getLogger((String)DicomRXListener.class.getName());
    private ConcurrentHashMap<String, Object[]> lastSeries = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Object[]> lastStudies = new ConcurrentHashMap();

    public DicomRXListener(long waitSeconds) {
        final long waitmillis = waitSeconds * 1000L;
        new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        block3: while (true) {
                            File folder;
                            Long time;
                            Object[] val;
                            Thread.sleep(1000L);
                            long now = System.currentTimeMillis();
                            for (String key : DicomRXListener.this.lastSeries.keySet()) {
                                val = (Object[])DicomRXListener.this.lastSeries.get(key);
                                time = (Long)val[0];
                                if (time + waitmillis >= now) continue;
                                folder = (File)val[1];
                                DicomRXListener.this.seriesReceived(key, folder);
                                DicomRXListener.this.lastSeries.remove(key);
                            }
                            Iterator iterator = DicomRXListener.this.lastStudies.keySet().iterator();
                            while (true) {
                                String key;
                                if (!iterator.hasNext()) continue block3;
                                key = (String)iterator.next();
                                val = (Object[])DicomRXListener.this.lastStudies.get(key);
                                time = (Long)val[0];
                                if (time + waitmillis * 3L >= now) continue;
                                folder = (File)val[1];
                                DicomRXListener.this.studyReceived(key, folder);
                                DicomRXListener.this.lastStudies.remove(key);
                            }
                            break;
                        }
                    }
                    catch (InterruptedException e) {
                        logger.log((Priority)Level.ERROR, (Object)"", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
        }.start();
    }

    @Override
    public void fireDicomEvent(DicomEvent event) {
        if (event != null && "ADD".equals(event.getType())) {
            File f = event.getFile();
            DicomHeader dh = new DicomHeader(f);
            Long time = System.currentTimeMillis();
            String sUID = dh.getHeaderStringValue(0x20000E);
            Object[] val = new Object[]{time, f.getAbsoluteFile().getParentFile()};
            this.lastSeries.put(sUID, val);
            String studyUID = dh.getHeaderStringValue(0x20000D);
            Object[] val2 = new Object[]{time, f.getAbsoluteFile().getParentFile().getParentFile()};
            this.lastStudies.put(studyUID, val2);
            String iUID = dh.getHeaderStringValue(524312);
            this.imageReceived(iUID, f);
        }
    }

    protected abstract void imageReceived(String var1, File var2);

    protected abstract void seriesReceived(String var1, File var2);

    protected abstract void studyReceived(String var1, File var2);
}

