/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.receiver;

import java.io.File;
import lu.tudor.santec.dicom.gui.dicomdir.DICOMDIRVIEW;
import lu.tudor.santec.dicom.receiver.DicomDirListener;
import lu.tudor.santec.dicom.receiver.DicomEvent;
import org.apache.log4j.Logger;

public class DicomDirWatcher
extends Thread {
    private DicomDirListener listener;
    private File dicomdirFile;
    private int interval;
    private long oldLastModified = 0L;
    private boolean paused;
    private static final Logger log = Logger.getLogger((String)"DicomDirWatcher");

    public DicomDirWatcher(File dicomdirFile, int interval, DICOMDIRVIEW panel) {
        this.dicomdirFile = dicomdirFile;
        this.interval = interval;
        this.oldLastModified = this.dicomdirFile.lastModified();
        log.info((Object)("+++++++++ adding dicom listener to " + dicomdirFile));
        this.listener = panel;
        this.start();
    }

    public void fireDicomEvent(DicomEvent d_Event) {
        this.listener.dicomdirChanged(d_Event);
    }

    @Override
    public void run() {
        while (!this.paused) {
            long lastModified = this.dicomdirFile.lastModified();
            if (this.oldLastModified != lastModified) {
                this.oldLastModified = lastModified;
                this.fireDicomEvent(new DicomEvent(this.dicomdirFile));
            }
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }
}

