/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.query;

import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.ProgressMonitor;
import lu.tudor.santec.dicom.gui.header.HeaderTag;
import lu.tudor.santec.dicom.query.DcmQR;
import org.apache.log4j.Logger;
import org.dcm4che.util.DcmURL;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.Tag;
import org.dcm4che2.net.NoPresentationContextException;

public class DicomQuery {
    private Logger logger = Logger.getLogger((String)"lu.tudor.santec.dicom.query.DicomQuery");
    private DcmURL url;
    private DcmQR query;
    private ProgressMonitor progressMonitor;

    public DicomQuery(DcmURL url) {
        this.url = url.clone();
        this.query = new DcmQR();
        this.query.setCalledAET(url.getCalledAET(), true);
        if (url.getCallingAET() != null) {
            this.query.setCalling(url.getCallingAET());
        }
        this.query.setRemoteHost(url.getHost());
        this.query.setRemotePort(url.getPort());
    }

    public Vector<DicomObject> query(Vector<HeaderTag> filters, DcmQR.QueryRetrieveLevel level) throws Exception {
        this.query.setQueryLevel(level);
        int[] nArray = level.getReturnKeys();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int retKey = nArray[n2];
            this.query.addReturnKey(retKey);
            ++n2;
        }
        if (filters != null) {
            for (HeaderTag headerTag : filters) {
                this.query.addMatchingKey(headerTag.getTagInt(), headerTag.getTagValue());
            }
        }
        this.query.configureTransferCapability(true);
        this.query.start();
        this.query.open();
        List<DicomObject> result = null;
        result = this.query.query();
        this.query.close();
        this.query.stop();
        return new Vector<DicomObject>(result);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Vector<DicomObject> queryPatients(int searchTag, String searchString) throws Exception {
        block3: {
            this.query.setQueryLevel(DcmQR.QueryRetrieveLevel.PATIENT);
            this.query.addReturnKey(0x100020);
            this.query.addReturnKey(0x201200);
            this.query.addReturnKey(0x201202);
            this.query.addReturnKey(2101764);
            this.query.addMatchingKey(searchTag, searchString);
            this.query.configureTransferCapability(true);
            this.query.start();
            this.query.open();
            result /* !! */  = null;
            try {
                result /* !! */  = this.query.query();
                break block3;
            }
            catch (NoPresentationContextException e) {
                this.logger.info((Object)"query for patient not supported, try query for studies.....");
                this.query.close();
                this.query.stop();
                this.query.setQueryLevel(DcmQR.QueryRetrieveLevel.STUDY);
                this.query.addMatchingKey(searchTag, searchString);
                this.query.addReturnKey(0x100020);
                this.query.addReturnKey(0x201200);
                this.query.addReturnKey(0x201202);
                this.query.addReturnKey(2101764);
                this.query.configureTransferCapability(true);
                this.query.start();
                this.query.open();
                resultStudies = this.query.query();
                patients = new HashMap<String, DicomObject>();
                ** for (study : resultStudies)
            }
lbl-1000:
            // 1 sources

            {
                patients.put(study.getString(0x100020), study);
                continue;
            }
lbl33:
            // 1 sources

            result /* !! */  = patients.values();
        }
        this.query.close();
        this.query.stop();
        return new Vector<DicomObject>(result /* !! */ );
    }

    public Vector<DicomObject> queryStudiesByPatient(DicomObject patient) throws Exception {
        this.query.setQueryLevel(DcmQR.QueryRetrieveLevel.STUDY);
        this.query.addMatchingKey(0x100020, patient.getString(0x100020));
        this.query.addReturnKey(0x20000D);
        this.query.addReturnKey(528432);
        this.query.addReturnKey(3293184);
        this.query.addReturnKey(524320);
        this.query.addReturnKey(524336);
        this.query.configureTransferCapability(true);
        this.query.start();
        this.query.open();
        List<DicomObject> result = this.query.query();
        this.query.close();
        this.query.stop();
        return new Vector<DicomObject>(result);
    }

    public Vector<DicomObject> querySeriesByStudy(DicomObject study, String wantedModality) throws Exception {
        this.query.setQueryLevel(DcmQR.QueryRetrieveLevel.SERIES);
        this.query.addMatchingKey(0x20000D, study.getString(0x20000D));
        if (wantedModality != null && !wantedModality.equals("")) {
            this.query.addMatchingKey(524384, wantedModality);
        } else {
            this.query.addReturnKey(524384);
        }
        this.query.addReturnKey(0x20000E);
        this.query.addReturnKey(528446);
        this.query.addReturnKey(0x200011);
        this.query.addReturnKey(524321);
        this.query.addReturnKey(524337);
        this.query.configureTransferCapability(true);
        this.query.start();
        this.query.open();
        List<DicomObject> result = this.query.query();
        this.query.close();
        this.query.stop();
        return new Vector<DicomObject>(result);
    }

    public Vector<DicomObject> queryPicturesBySeries(DicomObject series) throws Exception {
        this.query.reset();
        this.query.setQueryLevel(DcmQR.QueryRetrieveLevel.IMAGE);
        this.query.addMatchingKey(0x20000E, series.getString(0x20000E));
        this.query.configureTransferCapability(true);
        this.query.start();
        this.query.open();
        List<DicomObject> result = this.query.query();
        this.query.close();
        this.query.stop();
        return new Vector<DicomObject>(result);
    }

    public void moveSeries(Component parent, String destUrl, DicomObject series) throws Exception {
        try {
            this.progressMonitor = new ProgressMonitor(parent, "Moving Series to AET: \r\n" + destUrl, "moving.....", 0, 3);
            this.progressMonitor.setMillisToDecideToPopup(0);
            this.progressMonitor.setMillisToPopup(0);
            this.progressMonitor.setProgress(2);
            this.move(DcmQR.QueryRetrieveLevel.SERIES, destUrl, series);
            this.progressMonitor.close();
        }
        catch (Exception e) {
            this.progressMonitor.close();
            throw e;
        }
    }

    public void moveStudies(Component parent, String destUrl, DicomObject study) throws Exception {
        try {
            this.progressMonitor = new ProgressMonitor(parent, "Moving Studies to AET: \r\n" + destUrl, "moving.....", 0, 3);
            this.progressMonitor.setMillisToDecideToPopup(0);
            this.progressMonitor.setMillisToPopup(0);
            this.progressMonitor.setProgress(2);
            this.move(DcmQR.QueryRetrieveLevel.STUDY, destUrl, study);
            this.progressMonitor.close();
        }
        catch (Exception e) {
            this.progressMonitor.close();
            e.printStackTrace();
            throw e;
        }
    }

    private void move(DcmQR.QueryRetrieveLevel queryRetrieveLevel, String destUrl, DicomObject object) throws Exception {
        DcmQR dcmqr = new DcmQR();
        dcmqr.setRemoteHost(this.url.getHost());
        dcmqr.setRemotePort(this.url.getPort());
        dcmqr.setCalledAET(this.url.getCalledAET(), false);
        if (this.url.getCallingAET() != null) {
            dcmqr.setCalling(this.url.getCallingAET());
        }
        dcmqr.setMoveDest(destUrl);
        dcmqr.setQueryLevel(queryRetrieveLevel);
        if (queryRetrieveLevel.equals((Object)DcmQR.QueryRetrieveLevel.PATIENT)) {
            dcmqr.addMatchingKey(0x100020, object.getString(0x100020));
        } else if (queryRetrieveLevel.equals((Object)DcmQR.QueryRetrieveLevel.STUDY)) {
            dcmqr.addMatchingKey(0x20000D, object.getString(0x20000D));
        } else if (queryRetrieveLevel.equals((Object)DcmQR.QueryRetrieveLevel.SERIES)) {
            dcmqr.addMatchingKey(0x20000E, object.getString(0x20000E));
        } else if (queryRetrieveLevel.equals((Object)DcmQR.QueryRetrieveLevel.IMAGE)) {
            dcmqr.addMatchingKey(524310, object.getString(524310));
        }
        dcmqr.configureTransferCapability(true);
        dcmqr.start();
        dcmqr.open();
        List<DicomObject> result = dcmqr.query();
        dcmqr.move(result);
        dcmqr.close();
        dcmqr.stop();
    }

    public void moveImage(Component parent, String destUrl, DicomObject image) throws Exception {
        try {
            this.progressMonitor = new ProgressMonitor(parent, "Moving Image to AET: \r\n" + destUrl, "moving.....", 0, 3);
            this.progressMonitor.setMillisToDecideToPopup(0);
            this.progressMonitor.setMillisToPopup(0);
            this.progressMonitor.setProgress(2);
            this.move(DcmQR.QueryRetrieveLevel.IMAGE, destUrl, image);
            this.progressMonitor.close();
        }
        catch (Exception e) {
            this.progressMonitor.close();
            throw e;
        }
    }

    public static int moveSeries(DcmURL queryUrl, String destAET, HeaderTag[] filters) throws Exception {
        DcmQR dcmqr = new DcmQR();
        dcmqr.setRemoteHost(queryUrl.getHost());
        dcmqr.setRemotePort(queryUrl.getPort());
        dcmqr.setCalledAET(queryUrl.getCalledAET(), false);
        if (queryUrl.getCallingAET() != null) {
            dcmqr.setCalling(queryUrl.getCallingAET());
        } else {
            dcmqr.setCalling(destAET);
        }
        dcmqr.setMoveDest(destAET);
        dcmqr.setQueryLevel(DcmQR.QueryRetrieveLevel.SERIES);
        if (filters != null) {
            int i = 0;
            while (i < filters.length) {
                HeaderTag tag = filters[i];
                int tagInt = Tag.toTag((String)tag.getTagNr().replaceAll(",", ""));
                dcmqr.addMatchingKey(tagInt, tag.getTagValue());
                ++i;
            }
        }
        dcmqr.configureTransferCapability(true);
        dcmqr.start();
        dcmqr.open();
        List<DicomObject> result = dcmqr.query();
        dcmqr.move(result);
        dcmqr.close();
        dcmqr.stop();
        return result.size();
    }

    public static void main(String[] args) throws Exception {
        try {
            String url = "dicom://OSIRIX";
            url = String.valueOf(url) + "@" + "10.14.1.8" + ":" + "5104";
            DcmURL dcmUrl = new DcmURL(url);
            DicomQuery inst = new DicomQuery(dcmUrl);
            Vector<DicomObject> dos = inst.queryPatients(0x100010, "Anony*");
            for (DicomObject dicomObject : dos) {
                System.out.println(dicomObject);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void close() {
    }
}

