/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.query;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.log4j.Logger;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.UIDDictionary;
import org.dcm4che2.data.VR;
import org.dcm4che2.io.DicomOutputStream;
import org.dcm4che2.net.Association;
import org.dcm4che2.net.CommandUtils;
import org.dcm4che2.net.ConfigurationException;
import org.dcm4che2.net.Device;
import org.dcm4che2.net.DicomServiceException;
import org.dcm4che2.net.DimseRSP;
import org.dcm4che2.net.DimseRSPHandler;
import org.dcm4che2.net.ExtQueryTransferCapability;
import org.dcm4che2.net.ExtRetrieveTransferCapability;
import org.dcm4che2.net.NetworkApplicationEntity;
import org.dcm4che2.net.NetworkConnection;
import org.dcm4che2.net.NewThreadExecutor;
import org.dcm4che2.net.NoPresentationContextException;
import org.dcm4che2.net.PDVInputStream;
import org.dcm4che2.net.TransferCapability;
import org.dcm4che2.net.UserIdentity;
import org.dcm4che2.net.service.DicomService;
import org.dcm4che2.net.service.StorageService;

public class DcmQR {
    private static Logger logger = Logger.getLogger((String)DcmQR.class.getName());
    private static final int KB = 1024;
    private static char[] SECRET = new char[]{'s', 'e', 'c', 'r', 'e', 't'};
    private static final String[] PATIENT_LEVEL_FIND_CUID = new String[]{"1.2.840.10008.5.1.4.1.2.1.1", "1.2.840.10008.5.1.4.1.2.3.1"};
    private static final String[] STUDY_LEVEL_FIND_CUID = new String[]{"1.2.840.10008.5.1.4.1.2.2.1", "1.2.840.10008.5.1.4.1.2.1.1", "1.2.840.10008.5.1.4.1.2.3.1"};
    private static final String[] SERIES_LEVEL_FIND_CUID = new String[]{"1.2.840.10008.5.1.4.1.2.2.1", "1.2.840.10008.5.1.4.1.2.1.1"};
    private static final String[] PATIENT_LEVEL_GET_CUID = new String[]{"1.2.840.10008.5.1.4.1.2.1.3", "1.2.840.10008.5.1.4.1.2.3.3"};
    private static final String[] STUDY_LEVEL_GET_CUID = new String[]{"1.2.840.10008.5.1.4.1.2.2.3", "1.2.840.10008.5.1.4.1.2.1.3", "1.2.840.10008.5.1.4.1.2.3.3"};
    private static final String[] SERIES_LEVEL_GET_CUID = new String[]{"1.2.840.10008.5.1.4.1.2.2.3", "1.2.840.10008.5.1.4.1.2.1.3"};
    private static final String[] PATIENT_LEVEL_MOVE_CUID = new String[]{"1.2.840.10008.5.1.4.1.2.1.2", "1.2.840.10008.5.1.4.1.2.3.2"};
    private static final String[] STUDY_LEVEL_MOVE_CUID = new String[]{"1.2.840.10008.5.1.4.1.2.2.2", "1.2.840.10008.5.1.4.1.2.1.2", "1.2.840.10008.5.1.4.1.2.3.2"};
    private static final String[] SERIES_LEVEL_MOVE_CUID = new String[]{"1.2.840.10008.5.1.4.1.2.2.2", "1.2.840.10008.5.1.4.1.2.1.2"};
    private static final int[] PATIENT_RETURN_KEYS = new int[]{0x100010, 0x100020, 0x100030, 0x100040, 0x201200, 0x201202, 2101764};
    public static final int[] PATIENT_MATCHING_KEYS = new int[]{0x100010, 0x100020, 0x100021, 0x100030, 0x100040};
    private static final int[] STUDY_RETURN_KEYS = new int[]{524320, 524336, 524368, 0x200010, 0x20000D, 2101766, 2101768};
    public static final int[] STUDY_MATCHING_KEYS = new int[]{524320, 524336, 524368, 524385, 524432, 0x200010, 0x20000D};
    public static final int[] PATIENT_STUDY_MATCHING_KEYS = new int[]{524320, 524336, 524368, 524385, 524432, 0x100010, 0x100020, 0x100021, 0x100030, 0x100040, 0x200010, 0x20000D};
    private static final int[] SERIES_RETURN_KEYS = new int[]{524384, 0x200011, 0x20000E, 2101769};
    private static final int[] SERIES_MATCHING_KEYS = new int[]{524384, 0x200011, 0x20000E, 4194933};
    private static final int[] INSTANCE_RETURN_KEYS = new int[]{2097171, 524310, 524312};
    private static final int[] MOVE_KEYS = new int[]{524370, 0x100020, 0x20000D, 0x20000E, 524312};
    private static final String[] IVRLE_TS = new String[]{"1.2.840.10008.1.2"};
    private static final String[] NATIVE_LE_TS = new String[]{"1.2.840.10008.1.2.1", "1.2.840.10008.1.2"};
    private static final String[] NATIVE_BE_TS = new String[]{"1.2.840.10008.1.2.2", "1.2.840.10008.1.2"};
    private static final String[] DEFLATED_TS = new String[]{"1.2.840.10008.1.2.1.99", "1.2.840.10008.1.2.1", "1.2.840.10008.1.2"};
    private static final String[] NOPX_TS = new String[]{"1.2.840.10008.1.2.4.96", "1.2.840.10008.1.2.1", "1.2.840.10008.1.2"};
    private static final String[] NOPXDEFL_TS = new String[]{"1.2.840.10008.1.2.4.97", "1.2.840.10008.1.2.4.96", "1.2.840.10008.1.2.1", "1.2.840.10008.1.2"};
    private static final String[] JPLL_TS = new String[]{"1.2.840.10008.1.2.4.70", "1.2.840.10008.1.2.4.57", "1.2.840.10008.1.2.4.80", "1.2.840.10008.1.2.4.90", "1.2.840.10008.1.2.1", "1.2.840.10008.1.2"};
    private static final String[] JPLY_TS = new String[]{"1.2.840.10008.1.2.4.50", "1.2.840.10008.1.2.4.51", "1.2.840.10008.1.2.4.81", "1.2.840.10008.1.2.4.91", "1.2.840.10008.1.2.1", "1.2.840.10008.1.2"};
    private static final String[] MPEG2_TS = new String[]{"1.2.840.10008.1.2.4.100"};
    private static final String[] DEF_TS = new String[]{"1.2.840.10008.1.2.4.70", "1.2.840.10008.1.2.4.57", "1.2.840.10008.1.2.4.80", "1.2.840.10008.1.2.4.81", "1.2.840.10008.1.2.4.90", "1.2.840.10008.1.2.4.91", "1.2.840.10008.1.2.4.50", "1.2.840.10008.1.2.4.51", "1.2.840.10008.1.2.4.100", "1.2.840.10008.1.2.1.99", "1.2.840.10008.1.2.2", "1.2.840.10008.1.2.1", "1.2.840.10008.1.2"};
    private static final String[] EMPTY_STRING = new String[0];
    private Executor executor = new NewThreadExecutor("DCMQR");
    private NetworkApplicationEntity remoteAE = new NetworkApplicationEntity();
    private NetworkConnection remoteConn = new NetworkConnection();
    private Device device = new Device("DCMQR");
    private NetworkApplicationEntity ae = new NetworkApplicationEntity();
    private NetworkConnection conn = new NetworkConnection();
    private Association assoc;
    private int priority = 0;
    private boolean cget;
    private String moveDest;
    private File storeDest;
    private boolean devnull;
    private int fileBufferSize = 256;
    private boolean evalRetrieveAET = false;
    private QueryRetrieveLevel qrlevel = QueryRetrieveLevel.STUDY;
    private List<String> privateFind = new ArrayList<String>();
    private final List<TransferCapability> storeTransferCapability = new ArrayList<TransferCapability>(8);
    private DicomObject keys = new BasicDicomObject();
    private int cancelAfter = Integer.MAX_VALUE;
    private int completed;
    private int warning;
    private int failed;
    private String errorComment;
    private boolean relationQR;
    private boolean dateTimeMatching;
    private boolean fuzzySemanticPersonNameMatching;
    private boolean noExtNegotiation;
    private String keyStoreURL = "resource:tls/test_sys_1.p12";
    private char[] keyStorePassword = SECRET;
    private char[] keyPassword;
    private String trustStoreURL = "resource:tls/mesa_certs.jks";
    private char[] trustStorePassword = SECRET;
    private final DimseRSPHandler rspHandler = new DimseRSPHandler(){

        public void onDimseRSP(Association as, DicomObject cmd, DicomObject data) {
            DcmQR.this.onMoveRSP(as, cmd, data);
        }
    };

    public DcmQR() {
        this.remoteAE.setInstalled(true);
        this.remoteAE.setAssociationAcceptor(true);
        this.remoteAE.setNetworkConnection(new NetworkConnection[]{this.remoteConn});
        this.device.setNetworkApplicationEntity(this.ae);
        this.device.setNetworkConnection(this.conn);
        this.ae.setNetworkConnection(this.conn);
        this.ae.setAssociationInitiator(true);
        this.ae.setAssociationAcceptor(true);
        this.ae.setAETitle("DCMQR");
    }

    public final void setLocalHost(String hostname) {
        this.conn.setHostname(hostname);
    }

    public final void setLocalPort(int port) {
        this.conn.setPort(port);
    }

    public final void setRemoteHost(String hostname) {
        this.remoteConn.setHostname(hostname);
    }

    public final void setRemotePort(int port) {
        this.remoteConn.setPort(port);
    }

    public final void setTlsWithoutEncyrption() {
        this.conn.setTlsWithoutEncyrption();
        this.remoteConn.setTlsWithoutEncyrption();
    }

    public final void setTls3DES_EDE_CBC() {
        this.conn.setTls3DES_EDE_CBC();
        this.remoteConn.setTls3DES_EDE_CBC();
    }

    public final void setTlsAES_128_CBC() {
        this.conn.setTlsAES_128_CBC();
        this.remoteConn.setTlsAES_128_CBC();
    }

    public final void disableSSLv2Hello() {
        this.conn.disableSSLv2Hello();
    }

    public final void setTlsNeedClientAuth(boolean needClientAuth) {
        this.conn.setTlsNeedClientAuth(needClientAuth);
    }

    public final void setKeyStoreURL(String url) {
        this.keyStoreURL = url;
    }

    public final void setKeyStorePassword(String pw) {
        this.keyStorePassword = pw.toCharArray();
    }

    public final void setKeyPassword(String pw) {
        this.keyPassword = pw.toCharArray();
    }

    public final void setTrustStorePassword(String pw) {
        this.trustStorePassword = pw.toCharArray();
    }

    public final void setTrustStoreURL(String url) {
        this.trustStoreURL = url;
    }

    public final void setCalledAET(String called, boolean reuse) {
        this.remoteAE.setAETitle(called);
        if (reuse) {
            this.ae.setReuseAssocationToAETitle(new String[]{called});
        }
    }

    public final void setCalling(String calling) {
        this.ae.setAETitle(calling);
    }

    public final void setUserIdentity(UserIdentity userIdentity) {
        this.ae.setUserIdentity(userIdentity);
    }

    public final void setPriority(int priority) {
        this.priority = priority;
    }

    public final void setConnectTimeout(int connectTimeout) {
        this.conn.setConnectTimeout(connectTimeout);
    }

    public final void setMaxPDULengthReceive(int maxPDULength) {
        this.ae.setMaxPDULengthReceive(maxPDULength);
    }

    public final void setMaxOpsInvoked(int maxOpsInvoked) {
        this.ae.setMaxOpsInvoked(maxOpsInvoked);
    }

    public final void setMaxOpsPerformed(int maxOps) {
        this.ae.setMaxOpsPerformed(maxOps);
    }

    public final void setPackPDV(boolean packPDV) {
        this.ae.setPackPDV(packPDV);
    }

    public final void setAssociationReaperPeriod(int period) {
        this.device.setAssociationReaperPeriod(period);
    }

    public final void setDimseRspTimeout(int timeout) {
        this.ae.setDimseRspTimeout(timeout);
    }

    public final void setTcpNoDelay(boolean tcpNoDelay) {
        this.conn.setTcpNoDelay(tcpNoDelay);
    }

    public final void setAcceptTimeout(int timeout) {
        this.conn.setAcceptTimeout(timeout);
    }

    public final void setReleaseTimeout(int timeout) {
        this.conn.setReleaseTimeout(timeout);
    }

    public final void setSocketCloseDelay(int timeout) {
        this.conn.setSocketCloseDelay(timeout);
    }

    public final void setMaxPDULengthSend(int maxPDULength) {
        this.ae.setMaxPDULengthSend(maxPDULength);
    }

    public final void setReceiveBufferSize(int bufferSize) {
        this.conn.setReceiveBufferSize(bufferSize);
    }

    public final void setSendBufferSize(int bufferSize) {
        this.conn.setSendBufferSize(bufferSize);
    }

    public final void setFileBufferSize(int size) {
        this.fileBufferSize = size;
    }

    public static void main(String[] args) {
        DcmQR dcmqr = new DcmQR();
        dcmqr.setCalledAET("OSIRIX", true);
        dcmqr.setRemoteHost("10.14.1.8");
        dcmqr.setRemotePort(5104);
        dcmqr.setQueryLevel(QueryRetrieveLevel.STUDY);
        dcmqr.addMatchingKey(0x100010, "Anonymous Male 19*");
        dcmqr.addReturnKey(524384);
        dcmqr.configureTransferCapability(true);
        try {
            dcmqr.start();
            dcmqr.open();
            List<DicomObject> result = dcmqr.query();
            dcmqr.close();
            dcmqr.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addStoreTransferCapability(String cuid, String[] tsuids) {
        this.storeTransferCapability.add(new TransferCapability(cuid, tsuids, "SCP"));
    }

    private void setEvalRetrieveAET(boolean evalRetrieveAET) {
        this.evalRetrieveAET = evalRetrieveAET;
    }

    private boolean isEvalRetrieveAET() {
        return this.evalRetrieveAET;
    }

    private void setNoExtNegotiation(boolean b) {
        this.noExtNegotiation = b;
    }

    private void setFuzzySemanticPersonNameMatching(boolean b) {
        this.fuzzySemanticPersonNameMatching = b;
    }

    private void setDateTimeMatching(boolean b) {
        this.dateTimeMatching = b;
    }

    private void setRelationQR(boolean b) {
        this.relationQR = b;
    }

    public final int getFailed() {
        return this.failed;
    }

    public final int getWarning() {
        return this.warning;
    }

    private final int getTotalRetrieved() {
        return this.completed + this.warning;
    }

    private void setCancelAfter(int limit) {
        this.cancelAfter = limit;
    }

    private void addMatchingKey(int[] tagPath, String value) {
        this.keys.putString(tagPath, null, value);
    }

    public void addMatchingKey(int tag, String value) {
        this.keys.putString(tag, null, value);
    }

    private void addReturnKey(int[] tagPath) {
        this.keys.putNull(tagPath, null);
    }

    void addReturnKey(int tag) {
        this.keys.putNull(tag, null);
    }

    public void configureTransferCapability(boolean ivrle) {
        String cuid2;
        String[] findcuids = this.qrlevel.getFindClassUids();
        String[] movecuids = this.moveDest != null ? this.qrlevel.getMoveClassUids() : EMPTY_STRING;
        String[] getcuids = this.cget ? this.qrlevel.getGetClassUids() : EMPTY_STRING;
        TransferCapability[] tcs = new TransferCapability[findcuids.length + this.privateFind.size() + movecuids.length + getcuids.length + this.storeTransferCapability.size()];
        int i = 0;
        String[] stringArray = findcuids;
        int n = findcuids.length;
        int n2 = 0;
        while (n2 < n) {
            cuid2 = stringArray[n2];
            tcs[i++] = this.mkFindTC(cuid2, ivrle ? IVRLE_TS : NATIVE_LE_TS);
            ++n2;
        }
        for (String cuid2 : this.privateFind) {
            tcs[i++] = this.mkFindTC(cuid2, ivrle ? IVRLE_TS : DEFLATED_TS);
        }
        stringArray = movecuids;
        n = movecuids.length;
        int n3 = 0;
        while (n3 < n) {
            cuid2 = stringArray[n3];
            tcs[i++] = this.mkRetrieveTC(cuid2, ivrle ? IVRLE_TS : NATIVE_LE_TS);
            ++n3;
        }
        stringArray = getcuids;
        n = getcuids.length;
        n3 = 0;
        while (n3 < n) {
            cuid2 = stringArray[n3];
            tcs[i++] = this.mkRetrieveTC(cuid2, ivrle ? IVRLE_TS : NATIVE_LE_TS);
            ++n3;
        }
        for (TransferCapability tc : this.storeTransferCapability) {
            tcs[i++] = tc;
        }
        this.ae.setTransferCapability(tcs);
        if (!this.storeTransferCapability.isEmpty()) {
            this.ae.register(this.createStorageService());
        }
    }

    private DicomService createStorageService() {
        String[] cuids = new String[this.storeTransferCapability.size()];
        int i = 0;
        for (TransferCapability tc : this.storeTransferCapability) {
            cuids[i++] = tc.getSopClass();
        }
        return new StorageService(cuids){

            protected void onCStoreRQ(Association as, int pcid, DicomObject rq, PDVInputStream dataStream, String tsuid, DicomObject rsp) throws IOException, DicomServiceException {
                if (DcmQR.this.storeDest == null) {
                    super.onCStoreRQ(as, pcid, rq, dataStream, tsuid, rsp);
                } else {
                    try {
                        String cuid = rq.getString(2);
                        String iuid = rq.getString(4096);
                        BasicDicomObject fmi = new BasicDicomObject();
                        fmi.initFileMetaInformation(cuid, iuid, tsuid);
                        File file = DcmQR.this.devnull ? DcmQR.this.storeDest : new File(DcmQR.this.storeDest, iuid);
                        FileOutputStream fos = new FileOutputStream(file);
                        BufferedOutputStream bos = new BufferedOutputStream(fos, DcmQR.this.fileBufferSize);
                        DicomOutputStream dos = new DicomOutputStream((OutputStream)bos);
                        dos.writeFileMetaInformation((DicomObject)fmi);
                        dataStream.copyTo((OutputStream)dos);
                        dos.close();
                    }
                    catch (IOException e) {
                        throw new DicomServiceException(rq, 272, e.getMessage());
                    }
                }
            }
        };
    }

    private TransferCapability mkRetrieveTC(String cuid, String[] ts) {
        ExtRetrieveTransferCapability tc = new ExtRetrieveTransferCapability(cuid, ts, "SCU");
        tc.setExtInfoBoolean(0, this.relationQR);
        if (this.noExtNegotiation) {
            tc.setExtInfo(null);
        }
        return tc;
    }

    private TransferCapability mkFindTC(String cuid, String[] ts) {
        ExtQueryTransferCapability tc = new ExtQueryTransferCapability(cuid, ts, "SCU");
        tc.setExtInfoBoolean(0, this.relationQR);
        tc.setExtInfoBoolean(1, this.dateTimeMatching);
        tc.setExtInfoBoolean(2, this.fuzzySemanticPersonNameMatching);
        if (this.noExtNegotiation) {
            tc.setExtInfo(null);
        }
        return tc;
    }

    public void setQueryLevel(QueryRetrieveLevel qrlevel) {
        this.qrlevel = qrlevel;
        this.keys.putString(524370, VR.CS, qrlevel.getCode());
        int[] nArray = qrlevel.getReturnKeys();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int tag = nArray[n2];
            this.keys.putNull(tag, null);
            ++n2;
        }
    }

    public final void addPrivate(String cuid) {
        this.privateFind.add(cuid);
    }

    private void setCGet(boolean cget) {
        this.cget = cget;
    }

    private boolean isCGet() {
        return this.cget;
    }

    public void setMoveDest(String aet) {
        this.moveDest = aet;
    }

    private boolean isCMove() {
        return this.moveDest != null;
    }

    private static int toPort(String port) {
        return port != null ? DcmQR.parseInt(port, "illegal port number", 1, 65535) : 104;
    }

    private static int parseInt(String s, String errPrompt, int min, int max) {
        try {
            int i = Integer.parseInt(s);
            if (i >= min && i <= max) {
                return i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        DcmQR.exit(errPrompt);
        throw new RuntimeException();
    }

    private static String[] split(String s, char delim) {
        String[] stringArray = new String[2];
        stringArray[0] = s;
        String[] s2 = stringArray;
        int pos = s.indexOf(delim);
        if (pos != -1) {
            s2[0] = s.substring(0, pos);
            s2[1] = s.substring(pos + 1);
        }
        return s2;
    }

    private static void exit(String msg) {
        System.err.println(msg);
        System.err.println("Try 'dcmqr -h' for more information.");
        System.exit(1);
    }

    public void start() throws IOException {
        if (this.conn.isListening()) {
            this.conn.bind(this.executor);
            System.out.println("Start Server listening on port " + this.conn.getPort());
        }
    }

    public void stop() {
        if (this.conn.isListening()) {
            this.conn.unbind();
        }
    }

    public void open() throws IOException, ConfigurationException, InterruptedException {
        this.assoc = this.ae.connect(this.remoteAE, this.executor);
    }

    public List<DicomObject> query() throws IOException, InterruptedException {
        this.errorComment = null;
        ArrayList<DicomObject> result = new ArrayList<DicomObject>();
        TransferCapability tc = this.selectFindTransferCapability();
        String cuid = tc.getSopClass();
        String tsuid = this.selectTransferSyntax(tc);
        if (tc.getExtInfoBoolean(0) || this.containsUpperLevelUIDs(cuid)) {
            logger.info((Object)("Send Query Request using: \n" + this.keys + " to " + this.remoteAE.getAETitle()));
            DimseRSP rsp = this.assoc.cfind(cuid, this.priority, this.keys, tsuid, this.cancelAfter);
            while (rsp.next()) {
                DicomObject cmd = rsp.getCommand();
                if (!CommandUtils.isPending((DicomObject)cmd)) continue;
                if (cmd.getString(2307) != null || cmd.getString(2306) != null) {
                    this.errorComment = "ErrorID:" + cmd.getString(2307) + " ErrorComment:" + cmd.getString(2306);
                }
                DicomObject data = rsp.getDataset();
                result.add(data);
                logger.info((Object)("Query Response: " + Integer.valueOf(result.size())));
            }
        } else {
            List<DicomObject> upperLevelUIDs = this.queryUpperLevelUIDs(cuid, tsuid);
            ArrayList<DimseRSP> rspList = new ArrayList<DimseRSP>(upperLevelUIDs.size());
            int i = 0;
            int n = upperLevelUIDs.size();
            while (i < n) {
                upperLevelUIDs.get(i).copyTo(this.keys);
                logger.info((Object)("Send Query Request  \n" + this.keys + " to " + this.remoteAE.getAETitle()));
                rspList.add(this.assoc.cfind(cuid, this.priority, this.keys, tsuid, this.cancelAfter));
                ++i;
            }
            i = 0;
            n = rspList.size();
            while (i < n) {
                DimseRSP rsp = (DimseRSP)rspList.get(i);
                int j = 0;
                while (rsp.next()) {
                    DicomObject cmd = rsp.getCommand();
                    if (CommandUtils.isPending((DicomObject)cmd)) {
                        if (cmd.getString(2307) != null || cmd.getString(2306) != null) {
                            this.errorComment = String.valueOf(cmd.getString(2307)) + " " + cmd.getString(2306);
                        }
                        DicomObject data = rsp.getDataset();
                        result.add(data);
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (this.errorComment != null) {
            throw new IOException("DICOM Query Error: " + this.errorComment);
        }
        return result;
    }

    private boolean containsUpperLevelUIDs(String cuid) {
        switch (this.qrlevel) {
            case IMAGE: {
                if (!this.keys.containsValue(0x20000E)) {
                    return false;
                }
            }
            case SERIES: {
                if (!this.keys.containsValue(0x20000D)) {
                    return false;
                }
            }
            case STUDY: {
                if (!Arrays.asList(PATIENT_LEVEL_FIND_CUID).contains(cuid) || this.keys.containsValue(0x100020)) break;
                return false;
            }
        }
        return true;
    }

    private List<DicomObject> queryUpperLevelUIDs(String cuid, String tsuid) throws IOException, InterruptedException {
        List<DicomObject> keylist = new ArrayList<DicomObject>();
        if (Arrays.asList(PATIENT_LEVEL_FIND_CUID).contains(cuid)) {
            this.queryPatientIDs(cuid, tsuid, keylist);
            if (this.qrlevel == QueryRetrieveLevel.STUDY) {
                return keylist;
            }
            keylist = this.queryStudyOrSeriesIUIDs(cuid, tsuid, keylist, 0x20000D, STUDY_MATCHING_KEYS, QueryRetrieveLevel.STUDY);
        } else {
            keylist.add((DicomObject)new BasicDicomObject());
            keylist = this.queryStudyOrSeriesIUIDs(cuid, tsuid, keylist, 0x20000D, PATIENT_STUDY_MATCHING_KEYS, QueryRetrieveLevel.STUDY);
        }
        if (this.qrlevel == QueryRetrieveLevel.IMAGE) {
            keylist = this.queryStudyOrSeriesIUIDs(cuid, tsuid, keylist, 0x20000E, SERIES_MATCHING_KEYS, QueryRetrieveLevel.SERIES);
        }
        return keylist;
    }

    private void queryPatientIDs(String cuid, String tsuid, List<DicomObject> keylist) throws IOException, InterruptedException {
        String patID = this.keys.getString(0x100020);
        String issuer = this.keys.getString(0x100021);
        if (patID != null) {
            BasicDicomObject patIdKeys = new BasicDicomObject();
            patIdKeys.putString(0x100020, VR.LO, patID);
            if (issuer != null) {
                patIdKeys.putString(0x100021, VR.LO, issuer);
            }
            keylist.add((DicomObject)patIdKeys);
        } else {
            BasicDicomObject patLevelQuery = new BasicDicomObject();
            this.keys.subSet(PATIENT_MATCHING_KEYS).copyTo((DicomObject)patLevelQuery);
            patLevelQuery.putNull(0x100020, VR.LO);
            patLevelQuery.putNull(0x100021, VR.LO);
            patLevelQuery.putString(524370, VR.CS, "PATIENT");
            logger.info((Object)("Send Query Request using " + patLevelQuery));
            DimseRSP rsp = this.assoc.cfind(cuid, this.priority, (DicomObject)patLevelQuery, tsuid, Integer.MAX_VALUE);
            int i = 0;
            while (rsp.next()) {
                DicomObject cmd = rsp.getCommand();
                if (CommandUtils.isPending((DicomObject)cmd)) {
                    DicomObject data = rsp.getDataset();
                    logger.info((Object)("Query Response \n" + data));
                    BasicDicomObject patIdKeys = new BasicDicomObject();
                    patIdKeys.putString(0x100020, VR.LO, data.getString(0x100020));
                    issuer = this.keys.getString(0x100021);
                    if (issuer != null) {
                        patIdKeys.putString(0x100021, VR.LO, issuer);
                    }
                    keylist.add((DicomObject)patIdKeys);
                }
                ++i;
            }
        }
    }

    private List<DicomObject> queryStudyOrSeriesIUIDs(String cuid, String tsuid, List<DicomObject> upperLevelIDs, int uidTag, int[] matchingKeys, QueryRetrieveLevel qrLevel) throws IOException, InterruptedException {
        ArrayList<DicomObject> keylist = new ArrayList<DicomObject>();
        String uid = this.keys.getString(uidTag);
        for (DicomObject upperLevelID : upperLevelIDs) {
            if (uid != null) {
                BasicDicomObject suidKey = new BasicDicomObject();
                upperLevelID.copyTo((DicomObject)suidKey);
                suidKey.putString(uidTag, VR.UI, uid);
                keylist.add((DicomObject)suidKey);
                continue;
            }
            BasicDicomObject keys2 = new BasicDicomObject();
            this.keys.subSet(matchingKeys).copyTo((DicomObject)keys2);
            upperLevelID.copyTo((DicomObject)keys2);
            keys2.putNull(uidTag, VR.UI);
            keys2.putString(524370, VR.CS, qrLevel.getCode());
            logger.info((Object)("Send Query Request using " + keys2));
            DimseRSP rsp = this.assoc.cfind(cuid, this.priority, (DicomObject)keys2, tsuid, Integer.MAX_VALUE);
            int i = 0;
            while (rsp.next()) {
                DicomObject cmd = rsp.getCommand();
                if (CommandUtils.isPending((DicomObject)cmd)) {
                    DicomObject data = rsp.getDataset();
                    logger.info((Object)("Query Response: \n" + data));
                    BasicDicomObject suidKey = new BasicDicomObject();
                    upperLevelID.copyTo((DicomObject)suidKey);
                    suidKey.putString(uidTag, VR.UI, data.getString(uidTag));
                    keylist.add((DicomObject)suidKey);
                }
                ++i;
            }
        }
        return keylist;
    }

    private TransferCapability selectFindTransferCapability() throws NoPresentationContextException {
        TransferCapability tc = this.selectTransferCapability(this.privateFind);
        if (tc != null) {
            return tc;
        }
        tc = this.selectTransferCapability(this.qrlevel.getFindClassUids());
        if (tc != null) {
            return tc;
        }
        throw new NoPresentationContextException(String.valueOf(UIDDictionary.getDictionary().prompt(this.qrlevel.getFindClassUids()[0])) + " not supported by " + this.remoteAE.getAETitle());
    }

    private String selectTransferSyntax(TransferCapability tc) {
        String[] tcuids = tc.getTransferSyntax();
        if (Arrays.asList(tcuids).indexOf("1.2.840.10008.1.2.1.99") != -1) {
            return "1.2.840.10008.1.2.1.99";
        }
        return tcuids[0];
    }

    public void move(List<DicomObject> findResults) throws IOException, InterruptedException {
        this.errorComment = null;
        if (this.moveDest == null) {
            throw new IllegalStateException("moveDest == null");
        }
        TransferCapability tc = this.selectTransferCapability(this.qrlevel.getMoveClassUids());
        if (tc == null) {
            throw new NoPresentationContextException(String.valueOf(UIDDictionary.getDictionary().prompt(this.qrlevel.getMoveClassUids()[0])) + " not supported by" + this.remoteAE.getAETitle());
        }
        String cuid = tc.getSopClass();
        String tsuid = this.selectTransferSyntax(tc);
        int i = 0;
        int n = Math.min(findResults.size(), this.cancelAfter);
        while (i < n) {
            DicomObject keys = findResults.get(i).subSet(MOVE_KEYS);
            if (this.isEvalRetrieveAET() && this.moveDest.equals(findResults.get(i).getString(524372))) {
                logger.info((Object)("Skipping " + keys));
            } else {
                logger.info((Object)("Send Retrieve Request using " + keys));
                this.assoc.cmove(cuid, this.priority, keys, tsuid, this.moveDest, this.rspHandler);
            }
            if (this.errorComment != null) {
                throw new IOException("DICOM MOVE Error: " + this.errorComment);
            }
            ++i;
        }
        this.assoc.waitForDimseRSP();
        if (this.errorComment != null) {
            throw new IOException("DICOM MOVE Error: " + this.errorComment);
        }
    }

    public void get(List<DicomObject> findResults) throws IOException, InterruptedException {
        TransferCapability tc = this.selectTransferCapability(this.qrlevel.getGetClassUids());
        if (tc == null) {
            throw new NoPresentationContextException(String.valueOf(UIDDictionary.getDictionary().prompt(this.qrlevel.getGetClassUids()[0])) + " not supported by" + this.remoteAE.getAETitle());
        }
        String cuid = tc.getSopClass();
        String tsuid = this.selectTransferSyntax(tc);
        int i = 0;
        int n = Math.min(findResults.size(), this.cancelAfter);
        while (i < n) {
            DicomObject keys = findResults.get(i).subSet(MOVE_KEYS);
            logger.info((Object)("Send Retrieve Request using " + keys));
            this.assoc.cget(cuid, this.priority, keys, tsuid, this.rspHandler);
            ++i;
        }
        this.assoc.waitForDimseRSP();
    }

    protected void onMoveRSP(Association as, DicomObject cmd, DicomObject data) {
        if (!CommandUtils.isPending((DicomObject)cmd)) {
            this.completed += cmd.getInt(4129);
            this.warning += cmd.getInt(4131);
            this.failed += cmd.getInt(4130);
            if (cmd.getString(2307) != null || cmd.getString(2306) != null) {
                this.errorComment = "ErrorID:" + cmd.getString(2307) + " ErrorComment:" + cmd.getString(2306);
            }
        }
    }

    private TransferCapability selectTransferCapability(String[] cuid) {
        int i = 0;
        while (i < cuid.length) {
            TransferCapability tc = this.assoc.getTransferCapabilityAsSCU(cuid[i]);
            if (tc != null) {
                return tc;
            }
            ++i;
        }
        return null;
    }

    private TransferCapability selectTransferCapability(List<String> cuid) {
        int i = 0;
        int n = cuid.size();
        while (i < n) {
            TransferCapability tc = this.assoc.getTransferCapabilityAsSCU(cuid.get(i));
            if (tc != null) {
                return tc;
            }
            ++i;
        }
        return null;
    }

    public void close() throws InterruptedException {
        this.assoc.release(true);
    }

    private void setStoreDestination(String filePath) {
        this.storeDest = new File(filePath);
        this.devnull = "/dev/null".equals(filePath);
        if (!this.devnull) {
            this.storeDest.mkdir();
        }
    }

    public void initTLS() throws GeneralSecurityException, IOException {
        KeyStore keyStore = DcmQR.loadKeyStore(this.keyStoreURL, this.keyStorePassword);
        KeyStore trustStore = DcmQR.loadKeyStore(this.trustStoreURL, this.trustStorePassword);
        this.device.initTLS(keyStore, this.keyPassword != null ? this.keyPassword : this.keyStorePassword, trustStore);
    }

    private static KeyStore loadKeyStore(String url, char[] password) throws GeneralSecurityException, IOException {
        KeyStore key = KeyStore.getInstance(DcmQR.toKeyStoreType(url));
        InputStream in = DcmQR.openFileOrURL(url);
        try {
            key.load(in, password);
        }
        finally {
            in.close();
        }
        return key;
    }

    private static InputStream openFileOrURL(String url) throws IOException {
        if (url.startsWith("resource:")) {
            return DcmQR.class.getClassLoader().getResourceAsStream(url.substring(9));
        }
        try {
            return new URL(url).openStream();
        }
        catch (MalformedURLException e) {
            return new FileInputStream(url);
        }
    }

    private static String toKeyStoreType(String fname) {
        return fname.endsWith(".p12") || fname.endsWith(".P12") ? "PKCS12" : "JKS";
    }

    public void reset() {
        this.keys = new BasicDicomObject();
    }

    public String getErrorComment() {
        return this.errorComment;
    }

    static /* synthetic */ int[] access$0() {
        return PATIENT_RETURN_KEYS;
    }

    static /* synthetic */ String[] access$1() {
        return PATIENT_LEVEL_FIND_CUID;
    }

    static /* synthetic */ String[] access$2() {
        return PATIENT_LEVEL_GET_CUID;
    }

    static /* synthetic */ String[] access$3() {
        return PATIENT_LEVEL_MOVE_CUID;
    }

    static /* synthetic */ int[] access$4() {
        return STUDY_RETURN_KEYS;
    }

    static /* synthetic */ String[] access$5() {
        return STUDY_LEVEL_FIND_CUID;
    }

    static /* synthetic */ String[] access$6() {
        return STUDY_LEVEL_GET_CUID;
    }

    static /* synthetic */ String[] access$7() {
        return STUDY_LEVEL_MOVE_CUID;
    }

    static /* synthetic */ int[] access$8() {
        return SERIES_RETURN_KEYS;
    }

    static /* synthetic */ String[] access$9() {
        return SERIES_LEVEL_FIND_CUID;
    }

    static /* synthetic */ String[] access$10() {
        return SERIES_LEVEL_GET_CUID;
    }

    static /* synthetic */ String[] access$11() {
        return SERIES_LEVEL_MOVE_CUID;
    }

    static /* synthetic */ int[] access$12() {
        return INSTANCE_RETURN_KEYS;
    }

    static /* synthetic */ String[] access$13() {
        return IVRLE_TS;
    }

    static /* synthetic */ String[] access$14() {
        return NATIVE_LE_TS;
    }

    static /* synthetic */ String[] access$15() {
        return NATIVE_BE_TS;
    }

    static /* synthetic */ String[] access$16() {
        return DEFLATED_TS;
    }

    static /* synthetic */ String[] access$17() {
        return JPLL_TS;
    }

    static /* synthetic */ String[] access$18() {
        return JPLY_TS;
    }

    static /* synthetic */ String[] access$19() {
        return MPEG2_TS;
    }

    static /* synthetic */ String[] access$20() {
        return NOPX_TS;
    }

    static /* synthetic */ String[] access$21() {
        return NOPXDEFL_TS;
    }

    private static enum CUID {
        CR("1.2.840.10008.5.1.4.1.1.1"),
        CT("1.2.840.10008.5.1.4.1.1.2"),
        MR("1.2.840.10008.5.1.4.1.1.4"),
        US("1.2.840.10008.5.1.4.1.1.6.1"),
        NM("1.2.840.10008.5.1.4.1.1.20"),
        SC("1.2.840.10008.5.1.4.1.1.7"),
        XA("1.2.840.10008.5.1.4.1.1.12.1"),
        XRF("1.2.840.10008.5.1.4.1.1.12.2"),
        DX("1.2.840.10008.5.1.4.1.1.1.1"),
        MG("1.2.840.10008.5.1.4.1.1.1.2"),
        PR("1.2.840.10008.5.1.4.1.1.11.1"),
        KO("1.2.840.10008.5.1.4.1.1.88.59"),
        SR("1.2.840.10008.5.1.4.1.1.88.11");

        final String uid;

        private CUID(String uid) {
            this.uid = uid;
        }
    }

    public static enum QueryRetrieveLevel {
        PATIENT("PATIENT", DcmQR.access$0(), DcmQR.access$1(), DcmQR.access$2(), DcmQR.access$3()),
        STUDY("STUDY", DcmQR.access$4(), DcmQR.access$5(), DcmQR.access$6(), DcmQR.access$7()),
        SERIES("SERIES", DcmQR.access$8(), DcmQR.access$9(), DcmQR.access$10(), DcmQR.access$11()),
        IMAGE("IMAGE", DcmQR.access$12(), DcmQR.access$9(), DcmQR.access$10(), DcmQR.access$11());

        private final String code;
        private final int[] returnKeys;
        private final String[] findClassUids;
        private final String[] getClassUids;
        private final String[] moveClassUids;

        private QueryRetrieveLevel(String code, int[] returnKeys, String[] findClassUids, String[] getClassUids, String[] moveClassUids) {
            this.code = code;
            this.returnKeys = returnKeys;
            this.findClassUids = findClassUids;
            this.getClassUids = getClassUids;
            this.moveClassUids = moveClassUids;
        }

        public String getCode() {
            return this.code;
        }

        public int[] getReturnKeys() {
            return this.returnKeys;
        }

        public String[] getFindClassUids() {
            return this.findClassUids;
        }

        public String[] getGetClassUids() {
            return this.getClassUids;
        }

        public String[] getMoveClassUids() {
            return this.moveClassUids;
        }
    }

    private static enum TS {
        IVLE(DcmQR.access$13()),
        LE(DcmQR.access$14()),
        BE(DcmQR.access$15()),
        DEFL(DcmQR.access$16()),
        JPLL(DcmQR.access$17()),
        JPLY(DcmQR.access$18()),
        MPEG2(DcmQR.access$19()),
        NOPX(DcmQR.access$20()),
        NOPXD(DcmQR.access$21());

        final String[] uids;

        private TS(String[] uids) {
            this.uids = uids;
        }
    }
}

