/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.viewer;

import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileInfo;
import ij.measure.Calibration;
import ij.plugin.DICOM;
import ij.process.ImageProcessor;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import javax.swing.ProgressMonitor;
import lu.tudor.santec.dicom.DicomOpener;
import lu.tudor.santec.dicom.OverlayExtractor;
import lu.tudor.santec.dicom.gui.header.DicomHeader;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Series
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int thumbSize = 64;
    private String seriesInfo = "";
    private ArrayList<String> seriesImageFiles = new ArrayList();
    private LinkedHashMap<String, ImagePlus> seriesImages = new LinkedHashMap();
    private static Logger logger = Logger.getLogger((String)Series.class.getName());
    private double size = 0.0;
    private int currentImage = 0;
    private String memorySize;
    private NumberFormat nf = NumberFormat.getInstance();
    protected ImagePlus imagePlus;
    protected JToggleButton button;
    protected String ID;
    private File[] files;

    /*
     * WARNING - void declaration
     */
    public Series(File[] imageFiles, boolean inMemory, boolean openViaImageJ) {
        if (imageFiles == null || imageFiles.length == 0) {
            logger.info((Object)"No Images to create Series.....");
            return;
        }
        this.files = imageFiles;
        ProgressMonitor progressMonitor = new ProgressMonitor(null, "Loading DICOM Series", "preparing", 0, imageFiles.length * 10);
        progressMonitor.setMillisToDecideToPopup(200);
        this.ID = String.valueOf(System.currentTimeMillis());
        this.nf.setMaximumFractionDigits(2);
        boolean imageFound = false;
        int progress = 0;
        int i = 0;
        while (i < imageFiles.length) {
            if (imageFiles[i].canRead() && !imageFiles[i].isDirectory()) {
                try {
                    if (progressMonitor.isCanceled()) break;
                    progress = i * 10;
                    progressMonitor.setNote("img  ( " + (i + 1) + " of " + (imageFiles.length + 1) + " )");
                    progressMonitor.setProgress(progress);
                    this.imagePlus = DicomOpener.loadImageStack(imageFiles[i], null, null, openViaImageJ);
                    if (this.imagePlus == null) {
                        return;
                    }
                    Properties p = this.imagePlus.getProperties();
                    Calibration c = this.imagePlus.getCalibration();
                    this.size += (double)imageFiles[i].length();
                    ImageStack is = this.imagePlus.getStack();
                    FileInfo fi = this.imagePlus.getOriginalFileInfo();
                    int j = 1;
                    while (j < is.getSize() + 1) {
                        progressMonitor.setNote("img ( " + (i + 1) + " of " + (imageFiles.length + 1) + " slice:" + j + " )");
                        progressMonitor.setProgress(progress++);
                        String imageName = String.valueOf(imageFiles[i].getAbsolutePath()) + "#" + j;
                        this.seriesImageFiles.add(imageName);
                        this.imagePlus = new ImagePlus(imageName, is.getProcessor(j));
                        this.imagePlus.setFileInfo(fi);
                        this.imagePlus.setCalibration(c);
                        try {
                            for (String string : p.keySet()) {
                                this.imagePlus.setProperty(string, p.get(string));
                            }
                        }
                        catch (Exception e) {
                            System.out.println("File has no DICOM Header...");
                            e.printStackTrace();
                        }
                        if (!imageFound) {
                            void var15_22;
                            this.imagePlus.getProcessor().getMax();
                            DicomHeader dh = new DicomHeader(new File(imageFiles[i].getAbsolutePath()));
                            String string = dh.getHeaderStringValue(0x100010);
                            if (string.length() > 12) {
                                String string2 = string.substring(0, 11);
                            }
                            String birthdate = dh.getHeaderStringValue(0x100030);
                            try {
                                birthdate = String.valueOf(birthdate.substring(6, 8)) + "." + birthdate.substring(4, 6) + "." + birthdate.substring(0, 4);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            String seriesdate = dh.getHeaderStringValue(524321);
                            try {
                                seriesdate = String.valueOf(seriesdate.substring(6, 8)) + "." + seriesdate.substring(4, 6) + "." + seriesdate.substring(0, 4);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            this.ID = dh.getHeaderStringValue(0x20000E);
                            this.seriesInfo = "Name: " + (String)var15_22 + "<br>" + "Birthdate: " + birthdate + "<br>" + "Sex: " + dh.getHeaderStringValue(0x100040) + "  &nbsp;&nbsp;&nbsp;  Modality: " + dh.getHeaderStringValue(524384) + "<br>" + "Series Date: " + seriesdate + "<br>" + "Body Part: " + dh.getHeaderStringValue(1572885) + "</p>";
                            if (inMemory) {
                                this.seriesImages.put(imageName, this.imagePlus);
                            }
                            imageFound = true;
                        } else if (inMemory) {
                            this.seriesImages.put(imageName, this.imagePlus);
                        }
                        ++j;
                    }
                }
                catch (Exception e) {
                    logger.log((Priority)Level.WARN, (Object)"File has no dicomheader", (Throwable)e);
                }
            }
            ++i;
        }
        progressMonitor.close();
        this.memorySize = this.nf.format(this.size / 1024.0 / 1024.0);
        String buttonText = "<html><body><p align=\"left\" >Slice: " + (this.currentImage + 1) + "/" + this.seriesImageFiles.size() + " size: " + this.memorySize + "mb<br>" + this.seriesInfo;
        this.button = new JToggleButton(buttonText, this.getThumb(this.imagePlus));
    }

    /*
     * WARNING - void declaration
     */
    public Series(Collection<byte[]> images) {
        if (images == null || images.size() == 0) {
            logger.info((Object)"No Images to create Series.....");
            return;
        }
        ProgressMonitor progressMonitor = new ProgressMonitor(null, "Loading DICOM Series", "preparing", 0, images.size());
        progressMonitor.setMillisToDecideToPopup(200);
        this.ID = String.valueOf(System.currentTimeMillis());
        this.nf.setMaximumFractionDigits(2);
        boolean imageFound = false;
        int i = 0;
        for (byte[] imgBytes : images) {
            try {
                if (progressMonitor.isCanceled()) break;
                progressMonitor.setNote("img  ( " + (i + 1) + " of " + (images.size() + 1) + " )");
                progressMonitor.setProgress(i);
                BufferedInputStream bIn = new BufferedInputStream(new ByteArrayInputStream(imgBytes));
                DICOM dic = new DICOM(bIn);
                dic.run(String.valueOf(i));
                this.imagePlus = dic;
                Properties p = this.imagePlus.getProperties();
                Calibration c = this.imagePlus.getCalibration();
                this.size += (double)imgBytes.length;
                ImageStack is = this.imagePlus.getStack();
                int j = 1;
                while (j < is.getSize() + 1) {
                    String imageName = String.valueOf(i) + "#" + j;
                    this.seriesImageFiles.add(imageName);
                    this.imagePlus = new ImagePlus(imageName, is.getProcessor(j));
                    this.imagePlus.setCalibration(c);
                    try {
                        for (String string : p.keySet()) {
                            this.imagePlus.setProperty(string, p.get(string));
                        }
                    }
                    catch (Exception e) {
                        logger.info((Object)"File has no dicomheader");
                    }
                    if (!imageFound) {
                        void var15_21;
                        this.imagePlus.getProcessor().getMax();
                        DicomHeader dh = new DicomHeader(this.imagePlus);
                        String string = dh.getHeaderStringValue(0x100010);
                        if (string.length() > 12) {
                            String string2 = string.substring(0, 11);
                        }
                        String birthdate = dh.getHeaderStringValue(0x100030);
                        try {
                            birthdate = String.valueOf(birthdate.substring(6, 8)) + "." + birthdate.substring(4, 6) + "." + birthdate.substring(0, 4);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        String seriesdate = dh.getHeaderStringValue(524321);
                        try {
                            seriesdate = String.valueOf(seriesdate.substring(6, 8)) + "." + seriesdate.substring(4, 6) + "." + seriesdate.substring(0, 4);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.seriesInfo = "Name: " + (String)var15_21 + "<br>" + "Birthdate: " + birthdate + "<br>" + "Sex: " + dh.getHeaderStringValue(0x100040) + "  &nbsp;&nbsp;&nbsp;  Modality: " + dh.getHeaderStringValue(524384) + "<br>" + "Series Date: " + seriesdate + "<br>" + "Body Part: " + dh.getHeaderStringValue(1572885) + "</p>";
                        this.ID = dh.getHeaderStringValue(0x20000E);
                        this.seriesImages.put(imageName, this.imagePlus);
                        imageFound = true;
                    } else {
                        this.seriesImages.put(imageName, this.imagePlus);
                    }
                    ++j;
                }
                ++i;
            }
            catch (Exception e) {
                logger.log((Priority)Level.WARN, (Object)"File has no dicomheader", (Throwable)e);
            }
        }
        progressMonitor.close();
        this.memorySize = this.nf.format(this.size / 1024.0 / 1024.0);
        String buttonText = "<html><body><p align=\"left\" >Slice: " + (this.currentImage + 1) + "/" + this.seriesImageFiles.size() + " size: " + this.memorySize + "mb<br>" + this.seriesInfo;
        this.button = new JToggleButton(buttonText, this.getThumb(this.imagePlus));
    }

    public void next() {
        try {
            String f = this.seriesImageFiles.get(++this.currentImage);
            this.imagePlus = this.seriesImages.get(f);
            double min = 0.0;
            double max = 0.0;
            try {
                max = this.imagePlus.getProcessor().getMax();
                min = this.imagePlus.getProcessor().getMin();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.imagePlus == null) {
                System.out.println("Loading from file instead of memory");
            }
            if (min != 0.0 && max != 0.0) {
                this.imagePlus.getProcessor().setMinAndMax(min, max);
            }
            this.imagePlus.updateImage();
            String buttonText = "<html><body><p align=\"left\" >Slice: " + (this.currentImage + 1) + "/" + this.seriesImageFiles.size() + " size: " + this.memorySize + "mb<br>" + this.seriesInfo;
            this.button.setText(buttonText);
            ImageIcon ii = this.getThumb(this.imagePlus);
            if (ii != null) {
                this.button.setIcon(ii);
            }
        }
        catch (Exception e) {
            logger.info((Object)("No Image for Index: " + this.currentImage));
            --this.currentImage;
        }
    }

    public void previous() {
        try {
            String f = this.seriesImageFiles.get(--this.currentImage);
            this.imagePlus = this.seriesImages.get(f);
            double min = 0.0;
            double max = 0.0;
            try {
                max = this.imagePlus.getProcessor().getMax();
                min = this.imagePlus.getProcessor().getMin();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.imagePlus == null) {
                System.out.println("Loading from file instead of memory");
            }
            if (min != 0.0 && max != 0.0) {
                this.imagePlus.getProcessor().setMinAndMax(min, max);
            }
            String buttonText = "<html><body><p align=\"left\" >Slice: " + (this.currentImage + 1) + "/" + this.seriesImageFiles.size() + " size: " + this.memorySize + "mb<br>" + this.seriesInfo;
            this.button.setText(buttonText);
            ImageIcon ii = this.getThumb(this.imagePlus);
            if (ii != null) {
                this.button.setIcon(ii);
            }
        }
        catch (Exception e) {
            logger.info((Object)("No Image for Index: " + this.currentImage));
            ++this.currentImage;
        }
    }

    public ImageIcon getThumb(ImagePlus imagePlus) {
        int imageHeight;
        Image image = null;
        try {
            DicomHeader dh = new DicomHeader(imagePlus);
            image = OverlayExtractor.hasOverlayImage(dh.getDicomObject()) ? OverlayExtractor.createOverlayImage(imagePlus, dh.getDicomObject()).getImage() : imagePlus.getImage();
        }
        catch (Exception e) {
            e.printStackTrace();
            image = imagePlus.getImage();
        }
        if (image == null) {
            logger.warn((Object)"This is no Image!!!!");
            return null;
        }
        int thumbWidth = 64;
        int thumbHeight = 64;
        double thumbRatio = (double)thumbWidth / (double)thumbHeight;
        int imageWidth = image.getWidth(null);
        double imageRatio = (double)imageWidth / (double)(imageHeight = image.getHeight(null));
        if (thumbRatio < imageRatio) {
            thumbHeight = (int)((double)thumbWidth / imageRatio);
        } else {
            thumbWidth = (int)((double)thumbHeight * imageRatio);
        }
        BufferedImage thumbImage = new BufferedImage(thumbWidth, thumbHeight, 1);
        Graphics2D graphics2D = thumbImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(image, 0, 0, thumbWidth, thumbHeight, null);
        return new ImageIcon(thumbImage);
    }

    public ImagePlus getAsImageStack() {
        ImageStack stack = null;
        ImagePlus imgPlus = null;
        Object info = null;
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (ImagePlus ipl : this.seriesImages.values()) {
            try {
                if (stack == null) {
                    stack = ipl.createEmptyStack();
                }
                info = ipl.getProperty("Info");
                ImageProcessor ip = ipl.getProcessor();
                if (ip.getMin() < min) {
                    min = ip.getMin();
                }
                if (ip.getMax() > max) {
                    max = ip.getMax();
                }
                stack.addSlice(ipl.getTitle(), ip);
                logger.info((Object)("Slice: " + ipl.getFileInfo().fileName + "added"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        imgPlus = new ImagePlus("Imported Stack", stack);
        if (imgPlus.getBitDepth() == 16 || imgPlus.getBitDepth() == 32) {
            imgPlus.getProcessor().setMinAndMax(min, max);
        }
        Calibration cal = imgPlus.getCalibration();
        try {
            imgPlus.setProperty("Info", info);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return imgPlus;
    }

    public void setSlice(int sliceNum) {
        try {
            this.currentImage = sliceNum;
            String f = this.seriesImageFiles.get(sliceNum);
            this.imagePlus = this.seriesImages.get(f);
            double min = 0.0;
            double max = 0.0;
            try {
                max = this.imagePlus.getProcessor().getMax();
                min = this.imagePlus.getProcessor().getMin();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.imagePlus == null) {
                logger.log((Priority)Level.INFO, (Object)"Loading from file instead of memory");
            }
            if (min != 0.0 && max != 0.0) {
                this.imagePlus.getProcessor().setMinAndMax(min, max);
            }
        }
        catch (Exception e) {
            logger.info((Object)("No Image for Index: " + this.currentImage));
            this.currentImage = sliceNum;
        }
    }

    public ImagePlus getImagePlus() {
        return this.imagePlus;
    }

    public String[] getFileName() {
        if (this.files == null) {
            return null;
        }
        String[] names = new String[this.files.length];
        int i = 0;
        while (i < this.files.length) {
            names[i] = this.files[i].getAbsolutePath();
            ++i;
        }
        return names;
    }
}

