/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.viewer;

import ij.ImageJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.OvalRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.process.ImageProcessor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import lu.tudor.santec.dicom.DicomOpener;
import lu.tudor.santec.dicom.OverlayExtractor;
import lu.tudor.santec.dicom.gui.DicomIcons;
import lu.tudor.santec.dicom.gui.header.DicomHeader;
import lu.tudor.santec.dicom.gui.header.DicomHeaderInfoDialog;
import lu.tudor.santec.dicom.gui.header.DicomHexInfoDialog;
import lu.tudor.santec.dicom.gui.header.SRDialog;
import lu.tudor.santec.dicom.gui.viewer.ImageListener;
import lu.tudor.santec.dicom.gui.viewer.OSDText;
import lu.tudor.santec.dicom.gui.viewer.RoiListener;
import lu.tudor.santec.dicom.gui.viewer.Series;
import lu.tudor.santec.dicom.gui.viewer.SliceListener;
import lu.tudor.santec.dicom.gui.viewer.WindowListener;
import lu.tudor.santec.i18n.Translatrix;
import org.apache.log4j.Logger;

public class DicomImagePanel
extends JTextField
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener,
FocusListener {
    private static final long serialVersionUID = 1L;
    private static final String WARNING_TEXT = Translatrix.getTranslationString((String)"dicom.dicomImagePanel.warning");
    private static final String[] WARNING_TEXT_IMAGEIO = Translatrix.getTranslationString((String)"dicom.dicomImagePanel.imageiowarning").split("\n");
    private static final boolean isImageIOWorking = DicomOpener.isImageIOWorking();
    private String bigAreaTitle = "Optimage Image View";
    private static Logger logger = Logger.getLogger((String)DicomImagePanel.class.getName());
    protected ImagePlus image;
    protected ImageProcessor imageProcessor;
    private Vector<Roi> rois;
    private Vector<Roi> defaultRois;
    private Vector<OSDText> osdTexts;
    protected int windowWidth;
    protected int windowCenter;
    private int origWindowWith;
    private int origWindowCenter;
    private Calibration calibration;
    private double calibrationCoefficient = 0.0;
    private double pixelSizeX = 0.0;
    private double pixelSizeY = 0.0;
    private static int OFFSET = 5;
    private static int DOUBLE_OFFSET = OFFSET * 2;
    private int startpointY;
    private int startpointX;
    private int mouseY;
    private int mouseX;
    private int shiftX;
    private int shiftY;
    private double oldZoomFactor;
    private double zoomOffsetX;
    private double zoomOffsetY;
    private boolean mouseIn;
    private int xPixel;
    private int yPixel;
    private double imageAspect;
    protected DicomImagePanel bigArea;
    private JDialog bigDialog;
    protected JDialog parentDialog;
    private JPopupMenu popup;
    private JToolBar toolBar;
    protected DicomHeaderInfoDialog dicomHeaderInfoDialog;
    private boolean extendable;
    private double zoomFactor = 1.0;
    private boolean usePixelValues;
    private boolean moveable;
    private boolean showRois = true;
    private boolean showText = true;
    private boolean showDicomInfos = false;
    private String[] dicomInfos = new String[]{"0020,0013", "0010,0010", "0010,0030", "0010,0040", "0018,0015"};
    private NumberFormat nf = NumberFormat.getInstance();
    private int halfArrowSize = 16;
    private int arrowSize = 2 * this.halfArrowSize;
    private Image[] arrowArray = new Image[]{DicomIcons.getImage("1uparrow.png", this.arrowSize), DicomIcons.getImage("1downarrow.png", this.arrowSize), DicomIcons.getImage("1leftarrow.png", this.arrowSize), DicomIcons.getImage("1rightarrow.png", this.arrowSize)};
    private Cursor CURSOR_DEFAULT = Cursor.getPredefinedCursor(0);
    private Cursor CURSOR_ZOOM = this.getToolkit().createCustomCursor(DicomIcons.getImage("cursor_zoom.gif", 32), new Point(16, 16), "zoom");
    private Cursor CURSOR_WINDOW = this.getToolkit().createCustomCursor(DicomIcons.getImage("cursor_window.gif", 32), new Point(16, 16), "window");
    private Cursor CURSOR_MOVE = Cursor.getPredefinedCursor(13);
    private CursorTask cursorTask = new CursorTask();
    private Timer cursorTimer = new Timer();
    private AbstractAction actionResetAll;
    private AbstractAction actionResetWindowing;
    private AbstractAction actionResetZoom;
    private AbstractAction actionResetShift;
    private AbstractAction actionOpenImageJ;
    private AbstractAction actionSaveScreenShot;
    private AbstractAction actionShowHeader;
    private AbstractAction actionShowHex;
    private AbstractAction actionHelp;
    private JToggleButton buttonRois;
    private JToggleButton buttonText;
    private JToggleButton buttonWindow = new JToggleButton();
    private JToggleButton buttonZoom;
    private JToggleButton buttonMove;
    private JToggleButton buttonCrop;
    private JToggleButton buttonDoNothing = new JToggleButton();
    private JToggleButton currentButton = this.buttonWindow;
    private LinkedHashMap<AbstractButton, ImageListener> modeButtons = new LinkedHashMap();
    private LinkedHashMap<AbstractButton, ImageListener> functionButtons = new LinkedHashMap();
    private ImageListener imageListener;
    private SliceListener sliceListener;
    private Vector<OSDText> defaultOsdTexts;
    private int pixelDepth = 8;
    public DicomImagePanel parentPanel;
    private Series series;
    private boolean multislice;
    private JToggleButton buttonStack;
    private String unit;
    private boolean firstDrawing = true;
    private int panelOffsetY;
    private int panelOffsetX;
    private int oldPaintSize;
    private boolean interpolate = false;
    private ImageProcessor origProcessor;
    protected DicomHexInfoDialog dicomHexInfoDialog;
    private boolean dropable = true;
    private ImagePlus overlayImage;
    private boolean one2one;
    private JToggleButton buttonOne2one;
    private DicomHeader dicomHeader;
    private Vector<WindowListener> windowListeners = new Vector();
    private Dimension bigAreaPrefferedSize = null;
    private boolean useDefaultButtons;
    private boolean zoomable;
    private int panelWidth;
    private int panelHeight;
    private double imageWidth;
    private double imageHeight;
    private int offsetX;
    private int offsetY;
    private int xPaintSize;
    private int yPaintSize;
    private double factorX;
    private double factorY;
    private String lastSeriesUID;
    private boolean imageIOMessage;
    private AbstractAction actionShowSR;
    private EventListenerList listeners = new EventListenerList();
    public static String ROIS = "rois";
    public static String DEFAULT_ROIS = "default_rois";

    public DicomImagePanel(int width, int height) {
        this.createImageArea(width, height, true, false, false, true);
    }

    public DicomImagePanel(int width, int height, boolean extendable, boolean zoomable, boolean moveable) {
        this.createImageArea(width, height, extendable, zoomable, moveable, true);
    }

    public DicomImagePanel(int width, int height, boolean extendable, boolean zoomable, boolean moveable, boolean useDefaultButtons) {
        this.createImageArea(width, height, extendable, zoomable, moveable, useDefaultButtons);
    }

    private void createImageArea(int width, int height, boolean extendable, boolean zoomable, boolean moveable, boolean useDefaultButtons) {
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK, 1), BorderFactory.createLineBorder(Color.LIGHT_GRAY, 2)));
        Dimension scrnsize = Toolkit.getDefaultToolkit().getScreenSize();
        if (height > scrnsize.height - 50) {
            double factor = height / (scrnsize.height - 50);
            height = (int)((double)height * factor);
            width = (int)((double)width * factor);
        }
        this.setPreferredSize(new Dimension(width + DOUBLE_OFFSET, height + DOUBLE_OFFSET));
        this.setBackground(Color.BLACK);
        this.setCursor(this.CURSOR_DEFAULT);
        this.setFocusable(true);
        this.addFocusListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.extendable = extendable;
        this.moveable = moveable;
        this.zoomable = zoomable;
        this.useDefaultButtons = useDefaultButtons;
        this.addMouseWheelListener(this);
        this.nf.setMaximumFractionDigits(1);
        this.actionResetAll = new AbstractAction(Translatrix.getTranslationString((String)"dicom.dicomImagePanel.resetAll"), DicomIcons.getScreenDependentIcon("action_undo.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DicomImagePanel.this.firstDrawing = true;
                DicomImagePanel.this.zoomFactor = 1.0;
                DicomImagePanel.this.shiftX = 0;
                DicomImagePanel.this.shiftY = 0;
                DicomImagePanel.this.zoomOffsetX = 0.0;
                DicomImagePanel.this.zoomOffsetY = 0.0;
                DicomImagePanel.this.windowImage(DicomImagePanel.this.origWindowCenter - DicomImagePanel.this.windowCenter, DicomImagePanel.this.origWindowWith - DicomImagePanel.this.windowWidth, false, true);
            }
        };
        this.actionResetWindowing = new AbstractAction(Translatrix.getTranslationString((String)"dicom.dicomImagePanel.resetWindowing"), DicomIcons.getScreenDependentIcon("action_window_undo.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DicomImagePanel.this.windowImage(DicomImagePanel.this.origWindowCenter - DicomImagePanel.this.windowCenter, DicomImagePanel.this.origWindowWith - DicomImagePanel.this.windowWidth, false, true);
            }
        };
        this.actionResetZoom = new AbstractAction(Translatrix.getTranslationString((String)"dicom.dicomImagePanel.resetZoom"), DicomIcons.getScreenDependentIcon("action_zoom_undo.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DicomImagePanel.this.firstDrawing = true;
                DicomImagePanel.this.zoomFactor = 1.0;
                DicomImagePanel.this.shiftX = 0;
                DicomImagePanel.this.shiftY = 0;
                DicomImagePanel.this.zoomOffsetX = 0.0;
                DicomImagePanel.this.zoomOffsetY = 0.0;
                DicomImagePanel.this.repaint();
            }
        };
        this.actionResetShift = new AbstractAction(Translatrix.getTranslationString((String)"dicom.dicomImagePanel.resetShift"), DicomIcons.getScreenDependentIcon("action_move_undo.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DicomImagePanel.this.firstDrawing = true;
                DicomImagePanel.this.shiftX = 0;
                DicomImagePanel.this.shiftY = 0;
                DicomImagePanel.this.zoomOffsetX = 0.0;
                DicomImagePanel.this.zoomOffsetY = 0.0;
                DicomImagePanel.this.repaint();
            }
        };
        this.actionOpenImageJ = new AbstractAction(Translatrix.getTranslationString((String)"dicom.dicomImagePanel.openImagej"), DicomIcons.getScreenDependentIcon("action_imagej.png")){
            private static final long serialVersionUID = 1L;
            private ImageJ m_ImageJ;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.m_ImageJ == null) {
                    this.m_ImageJ = new ImageJ();
                    this.m_ImageJ.setVisible(false);
                }
                if (DicomImagePanel.this.series != null) {
                    Series s = DicomImagePanel.this.series;
                    WindowManager.addWindow((Frame)new ImageWindow(s.getAsImageStack()));
                } else if (DicomImagePanel.this.image != null) {
                    ImagePlus imp = new ImagePlus("DicomViewer debug", DicomImagePanel.this.image.getProcessor().duplicate());
                    imp.setCalibration(DicomImagePanel.this.image.getCalibration());
                    WindowManager.addWindow((Frame)new ImageWindow(imp));
                }
                this.m_ImageJ.setVisible(true);
            }
        };
        this.actionShowHeader = new AbstractAction(Translatrix.getTranslationString((String)"dicom.dicomImagePanel.showHeader"), DicomIcons.getScreenDependentIcon("action_header.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DicomImagePanel.this.dicomHeaderInfoDialog == null) {
                    DicomImagePanel.this.dicomHeaderInfoDialog = new DicomHeaderInfoDialog();
                    DicomImagePanel.this.dicomHeaderInfoDialog.setLocationRelativeTo(DicomImagePanel.this);
                }
                File f = new File(String.valueOf(DicomImagePanel.this.image.getOriginalFileInfo().directory) + DicomImagePanel.this.image.getOriginalFileInfo().fileName);
                DicomImagePanel.this.dicomHeaderInfoDialog.setInfo(f);
                DicomImagePanel.this.dicomHeaderInfoDialog.setVisible(true);
            }
        };
        this.actionShowHex = new AbstractAction(Translatrix.getTranslationString((String)"dicom.dicomImagePanel.showHex"), DicomIcons.getScreenDependentIcon("action_hex.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DicomImagePanel.this.dicomHexInfoDialog == null) {
                    DicomImagePanel.this.dicomHexInfoDialog = new DicomHexInfoDialog();
                }
                File f = new File(String.valueOf(DicomImagePanel.this.image.getOriginalFileInfo().directory) + DicomImagePanel.this.image.getOriginalFileInfo().fileName);
                DicomImagePanel.this.dicomHexInfoDialog.setInfo(f);
                DicomImagePanel.this.dicomHexInfoDialog.setVisible(true);
            }
        };
        this.actionShowSR = new AbstractAction(Translatrix.getTranslationString((String)"dicom.dicomImagePanel.showSR"), DicomIcons.getScreenDependentIcon("action_sr.png")){
            private static final long serialVersionUID = 1L;
            private SRDialog srDialog;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.srDialog == null) {
                    this.srDialog = new SRDialog();
                }
                File f = new File(String.valueOf(DicomImagePanel.this.image.getOriginalFileInfo().directory) + DicomImagePanel.this.image.getOriginalFileInfo().fileName);
                this.srDialog.showReports(new File[]{f});
            }
        };
        this.actionSaveScreenShot = new AbstractAction(Translatrix.getTranslationString((String)"dicom.dicomImagePanel.screenShot"), DicomIcons.getScreenDependentIcon("action_export.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser jfc = new JFileChooser();
                int retval = jfc.showSaveDialog(DicomImagePanel.this.parentDialog);
                if (retval == 0) {
                    File file = jfc.getSelectedFile();
                    BufferedImage shot = DicomImagePanel.this.getScreenShot();
                    try {
                        ImageIO.write((RenderedImage)shot, "png", file);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        };
        this.actionHelp = new AbstractAction(Translatrix.getTranslationString((String)"dicom.dicomImagePanel.help"), DicomIcons.getScreenDependentIcon("action_help.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JPanel mp = new JPanel(new BorderLayout());
                JPanel jp = new JPanel(new GridLayout(0, 1));
                Component[] comps = DicomImagePanel.this.toolBar.getComponents();
                int i = 0;
                while (i < comps.length) {
                    try {
                        AbstractButton element = (AbstractButton)comps[i];
                        jp.add(new JLabel(element.getToolTipText(), element.getIcon(), 2));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i;
                }
                StringBuffer helpText = new StringBuffer(Translatrix.getTranslationString((String)"dicom.dicomImagePanel.helpHeader1"));
                if (DicomImagePanel.this.multislice) {
                    helpText.append(Translatrix.getTranslationString((String)"dicom.dicomImagePanel.helpHeader2"));
                } else {
                    helpText.append(Translatrix.getTranslationString((String)"dicom.dicomImagePanel.helpHeader3"));
                }
                helpText.append(Translatrix.getTranslationString((String)"dicom.dicomImagePanel.helpHeader4"));
                mp.add((Component)new JLabel(helpText.toString(), 2), "North");
                mp.add((Component)jp, "Center");
                JOptionPane.showMessageDialog(DicomImagePanel.this.parentDialog, mp, Translatrix.getTranslationString((String)"dicom.dicomImagePanel"), 0, DicomIcons.getIcon("icon_help.png"));
            }
        };
    }

    public void clear() {
        this.image = null;
        this.imageProcessor = null;
        this.repaint();
        if (this.parentPanel != null) {
            this.parentPanel.image = null;
            this.parentPanel.imageProcessor = null;
            this.parentPanel.repaint();
        }
        if (this.bigArea != null) {
            this.bigArea.image = null;
            this.bigArea.imageProcessor = null;
            this.bigArea.repaint();
        }
    }

    public void setImage(ImagePlus image) {
        if (image == null) {
            this.clear();
            return;
        }
        this.image = image;
        try {
            this.imageProcessor = image.getProcessor();
        }
        catch (Exception e) {
            logger.info((Object)"Image is no DicomImage");
        }
        if (this.imageProcessor == null) {
            logger.warn((Object)"This Object is no Image");
            return;
        }
        this.firstDrawing = true;
        try {
            if (image.getProperty(DicomHeader.class.getSimpleName()) != null) {
                this.dicomHeader = (DicomHeader)image.getProperty(DicomHeader.class.getSimpleName());
            } else {
                try {
                    File f = new File(String.valueOf(image.getOriginalFileInfo().directory) + image.getOriginalFileInfo().fileName);
                    this.dicomHeader = new DicomHeader(f);
                }
                catch (Exception f) {
                    // empty catch block
                }
            }
            try {
                this.overlayImage = OverlayExtractor.hasOverlayImage(this.dicomHeader.getDicomObject()) ? OverlayExtractor.extractOverlay(this.dicomHeader.getDicomObject()) : null;
            }
            catch (Exception e) {
                this.overlayImage = null;
            }
            if (this.dicomHeaderInfoDialog != null) {
                this.dicomHeaderInfoDialog.setInfo(this.dicomHeader);
            }
            this.imageAspect = (0.0 + (double)image.getHeight()) / (double)image.getWidth();
            this.calibration = image.getCalibration();
            try {
                this.calibrationCoefficient = this.calibration.getCoefficients()[0];
                this.usePixelValues = false;
            }
            catch (Exception e) {
                this.usePixelValues = true;
            }
            String modality = this.dicomHeader.getHeaderStringValue(524384).toUpperCase();
            if (!this.usePixelValues) {
                this.unit = modality.equals("CT") ? "HU" : (modality.equals("NM") ? "Counts" : (modality.equals("PT") ? "Counts" : ""));
            }
            this.actionShowSR.setEnabled(modality.equals("SR"));
            try {
                this.pixelDepth = image.getBitDepth();
                String[] spacing = this.dicomHeader.getHeaderStringValues(2621488);
                this.pixelSizeX = Double.parseDouble(spacing[0]);
                this.pixelSizeY = Double.parseDouble(spacing[1]);
            }
            catch (Exception e) {
                try {
                    String[] spacing = this.dicomHeader.getHeaderStringValues(1577316);
                    this.pixelSizeX = Double.parseDouble(spacing[0]);
                    this.pixelSizeY = Double.parseDouble(spacing[1]);
                }
                catch (Exception spacing) {
                    // empty catch block
                }
            }
            String transferSyntax = this.dicomHeader.getHeaderStringValue(131088);
            this.imageIOMessage = transferSyntax != null && transferSyntax.startsWith("1.2.840.10008.1.2.4") && !isImageIOWorking;
        }
        catch (Exception e) {
            this.dicomHeader = null;
            e.printStackTrace();
        }
        double windowMin = this.imageProcessor.getMin();
        double windowMax = this.imageProcessor.getMax();
        String seriesUId = this.dicomHeader.getHeaderStringValue(0x20000E);
        if (!seriesUId.equals(this.lastSeriesUID)) {
            this.origWindowWith = (int)(windowMax - windowMin);
            this.origWindowCenter = (int)(windowMin + (double)(this.windowWidth / 2));
            this.windowWidth = this.origWindowWith;
            this.windowCenter = this.origWindowCenter;
        } else {
            this.setWindow(this.windowCenter, this.windowWidth);
        }
        this.lastSeriesUID = seriesUId;
        this.repaint();
        if (this.bigArea != null) {
            this.bigArea.setImage(this.image);
            this.bigArea.origWindowCenter = this.origWindowCenter;
            this.bigArea.origWindowWith = this.origWindowWith;
            this.bigArea.setDefaultRois(this.defaultRois);
            this.bigArea.setRois(this.rois);
        }
        if (this.modeButtons.get(this.currentButton) != null) {
            this.modeButtons.get(this.currentButton).imageChanged(image);
        }
        if (this.imageListener != null) {
            this.imageListener.imageChanged(image);
        }
    }

    public BufferedImage getScreenShot() {
        int w = this.getWidth();
        int h = this.getHeight();
        BufferedImage shot = new BufferedImage(w, h, 1);
        Graphics2D g2 = shot.createGraphics();
        this.paint(g2);
        g2.dispose();
        return shot;
    }

    public void setImageSize(int width, int height) {
        this.setPreferredSize(new Dimension(width + DOUBLE_OFFSET, height + DOUBLE_OFFSET));
        this.repaint();
    }

    public void setWindowingDisabled(boolean windowingDisabled) {
        this.currentButton = windowingDisabled ? this.buttonDoNothing : this.buttonWindow;
    }

    public void setDefaultRois(Vector<Roi> rois) {
        this.defaultRois = rois;
        if (this.bigArea != null) {
            this.bigArea.setDefaultRois(rois);
        }
        this.repaint();
    }

    public void setRois(Vector<Roi> rois) {
        this.rois = rois;
        if (this.bigArea != null) {
            this.bigArea.setRois(rois);
        }
        this.repaint();
    }

    public Vector<Roi> getRois() {
        return this.rois;
    }

    public Vector<Roi> getDefaultRois() {
        return this.defaultRois;
    }

    public void setOSDTexts(Vector<OSDText> texts) {
        this.osdTexts = texts;
        if (this.bigArea != null) {
            this.bigArea.setOSDTexts(texts);
        }
        this.repaint();
    }

    public void setDefaultOSDTexts(Vector<OSDText> texts) {
        this.defaultOsdTexts = texts;
        if (this.bigArea != null) {
            this.bigArea.setDefaultOSDTexts(texts);
        }
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        block27: {
            super.paintComponent(g);
            try {
                if (this.image == null) break block27;
                this.calcPositions();
                if (this.interpolate) {
                    if (this.xPaintSize != this.oldPaintSize) {
                        this.imageProcessor.setInterpolate(true);
                        this.imageProcessor = this.imageProcessor.resize(this.xPaintSize, this.yPaintSize);
                        this.image.setProcessor("bla", this.imageProcessor);
                        this.image.updateImage();
                    }
                    this.oldPaintSize = this.xPaintSize;
                }
                g.drawImage(this.image.getImage(), this.offsetX, this.offsetY, this.xPaintSize, this.yPaintSize, this);
                if (this.showText && this.overlayImage != null) {
                    g.drawImage(this.overlayImage.getImage(), this.offsetX, this.offsetY, this.xPaintSize, this.yPaintSize, this);
                }
                if (this.getWidth() >= 200) {
                    DicomImagePanel.drawRois(g, this.defaultRois, this.offsetX, this.offsetY, this.factorX, this.factorY);
                    DicomImagePanel.drawOSDTexts(g, this.defaultOsdTexts, this.offsetX, this.offsetY, this.factorX, this.factorY);
                    if (this.showRois) {
                        DicomImagePanel.drawRois(g, this.rois, this.offsetX, this.offsetY, this.factorX, this.factorY);
                        DicomImagePanel.drawOSDTexts(g, this.osdTexts, this.offsetX, this.offsetY, this.factorX, this.factorY);
                    }
                    if (this.panelWidth > 300) {
                        g.setFont(g.getFont().deriveFont(1));
                        g.setColor(Color.RED);
                        g.drawString(WARNING_TEXT, this.panelWidth / 2 - 80, DOUBLE_OFFSET * 2);
                        if (this.imageIOMessage) {
                            Font f = g.getFont();
                            g.setFont(g.getFont().deriveFont(16.0f));
                            int i2 = 0;
                            while (i2 < WARNING_TEXT_IMAGEIO.length) {
                                g.drawString(WARNING_TEXT_IMAGEIO[i2], this.panelWidth / 2 - 120, DOUBLE_OFFSET * (5 + i2 * 2));
                                ++i2;
                            }
                            g.setFont(f);
                        }
                    }
                    if (this.showText) {
                        if (this.showDicomInfos) {
                            g.setColor(Color.GREEN.darker());
                            int i = 0;
                            while (i < this.dicomInfos.length) {
                                try {
                                    g.drawString(this.dicomHeader.getHeader(this.dicomInfos[i]), DOUBLE_OFFSET, DOUBLE_OFFSET * ((i + 1) * 2));
                                }
                                catch (Exception i2) {
                                    // empty catch block
                                }
                                ++i;
                            }
                        }
                        if (this.panelWidth > 300) {
                            g.setColor(Color.GREEN.darker());
                            g.drawString("Center: " + this.windowCenter, DOUBLE_OFFSET, this.panelHeight);
                            g.drawString("Width: " + this.windowWidth, this.panelWidth - 80, this.panelHeight);
                            if (this.one2one) {
                                g.drawString("1:1", this.panelWidth / 2 - 10, this.panelHeight);
                            } else {
                                g.drawString(String.valueOf(this.nf.format(this.factorX)) + "x", this.panelWidth / 2 - 10, this.panelHeight);
                            }
                            if (this.mouseIn) {
                                int val = this.image.getPixel(this.xPixel, this.yPixel)[0];
                                g.drawString("Px  Value=" + val, this.panelWidth - 140, DOUBLE_OFFSET * 4);
                                if (!this.usePixelValues) {
                                    g.drawString("Cal Value=" + this.pixelToHounsfield(val) + this.unit, this.panelWidth - 140, DOUBLE_OFFSET * 6);
                                }
                                String unit = "mm";
                                double xpos = this.xPixel;
                                double ypos = this.yPixel;
                                if (this.pixelSizeX == 0.0 || this.pixelSizeY == 0.0) {
                                    unit = "px";
                                } else {
                                    xpos *= this.pixelSizeX;
                                    ypos *= this.pixelSizeY;
                                }
                                g.drawString("X=" + this.nf.format(xpos), this.panelWidth - 140, DOUBLE_OFFSET * 2);
                                g.drawString("Y=" + this.nf.format(ypos) + unit, this.panelWidth - 80, DOUBLE_OFFSET * 2);
                            }
                        }
                    }
                }
                if (this.showRois) {
                    if (this.offsetY < 0) {
                        g.drawImage(this.arrowArray[0], DOUBLE_OFFSET + this.panelWidth / 2 - this.halfArrowSize, OFFSET, this.arrowSize, this.arrowSize, this);
                    }
                    if (this.panelHeight + DOUBLE_OFFSET < this.yPaintSize + this.offsetY) {
                        g.drawImage(this.arrowArray[1], OFFSET + this.panelWidth / 2 - this.halfArrowSize, this.panelHeight - this.arrowSize - 5, this.arrowSize, this.arrowSize, this);
                    }
                    if (this.offsetX < 0) {
                        g.drawImage(this.arrowArray[2], OFFSET, OFFSET + this.panelHeight / 2 - this.halfArrowSize, this.arrowSize, this.arrowSize, this);
                    }
                    if (this.panelWidth + DOUBLE_OFFSET < this.xPaintSize + this.offsetX) {
                        g.drawImage(this.arrowArray[3], this.panelWidth - this.arrowSize, OFFSET + this.panelHeight / 2 - this.halfArrowSize, this.arrowSize, this.arrowSize, this);
                    }
                }
            }
            catch (Throwable e) {
                logger.debug((Object)e.getMessage());
            }
        }
    }

    private void calcPositions() {
        try {
            this.panelWidth = this.getWidth() - DOUBLE_OFFSET;
            this.panelHeight = this.getHeight() - DOUBLE_OFFSET;
            this.imageWidth = this.image.getWidth();
            this.imageHeight = this.image.getHeight();
            this.xPaintSize = (int)((double)this.panelWidth * this.zoomFactor);
            this.yPaintSize = (int)((double)this.panelHeight * this.zoomFactor);
            if (this.one2one) {
                this.xPaintSize = (int)this.imageWidth;
                this.yPaintSize = (int)this.imageHeight;
            }
            this.offsetX = OFFSET + this.shiftX + (int)this.zoomOffsetX;
            this.offsetY = OFFSET + this.shiftY + (int)this.zoomOffsetY;
            double panelAspect = (0.0 + (double)this.panelHeight) / (double)this.panelWidth;
            if (this.imageAspect > panelAspect) {
                this.xPaintSize = (int)((double)this.yPaintSize / this.imageAspect);
            } else {
                this.yPaintSize = (int)((double)this.xPaintSize * this.imageAspect);
            }
            if (this.firstDrawing) {
                this.panelOffsetY = (this.panelHeight - this.yPaintSize) / 2;
                this.panelOffsetX = (this.panelWidth - this.xPaintSize) / 2;
                this.firstDrawing = false;
            }
            this.offsetY += this.panelOffsetY;
            this.offsetX += this.panelOffsetX;
            this.factorX = (double)this.xPaintSize / this.imageWidth;
            this.factorY = (double)this.yPaintSize / this.imageHeight;
            this.xPixel = (int)((double)(this.mouseX - this.offsetX) / this.factorX);
            this.yPixel = (int)((double)(this.mouseY - this.offsetY) / this.factorY);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void drawRois(Graphics g, Vector<Roi> rois, int offsetX, int offsetY, double factorX, double factorY) {
        if (rois == null) {
            return;
        }
        for (Roi roi : rois) {
            if (roi == null) continue;
            try {
                String[] colors = roi.getName().split(",");
                g.setColor(new Color(Integer.parseInt(colors[0].trim()), Integer.parseInt(colors[1].trim()), Integer.parseInt(colors[2].trim())));
            }
            catch (Exception e) {
                if (roi.getStrokeColor() != null) {
                    g.setColor(roi.getStrokeColor());
                }
                g.setColor(Color.YELLOW);
            }
            if (roi instanceof Line) {
                Line line = (Line)roi;
                g.drawLine((int)((double)line.x1 * factorX) + offsetX, (int)((double)line.y1 * factorY) + offsetY, (int)((double)line.x2 * factorX) + offsetX, (int)((double)line.y2 * factorY) + offsetY);
                continue;
            }
            if (roi instanceof OvalRoi || roi instanceof PolygonRoi || roi instanceof Roi) {
                Polygon p = roi.getPolygon();
                int i = 0;
                while (i < p.xpoints.length) {
                    p.xpoints[i] = (int)((double)p.xpoints[i] * factorX) + offsetX;
                    ++i;
                }
                i = 0;
                while (i < p.ypoints.length) {
                    p.ypoints[i] = (int)((double)p.ypoints[i] * factorY) + offsetY;
                    ++i;
                }
                g.drawPolygon(p);
                continue;
            }
            logger.info((Object)("Roi " + roi.getClass().getName() + " not implemented"));
        }
    }

    private static void drawOSDTexts(Graphics g, Vector<OSDText> osdTexts, int offsetX, int offsetY, double factorX, double factorY) {
        if (osdTexts == null) {
            return;
        }
        Iterator<OSDText> iter = osdTexts.iterator();
        while (iter.hasNext()) {
            try {
                OSDText osdText = iter.next();
                if (osdText == null) continue;
                g.setColor(osdText.color);
                g.drawString(osdText.text, (int)((double)osdText.xPos * factorX) + offsetX, (int)((double)osdText.yPos * factorY) + offsetY);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() >= 2 && this.extendable) {
            this.showBigArea(true);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e.getComponent(), e.getX(), e.getY());
        }
        this.setMouseCursor(this.CURSOR_DEFAULT);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.mouseIn = true;
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.mouseIn = false;
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.startpointY = e.getY();
        this.startpointX = e.getX();
        if (e.isPopupTrigger()) {
            this.showPopup(e.getComponent(), e.getX(), e.getY());
        } else if (SwingUtilities.isLeftMouseButton(e)) {
            if ((e.isControlDown() || this.currentButton.equals(this.buttonMove)) && this.moveable) {
                this.setMouseCursor(this.CURSOR_MOVE);
            } else if (!this.currentButton.equals(this.buttonZoom)) {
                if (this.currentButton.equals(this.buttonWindow)) {
                    this.setMouseCursor(this.CURSOR_WINDOW);
                } else if (this.modeButtons.containsKey(this.currentButton)) {
                    this.modeButtons.get(this.currentButton).pixelClicked(this.image, this.xPixel, this.yPixel);
                }
            }
            if (this.imageListener != null) {
                this.imageListener.pixelClicked(this.image, this.xPixel, this.yPixel);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseX = e.getX();
        this.mouseY = e.getY();
        if (SwingUtilities.isLeftMouseButton(e)) {
            if ((e.isControlDown() || this.currentButton.equals(this.buttonMove)) && this.moveable) {
                this.moveImage(this.startpointY - e.getY(), e.getX() - this.startpointX, e.isShiftDown());
            } else if (this.currentButton.equals(this.buttonZoom)) {
                this.zoomImage(1.0, this.startpointY - e.getY(), e.isShiftDown());
            } else if (this.currentButton.equals(this.buttonStack)) {
                if (this.sliceListener != null) {
                    if (this.startpointY - e.getY() > 0) {
                        this.sliceListener.previousSlice();
                    } else {
                        this.sliceListener.nextSlice();
                    }
                }
            } else if (this.currentButton.equals(this.buttonWindow)) {
                int windowCenterDiff = this.startpointY - e.getY();
                int windowWidthDiff = e.getX() - this.startpointX;
                if (this.usePixelValues) {
                    if (this.windowWidth > 2000) {
                        windowCenterDiff *= this.windowWidth / 1000;
                        windowWidthDiff *= this.windowWidth / 1000;
                    } else {
                        windowCenterDiff *= 2;
                        windowWidthDiff *= 2;
                    }
                }
                this.windowImage(windowCenterDiff, windowWidthDiff, e.isShiftDown(), true);
            } else if (this.imageListener != null) {
                this.calcPositions();
                this.imageListener.mouseMoved(this.xPixel, this.yPixel, e);
            }
            this.startpointY = e.getY();
            this.startpointX = e.getX();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mouseX = e.getX();
        this.mouseY = e.getY();
        this.repaint();
        if (this.modeButtons.containsKey(this.currentButton)) {
            this.modeButtons.get(this.currentButton).mouseMoved(this.xPixel, this.yPixel, e);
        }
        if (this.imageListener != null) {
            this.imageListener.mouseMoved(this.xPixel, this.yPixel, e);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.isControlDown() && this.zoomable) {
            this.zoomImage(e.getScrollAmount(), e.getWheelRotation(), e.isShiftDown());
        } else if (this.multislice) {
            if (this.sliceListener != null) {
                if (e.getWheelRotation() < 0) {
                    this.sliceListener.previousSlice();
                } else {
                    this.sliceListener.nextSlice();
                }
            }
        } else {
            this.zoomImage(e.getScrollAmount(), e.getWheelRotation(), e.isShiftDown());
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        System.out.println(e);
        if (e.getKeyChar() == 'r' || e.getKeyChar() == 'R') {
            this.buttonRois.doClick();
            this.repaint();
        } else if (e.getKeyChar() == 't' || e.getKeyChar() == 'T') {
            this.buttonText.doClick();
            this.repaint();
        } else if (e.getKeyChar() == 'h' || e.getKeyChar() == 'H') {
            this.actionShowHeader.actionPerformed(null);
        } else if (e.getKeyChar() == 'w' || e.getKeyChar() == 'W') {
            this.buttonWindow.doClick();
        } else if (e.getKeyChar() == 'z' || e.getKeyChar() == 'Z') {
            this.buttonZoom.doClick();
        } else if (e.getKeyChar() == 'm' || e.getKeyChar() == 'M') {
            this.buttonMove.doClick();
        } else if (e.getKeyChar() == 's' || e.getKeyChar() == 'S') {
            this.buttonStack.doClick();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 38) {
            if (this.sliceListener != null) {
                this.sliceListener.previousSlice();
            }
        } else if (e.getKeyCode() == 40 && this.sliceListener != null) {
            this.sliceListener.nextSlice();
        }
    }

    public void setBigAreaTitle(String title) {
        this.bigAreaTitle = title;
    }

    public void setBigAreaPreferredSize(Dimension dimension) {
        this.bigAreaPrefferedSize = dimension;
    }

    public void showBigArea(boolean show) {
        if (this.bigArea == null) {
            JDialog jd = this.findParentDialog();
            if (jd != null) {
                this.bigDialog = new JDialog(jd);
                if (jd.isModal()) {
                    this.bigDialog.setModal(true);
                }
            } else {
                this.bigDialog = new JDialog();
            }
            this.bigDialog.setDefaultCloseOperation(1);
            this.bigDialog.setTitle(this.bigAreaTitle);
            this.bigDialog.getContentPane().setLayout(new BorderLayout());
            this.createBigArea();
            this.bigDialog.getContentPane().add((Component)this.bigArea, "Center");
            this.bigDialog.getContentPane().add((Component)this.bigArea.createToolBar(), "West");
            this.bigArea.setImage(this.image);
            DicomImagePanel.center(this.bigDialog);
            DisplayMode dm = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDisplayMode();
            double monitorAspect = (0.0 + (double)dm.getHeight()) / (double)dm.getWidth();
            if (this.bigAreaPrefferedSize != null) {
                this.bigArea.setPreferredSize(this.bigAreaPrefferedSize);
            } else if (this.imageAspect > monitorAspect) {
                int tmp = dm.getHeight() - 100;
                this.bigArea.setImageSize((int)((double)tmp / this.imageAspect), tmp);
            } else {
                int tmp = dm.getWidth() - 100;
                this.bigArea.setImageSize(tmp, (int)((double)tmp * this.imageAspect));
            }
            this.bigDialog.pack();
        }
        if (show) {
            this.bigArea.origWindowCenter = this.origWindowCenter;
            this.bigArea.origWindowWith = this.origWindowWith;
            this.bigArea.setDefaultRois(this.defaultRois);
            this.bigArea.setRois(this.rois);
            this.bigArea.setOSDTexts(this.osdTexts);
        }
        this.bigDialog.setVisible(show);
    }

    private JDialog findParentDialog() {
        Container comp = this;
        while (comp != null) {
            if (comp instanceof JDialog) {
                return (JDialog)comp;
            }
            comp = comp.getParent();
        }
        return null;
    }

    public DicomImagePanel createBigArea() {
        this.bigArea = new DicomImagePanel(200, 200, false, true, true, this.useDefaultButtons);
        this.bigArea.parentPanel = this;
        this.bigArea.modeButtons = this.modeButtons;
        this.bigArea.functionButtons = this.functionButtons;
        this.bigArea.setParentDialog(this.bigDialog);
        return this.bigArea;
    }

    public void setWindow(Integer center, Integer width) {
        if (center != null && width != null) {
            this.windowImage(center - this.windowCenter, width - this.windowWidth, false, false);
        } else {
            this.windowImage(this.origWindowCenter - this.windowCenter, this.origWindowWith - this.windowWidth, false, false);
        }
    }

    private void windowImage(int windowCenterDiff, int windowWithDiff, boolean turbo, boolean notify) {
        if (this.pixelDepth >= 24) {
            return;
        }
        if (turbo) {
            windowCenterDiff *= 5;
            windowWithDiff *= 5;
        }
        this.windowCenter += windowCenterDiff;
        this.windowWidth += windowWithDiff;
        int maxVal = 256;
        if (this.pixelDepth == 16) {
            maxVal = 65534;
        }
        if (this.windowWidth <= 0) {
            this.windowWidth = 1;
        } else if (this.windowWidth >= maxVal) {
            this.windowWidth = maxVal;
        }
        if (this.windowCenter - this.windowWidth / 2 <= 0) {
            this.windowCenter = this.windowWidth / 2;
        }
        if (this.windowCenter + this.windowWidth / 2 >= maxVal) {
            this.windowCenter = maxVal - this.windowWidth / 2;
        }
        double windowMin = this.windowCenter - this.windowWidth / 2;
        double windowMax = this.windowCenter + this.windowWidth / 2;
        try {
            this.imageProcessor.setMinAndMax(windowMin, windowMax);
            this.image.updateImage();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (notify) {
            for (WindowListener wl : this.windowListeners) {
                wl.setWindow(this, this.windowCenter, this.windowWidth);
            }
        }
        this.repaint();
    }

    public void addWindowsListener(WindowListener wl) {
        this.windowListeners.add(wl);
    }

    public void removeWindowsListener(WindowListener wl) {
        this.windowListeners.remove(wl);
    }

    private void moveImage(int y, int x, boolean turbo) {
        if (turbo) {
            x *= 5;
            y *= 5;
        }
        this.shiftX += x;
        this.shiftY -= y;
        this.repaint();
    }

    private void zoomImage(double scrolls, double direktion, boolean turbo) {
        if (this.one2one) {
            return;
        }
        this.setMouseCursor(this.CURSOR_ZOOM);
        this.cursorTask.cancel();
        this.cursorTask = new CursorTask();
        this.cursorTimer.schedule((TimerTask)this.cursorTask, 500L);
        if (turbo) {
            scrolls *= 5.0;
        }
        this.oldZoomFactor = this.zoomFactor;
        this.zoomFactor += scrolls * 3.0 * direktion / 100.0;
        if (direktion < 0.0 && this.zoomFactor < 1.0) {
            this.zoomFactor = 1.0;
        } else if (this.zoomFactor > 100.0) {
            this.zoomFactor = 100.0;
        }
        this.zoomOffsetX += (double)this.mouseX * this.oldZoomFactor - (double)this.mouseX * this.zoomFactor;
        this.zoomOffsetY += (double)this.mouseY * this.oldZoomFactor - (double)this.mouseY * this.zoomFactor;
        this.repaint();
    }

    private double pixelToHounsfield(double pixel) {
        return pixel + this.calibrationCoefficient;
    }

    private void showPopup(Component c, int x, int y) {
        if (this.popup == null) {
            this.popup = new JPopupMenu();
            this.popup.add(this.actionResetAll);
            this.popup.add(this.actionResetWindowing);
            this.popup.add(this.actionResetZoom);
            this.popup.add(this.actionResetShift);
            this.popup.add(this.actionOpenImageJ);
        }
        this.popup.show(c, x, y);
    }

    private static void center(JDialog comp) {
        Dimension f = comp.getSize();
        Point d = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        comp.setLocation(d.x - f.width / 2, 0);
    }

    protected void setMouseCursor(Cursor c) {
        this.setCursor(c);
        if (this.parentDialog != null) {
            this.parentDialog.setCursor(c);
        }
    }

    protected void setParentDialog(JDialog jd) {
        this.parentDialog = jd;
    }

    public JToolBar createToolBar() {
        if (this.toolBar != null) {
            return this.toolBar;
        }
        this.toolBar = new JToolBar(1);
        this.toolBar.setMinimumSize(new Dimension(20, 20));
        this.toolBar.addKeyListener(this);
        if (this.useDefaultButtons) {
            this.buttonWindow = new JToggleButton(new AbstractAction("", DicomIcons.getScreenDependentIcon("action_window.png")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    DicomImagePanel.this.setModeButton((JToggleButton)e.getSource());
                }
            });
            this.buttonWindow.setToolTipText(Translatrix.getTranslationString((String)"dicom.dicomImagePanel.windowImage"));
            this.toolBar.add(this.buttonWindow);
            this.setModeButton(this.buttonWindow);
        }
        if (this.useDefaultButtons) {
            this.buttonZoom = new JToggleButton(new AbstractAction("", DicomIcons.getScreenDependentIcon("action_zoom.png")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    DicomImagePanel.this.setModeButton((JToggleButton)e.getSource());
                }
            });
            this.buttonZoom.setToolTipText(Translatrix.getTranslationString((String)"dicom.dicomImagePanel.zoomImage"));
            this.toolBar.add(this.buttonZoom);
        }
        this.buttonMove = new JToggleButton(new AbstractAction("", DicomIcons.getScreenDependentIcon("action_move.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DicomImagePanel.this.setModeButton((JToggleButton)e.getSource());
            }
        });
        this.buttonMove.setToolTipText(Translatrix.getTranslationString((String)"dicom.dicomImagePanel.moveImage"));
        this.toolBar.add(this.buttonMove);
        if (this.useDefaultButtons && this.multislice) {
            this.buttonStack = new JToggleButton(new AbstractAction("", DicomIcons.getScreenDependentIcon("action_stack.png")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    DicomImagePanel.this.setModeButton((JToggleButton)e.getSource());
                }
            });
            this.buttonStack.setToolTipText(Translatrix.getTranslationString((String)"dicom.dicomImagePanel.runStack"));
            this.toolBar.add(this.buttonStack);
        }
        for (JToggleButton jToggleButton : this.modeButtons.keySet()) {
            this.toolBar.add(jToggleButton);
        }
        this.toolBar.addSeparator();
        for (AbstractButton abstractButton : this.functionButtons.keySet()) {
            this.toolBar.add(abstractButton);
        }
        if (this.useDefaultButtons) {
            this.buttonOne2one = new JToggleButton(new AbstractAction("", DicomIcons.getScreenDependentIcon("action_one2one.png")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    DicomImagePanel.this.one2one = DicomImagePanel.this.buttonOne2one.isSelected();
                }
            });
            this.buttonOne2one.setToolTipText(Translatrix.getTranslationString((String)"dicom.dicomImagePanel.one2one"));
            this.toolBar.add(this.buttonOne2one);
        }
        if (this.useDefaultButtons) {
            this.buttonText = new JToggleButton(new AbstractAction("", DicomIcons.getScreenDependentIcon("action_text.png")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    DicomImagePanel.this.showText = !DicomImagePanel.this.showText;
                    DicomImagePanel.this.buttonText.setSelected(DicomImagePanel.this.showText);
                    DicomImagePanel.this.repaint();
                }
            });
            this.buttonText.setSelected(this.showText);
            this.buttonText.setToolTipText(Translatrix.getTranslationString((String)"dicom.dicomImagePanel.toggleText"));
            this.toolBar.add(this.buttonText);
        }
        if (this.useDefaultButtons) {
            this.buttonRois = new JToggleButton(new AbstractAction("", DicomIcons.getScreenDependentIcon("action_rois.png")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    DicomImagePanel.this.showRois = !DicomImagePanel.this.showRois;
                    DicomImagePanel.this.buttonRois.setSelected(DicomImagePanel.this.showRois);
                    DicomImagePanel.this.repaint();
                }
            });
            this.buttonRois.setSelected(this.showRois);
            this.buttonRois.setToolTipText(Translatrix.getTranslationString((String)"dicom.dicomImagePanel.toggleRois"));
            this.toolBar.add(this.buttonRois);
        }
        if (this.useDefaultButtons) {
            this.toolBar.addSeparator();
        }
        this.actionResetAll.putValue("ShortDescription", Translatrix.getTranslationString((String)"dicom.dicomImagePanel.resetAll"));
        this.toolBar.add(this.actionResetAll);
        if (this.useDefaultButtons) {
            this.actionOpenImageJ.putValue("ShortDescription", Translatrix.getTranslationString((String)"dicom.dicomImagePanel.openImagej"));
            this.toolBar.add(this.actionOpenImageJ);
            this.actionShowHeader.putValue("ShortDescription", Translatrix.getTranslationString((String)"dicom.dicomImagePanel.showHeader"));
            this.toolBar.add(this.actionShowHeader);
            this.actionShowHex.putValue("ShortDescription", Translatrix.getTranslationString((String)"dicom.dicomImagePanel.showHex"));
            this.toolBar.add(this.actionShowHex);
            this.actionShowSR.putValue("ShortDescription", Translatrix.getTranslationString((String)"dicom.dicomImagePanel.showSR"));
            this.toolBar.add(this.actionShowSR);
            this.actionSaveScreenShot.putValue("ShortDescription", Translatrix.getTranslationString((String)"dicom.dicomImagePanel.screenShot"));
            this.toolBar.add(this.actionSaveScreenShot);
            this.toolBar.addSeparator();
            this.actionHelp.putValue("ShortDescription", Translatrix.getTranslationString((String)"dicom.dicomImagePanel.help"));
            this.toolBar.add(this.actionHelp);
        }
        return this.toolBar;
    }

    private void setModeButton(JToggleButton jtb) {
        this.currentButton = jtb;
        Component[] comps = this.toolBar.getComponents();
        int i = 0;
        while (i < comps.length) {
            try {
                boolean isButton = false;
                JToggleButton element = (JToggleButton)comps[i];
                if (element.equals(jtb)) {
                    isButton = true;
                }
                try {
                    element.setSelected(isButton);
                    this.modeButtons.get(element).optionSelected(isButton);
                }
                catch (Exception exception) {}
            }
            catch (Exception e) {
                break;
            }
            ++i;
        }
    }

    public JToggleButton addModeButton(ImageIcon icon, String text, ImageListener il) {
        JToggleButton b = new JToggleButton(new AbstractAction("", icon){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DicomImagePanel.this.bigArea != null) {
                    DicomImagePanel.this.bigArea.setModeButton((JToggleButton)e.getSource());
                }
            }
        });
        b.setToolTipText(text);
        this.modeButtons.put(b, il);
        return b;
    }

    public void addFunctionButton(AbstractButton button, ImageListener il) {
        this.functionButtons.put(button, il);
    }

    public void addRoiListener(RoiListener listener) {
        this.listeners.add(RoiListener.class, listener);
    }

    public void removeRoiListener(RoiListener listener) {
        this.listeners.remove(RoiListener.class, listener);
    }

    public synchronized void fireRoiEvent(String roiEventname) {
        RoiListener[] roiListenerArray = (RoiListener[])this.listeners.getListeners(RoiListener.class);
        int n = roiListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            RoiListener l = roiListenerArray[n2];
            l.update(roiEventname);
            ++n2;
        }
    }

    public double getPixelSizeX() {
        return this.pixelSizeX;
    }

    public double getPixelSizeY() {
        return this.pixelSizeY;
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.RED, 1), BorderFactory.createLineBorder(Color.LIGHT_GRAY, 2)));
        this.validate();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK, 1), BorderFactory.createLineBorder(Color.LIGHT_GRAY, 2)));
        this.validate();
    }

    public void setShowDicomInfos(boolean showDicomInfos) {
        this.showDicomInfos = showDicomInfos;
    }

    public void setSliceListener(SliceListener sl) {
        this.sliceListener = sl;
        this.multislice = true;
    }

    public void setImageListener(ImageListener il) {
        this.imageListener = il;
    }

    public boolean isInterpolate() {
        return this.interpolate;
    }

    public void setInterpolation(boolean interpolate) {
        if (interpolate == this.interpolate) {
            return;
        }
        if (interpolate) {
            this.origProcessor = this.imageProcessor.duplicate();
        } else {
            this.origProcessor.setMinAndMax(this.imageProcessor.getMin(), this.imageProcessor.getMax());
            this.imageProcessor = this.origProcessor;
            this.origProcessor = null;
        }
        this.image.setProcessor("bla", this.imageProcessor);
        try {
            this.bigArea.setInterpolation(interpolate);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.interpolate = interpolate;
        this.oldPaintSize = 0;
        this.repaint();
    }

    @Override
    public void replaceSelection(String content) {
        if (this.dropable) {
            try {
                content = content.replaceAll("file:/", "");
                ImagePlus ip = new ImagePlus(content);
                if (this.parentPanel != null) {
                    this.parentPanel.setImage(ip);
                } else {
                    this.setImage(ip);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isFilesDropable() {
        return this.dropable;
    }

    public void setFilesDropable(boolean dropable) {
        this.dropable = dropable;
    }

    public ImagePlus getImage() {
        return this.image;
    }

    public JDialog getBigDialog() {
        return this.bigDialog;
    }

    public void setSeries(Series activeSeries) {
        this.series = activeSeries;
    }

    public Series getSeries() {
        return this.series;
    }

    public String[] getDicomInfos() {
        return this.dicomInfos;
    }

    public void setDicomInfos(String[] dicomInfos) {
        this.dicomInfos = dicomInfos;
    }

    public DicomHeader getDicomHeader() {
        return this.dicomHeader;
    }

    class CursorTask
    extends TimerTask {
        CursorTask() {
        }

        @Override
        public void run() {
            DicomImagePanel.this.setCursor(DicomImagePanel.this.CURSOR_DEFAULT);
            if (DicomImagePanel.this.parentDialog != null) {
                DicomImagePanel.this.parentDialog.setCursor(DicomImagePanel.this.CURSOR_DEFAULT);
            }
        }
    }
}

