/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.viewer;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.Roi;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JButton;
import lu.tudor.santec.dicom.gui.DicomIcons;
import lu.tudor.santec.dicom.gui.viewer.DicomImagePanel;
import lu.tudor.santec.dicom.gui.viewer.ImageListener;
import lu.tudor.santec.i18n.Translatrix;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class DicomImageHistogramViewerPlugin
implements ActionListener {
    private DicomImagePanel dicomImagePanel;
    private JButton button;
    private Logger logger = Logger.getLogger((String)DicomImageHistogramViewerPlugin.class.getName());

    public DicomImageHistogramViewerPlugin(DicomImagePanel dip) {
        this.dicomImagePanel = dip;
        this.button = new JButton(DicomIcons.getScreenDependentIcon("action_histogram.png"));
        this.button.setToolTipText(Translatrix.getTranslationString((String)"dicom.dicomImagePanel.histogram"));
        this.button.addActionListener(this);
        this.dicomImagePanel.addFunctionButton(this.button, new ImageListener(){

            @Override
            public void mouseMoved(int x, int y, MouseEvent e) {
            }

            @Override
            public void optionSelected(boolean selected) {
            }

            @Override
            public void pixelClicked(ImagePlus ip, int x, int y) {
            }

            @Override
            public void imageChanged(ImagePlus image) {
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getModifiers() == 18) {
            IJ.setKeyDown((int)18);
        }
        try {
            ImagePlus imp = new ImagePlus("Image", this.dicomImagePanel.imageProcessor);
            Vector<Roi> rois = this.dicomImagePanel.getRois();
            if (rois.size() == 1) {
                Roi roi = rois.iterator().next();
                imp.setRoi(roi);
            }
            WindowManager.setTempCurrentImage((ImagePlus)imp);
            IJ.run((String)"Histogram");
        }
        catch (NullPointerException e1) {
            this.logger.log((Priority)Level.INFO, (Object)"There is no image open!");
        }
    }
}

