/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.viewer;

import ij.ImagePlus;
import ij.gui.Line;
import ij.gui.OvalRoi;
import ij.gui.Roi;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.util.Vector;
import lu.tudor.santec.dicom.gui.DicomIcons;
import lu.tudor.santec.dicom.gui.viewer.DicomImagePanel;
import lu.tudor.santec.dicom.gui.viewer.ImageListener;
import lu.tudor.santec.dicom.gui.viewer.OSDText;
import lu.tudor.santec.i18n.Translatrix;

public class DicomImageAngleMeasurement {
    DicomImagePanel dicomImagePanel;

    public DicomImageAngleMeasurement(DicomImagePanel dip) {
        this.dicomImagePanel = dip;
        this.dicomImagePanel.addModeButton(DicomIcons.getScreenDependentIcon("action_angle.png"), Translatrix.getTranslationString((String)"dicom.dicomImagePanel.measureAngle"), new ImageListener(){
            Vector<Roi> v = new Vector();
            Vector<OSDText> vText = new Vector();
            int x1;
            int x2;
            int y1;
            int y2;
            int count = 1;
            private Line l;
            private Line l1;
            private NumberFormat nf = NumberFormat.getInstance();
            private double deg1;

            @Override
            public void pixelClicked(ImagePlus ip, int x, int y) {
                this.vText.removeAllElements();
                if (this.count == 1) {
                    this.v.removeAllElements();
                    this.x1 = x;
                    this.y1 = y;
                    ++this.count;
                    OvalRoi or = new OvalRoi(x - 5, y - 5, 10, 10);
                    or.setName("0,255,0");
                    this.v.add((Roi)or);
                } else if (this.count == 2) {
                    this.x2 = x;
                    this.y2 = y;
                    ++this.count;
                    OvalRoi or = new OvalRoi(x - 5, y - 5, 10, 10);
                    or.setName("0,255,0");
                    this.v.add((Roi)or);
                    this.v.remove(this.l);
                    this.l1 = new Line(this.x1, this.y1, this.x2, this.y2);
                    this.l1.setName("0,255,0");
                    System.out.println("-------------------------------------------------------");
                    double xdiff = this.l1.x1 - this.l1.x2;
                    double ydiff = this.l1.y1 - this.l1.y2;
                    double tan = ydiff / xdiff;
                    this.deg1 = Math.toDegrees(Math.atan(tan));
                    System.out.println(String.valueOf(this.deg1) + " \u00b0");
                    this.v.add((Roi)this.l1);
                } else if (this.count == 3) {
                    this.x1 = x;
                    this.y1 = y;
                    ++this.count;
                    OvalRoi or = new OvalRoi(x - 5, y - 5, 10, 10);
                    or.setName("0,255,0");
                    this.v.add((Roi)or);
                } else if (this.count == 4) {
                    this.x2 = x;
                    this.y2 = y;
                    ++this.count;
                    OvalRoi or = new OvalRoi(x - 5, y - 5, 10, 10);
                    or.setName("0,255,0");
                    this.v.add((Roi)or);
                    this.v.remove(this.l);
                    this.l = new Line(this.x1, this.y1, this.x2, this.y2);
                    this.l.setName("0,255,0");
                    this.v.add((Roi)this.l);
                    this.count = 1;
                    double xdiff = this.l.x1 - this.l.x2;
                    double ydiff = this.l.y1 - this.l.y2;
                    double tan = ydiff / xdiff;
                    double deg2 = Math.toDegrees(Math.atan(tan));
                    System.out.println(String.valueOf(deg2) + " \u00b0");
                    double deg3 = Math.abs(this.deg1 - deg2);
                    if (deg3 > 90.0) {
                        deg3 = 180.0 - deg3;
                    }
                    int xTextPos = ((this.l.x1 + this.l.x2) / 2 + (this.l1.x1 + this.l1.x2) / 2) / 2 - 50;
                    int yTextPos = ((this.l.y1 + this.l.y2) / 2 + (this.l1.y1 + this.l1.y2) / 2) / 2;
                    this.vText.add(new OSDText(String.valueOf(this.nf.format(deg3)) + " \u00b0", xTextPos, yTextPos, Color.GREEN));
                    DicomImageAngleMeasurement.this.dicomImagePanel.setDefaultOSDTexts(this.vText);
                }
                DicomImageAngleMeasurement.this.dicomImagePanel.setDefaultRois(this.v);
                DicomImageAngleMeasurement.this.dicomImagePanel.setOSDTexts(this.vText);
            }

            @Override
            public void optionSelected(boolean selected) {
                if (!selected) {
                    this.v.removeAllElements();
                    DicomImageAngleMeasurement.this.dicomImagePanel.setDefaultRois(this.v);
                    this.vText.removeAllElements();
                    DicomImageAngleMeasurement.this.dicomImagePanel.setOSDTexts(this.vText);
                }
            }

            @Override
            public void mouseMoved(int x, int y, MouseEvent e) {
                if (this.count == 2 || this.count == 4) {
                    this.x2 = x;
                    this.y2 = y;
                    this.v.remove(this.l);
                    this.vText.removeAllElements();
                    this.l = new Line(this.x1, this.y1, this.x2, this.y2);
                    this.l.setName("0,255,0");
                    this.v.add((Roi)this.l);
                    double xdiff = this.x1 - this.x2;
                    double ydiff = this.y1 - this.y2;
                    double tan = ydiff / xdiff;
                    double deg = Math.toDegrees(Math.atan(tan));
                    this.vText.add(new OSDText(String.valueOf(this.nf.format(deg)) + " \u00b0", this.x2, this.y2 - 10, Color.GREEN));
                    DicomImageAngleMeasurement.this.dicomImagePanel.setDefaultOSDTexts(this.vText);
                    DicomImageAngleMeasurement.this.dicomImagePanel.setDefaultRois(this.v);
                }
            }

            @Override
            public void imageChanged(ImagePlus image) {
            }
        });
    }
}

