/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.viewer;

import ij.ImagePlus;
import ij.WindowManager;
import ij.process.StackConverter;
import ij3d.Executer;
import ij3d.Image3DUniverse;
import ij3d.Install_J3D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import lu.tudor.santec.dicom.gui.DicomIcons;
import lu.tudor.santec.dicom.gui.viewer.DicomImagePanel;
import lu.tudor.santec.dicom.gui.viewer.ImageListener;
import lu.tudor.santec.dicom.gui.viewer.Series;
import lu.tudor.santec.i18n.Translatrix;

public class DicomImage3DViewer {
    final DicomImagePanel dicomImagePanel;
    private Image3DUniverse univ = null;
    private Executer exec = null;

    public DicomImage3DViewer(DicomImagePanel dip) throws Exception {
        try {
            if (Install_J3D.getJava3DVersion() == null) {
                throw new Exception("No Java 3D installed, Not loading DicomImage3DViewer");
            }
        }
        catch (Throwable e) {
            throw new Exception("No Java 3D installed, Not loading DicomImage3DViewer");
        }
        this.dicomImagePanel = dip;
        JButton threeDee = new JButton(new AbstractAction("", DicomIcons.getScreenDependentIcon("action_3d.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("3D");
                DicomImage3DViewer.this.univ = new Image3DUniverse();
                DicomImage3DViewer.this.exec = new Executer(DicomImage3DViewer.this.univ);
                DicomImage3DViewer.this.univ.show();
                Series s = DicomImage3DViewer.this.dicomImagePanel.getSeries();
                ImagePlus ip = s.getAsImageStack();
                new StackConverter(ip).convertToGray8();
                ip.setTitle(DicomImage3DViewer.this.dicomImagePanel.getImage().getTitle());
                ip.show();
                WindowManager.getCurrentWindow().setVisible(false);
                DicomImage3DViewer.this.exec.addContentFromImage(ip);
            }
        });
        threeDee.setToolTipText(Translatrix.getTranslationString((String)"dicom.dicomImagePanel.3dViewer"));
        this.dicomImagePanel.addFunctionButton(threeDee, new ImageListener(){

            @Override
            public void pixelClicked(ImagePlus ip, int x, int y) {
            }

            @Override
            public void optionSelected(boolean selected) {
            }

            @Override
            public void mouseMoved(int x, int y, MouseEvent e) {
            }

            @Override
            public void imageChanged(ImagePlus image) {
            }
        });
    }
}

