/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class LineColorCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    public Color c_OddColor;
    public Color c_EvenColor;
    private Font textFont;
    private boolean centerText;

    public LineColorCellRenderer() {
        this(false);
    }

    public LineColorCellRenderer(boolean invertColors) {
        if (invertColors) {
            this.c_EvenColor = new Color(237, 243, 254);
            this.c_OddColor = new Color(255, 255, 255);
        } else {
            this.c_OddColor = new Color(237, 243, 254);
            this.c_EvenColor = new Color(255, 255, 255);
        }
    }

    public LineColorCellRenderer(int alpha) {
        this.c_OddColor = new Color(237, 243, 254, alpha);
        this.c_EvenColor = new Color(255, 255, 255, alpha);
    }

    public LineColorCellRenderer(int alpha, Font font, boolean centerText) {
        this.c_OddColor = new Color(237, 243, 254, alpha);
        this.c_EvenColor = new Color(255, 255, 255, alpha);
        this.textFont = font;
        this.centerText = centerText;
        if (centerText) {
            this.setHorizontalAlignment(0);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable p_Table, Object value, boolean p_IsSelected, boolean hasFocus, int p_Row, int p_Column) {
        Color l_Background;
        super.getTableCellRendererComponent(p_Table, value, p_IsSelected, hasFocus, p_Row, p_Column);
        Color color = l_Background = p_Row % 2 == 0 ? this.c_OddColor : this.c_EvenColor;
        if (p_IsSelected) {
            this.setBackground(p_Table.getSelectionBackground());
        } else {
            this.setBackground(l_Background);
        }
        if (this.textFont != null) {
            this.setFont(this.textFont);
        }
        if (this.centerText) {
            this.setHorizontalAlignment(0);
        }
        try {
            this.setSize(p_Table.getColumnModel().getColumn(p_Column).getWidth(), this.getPreferredSize().height);
            if (p_Table.getRowHeight(p_Row) < this.getPreferredSize().height) {
                p_Table.setRowHeight(p_Row, this.getPreferredSize().height);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }
}

