/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.dicom.gui.selector;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import lu.tudor.santec.dicom.gui.DicomFileDialog;
import lu.tudor.santec.dicom.gui.DicomFilter;
import lu.tudor.santec.dicom.gui.DicomIcons;
import lu.tudor.santec.dicom.gui.selector.DIRFileFilter;
import lu.tudor.santec.dicom.gui.selector.MatcherPanel;
import lu.tudor.santec.i18n.Translatrix;
import org.dcm4che.util.DcmURL;

public class SelectorPanel
extends JPanel
implements ActionListener,
DicomFilter {
    private static final long serialVersionUID = 1L;
    private JTextField fileField;
    private JButton chooseFileButton;
    private JButton reloadButton;
    private JLabel fileFieldLabel;
    private CardLayout cardLayout;
    private JPanel contentPanel;
    private JFileChooser dirChooser;
    public MatcherPanel matcherPanel;
    public DicomFileDialog parent;
    private File file;
    private static final String FILE_VIEW = "file";
    private static final String DICOMDIR_VIEW = "dicomdir";

    public SelectorPanel(File file, DicomFileDialog parent, boolean send) {
        this.parent = parent;
        this.file = file;
        this.cardLayout = new CardLayout();
        this.setLayout(this.cardLayout);
        CellConstraints cc = new CellConstraints();
        FormLayout fl = new FormLayout("6dlu, 200dlu:grow, 4dlu", "6dlu, pref, 4dlu, fill:100dlu:grow");
        this.contentPanel = new JPanel((LayoutManager)fl);
        JPanel buttonPanel = new JPanel((LayoutManager)new FormLayout("4dlu, pref, 4dlu, 200dlu:grow, 4dlu, pref, 4dlu, pref, 4dlu", "2dlu, 20dlu, 2dlu"));
        buttonPanel.setBorder(new LineBorder(new JTabbedPane().getBackground()));
        this.fileFieldLabel = new JLabel(Translatrix.getTranslationString((String)"dicom.ChooseDir"));
        this.fileField = new JTextField(file.getAbsolutePath());
        this.chooseFileButton = new JButton("...");
        this.chooseFileButton.addActionListener(this);
        this.chooseFileButton.setToolTipText("Load DICOMDIR");
        this.reloadButton = new JButton(DicomIcons.getIcon("icon_reload.png"));
        this.reloadButton.setToolTipText("Refresh DICOMDIR");
        this.reloadButton.addActionListener(this);
        buttonPanel.add((Component)this.fileFieldLabel, cc.xy(2, 2));
        buttonPanel.add((Component)this.fileField, cc.xy(4, 2));
        buttonPanel.add((Component)this.chooseFileButton, cc.xy(6, 2));
        buttonPanel.add((Component)this.reloadButton, cc.xy(8, 2));
        this.contentPanel.add((Component)buttonPanel, cc.xy(2, 2));
        this.matcherPanel = new MatcherPanel(this, this.getParentDialog().dicomFields);
        this.contentPanel.add((Component)this.matcherPanel, cc.xyw(1, 4, 3));
        this.add((Component)this.contentPanel, DICOMDIR_VIEW);
        this.dirChooser = new JFileChooser(file);
        this.dirChooser.setFileSelectionMode(1);
        this.dirChooser.addChoosableFileFilter(new DIRFileFilter());
        this.dirChooser.addActionListener(this);
        this.add((Component)this.dirChooser, FILE_VIEW);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.chooseFileButton)) {
            this.cardLayout.show(this, FILE_VIEW);
        } else if (e.getSource().equals(this.reloadButton)) {
            this.setPath(this.file);
        } else if (e.getSource().equals(this.dirChooser)) {
            if (e.getActionCommand().equals("ApproveSelection")) {
                this.file = this.dirChooser.getSelectedFile();
                this.setPath(this.file);
            }
            this.cardLayout.show(this, DICOMDIR_VIEW);
        }
    }

    public void setPath(File f) {
        this.matcherPanel.setPath(f);
        this.fileField.setText(f.getAbsolutePath());
    }

    public DicomFileDialog getParentDialog() {
        return this.parent;
    }

    public void setDicomSenders(DcmURL[] senders) {
        this.matcherPanel.setDicomSenders(senders);
    }

    public void setLocalDest(DcmURL localDest) {
        this.matcherPanel.setLocalDest(localDest);
    }

    @Override
    public void setDicomFilterTags(Vector headerTags) {
        this.matcherPanel.setDicomFilterTags(headerTags);
    }

    public Vector getDicomFilterTags() {
        return this.matcherPanel.getDicomFilterTags();
    }
}

